/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.examples.basic;

import com.metaobjects.MetaData;
import com.metaobjects.field.MetaField;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.loader.simple.SimpleLoader;
import com.metaobjects.object.MetaObject;
import com.metaobjects.util.MetaDataUtil;
import com.metaobjects.validator.LengthValidator;
import com.metaobjects.validator.RequiredValidator;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class BasicMetaObjectsExample {
    public static void main(String[] args) {
        try {
            System.out.println("=== MetaObjects Basic Example ===");
            System.out.println("\n1. Loading metadata...");
            SimpleLoader loader = new SimpleLoader("examples");
            URL resourceUrl = BasicMetaObjectsExample.class.getResource("/metadata/examples-metadata.json");
            if (resourceUrl == null) {
                throw new RuntimeException("Could not find metadata resource: /metadata/examples-metadata.json");
            }
            Path tempFile = Files.createTempFile("examples-metadata", ".json", new FileAttribute[0]);
            try (InputStream is = resourceUrl.openStream();){
                Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
            }
            URI metadataUri = tempFile.toUri();
            System.out.println("   Temporary file URI: " + String.valueOf(metadataUri));
            loader.setSourceURIs(Arrays.asList(metadataUri));
            loader.init();
            System.out.println("   Loaded " + loader.getChildren().size() + " metadata items");
            System.out.println("\n2. Code generation capability available...");
            System.out.println("   (Code generation available via MustacheTemplateGenerator)");
            System.out.println("\n3. Working with metadata...");
            System.out.println("   Debug: All loaded children:");
            for (MetaData child : loader.getChildren()) {
                System.out.println("     - " + child.getClass().getSimpleName() + ": " + child.getName() + " (type: " + child.getType() + ")");
            }
            System.out.println("   Debug: All MetaObjects:");
            for (MetaObject obj : loader.getChildren(MetaObject.class)) {
                System.out.println("     - " + obj.getName() + " (package: " + obj.getPackage() + ")");
            }
            MetaObject userMeta = null;
            try {
                userMeta = MetaDataUtil.findMetaObjectByName((MetaDataLoader)loader, (String)"com_example_model::User");
                System.out.println("   Found User MetaObject via MetaDataUtil: " + userMeta.getName());
                System.out.println("   Fields: " + userMeta.getMetaFields().size());
            }
            catch (Exception e) {
                System.out.println("   Error finding User via MetaDataUtil: " + e.getMessage());
                try {
                    userMeta = loader.getMetaObjectByName("com_example_model::User");
                    System.out.println("   Found User via direct loader: " + userMeta.getName());
                    System.out.println("   Fields: " + userMeta.getMetaFields().size());
                }
                catch (Exception e2) {
                    System.out.println("   Error with direct loader access: " + e2.getMessage());
                }
            }
            if (userMeta != null) {
                for (MetaField field : userMeta.getMetaFields()) {
                    System.out.println("     - " + field.getName() + " (" + field.getSubType() + ")");
                }
            }
            System.out.println("\n4. Creating and validating objects...");
            if (userMeta != null) {
                HashMap<String, Object> user = new HashMap<String, Object>();
                user.put("id", 1L);
                user.put("username", "john_doe");
                user.put("email", "john@example.com");
                user.put("createdDate", new Date());
                System.out.println("   Created user: " + String.valueOf(user));
                boolean isValid = true;
                for (MetaField field : userMeta.getMetaFields()) {
                    boolean hasRequiredValidator = !field.getChildren(RequiredValidator.class).isEmpty();
                    if (!hasRequiredValidator || user.containsKey(field.getName())) continue;
                    System.out.println("   Validation error: Required field '" + field.getName() + "' is missing");
                    isValid = false;
                }
                System.out.println("   Validation result: " + (isValid ? "VALID" : "INVALID"));
                System.out.println("\n5. Direct metadata access...");
                MetaField emailField = userMeta.getMetaField("email");
                Object emailValue = user.get("email");
                System.out.println("   Email field value: " + String.valueOf(emailValue));
                boolean emailIsRequired = !emailField.getChildren(RequiredValidator.class).isEmpty();
                System.out.println("   Email field is required: " + emailIsRequired);
                LengthValidator lengthValidator = emailField.getChildren(LengthValidator.class).stream().findFirst().orElse(null);
                if (lengthValidator != null && lengthValidator.hasMetaAttr("max")) {
                    int maxLength = Integer.parseInt(lengthValidator.getMetaAttr("max").getValueAsString());
                    System.out.println("   Email field max length: " + maxLength);
                }
            } else {
                System.out.println("   Cannot create user object - User MetaObject not found");
            }
            System.out.println("\n6. Simple pattern utility methods...");
            System.out.println("   Loader name: " + loader.getName());
            List allObjects = MetaDataUtil.getAllMetaObjects((MetaDataLoader)loader);
            System.out.println("   Total MetaObjects via utility: " + allObjects.size());
            for (MetaObject obj : allObjects) {
                System.out.println("     - " + obj.getName() + " (package: " + obj.getPackage() + ")");
            }
            System.out.println("\n7. When to use simple vs complex patterns...");
            System.out.println("   SIMPLE PATTERN (this example):");
            System.out.println("     - Single MetaDataLoader");
            System.out.println("     - Direct loader.getMetaObjectByName() or MetaDataUtil.findMetaObjectByName(loader, ...)");
            System.out.println("     - No registry complexity needed");
            System.out.println("   COMPLEX PATTERN (see spring-example, osgi-example):");
            System.out.println("     - Multiple MetaDataLoaders in registry");
            System.out.println("     - MetaDataLoaderRegistry or MetaDataService");
            System.out.println("     - Multi-tenant, plugin, or framework scenarios");
            System.out.println("\n=== Example completed successfully ===");
        }
        catch (Exception e) {
            System.err.println("Error running example: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

