/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MessageSerializer {
    private final ObjectMapper mapper = new ObjectMapper();

    public MessageSerializer() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        this.mapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, true);
    }

    public <T> T deserialize(InputStream inputStream, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(inputStream, valueType);
    }

    public <T> T deserialize(String content, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(content, valueType);
    }

    public void serialize(OutputStream outputStream, Object value) throws IOException {
        this.mapper.writeValue(outputStream, value);
    }

    public String serialize(Object value) throws IOException {
        return this.mapper.writeValueAsString(value);
    }
}

