/*
 * Decompiled with CFR 0.152.
 */
package com.mparticle.sdk;

import com.mparticle.sdk.Logger;
import com.mparticle.sdk.model.Message;
import com.mparticle.sdk.model.audienceprocessing.AudienceMembershipChangeRequest;
import com.mparticle.sdk.model.audienceprocessing.AudienceMembershipChangeResponse;
import com.mparticle.sdk.model.audienceprocessing.AudienceSubscriptionRequest;
import com.mparticle.sdk.model.audienceprocessing.AudienceSubscriptionResponse;
import com.mparticle.sdk.model.dsrprocessing.DsrProcessingRequest;
import com.mparticle.sdk.model.dsrprocessing.DsrProcessingResponse;
import com.mparticle.sdk.model.eventprocessing.ApplicationStateTransitionEvent;
import com.mparticle.sdk.model.eventprocessing.AttributionEvent;
import com.mparticle.sdk.model.eventprocessing.CustomEvent;
import com.mparticle.sdk.model.eventprocessing.ErrorEvent;
import com.mparticle.sdk.model.eventprocessing.Event;
import com.mparticle.sdk.model.eventprocessing.EventProcessingRequest;
import com.mparticle.sdk.model.eventprocessing.EventProcessingResponse;
import com.mparticle.sdk.model.eventprocessing.ImpressionEvent;
import com.mparticle.sdk.model.eventprocessing.PrivacySettingChangeEvent;
import com.mparticle.sdk.model.eventprocessing.ProductActionEvent;
import com.mparticle.sdk.model.eventprocessing.PromotionActionEvent;
import com.mparticle.sdk.model.eventprocessing.PushMessageOpenEvent;
import com.mparticle.sdk.model.eventprocessing.PushMessageReceiptEvent;
import com.mparticle.sdk.model.eventprocessing.PushSubscriptionEvent;
import com.mparticle.sdk.model.eventprocessing.ScreenViewEvent;
import com.mparticle.sdk.model.eventprocessing.SessionEndEvent;
import com.mparticle.sdk.model.eventprocessing.SessionStartEvent;
import com.mparticle.sdk.model.eventprocessing.UserAttributeChangeEvent;
import com.mparticle.sdk.model.eventprocessing.UserIdentityChangeEvent;
import com.mparticle.sdk.model.eventprocessing.notification.CCPAConsentStateNotification;
import com.mparticle.sdk.model.eventprocessing.notification.GDPRConsentStateNotification;
import com.mparticle.sdk.model.eventprocessing.notification.SystemNotification;
import com.mparticle.sdk.model.registration.ModuleRegistrationRequest;
import com.mparticle.sdk.model.registration.ModuleRegistrationResponse;
import java.io.IOException;

public abstract class MessageProcessor {
    private Logger logger;

    public final Message processMessage(Message request) throws IOException {
        switch (request.getType()) {
            case MODULE_REGISTRATION_REQUEST: {
                return this.processRegistrationRequest((ModuleRegistrationRequest)request);
            }
            case EVENT_PROCESSING_REQUEST: {
                return this.processEventProcessingRequest((EventProcessingRequest)request);
            }
            case DSR_PROCESSING_REQUEST: {
                return this.processDsrProcessingRequest((DsrProcessingRequest)request);
            }
            case AUDIENCE_SUBSCRIPTION_REQUEST: {
                return this.processAudienceSubscriptionRequest((AudienceSubscriptionRequest)request);
            }
            case AUDIENCE_MEMBERSHIP_CHANGE_REQUEST: {
                AudienceMembershipChangeRequest audienceMembershipChangeRequest = (AudienceMembershipChangeRequest)request;
                if (audienceMembershipChangeRequest.getUserProfiles() != null) {
                    return this.processAudienceMembershipChangeRequest(audienceMembershipChangeRequest);
                }
                return new AudienceMembershipChangeResponse();
            }
        }
        throw new UnsupportedOperationException("The message type \"" + (Object)((Object)request.getType()) + "\" is not supported.");
    }

    public abstract ModuleRegistrationResponse processRegistrationRequest(ModuleRegistrationRequest var1);

    public EventProcessingResponse processEventProcessingRequest(EventProcessingRequest request) throws IOException {
        EventProcessingResponse response = new EventProcessingResponse();
        if (request.getSystemNotifications() != null) {
            for (SystemNotification notification : request.getSystemNotifications()) {
                notification.setRequest(request);
                switch (notification.getType()) {
                    case GDPR_CONSENT_STATE: {
                        this.processGDPRConsentStateNotification((GDPRConsentStateNotification)notification);
                        break;
                    }
                    case CCPA_CONSENT_STATE: {
                        this.processCCPAConsentStateNotification((CCPAConsentStateNotification)notification);
                    }
                }
            }
        }
        for (Event e : request.getEvents()) {
            e.setRequest(request);
            switch (e.getType()) {
                case SESSION_START: {
                    this.processSessionStartEvent((SessionStartEvent)e);
                    break;
                }
                case SESSION_END: {
                    this.processSessionEndEvent((SessionEndEvent)e);
                    break;
                }
                case CUSTOM_EVENT: {
                    this.processCustomEvent((CustomEvent)e);
                    break;
                }
                case SCREEN_VIEW: {
                    this.processScreenViewEvent((ScreenViewEvent)e);
                    break;
                }
                case ERROR: {
                    this.processErrorEvent((ErrorEvent)e);
                    break;
                }
                case PRIVACY_SETTING_CHANGE: {
                    this.processPrivacySettingChangeEvent((PrivacySettingChangeEvent)e);
                    break;
                }
                case USER_ATTRIBUTE_CHANGE: {
                    this.processUserAttributeChangeEvent((UserAttributeChangeEvent)e);
                    break;
                }
                case USER_IDENTITY_CHANGE: {
                    this.processUserIdentityChangeEvent((UserIdentityChangeEvent)e);
                    break;
                }
                case PUSH_SUBSCRIPTION: {
                    this.processPushSubscriptionEvent((PushSubscriptionEvent)e);
                    break;
                }
                case APPLICATION_STATE_TRANSITION: {
                    this.processApplicationStateTransitionEvent((ApplicationStateTransitionEvent)e);
                    break;
                }
                case PUSH_MESSAGE_RECEIPT: {
                    this.processPushMessageReceiptEvent((PushMessageReceiptEvent)e);
                    break;
                }
                case PUSH_MESSAGE_OPEN: {
                    this.processPushMessageOpenEvent((PushMessageOpenEvent)e);
                    break;
                }
                case PRODUCT_ACTION: {
                    this.processProductActionEvent((ProductActionEvent)e);
                    break;
                }
                case PROMOTION_ACTION: {
                    this.processPromotionActionEvent((PromotionActionEvent)e);
                    break;
                }
                case IMPRESSION: {
                    this.processImpressionEvent((ImpressionEvent)e);
                    break;
                }
                case ATTRIBUTION: {
                    this.processAttributionEvent((AttributionEvent)e);
                }
            }
        }
        return response;
    }

    public void processGDPRConsentStateNotification(GDPRConsentStateNotification notification) throws IOException {
    }

    public void processCCPAConsentStateNotification(CCPAConsentStateNotification notification) throws IOException {
    }

    public void processAttributionEvent(AttributionEvent event) throws IOException {
    }

    public void processImpressionEvent(ImpressionEvent event) throws IOException {
    }

    public void processPromotionActionEvent(PromotionActionEvent event) throws IOException {
    }

    public void processProductActionEvent(ProductActionEvent event) throws IOException {
    }

    public void processPushMessageReceiptEvent(PushMessageReceiptEvent event) throws IOException {
    }

    public void processPushMessageOpenEvent(PushMessageOpenEvent event) throws IOException {
    }

    public void processApplicationStateTransitionEvent(ApplicationStateTransitionEvent event) throws IOException {
    }

    public void processPushSubscriptionEvent(PushSubscriptionEvent event) throws IOException {
    }

    public void processUserIdentityChangeEvent(UserIdentityChangeEvent event) throws IOException {
    }

    public void processUserAttributeChangeEvent(UserAttributeChangeEvent event) throws IOException {
    }

    public void processSessionStartEvent(SessionStartEvent event) throws IOException {
    }

    public void processSessionEndEvent(SessionEndEvent event) throws IOException {
    }

    public void processCustomEvent(CustomEvent event) throws IOException {
    }

    public void processErrorEvent(ErrorEvent event) throws IOException {
    }

    public void processScreenViewEvent(ScreenViewEvent event) throws IOException {
    }

    public void processPrivacySettingChangeEvent(PrivacySettingChangeEvent event) throws IOException {
    }

    public DsrProcessingResponse processDsrProcessingRequest(DsrProcessingRequest request) throws IOException {
        return new DsrProcessingResponse();
    }

    public AudienceMembershipChangeResponse processAudienceMembershipChangeRequest(AudienceMembershipChangeRequest request) throws IOException {
        return new AudienceMembershipChangeResponse();
    }

    public AudienceSubscriptionResponse processAudienceSubscriptionRequest(AudienceSubscriptionRequest request) throws IOException {
        return new AudienceSubscriptionResponse();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected final void log(String message) {
        if (this.logger != null) {
            this.logger.log(message);
        }
    }
}

