/*
 * Decompiled with CFR 0.152.
 */
package com.ncryptify;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ncryptify.Account;
import com.ncryptify.InvalidKeyTypeException;
import com.ncryptify.Key;
import com.ncryptify.KeyNotFoundException;
import com.ncryptify.NCryptifyException;
import com.ncryptify.RestClient;
import com.ncryptify.UnsupportedVersionException;
import de.undercouch.bson4jackson.BsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Client {
    public static final String FPE_DIGIT = "digit";
    public static final String FPE_ALPHABET = "alphabet";
    public static final String FPE_ALPHANUMERIC = "alphanumeric";
    public static final String FPE_PRINTABLE = "printable";
    public static final String BLOB = "blob";
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    private static final String BLOB_CRYPTO_ALG = "AES/GCM/NoPadding";
    private static final int AAD_TLEN = 16;
    private static final int GCM_IV_LEN = 12;
    private static final int BLOB_CRYPTO_BLOCK_SIZE = 16;
    private static final int CRYPTO_HEADER_VERSION = 1;
    private static final int CHUNK_SIZE = 1024;
    private static final int MEMORY_MAP_SIZE_MINIMUM = 0x100000;
    private RestClient restClient;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public Client(String clientId, String clientSecret, String issuer, Long expiresInMinutes, String subject) {
        this.restClient = new RestClient(clientId, clientSecret, issuer, subject, expiresInMinutes.intValue());
    }

    public Client(String jwt) {
        this.restClient = new RestClient(jwt);
    }

    public static void setProxy(String proxyURL) throws IllegalArgumentException {
        RestClient.setProxy(proxyURL);
    }

    public static String createJwt(String clientId, String clientSecret, String issuer, Long expiresInMinutes, String subject) {
        return RestClient.constructJwt(clientId, clientSecret, issuer, subject, expiresInMinutes.intValue());
    }

    public String hide(String value, String keyNameOrId, String hint) throws NCryptifyException {
        return this.hide(value, keyNameOrId, hint, "");
    }

    public String hide(String value, String keyNameOrId, String hint, String tweak) throws NCryptifyException {
        return this.fpe("hide", value, keyNameOrId, hint, tweak);
    }

    public String unhide(String value, String keyNameOrId, String hint) throws NCryptifyException, UnsupportedVersionException, KeyNotFoundException {
        return this.unhide(value, keyNameOrId, hint, "");
    }

    public String unhide(String value, String keyNameOrId, String hint, String tweak) throws NCryptifyException, UnsupportedVersionException, KeyNotFoundException {
        return this.fpe("unhide", value, keyNameOrId, hint, tweak);
    }

    public int encryptBlob(ByteBuffer plainTextBuffer, ByteBuffer cipherTextBuffer, String keyNameOrId) throws NCryptifyException {
        String errorMessage;
        try {
            Key key = this.getKey(keyNameOrId);
            if (!key.getUsage().equals(BLOB)) {
                throw new InvalidKeyTypeException("Invalid key type found: " + key.getUsage());
            }
            byte[] iv = this.getRandom(12);
            byte[] header = this.createHeader(iv, key.getKeyId());
            Cipher aesCipher = Cipher.getInstance(BLOB_CRYPTO_ALG);
            aesCipher.init(1, (java.security.Key)key.getSecretKey(), new GCMParameterSpec(128, iv));
            int outputSize = aesCipher.getOutputSize(plainTextBuffer.limit());
            if (cipherTextBuffer != null) {
                aesCipher.updateAAD(header);
                cipherTextBuffer.put(header);
                while (plainTextBuffer.remaining() > 1024) {
                    ByteBuffer chunkBuffer = plainTextBuffer.slice();
                    chunkBuffer.limit(1024);
                    aesCipher.update(chunkBuffer, cipherTextBuffer);
                    plainTextBuffer.position(1024 + plainTextBuffer.position());
                }
                aesCipher.doFinal(plainTextBuffer, cipherTextBuffer);
            }
            return outputSize + header.length;
        }
        catch (NoSuchAlgorithmException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidKeyException e) {
            errorMessage = e.getMessage();
            if (errorMessage.contains("Illegal key size")) {
                errorMessage = errorMessage.concat(": Check that the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy is configured (see the README.md)");
            }
        }
        catch (IllegalBlockSizeException e) {
            errorMessage = e.getMessage();
        }
        catch (NoSuchPaddingException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidAlgorithmParameterException e) {
            errorMessage = e.getMessage();
        }
        catch (BadPaddingException e) {
            errorMessage = e.getMessage();
        }
        catch (ShortBufferException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidKeyTypeException e) {
            errorMessage = e.getMessage();
        }
        LOGGER.warning(errorMessage);
        throw new NCryptifyException(errorMessage);
    }

    public byte[] encryptBlob(byte[] plainTextBytes, String keyName) throws NCryptifyException {
        ByteBuffer plainTextBuffer = ByteBuffer.wrap(plainTextBytes);
        ByteBuffer cipherTextBuffer = ByteBuffer.allocate(this.encryptBlob(plainTextBuffer, null, keyName));
        this.encryptBlob(plainTextBuffer, cipherTextBuffer, keyName);
        return cipherTextBuffer.array();
    }

    public int decryptBlob(ByteBuffer cipherTextBuffer, ByteBuffer plainTextBuffer) throws NCryptifyException, KeyNotFoundException, UnsupportedVersionException {
        String errorMessage;
        try {
            int cipherTextBufferOriginalPosition = cipherTextBuffer.position();
            int headerLength = this.getHeaderLength(cipherTextBuffer);
            byte[] cipherTextHeaderBytes = new byte[headerLength];
            cipherTextBuffer.get(cipherTextHeaderBytes);
            CryptoHeader cryptoHeader = this.getHeader(cipherTextHeaderBytes);
            if (cryptoHeader.getVersion() > 1) {
                throw new UnsupportedVersionException("Unsupported crypto header version");
            }
            Key key = this.getKey(cryptoHeader.getKeyId(), false);
            if (!key.getUsage().equals(BLOB)) {
                throw new InvalidKeyTypeException("Invalid key type found: " + key.getUsage());
            }
            Cipher aesCipher = Cipher.getInstance(BLOB_CRYPTO_ALG);
            aesCipher.init(2, (java.security.Key)key.getSecretKey(), new GCMParameterSpec(128, cryptoHeader.getIv()));
            int outputSize = aesCipher.getOutputSize(cipherTextBuffer.limit() - headerLength);
            if (plainTextBuffer == null) {
                cipherTextBuffer.position(cipherTextBufferOriginalPosition);
            } else {
                aesCipher.updateAAD(cipherTextHeaderBytes);
                while (cipherTextBuffer.remaining() > 1024) {
                    ByteBuffer chunkBuffer = cipherTextBuffer.slice();
                    chunkBuffer.limit(1024);
                    aesCipher.update(chunkBuffer, plainTextBuffer);
                    cipherTextBuffer.position(1024 + cipherTextBuffer.position());
                }
                aesCipher.doFinal(cipherTextBuffer, plainTextBuffer);
            }
            return outputSize;
        }
        catch (NoSuchAlgorithmException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidKeyException e) {
            errorMessage = e.getMessage();
            if (errorMessage.contains("Illegal key size")) {
                errorMessage = errorMessage.concat(": Check that the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy is configured (see the README.md)");
            }
        }
        catch (IllegalBlockSizeException e) {
            errorMessage = e.getMessage();
        }
        catch (NoSuchPaddingException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidAlgorithmParameterException e) {
            errorMessage = e.getMessage();
        }
        catch (BadPaddingException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (BufferUnderflowException e) {
            errorMessage = e.getMessage();
        }
        catch (ShortBufferException e) {
            errorMessage = e.getMessage();
        }
        catch (InvalidKeyTypeException e) {
            errorMessage = e.getMessage();
        }
        LOGGER.warning(errorMessage);
        throw new NCryptifyException(errorMessage);
    }

    public byte[] decryptBlob(byte[] cipherTextBytes) throws NCryptifyException, KeyNotFoundException, UnsupportedVersionException {
        ByteBuffer cipherTextBuffer = ByteBuffer.wrap(cipherTextBytes);
        ByteBuffer plainTextBuffer = ByteBuffer.allocate(this.decryptBlob(cipherTextBuffer, null));
        this.decryptBlob(cipherTextBuffer, plainTextBuffer);
        return plainTextBuffer.array();
    }

    public void encryptFile(File plainTextFile, File cipherTextFile, String keyNameOrId) throws NCryptifyException {
        try {
            this.processFile(plainTextFile, cipherTextFile, keyNameOrId, true);
        }
        catch (KeyNotFoundException e) {
            throw new NCryptifyException(e.getMessage());
        }
        catch (UnsupportedVersionException e) {
            throw new NCryptifyException(e.getMessage());
        }
    }

    public void encryptFile(File plainTextFile, File cipherTextFile) throws NCryptifyException {
        this.encryptFile(plainTextFile, cipherTextFile, "defaultFileEncryptionKey");
    }

    private void processFile(File inputFile, File outputFile, String keyNameOrId, boolean encrypt) throws NCryptifyException, KeyNotFoundException, UnsupportedVersionException {
        String errorMessage;
        try {
            RandomAccessFile inputFileRA = new RandomAccessFile(inputFile, "r");
            boolean useMemoryMapping = inputFileRA.length() >= 0x100000L;
            ByteBuffer inputFileBuffer = null;
            if (useMemoryMapping) {
                FileChannel inputFileChannel = inputFileRA.getChannel();
                MappedByteBuffer mappedInputFileBuffer = inputFileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, inputFileChannel.size());
                mappedInputFileBuffer.load();
                inputFileBuffer = mappedInputFileBuffer;
            } else {
                inputFileBuffer = ByteBuffer.allocate((int)inputFileRA.length());
                inputFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
                inputFileRA.readFully(inputFileBuffer.array());
            }
            int requiredSize = encrypt ? this.encryptBlob(inputFileBuffer, null, keyNameOrId) : this.decryptBlob(inputFileBuffer, null);
            FileChannel outputFileChannel = new RandomAccessFile(outputFile, "rw").getChannel();
            if (useMemoryMapping) {
                MappedByteBuffer outputFileBuffer = outputFileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, requiredSize);
                if (encrypt) {
                    this.encryptBlob(inputFileBuffer, outputFileBuffer, keyNameOrId);
                } else {
                    this.decryptBlob(inputFileBuffer, outputFileBuffer);
                }
            } else {
                ByteBuffer cipherTextFileBuffer = ByteBuffer.allocate(requiredSize);
                cipherTextFileBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (encrypt) {
                    this.encryptBlob(inputFileBuffer, cipherTextFileBuffer, keyNameOrId);
                } else {
                    this.decryptBlob(inputFileBuffer, cipherTextFileBuffer);
                }
                cipherTextFileBuffer.position(0);
                outputFileChannel.write(cipherTextFileBuffer, 0L);
                outputFileChannel.close();
            }
            return;
        }
        catch (FileNotFoundException e) {
            errorMessage = e.getMessage();
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        LOGGER.warning(errorMessage);
        throw new NCryptifyException(errorMessage);
    }

    public void decryptFile(File cipherTextFile, File plainTextFile) throws NCryptifyException, KeyNotFoundException, UnsupportedVersionException {
        this.processFile(cipherTextFile, plainTextFile, null, false);
    }

    public Key getKey(String keyNameOrId) throws NCryptifyException {
        try {
            return this.getKey(keyNameOrId, true);
        }
        catch (KeyNotFoundException e) {
            throw new NCryptifyException(e.getMessage());
        }
    }

    public Key getKey(String keyNameOrId, boolean createIfNotFound) throws NCryptifyException, KeyNotFoundException {
        RestClient.KeyResponse keyResponse;
        try {
            keyResponse = this.restClient.getKey(keyNameOrId);
        }
        catch (KeyNotFoundException e) {
            if (!createIfNotFound) {
                throw e;
            }
            try {
                keyResponse = this.restClient.createKey(keyNameOrId);
            }
            catch (IOException ee) {
                String errorMessage = "Exception communicating with ncryptify: " + ee.getMessage();
                LOGGER.warning(errorMessage);
                throw new NCryptifyException(errorMessage);
            }
        }
        catch (IOException e) {
            String errorMessage = "Exception communicating with ncryptify: " + e.getMessage();
            LOGGER.warning(errorMessage);
            throw new NCryptifyException(errorMessage);
        }
        byte[] keyMaterial = Client.hexToBytes(keyResponse.getMaterial());
        return new Key(new SecretKeySpec(keyMaterial, 0, keyMaterial.length, "AES"), keyResponse.getId(), keyResponse.getUsage());
    }

    public Account getAccount() throws NCryptifyException {
        try {
            return this.restClient.getAccount();
        }
        catch (IOException e) {
            String errorMessage = "Exception communicating with ncryptify: " + e.getMessage();
            LOGGER.warning(errorMessage);
            throw new NCryptifyException(errorMessage);
        }
    }

    public void deleteKey(String keyNameOrId) throws NCryptifyException, KeyNotFoundException {
        try {
            this.restClient.deleteKey(keyNameOrId);
        }
        catch (IOException e) {
            String errorMessage = "Exception communicating with ncryptify: " + e.getMessage();
            LOGGER.warning(errorMessage);
            throw new NCryptifyException(errorMessage);
        }
    }

    public String getToken() {
        return this.restClient.getToken();
    }

    private byte[] createHeader(byte[] iv, String keyId) throws IOException {
        CryptoHeader cryptoHeader = new CryptoHeader(1, "AES-GCM", iv, keyId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new BsonFactory());
        mapper.writeValue((OutputStream)baos, (Object)cryptoHeader);
        return baos.toByteArray();
    }

    private CryptoHeader getHeader(byte[] serializedHeader) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new BsonFactory());
        return (CryptoHeader)mapper.readValue(serializedHeader, CryptoHeader.class);
    }

    private int getHeaderLength(ByteBuffer serializedHeaderBuffer) {
        serializedHeaderBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return serializedHeaderBuffer.getInt(0);
    }

    private String fpe(String cmd, String value, String keyName, String hint, String tweak) throws NCryptifyException {
        if (value == null) {
            return null;
        }
        try {
            return this.restClient.postFpeAction(cmd, value, keyName, hint, tweak);
        }
        catch (IOException e) {
            String errorMessage = "Exception posting to crypto service :" + e.getMessage();
            LOGGER.warning(errorMessage);
            throw new NCryptifyException(errorMessage);
        }
    }

    private String fpeHide(String value, String keyName, String hint, String tweak) throws NCryptifyException {
        return this.fpe("hide", value, keyName, hint, tweak);
    }

    private String fpeUnhide(String value, String keyName, String hint, String tweak) throws NCryptifyException {
        return this.fpe("unhide", value, keyName, hint, tweak);
    }

    public byte[] getRandom(int size) throws NCryptifyException {
        try {
            return Client.hexToBytes(this.restClient.getRandom(size).getMaterial());
        }
        catch (IOException e) {
            String errorMessage = "Exception retrieving random bytes: " + e.getMessage();
            LOGGER.warning(errorMessage);
            throw new NCryptifyException(errorMessage);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private boolean isFpe(String hint) {
        return hint.equals(FPE_DIGIT) || hint.equals(FPE_ALPHABET) || hint.equals(FPE_ALPHANUMERIC) || hint.equals(FPE_PRINTABLE);
    }

    static class CryptoHeader {
        private int version;
        private String algorithm;
        private byte[] iv;
        private String keyId;

        public CryptoHeader() {
            this.version = 1;
        }

        public CryptoHeader(int version, String algorithm, byte[] iv, String keyId) {
            this.version = version;
            this.algorithm = algorithm;
            this.iv = iv;
            this.keyId = keyId;
        }

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public void setIv(byte[] iv) {
            this.iv = iv;
        }

        public String getKeyId() {
            return this.keyId;
        }

        public void setKeyId(String keyId) {
            this.keyId = keyId;
        }
    }
}

