/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.ValueType;
import com.jsoniter.any.ArrayAny;
import com.jsoniter.any.ArrayLazyAny;
import com.jsoniter.any.ArrayWrapperAny;
import com.jsoniter.any.DoubleAny;
import com.jsoniter.any.DoubleLazyAny;
import com.jsoniter.any.FalseAny;
import com.jsoniter.any.FloatAny;
import com.jsoniter.any.IntAny;
import com.jsoniter.any.ListWrapperAny;
import com.jsoniter.any.LongAny;
import com.jsoniter.any.LongLazyAny;
import com.jsoniter.any.MapWrapperAny;
import com.jsoniter.any.NotFoundAny;
import com.jsoniter.any.NullAny;
import com.jsoniter.any.ObjectAny;
import com.jsoniter.any.ObjectLazyAny;
import com.jsoniter.any.StringAny;
import com.jsoniter.any.StringLazyAny;
import com.jsoniter.any.TrueAny;
import com.jsoniter.output.CodegenAccess;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class Any
implements Iterable<Any> {
    protected static final Set<String> EMPTY_KEYS;
    protected static final EntryIterator EMPTY_ENTRIES_ITERATOR;
    protected static final Iterator<Any> EMPTY_ITERATOR;
    private static final int wildcardHashCode;
    private static final Character wildcard;

    public static Any wrapArray(Object val) {
        return new ArrayWrapperAny(val);
    }

    public abstract ValueType valueType();

    public <T> T bindTo(T obj, Object ... keys) {
        return this.get(keys).bindTo(obj);
    }

    public <T> T bindTo(T obj) {
        return (T)this.object();
    }

    public <T> T bindTo(TypeLiteral<T> typeLiteral, T obj, Object ... keys) {
        return this.get(keys).bindTo(typeLiteral, obj);
    }

    public <T> T bindTo(TypeLiteral<T> typeLiteral, T obj) {
        return (T)this.object();
    }

    public Object object(Object ... keys) {
        return this.get(keys).object();
    }

    public abstract Object object();

    public Map<String, Any> asMap() {
        return (Map)this.object();
    }

    public List<Any> asList() {
        return (List)this.object();
    }

    public <T> T as(Class<T> clazz, Object ... keys) {
        return this.get(keys).as(clazz);
    }

    public <T> T as(Class<T> clazz) {
        return (T)this.object();
    }

    public <T> T as(TypeLiteral<T> typeLiteral, Object ... keys) {
        return this.get(keys).as(typeLiteral);
    }

    public <T> T as(TypeLiteral<T> typeLiteral) {
        return (T)this.object();
    }

    public final boolean toBoolean(Object ... keys) {
        return this.get(keys).toBoolean();
    }

    public abstract boolean toBoolean();

    public final int toInt(Object ... keys) {
        return this.get(keys).toInt();
    }

    public abstract int toInt();

    public final long toLong(Object ... keys) {
        return this.get(keys).toLong();
    }

    public abstract long toLong();

    public final float toFloat(Object ... keys) {
        return this.get(keys).toFloat();
    }

    public abstract float toFloat();

    public final double toDouble(Object ... keys) {
        return this.get(keys).toDouble();
    }

    public abstract double toDouble();

    public final String toString(Object ... keys) {
        return this.get(keys).toString();
    }

    public abstract String toString();

    public int size() {
        return 0;
    }

    public Set<String> keys() {
        return EMPTY_KEYS;
    }

    @Override
    public Iterator<Any> iterator() {
        return EMPTY_ITERATOR;
    }

    public EntryIterator entries() {
        return EMPTY_ENTRIES_ITERATOR;
    }

    public Any get(int index) {
        return new NotFoundAny(index, this.object());
    }

    public Any get(Object key) {
        return new NotFoundAny(key, this.object());
    }

    public final Any get(Object ... keys) {
        return this.get(keys, 0);
    }

    public Any get(Object[] keys, int idx) {
        if (idx == keys.length) {
            return this;
        }
        return new NotFoundAny(keys, idx, this.object());
    }

    public Any set(int newVal) {
        return Any.wrap(newVal);
    }

    public Any set(long newVal) {
        return Any.wrap(newVal);
    }

    public Any set(float newVal) {
        return Any.wrap(newVal);
    }

    public Any set(double newVal) {
        return Any.wrap(newVal);
    }

    public Any set(String newVal) {
        return Any.wrap(newVal);
    }

    public abstract void writeTo(JsonStream var1) throws IOException;

    protected JsonException reportUnexpectedType(ValueType toType) {
        throw new JsonException(String.format("can not convert %s to %s", new Object[]{this.valueType(), toType}));
    }

    public static Any lazyString(byte[] data, int head, int tail) {
        return new StringLazyAny(data, head, tail);
    }

    public static Any lazyDouble(byte[] data, int head, int tail) {
        return new DoubleLazyAny(data, head, tail);
    }

    public static Any lazyLong(byte[] data, int head, int tail) {
        return new LongLazyAny(data, head, tail);
    }

    public static Any lazyArray(byte[] data, int head, int tail) {
        return new ArrayLazyAny(data, head, tail);
    }

    public static Any lazyObject(byte[] data, int head, int tail) {
        return new ObjectLazyAny(data, head, tail);
    }

    public static Any wrap(int val) {
        return new IntAny(val);
    }

    public static Any wrap(long val) {
        return new LongAny(val);
    }

    public static Any wrap(float val) {
        return new FloatAny(val);
    }

    public static Any wrap(double val) {
        return new DoubleAny(val);
    }

    public static Any wrap(boolean val) {
        if (val) {
            return TrueAny.INSTANCE;
        }
        return FalseAny.INSTANCE;
    }

    public static Any wrap(String val) {
        if (val == null) {
            return NullAny.INSTANCE;
        }
        return new StringAny(val);
    }

    public static <T> Any wrap(Collection<T> val) {
        if (val == null) {
            return NullAny.INSTANCE;
        }
        return new ListWrapperAny(new ArrayList<T>(val));
    }

    public static <T> Any wrap(List<T> val) {
        if (val == null) {
            return NullAny.INSTANCE;
        }
        return new ListWrapperAny(val);
    }

    public static <T> Any wrap(Map<String, T> val) {
        if (val == null) {
            return NullAny.INSTANCE;
        }
        return new MapWrapperAny(val);
    }

    public static Any wrap(Object val) {
        return CodegenAccess.wrap(val);
    }

    public static Any wrapNull() {
        return NullAny.INSTANCE;
    }

    public static Any rewrap(List<Any> val) {
        return new ArrayAny(val);
    }

    public static Any rewrap(Map<String, Any> val) {
        return new ObjectAny(val);
    }

    protected boolean isWildcard(Object key) {
        return wildcardHashCode == key.hashCode() && wildcard.equals(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Any any = (Any)o;
        Object obj = this.object();
        Object thatObj = any.object();
        return obj != null ? obj.equals(thatObj) : thatObj == null;
    }

    public int hashCode() {
        Object obj = this.object();
        return obj != null ? obj.hashCode() : 0;
    }

    static {
        Encoder.ReflectionEncoder anyEncoder = new Encoder.ReflectionEncoder(){

            @Override
            public void encode(Object obj, JsonStream stream) throws IOException {
                Any any = (Any)obj;
                any.writeTo(stream);
            }

            @Override
            public Any wrap(Object obj) {
                return (Any)obj;
            }
        };
        JsonStream.registerNativeEncoder(Any.class, anyEncoder);
        JsonStream.registerNativeEncoder(TrueAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(FalseAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ArrayLazyAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(DoubleAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(FloatAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(IntAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(LongAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(NullAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(LongLazyAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(DoubleLazyAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ObjectLazyAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(StringAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(StringLazyAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ArrayAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ObjectAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ListWrapperAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(ArrayWrapperAny.class, anyEncoder);
        JsonStream.registerNativeEncoder(MapWrapperAny.class, anyEncoder);
        EMPTY_KEYS = Collections.unmodifiableSet(new HashSet());
        EMPTY_ENTRIES_ITERATOR = new EntryIterator(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public String key() {
                throw new NoSuchElementException();
            }

            @Override
            public Any value() {
                throw new NoSuchElementException();
            }
        };
        EMPTY_ITERATOR = new Iterator<Any>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Any next() {
                throw new NoSuchElementException();
            }
        };
        wildcardHashCode = Character.valueOf('*').hashCode();
        wildcard = Character.valueOf('*');
    }

    public static interface EntryIterator {
        public boolean next();

        public String key();

        public Any value();
    }
}

