/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.any;

import com.jsoniter.CodegenAccess;
import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.ValueType;
import com.jsoniter.any.LazyAny;
import com.jsoniter.spi.JsonException;
import java.io.IOException;

class StringLazyAny
extends LazyAny {
    private static final String FALSE = "false";
    private String cache;

    public StringLazyAny(byte[] data, int head, int tail) {
        super(data, head, tail);
    }

    @Override
    public ValueType valueType() {
        return ValueType.STRING;
    }

    @Override
    public Object object() {
        this.fillCache();
        return this.cache;
    }

    @Override
    public boolean toBoolean() {
        this.fillCache();
        int len = this.cache.length();
        if (len == 0) {
            return false;
        }
        if (len == 5 && FALSE.equals(this.cache)) {
            return false;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (this.cache.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int toInt() {
        JsonIterator iter = this.parse();
        try {
            CodegenAccess.nextToken(iter);
            int n = iter.readInt();
            return n;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public long toLong() {
        JsonIterator iter = this.parse();
        try {
            CodegenAccess.nextToken(iter);
            long l = iter.readLong();
            return l;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public float toFloat() {
        JsonIterator iter = this.parse();
        try {
            CodegenAccess.nextToken(iter);
            float f = iter.readFloat();
            return f;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public double toDouble() {
        JsonIterator iter = this.parse();
        try {
            CodegenAccess.nextToken(iter);
            double d = iter.readDouble();
            return d;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
        finally {
            JsonIteratorPool.returnJsonIterator(iter);
        }
    }

    @Override
    public String toString() {
        this.fillCache();
        return this.cache;
    }

    private void fillCache() {
        if (this.cache == null) {
            JsonIterator iter = this.parse();
            try {
                this.cache = iter.readString();
            }
            catch (IOException e) {
                throw new JsonException();
            }
            finally {
                JsonIteratorPool.returnJsonIterator(iter);
            }
        }
    }
}

