/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.CodegenImplNative;
import com.jsoniter.output.CodegenResult;
import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.ClassInfo;
import com.jsoniter.spi.EncodeTo;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsoniterSpi;
import com.jsoniter.spi.UnwrapperDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class CodegenImplObject {
    CodegenImplObject() {
    }

    public static CodegenResult genObject(ClassInfo classInfo) {
        boolean noIndention = JsoniterSpi.getCurrentConfig().indentionStep() == 0;
        CodegenResult ctx = new CodegenResult();
        ClassDescriptor desc = ClassDescriptor.getEncodingClassDescriptor(classInfo, false);
        List<EncodeTo> encodeTos = desc.encodeTos();
        ctx.append(String.format("public static void encode_(%s obj, com.jsoniter.output.JsonStream stream) throws java.io.IOException {", classInfo.clazz.getCanonicalName()));
        if (CodegenImplObject.hasFieldOutput(desc)) {
            int notFirst = 0;
            if (noIndention) {
                ctx.buffer('{');
            } else {
                ctx.append("stream.writeObjectStart();");
            }
            for (EncodeTo encodeTo : encodeTos) {
                notFirst = CodegenImplObject.genField(ctx, encodeTo.binding, encodeTo.toName, notFirst);
            }
            for (UnwrapperDescriptor unwrapper : desc.unwrappers) {
                if (unwrapper.isMap) {
                    ctx.append(String.format("java.util.Map map = (java.util.Map)obj.%s();", unwrapper.method.getName()));
                    ctx.append("java.util.Iterator iter = map.entrySet().iterator();");
                    ctx.append("while(iter.hasNext()) {");
                    ctx.append("java.util.Map.Entry entry = (java.util.Map.Entry)iter.next();");
                    notFirst = CodegenImplObject.appendComma(ctx, notFirst);
                    ctx.append("stream.writeObjectField(entry.getKey().toString());");
                    ctx.append("if (entry.getValue() == null) { stream.writeNull(); } else {");
                    CodegenImplNative.genWriteOp(ctx, "entry.getValue()", unwrapper.mapValueTypeLiteral.getType(), true);
                    ctx.append("}");
                    ctx.append("}");
                    continue;
                }
                notFirst = CodegenImplObject.appendComma(ctx, notFirst);
                ctx.append(String.format("obj.%s(stream);", unwrapper.method.getName()));
            }
            if (noIndention) {
                ctx.buffer('}');
            } else if (notFirst == 1) {
                ctx.append("stream.writeObjectEnd();");
            } else if (notFirst == 2) {
                ctx.append("if (notFirst) { stream.writeObjectEnd(); } else { stream.write('}'); }");
            } else {
                ctx.append("stream.write('}');");
            }
        } else {
            ctx.buffer("{}");
        }
        ctx.append("}");
        return ctx;
    }

    private static boolean hasFieldOutput(ClassDescriptor desc) {
        if (!desc.unwrappers.isEmpty()) {
            return true;
        }
        return !desc.encodeTos().isEmpty();
    }

    private static int genField(CodegenResult ctx, Binding binding, String toName, int notFirst) {
        String valueAccessor;
        Class<?> valueClazz;
        boolean noIndention = JsoniterSpi.getCurrentConfig().indentionStep() == 0;
        String fieldCacheKey = binding.encoderCacheKey();
        Encoder encoder = JsoniterSpi.getEncoder(fieldCacheKey);
        boolean isCollectionValueNullable = binding.isCollectionValueNullable;
        if (binding.field != null) {
            valueClazz = binding.field.getType();
            valueAccessor = "obj." + binding.field.getName();
        } else {
            valueClazz = binding.method.getReturnType();
            valueAccessor = "obj." + binding.method.getName() + "()";
        }
        if (!CodegenImplObject.supportCollectionValueNullable(valueClazz)) {
            isCollectionValueNullable = true;
        }
        boolean nullable = !valueClazz.isPrimitive();
        boolean omitZero = JsoniterSpi.getCurrentConfig().omitDefaultValue();
        if (!binding.isNullable) {
            nullable = false;
        }
        if (binding.defaultValueToOmit != null) {
            if (notFirst == 0) {
                notFirst = 2;
                ctx.append("boolean notFirst = false;");
            }
            ctx.append("if (!(" + String.format(binding.defaultValueToOmit.code(), valueAccessor) + ")) {");
            notFirst = CodegenImplObject.appendComma(ctx, notFirst);
            if (noIndention) {
                ctx.append(CodegenResult.bufferToWriteOp("\"" + toName + "\":"));
            } else {
                ctx.append(String.format("stream.writeObjectField(\"%s\");", toName));
            }
        } else {
            notFirst = CodegenImplObject.appendComma(ctx, notFirst);
            if (noIndention) {
                ctx.buffer('\"');
                ctx.buffer(toName);
                ctx.buffer('\"');
                ctx.buffer(':');
            } else {
                ctx.append(String.format("stream.writeObjectField(\"%s\");", toName));
            }
            if (nullable) {
                ctx.append(String.format("if (%s == null) { stream.writeNull(); } else {", valueAccessor));
            }
        }
        if (encoder == null) {
            CodegenImplNative.genWriteOp(ctx, valueAccessor, binding.valueType, nullable, isCollectionValueNullable);
        } else {
            ctx.append(String.format("com.jsoniter.output.CodegenAccess.writeVal(\"%s\", %s, stream);", fieldCacheKey, valueAccessor));
        }
        if (nullable || omitZero) {
            ctx.append("}");
        }
        return notFirst;
    }

    private static int appendComma(CodegenResult ctx, int notFirst) {
        boolean noIndention;
        boolean bl = noIndention = JsoniterSpi.getCurrentConfig().indentionStep() == 0;
        if (notFirst == 1) {
            if (noIndention) {
                ctx.buffer(',');
            } else {
                ctx.append("stream.writeMore();");
            }
        } else if (notFirst == 2) {
            if (noIndention) {
                ctx.append("if (notFirst) { stream.write(','); } else { notFirst = true; }");
            } else {
                ctx.append("if (notFirst) { stream.writeMore(); } else { stream.writeIndention(); notFirst = true; }");
            }
        } else {
            notFirst = 1;
            if (!noIndention) {
                ctx.append("stream.writeIndention();");
            }
        }
        return notFirst;
    }

    private static boolean supportCollectionValueNullable(Class clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Collection.class.isAssignableFrom(clazz);
    }
}

