/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.JsonException;
import java.io.IOException;

class StreamImplString {
    private static final byte[] ITOA = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final boolean[] CAN_DIRECT_WRITE = new boolean[128];
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;

    StreamImplString() {
    }

    public static final void writeString(JsonStream stream, String val) throws IOException {
        int bufLengthMinusTwo;
        int i = 0;
        int valLen = val.length();
        int toWriteLen = valLen;
        if (stream.count + toWriteLen > (bufLengthMinusTwo = stream.buf.length - 2)) {
            toWriteLen = bufLengthMinusTwo - stream.count;
        }
        if (toWriteLen < 0) {
            stream.ensure(32);
            if (stream.count + toWriteLen > bufLengthMinusTwo) {
                toWriteLen = bufLengthMinusTwo - stream.count;
            }
        }
        int n = stream.count;
        stream.buf[n++] = 34;
        while (i < toWriteLen) {
            char c = val.charAt(i);
            try {
                if (!CAN_DIRECT_WRITE[c]) break;
                stream.buf[n++] = (byte)c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            ++i;
        }
        if (i == valLen) {
            stream.buf[n++] = 34;
            stream.count = n;
            return;
        }
        stream.count = n;
        StreamImplString.writeStringSlowPath(stream, val, i, valLen);
        stream.write(34);
    }

    public static final void writeStringWithoutQuote(JsonStream stream, String val) throws IOException {
        char c;
        int bufLen;
        int i = 0;
        int valLen = val.length();
        int toWriteLen = valLen;
        if (stream.count + toWriteLen > (bufLen = stream.buf.length)) {
            toWriteLen = bufLen - stream.count;
        }
        if (toWriteLen < 0) {
            stream.ensure(32);
            if (stream.count + toWriteLen > bufLen) {
                toWriteLen = bufLen - stream.count;
            }
        }
        int n = stream.count;
        while (i < toWriteLen && (c = val.charAt(i)) > '\u001f' && c != '\"' && c != '\\' && c < '~') {
            stream.buf[n++] = (byte)c;
            ++i;
        }
        if (i == valLen) {
            stream.count = n;
            return;
        }
        stream.count = n;
        StreamImplString.writeStringSlowPath(stream, val, i, valLen);
    }

    private static void writeStringSlowPath(JsonStream stream, String val, int i, int valLen) throws IOException {
        boolean escapeUnicode = stream.currentConfig().escapeUnicode();
        if (escapeUnicode) {
            while (i < valLen) {
                char c = val.charAt(i);
                if (c > '}') {
                    byte b4 = (byte)(c & 0xF);
                    byte b3 = (byte)(c >> 4 & 0xF);
                    byte b2 = (byte)(c >> 8 & 0xF);
                    byte b1 = (byte)(c >> 12 & 0xF);
                    stream.write((byte)92, (byte)117, ITOA[b1], ITOA[b2], ITOA[b3], ITOA[b4]);
                } else {
                    StreamImplString.writeAsciiChar(stream, c);
                }
                ++i;
            }
        } else {
            StreamImplString.writeStringSlowPathWithoutEscapeUnicode(stream, val, i, valLen);
        }
    }

    private static void writeStringSlowPathWithoutEscapeUnicode(JsonStream stream, String val, int i, int valLen) throws IOException {
        while (i < valLen) {
            int c = val.charAt(i);
            if (c > 125) {
                if (c < 2048) {
                    stream.write((byte)(0xC0 | c >> 6), (byte)(0x80 | c & 0x3F));
                } else if (c < 55296 || c > 57343) {
                    stream.write((byte)(0xE0 | c >> 12), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F));
                } else {
                    if (c > 56319) {
                        throw new JsonException("illegalSurrogate");
                    }
                    int _surrogate = c;
                    if (i >= valLen) break;
                    int firstPart = _surrogate;
                    _surrogate = 0;
                    if (c < 56320 || c > 57343) {
                        throw new JsonException("Broken surrogate pair: first char 0x" + Integer.toHexString(firstPart) + ", second 0x" + Integer.toHexString(c) + "; illegal combination");
                    }
                    if ((c = 65536 + (firstPart - 55296 << 10) + (c - 56320)) > 0x10FFFF) {
                        throw new JsonException("illegalSurrogate");
                    }
                    stream.write((byte)(0xF0 | c >> 18), (byte)(0x80 | c >> 12 & 0x3F), (byte)(0x80 | c >> 6 & 0x3F), (byte)(0x80 | c & 0x3F));
                }
            } else {
                StreamImplString.writeAsciiChar(stream, c);
            }
            ++i;
        }
    }

    private static void writeAsciiChar(JsonStream stream, int c) throws IOException {
        switch (c) {
            case 34: {
                stream.write((byte)92, (byte)34);
                break;
            }
            case 92: {
                stream.write((byte)92, (byte)92);
                break;
            }
            case 8: {
                stream.write((byte)92, (byte)98);
                break;
            }
            case 12: {
                stream.write((byte)92, (byte)102);
                break;
            }
            case 10: {
                stream.write((byte)92, (byte)110);
                break;
            }
            case 13: {
                stream.write((byte)92, (byte)114);
                break;
            }
            case 9: {
                stream.write((byte)92, (byte)116);
                break;
            }
            default: {
                stream.write(c);
            }
        }
    }

    static {
        for (int i = 0; i < CAN_DIRECT_WRITE.length; ++i) {
            if (i <= 31 || i >= 126 || i == 34 || i == 92) continue;
            StreamImplString.CAN_DIRECT_WRITE[i] = true;
        }
    }
}

