/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.codegen;

import com.networknt.codegen.Generator;
import com.networknt.service.SingletonServiceFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FrameworkRegistry {
    private final Map<String, Generator> frameworks;
    private static final FrameworkRegistry INSTANCE = new FrameworkRegistry();

    private FrameworkRegistry() {
        Generator[] generators = SingletonServiceFactory.getBeans(Generator.class);
        HashMap map = new HashMap();
        if (generators != null) {
            Arrays.stream(generators).forEach(s -> map.put(s.getFramework(), s));
        }
        this.frameworks = Collections.unmodifiableMap(map);
    }

    public Set<String> getFrameworks() {
        return this.frameworks.keySet();
    }

    public Generator getGenerator(String framework) {
        return this.frameworks.get(framework);
    }

    public static FrameworkRegistry getInstance() {
        return INSTANCE;
    }
}

