/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.Link;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.Server;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.ValidationResults;
import com.networknt.oas.validator.impl.OpenApi3Messages;
import com.networknt.oas.validator.impl.ServerValidator;
import com.networknt.oas.validator.msg.Messages;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class LinkValidator
extends ObjectValidatorBase<Link> {
    @Override
    public void runObjectValidations() {
        Link link = (Link)((Object)this.value.getOverlay());
        this.validateStringField("description", false);
        Operation op = this.checkValidOperation(link);
        if (op != null) {
            this.checkParameters(link, op);
        }
        Overlay<Object> requestBody = this.validateField("requestBody", false, Object.class, null, new Consumer[0]);
        this.checkRequestBody(requestBody);
        this.validateField("server", false, Server.class, new ServerValidator(), new Consumer[0]);
        this.validateExtensions(link.getExtensions());
    }

    private Operation checkValidOperation(Link link) {
        String relativePath;
        String opId = link.getOperationId();
        String operationRef = link.getOperationRef();
        Operation op = null;
        if (opId == null && operationRef == null) {
            this.results.addError(Messages.msg(OpenApi3Messages.NoOpIdNoOpRefInLink, new Object[0]), this.value);
        } else if (opId != null && operationRef != null) {
            this.results.addError(Messages.msg(OpenApi3Messages.OpIdAndOpRefInLink, new Object[0]), this.value);
        }
        if (opId != null && (op = this.findOperationById((OpenApi3)Overlay.of(link).getModel(), opId)) == null) {
            this.results.addError(Messages.msg(OpenApi3Messages.OpIdNotFound, opId), this.value);
        }
        if ((relativePath = this.getRelativePath(operationRef, this.results)) != null && (op = this.findOperationByPath((OpenApi3)Overlay.of(link).getModel(), relativePath, this.results)) == null) {
            this.results.addError(Messages.msg(OpenApi3Messages.OpPathNotFound, operationRef), this.value);
        }
        return op;
    }

    private void checkParameters(Link link, Operation op) {
        Map<String, Integer> opParamCounts = this.getParamNameCounts(op.getParameters());
        Map<String, String> params = link.getParameters();
        for (String paramName : params.keySet()) {
            int count = opParamCounts.get(paramName);
            if (count == 0) {
                this.results.addError(Messages.msg(OpenApi3Messages.BadLinkParam, paramName), Overlay.of(params, paramName));
                continue;
            }
            if (count <= 1) continue;
            this.results.addWarning(Messages.msg(OpenApi3Messages.AmbigLinkParam, paramName), Overlay.of(params, paramName));
        }
    }

    private Operation findOperationById(OpenApi3 model2, String operationId) {
        for (Path path : model2.getPaths().values()) {
            for (Operation op : path.getOperations().values()) {
                if (!operationId.equals(op.getOperationId())) continue;
                return op;
            }
        }
        return null;
    }

    private Operation findOperationByPath(OpenApi3 model2, String relativePath, ValidationResults results) {
        Path path = model2.getPath(relativePath);
        return path != null ? path.getGet(false) : null;
    }

    private String getRelativePath(String operationRef, ValidationResults results) {
        if (operationRef != null) {
            results.addWarning(Messages.msg(OpenApi3Messages.OperationRefUnSupp, new Object[0]), this.value);
        }
        return null;
    }

    private Map<String, Integer> getParamNameCounts(Collection<? extends Parameter> parameters) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            if (counts.containsKey(name)) {
                counts.put(name, 1 + (Integer)counts.get(name));
                continue;
            }
            counts.put(name, 1);
        }
        return counts;
    }

    private void checkRequestBody(Overlay<Object> rbField) {
        if (rbField == null || !rbField.isPresent() || rbField.get() instanceof String) {
            // empty if block
        }
    }
}

