/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator.impl;

import com.networknt.oas.model.Callback;
import com.networknt.oas.model.Example;
import com.networknt.oas.model.ExternalDocs;
import com.networknt.oas.model.Header;
import com.networknt.oas.model.Info;
import com.networknt.oas.model.Link;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.Parameter;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.RequestBody;
import com.networknt.oas.model.Response;
import com.networknt.oas.model.Schema;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.oas.model.SecurityScheme;
import com.networknt.oas.model.Server;
import com.networknt.oas.model.Tag;
import com.networknt.oas.validator.ObjectValidatorBase;
import com.networknt.oas.validator.impl.CallbackValidator;
import com.networknt.oas.validator.impl.ExampleValidator;
import com.networknt.oas.validator.impl.ExternalDocsValidator;
import com.networknt.oas.validator.impl.HeaderValidator;
import com.networknt.oas.validator.impl.InfoValidator;
import com.networknt.oas.validator.impl.LinkValidator;
import com.networknt.oas.validator.impl.ParameterValidator;
import com.networknt.oas.validator.impl.PathValidator;
import com.networknt.oas.validator.impl.RequestBodyValidator;
import com.networknt.oas.validator.impl.ResponseValidator;
import com.networknt.oas.validator.impl.SchemaValidator;
import com.networknt.oas.validator.impl.SecurityRequirementValidator;
import com.networknt.oas.validator.impl.SecuritySchemeValidator;
import com.networknt.oas.validator.impl.ServerValidator;
import com.networknt.oas.validator.impl.TagValidator;
import java.util.function.Consumer;

public class OpenApi3Validator
extends ObjectValidatorBase<OpenApi3> {
    @Override
    public void runObjectValidations() {
        OpenApi3 model2 = (OpenApi3)((Object)this.value.getOverlay());
        this.validateStringField("openApi", true, "3\\.\\d+(\\.\\d+.*)?");
        this.validateField("info", true, Info.class, new InfoValidator(), new Consumer[0]);
        this.validateListField("servers", false, false, Server.class, new ServerValidator());
        this.validateMapField("paths", true, false, Path.class, new PathValidator());
        this.validateExtensions(model2.getPathsExtensions());
        this.validateMapField("schemas", false, false, Schema.class, new SchemaValidator());
        this.validateMapField("responses", false, false, Response.class, new ResponseValidator());
        this.validateMapField("parameters", false, false, Parameter.class, new ParameterValidator());
        this.validateMapField("examples", false, false, Example.class, new ExampleValidator());
        this.validateMapField("requestBodies", false, false, RequestBody.class, new RequestBodyValidator());
        this.validateMapField("headers", false, false, Header.class, new HeaderValidator());
        this.validateMapField("securitySchemes", false, false, SecurityScheme.class, new SecuritySchemeValidator());
        this.validateMapField("links", false, false, Link.class, new LinkValidator());
        this.validateMapField("callbacks", false, false, Callback.class, new CallbackValidator());
        this.validateExtensions(model2.getComponentsExtensions());
        this.validateListField("securityRequirements", false, false, SecurityRequirement.class, new SecurityRequirementValidator());
        this.validateListField("tags", false, false, Tag.class, new TagValidator());
        this.validateField("externalDocs", false, ExternalDocs.class, new ExternalDocsValidator(), new Consumer[0]);
        this.validateExtensions(model2.getExtensions());
    }
}

