/*
 * Decompiled with CFR 0.152.
 */
package graphql.analysis;

import graphql.Assert;
import graphql.PublicApi;
import graphql.analysis.FieldComplexityCalculator;
import graphql.analysis.FieldComplexityEnvironment;
import graphql.analysis.QueryTraversal;
import graphql.analysis.QueryVisitorEnvironment;
import graphql.execution.AbortExecutionException;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationValidationParameters;
import graphql.validation.ValidationError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@PublicApi
public class MaxQueryComplexityInstrumentation
extends SimpleInstrumentation {
    private final int maxComplexity;
    private final FieldComplexityCalculator fieldComplexityCalculator;

    public MaxQueryComplexityInstrumentation(int maxComplexity) {
        this(maxComplexity, (env, childComplexity) -> 1 + childComplexity);
    }

    public MaxQueryComplexityInstrumentation(int maxComplexity, FieldComplexityCalculator fieldComplexityCalculator) {
        this.maxComplexity = maxComplexity;
        this.fieldComplexityCalculator = Assert.assertNotNull(fieldComplexityCalculator, "calculator can't be null", new Object[0]);
    }

    @Override
    public InstrumentationContext<List<ValidationError>> beginValidation(InstrumentationValidationParameters parameters) {
        return SimpleInstrumentationContext.whenCompleted((errors, throwable) -> {
            if (errors != null && errors.size() > 0 || throwable != null) {
                return;
            }
            QueryTraversal queryTraversal = this.newQueryTraversal(parameters);
            LinkedHashMap valuesByParent = new LinkedHashMap();
            queryTraversal.visitPostOrder(env -> {
                int childsComplexity = 0;
                QueryVisitorEnvironment thisNodeAsParent = new QueryVisitorEnvironment(env.getField(), env.getFieldDefinition(), env.getParentType(), env.getParentEnvironment(), env.getArguments());
                if (valuesByParent.containsKey(thisNodeAsParent)) {
                    childsComplexity = ((List)valuesByParent.get(thisNodeAsParent)).stream().mapToInt(Integer::intValue).sum();
                }
                int value = this.calculateComplexity(env, childsComplexity);
                valuesByParent.putIfAbsent(env.getParentEnvironment(), new ArrayList());
                ((List)valuesByParent.get(env.getParentEnvironment())).add(value);
            });
            int totalComplexity = ((List)valuesByParent.get(null)).stream().mapToInt(Integer::intValue).sum();
            if (totalComplexity > this.maxComplexity) {
                throw this.mkAbortException(totalComplexity, this.maxComplexity);
            }
        });
    }

    protected AbortExecutionException mkAbortException(int totalComplexity, int maxComplexity) {
        return new AbortExecutionException("maximum query complexity exceeded " + totalComplexity + " > " + maxComplexity);
    }

    QueryTraversal newQueryTraversal(InstrumentationValidationParameters parameters) {
        return new QueryTraversal(parameters.getSchema(), parameters.getDocument(), parameters.getOperation(), parameters.getVariables());
    }

    private int calculateComplexity(QueryVisitorEnvironment queryVisitorEnvironment, int childsComplexity) {
        FieldComplexityEnvironment fieldComplexityEnvironment = this.convertEnv(queryVisitorEnvironment);
        return this.fieldComplexityCalculator.calculate(fieldComplexityEnvironment, childsComplexity);
    }

    private FieldComplexityEnvironment convertEnv(QueryVisitorEnvironment queryVisitorEnvironment) {
        FieldComplexityEnvironment parentEnv = null;
        if (queryVisitorEnvironment.getParentEnvironment() != null) {
            parentEnv = this.convertEnv(queryVisitorEnvironment.getParentEnvironment());
        }
        return new FieldComplexityEnvironment(queryVisitorEnvironment.getField(), queryVisitorEnvironment.getFieldDefinition(), queryVisitorEnvironment.getParentType(), queryVisitorEnvironment.getArguments(), parentEnv);
    }
}

