/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;

@Internal
public class Async {
    public static <U> CompletableFuture<List<U>> each(List<CompletableFuture<U>> futures) {
        CompletableFuture overallResult = new CompletableFuture();
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).whenComplete((noUsed, exception) -> {
            if (exception != null) {
                overallResult.completeExceptionally((Throwable)exception);
                return;
            }
            ArrayList results = new ArrayList();
            for (CompletableFuture future : futures) {
                results.add(future.join());
            }
            overallResult.complete(results);
        });
        return overallResult;
    }

    public static <T, U> CompletableFuture<List<U>> each(Iterable<T> list, BiFunction<T, Integer, CompletableFuture<U>> cfFactory) {
        ArrayList<CompletableFuture<U>> futures = new ArrayList<CompletableFuture<U>>();
        int index = 0;
        for (T t : list) {
            CompletableFuture<Object> cf;
            try {
                cf = cfFactory.apply(t, index++);
                Assert.assertNotNull(cf, "cfFactory must return a non null value", new Object[0]);
            }
            catch (Exception e) {
                cf = new CompletableFuture();
                cf.completeExceptionally(new CompletionException(e));
            }
            futures.add(cf);
        }
        return Async.each(futures);
    }

    public static <T, U> CompletableFuture<List<U>> eachSequentially(Iterable<T> list, CFFactory<T, U> cfFactory) {
        CompletableFuture<List<U>> result = new CompletableFuture<List<U>>();
        Async.eachSequentiallyImpl(list.iterator(), cfFactory, 0, new ArrayList(), result);
        return result;
    }

    private static <T, U> void eachSequentiallyImpl(Iterator<T> iterator, CFFactory<T, U> cfFactory, int index, List<U> tmpResult, CompletableFuture<List<U>> overallResult) {
        CompletableFuture<Object> cf;
        if (!iterator.hasNext()) {
            overallResult.complete(tmpResult);
        }
        try {
            cf = cfFactory.apply(iterator.next(), index, tmpResult);
            Assert.assertNotNull(cf, "cfFactory must return a non null value", new Object[0]);
        }
        catch (Exception e) {
            cf = new CompletableFuture();
            cf.completeExceptionally(new CompletionException(e));
        }
        cf.whenComplete((cfResult, exception) -> {
            if (exception != null) {
                overallResult.completeExceptionally((Throwable)exception);
                return;
            }
            tmpResult.add(cfResult);
            Async.eachSequentiallyImpl(iterator, cfFactory, index + 1, tmpResult, overallResult);
        });
    }

    public static <T> CompletableFuture<T> toCompletableFuture(T t) {
        if (t instanceof CompletionStage) {
            return ((CompletionStage)t).toCompletableFuture();
        }
        return CompletableFuture.completedFuture(t);
    }

    @FunctionalInterface
    public static interface CFFactory<T, U> {
        public CompletableFuture<U> apply(T var1, int var2, List<U> var3);
    }
}

