/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Directives;
import graphql.execution.ValuesResolver;
import graphql.language.Directive;
import graphql.language.NodeUtil;
import java.util.List;
import java.util.Map;

public class ConditionalNodes {
    private final ValuesResolver valuesResolver = new ValuesResolver();

    public boolean shouldInclude(Map<String, Object> variables, List<Directive> directives) {
        boolean skip = this.getDirectiveResult(variables, directives, Directives.SkipDirective.getName(), false);
        boolean include = this.getDirectiveResult(variables, directives, Directives.IncludeDirective.getName(), true);
        return !skip && include;
    }

    private Directive getDirectiveByName(List<Directive> directives, String name) {
        if (directives.isEmpty()) {
            return null;
        }
        return NodeUtil.directivesByName(directives).get(name);
    }

    private boolean getDirectiveResult(Map<String, Object> variables, List<Directive> directives, String directiveName, boolean defaultValue) {
        Directive directive = this.getDirectiveByName(directives, directiveName);
        if (directive != null) {
            Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(Directives.SkipDirective.getArguments(), directive.getArguments(), variables);
            return (Boolean)argumentValues.get("if");
        }
        return defaultValue;
    }
}

