/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import java.util.Map;

public class DataFetcherExceptionHandlerParameters {
    private final ExecutionContext executionContext;
    private final DataFetchingEnvironment dataFetchingEnvironment;
    private final Field field;
    private final GraphQLFieldDefinition fieldDefinition;
    private final Map<String, Object> argumentValues;
    private final ExecutionPath path;
    private final Throwable exception;

    public DataFetcherExceptionHandlerParameters(ExecutionContext executionContext, DataFetchingEnvironment dataFetchingEnvironment, Field field, GraphQLFieldDefinition fieldDefinition, Map<String, Object> argumentValues, ExecutionPath path, Throwable exception) {
        this.executionContext = executionContext;
        this.dataFetchingEnvironment = dataFetchingEnvironment;
        this.field = field;
        this.fieldDefinition = fieldDefinition;
        this.argumentValues = argumentValues;
        this.path = path;
        this.exception = exception;
    }

    public static Builder newExceptionParameters() {
        return new Builder();
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DataFetchingEnvironment getDataFetchingEnvironment() {
        return this.dataFetchingEnvironment;
    }

    public Field getField() {
        return this.field;
    }

    public GraphQLFieldDefinition getFieldDefinition() {
        return this.fieldDefinition;
    }

    public Map<String, Object> getArgumentValues() {
        return this.argumentValues;
    }

    public ExecutionPath getPath() {
        return this.path;
    }

    public Throwable getException() {
        return this.exception;
    }

    public static class Builder {
        ExecutionContext executionContext;
        DataFetchingEnvironment dataFetchingEnvironment;
        Field field;
        GraphQLFieldDefinition fieldDefinition;
        Map<String, Object> argumentValues;
        ExecutionPath path;
        Throwable exception;

        private Builder() {
        }

        public Builder executionContext(ExecutionContext executionContext) {
            this.executionContext = executionContext;
            return this;
        }

        public Builder dataFetchingEnvironment(DataFetchingEnvironment dataFetchingEnvironment) {
            this.dataFetchingEnvironment = dataFetchingEnvironment;
            return this;
        }

        public Builder field(Field field) {
            this.field = field;
            return this;
        }

        public Builder fieldDefinition(GraphQLFieldDefinition fieldDefinition) {
            this.fieldDefinition = fieldDefinition;
            return this;
        }

        public Builder argumentValues(Map<String, Object> argumentValues) {
            this.argumentValues = argumentValues;
            return this;
        }

        public Builder path(ExecutionPath path) {
            this.path = path;
            return this;
        }

        public Builder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public DataFetcherExceptionHandlerParameters build() {
            return new DataFetcherExceptionHandlerParameters(this.executionContext, this.dataFetchingEnvironment, this.field, this.fieldDefinition, this.argumentValues, this.path, this.exception);
        }
    }
}

