/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TypeMismatchError;
import graphql.TypeResolutionEnvironment;
import graphql.execution.AbsoluteGraphQLError;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.TypeResolutionParameters;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Field;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().get(0));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = instrumentation.beginField(new InstrumentationFieldParameters(executionContext, fieldDef, this.fieldTypeInfo(parameters, fieldDef)));
        CompletionStage result = this.fetchField(executionContext, parameters).thenCompose(fetchedValue -> this.completeField(executionContext, parameters, fetchedValue));
        fieldCtx.onDispatched((CompletableFuture<ExecutionResult>)result);
        ((CompletableFuture)result).whenComplete(fieldCtx::onCompleted);
        return result;
    }

    protected CompletableFuture<Object> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<Object> fetchedValue;
        Field field = parameters.getField().get(0);
        GraphQLObjectType parentType = parameters.getTypeInfo().castType(GraphQLObjectType.class);
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        GraphqlFieldVisibility fieldVisibility = executionContext.getGraphQLSchema().getFieldVisibility();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldVisibility, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        GraphQLOutputType fieldType = fieldDef.getType();
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext, fieldType, parameters.getField());
        ExecutionTypeInfo fieldTypeInfo = this.fieldTypeInfo(parameters, fieldDef);
        DataFetchingEnvironment environment = DataFetchingEnvironmentBuilder.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).arguments(argumentValues).fieldDefinition(fieldDef).fields(parameters.getField()).fieldType(fieldType).fieldTypeInfo(fieldTypeInfo).parentType(parentType).selectionSet(fieldCollector).build();
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, fieldDef, environment);
        InstrumentationContext<Object> fetchCtx = instrumentation.beginFieldFetch(instrumentationFieldFetchParams);
        DataFetcher<?> dataFetcher = fieldDef.getDataFetcher();
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams);
        ExecutionId executionId = executionContext.getExecutionId();
        try {
            log.debug("'{}' fetching field '{}' using data fetcher '{}'...", executionId, fieldTypeInfo.getPath(), dataFetcher.getClass().getName());
            Object fetchedValueRaw = dataFetcher.get(environment);
            log.debug("'{}' field '{}' fetch returned '{}'", executionId, fieldTypeInfo.getPath(), fetchedValueRaw == null ? "null" : fetchedValueRaw.getClass().getName());
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            log.debug(String.format("'%s', field '%s' fetch threw exception", executionId, fieldTypeInfo.getPath()), e);
            fetchedValue = new CompletableFuture();
            fetchedValue.completeExceptionally(e);
        }
        fetchCtx.onDispatched(fetchedValue);
        return ((CompletableFuture)((CompletableFuture)fetchedValue.handle((result, exception) -> {
            fetchCtx.onCompleted(result, (Throwable)exception);
            if (exception != null) {
                this.handleFetchingException(executionContext, parameters, field, fieldDef, argumentValues, environment, (Throwable)exception);
                return null;
            }
            return result;
        })).thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result))).thenApply(this::unboxPossibleOptional);
    }

    Object unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            dataFetcherResult.getErrors().stream().map(relError -> new AbsoluteGraphQLError(parameters, (GraphQLError)relError)).forEach(executionContext::addError);
            return dataFetcherResult.getData();
        }
        return result;
    }

    private void handleFetchingException(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field, GraphQLFieldDefinition fieldDef, Map<String, Object> argumentValues, DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().executionContext(executionContext).dataFetchingEnvironment(environment).argumentValues(argumentValues).field(field).fieldDefinition(fieldDef).path(parameters.getPath()).exception(e).build();
        this.dataFetcherExceptionHandler.accept(handlerParameters);
        parameters.deferredErrorSupport().onFetchingException(parameters, e);
    }

    protected CompletableFuture<ExecutionResult> completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object fetchedValue) {
        Field field = parameters.getField().get(0);
        GraphQLObjectType parentType = parameters.getTypeInfo().castType(GraphQLObjectType.class);
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        ExecutionTypeInfo fieldTypeInfo = this.fieldTypeInfo(parameters, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, fieldTypeInfo, fetchedValue);
        InstrumentationContext<ExecutionResult> ctxCompleteField = instrumentation.beginFieldComplete(instrumentationParams);
        GraphqlFieldVisibility fieldVisibility = executionContext.getGraphQLSchema().getFieldVisibility();
        Map<String, Object> argumentValues = this.valuesResolver.getArgumentValues(fieldVisibility, fieldDef.getArguments(), field.getArguments(), executionContext.getVariables());
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, fieldTypeInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.typeInfo(fieldTypeInfo).arguments(argumentValues).source(fetchedValue).nonNullFieldValidator(nonNullableFieldValidator));
        log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)fieldTypeInfo.getPath());
        CompletableFuture<ExecutionResult> cf = this.completeValue(executionContext, newParameters);
        ctxCompleteField.onDispatched(cf);
        cf.whenComplete(ctxCompleteField::onCompleted);
        return cf;
    }

    protected CompletableFuture<ExecutionResult> completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = parameters.getTypeInfo();
        Object result = this.unboxPossibleOptional(parameters.getSource());
        GraphQLType fieldType = typeInfo.getType();
        if (result == null) {
            return this.completeValueForNull(parameters);
        }
        if (fieldType instanceof GraphQLList) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (fieldType instanceof GraphQLScalarType) {
            return this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
        }
        if (fieldType instanceof GraphQLEnumType) {
            return this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
        }
        GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
        return this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
    }

    private CompletableFuture<ExecutionResult> completeValueForNull(ExecutionStrategyParameters parameters) {
        Object nullValue = parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(nullValue, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        resultIterable = parameters.getNonNullFieldValidator().validate(parameters.getPath(), resultIterable);
        if (resultIterable == null) {
            return CompletableFuture.completedFuture(new ExecutionResultImpl(null, null));
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected CompletableFuture<ExecutionResult> completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        ExecutionTypeInfo typeInfo = parameters.getTypeInfo();
        GraphQLList fieldType = typeInfo.castType(GraphQLList.class);
        GraphQLFieldDefinition fieldDef = parameters.getTypeInfo().getFieldDefinition();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, fieldDef, this.fieldTypeInfo(parameters, fieldDef), iterableValues);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> completeListCtx = instrumentation.beginFieldListComplete(instrumentationParams);
        CompletableFuture resultsFuture = Async.each(iterableValues, (item, index) -> {
            ExecutionPath indexedPath = parameters.getPath().segment((int)index);
            ExecutionTypeInfo wrappedTypeInfo = ExecutionTypeInfo.newTypeInfo().parentInfo(typeInfo).type(fieldType.getWrappedType()).path(indexedPath).fieldDefinition(fieldDef).build();
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, wrappedTypeInfo);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.typeInfo(wrappedTypeInfo).nonNullFieldValidator(nonNullableFieldValidator).path(indexedPath).source(item));
            return this.completeValue(executionContext, newParameters);
        });
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted(executionResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList();
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, null);
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete(completeListCtx::onCompleted);
        return overallResult;
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionTypeInfo typeInfo = parameters.getTypeInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        Map<String, List<Field>> subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField());
        ExecutionTypeInfo newTypeInfo = typeInfo.treatAs(resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newTypeInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.typeInfo(newTypeInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).source(result));
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        log.warn(error.getMessage(), e);
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
        return null;
    }

    protected Object unboxPossibleOptional(Object result) {
        if (result instanceof Optional) {
            Optional optional = (Optional)result;
            if (optional.isPresent()) {
                return optional.get();
            }
            return null;
        }
        if (result instanceof OptionalInt) {
            OptionalInt optional = (OptionalInt)result;
            if (optional.isPresent()) {
                return optional.getAsInt();
            }
            return null;
        }
        if (result instanceof OptionalDouble) {
            OptionalDouble optional = (OptionalDouble)result;
            if (optional.isPresent()) {
                return optional.getAsDouble();
            }
            return null;
        }
        if (result instanceof OptionalLong) {
            OptionalLong optional = (OptionalLong)result;
            if (optional.isPresent()) {
                return optional.getAsLong();
            }
            return null;
        }
        return result;
    }

    protected Iterable<Object> toIterable(Object result) {
        if (result.getClass().isArray()) {
            return IntStream.range(0, Array.getLength(result)).mapToObj(i -> Array.get(result, i)).collect(Collectors.toList());
        }
        return (Iterable)result;
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        GraphQLObjectType resolvedType;
        if (fieldType instanceof GraphQLInterfaceType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLInterfaceType((GraphQLInterfaceType)fieldType).field(parameters.getField().get(0)).value(parameters.getSource()).argumentValues(parameters.getArguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForInterface(resolutionParams);
        } else if (fieldType instanceof GraphQLUnionType) {
            TypeResolutionParameters resolutionParams = TypeResolutionParameters.newParameters().graphQLUnionType((GraphQLUnionType)fieldType).field(parameters.getField().get(0)).value(parameters.getSource()).argumentValues(parameters.getArguments()).context(executionContext.getContext()).schema(executionContext.getGraphQLSchema()).build();
            resolvedType = this.resolveTypeForUnion(resolutionParams);
        } else {
            resolvedType = (GraphQLObjectType)fieldType;
        }
        return resolvedType;
    }

    protected GraphQLObjectType resolveTypeForInterface(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLInterfaceType(), params.getSchema(), params.getContext());
        GraphQLObjectType result = params.getGraphQLInterfaceType().getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(params.getGraphQLInterfaceType());
        }
        return result;
    }

    protected GraphQLObjectType resolveTypeForUnion(TypeResolutionParameters params) {
        TypeResolutionEnvironment env = new TypeResolutionEnvironment(params.getValue(), params.getArgumentValues(), params.getField(), params.getGraphQLUnionType(), params.getSchema(), params.getContext());
        GraphQLObjectType result = params.getGraphQLUnionType().getTypeResolver().getType(env);
        if (result == null) {
            throw new UnresolvedTypeException(params.getGraphQLUnionType());
        }
        return result;
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (result.getClass().isArray() || result instanceof Iterable) {
            return this.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters, result);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getTypeInfo().getType());
        log.warn("{} got {}", (Object)error.getMessage(), (Object)result.getClass());
        context.addError(error);
        parameters.deferredErrorSupport().onError(error);
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = parameters.getTypeInfo().castType(GraphQLObjectType.class);
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = e.getTypeInfo();
        if (typeInfo.hasParentType() && typeInfo.getParentTypeInfo().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionTypeInfo typeInfo = e.getTypeInfo();
        if (typeInfo.hasParentType() && typeInfo.getParentTypeInfo().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResultImpl executionResult = null;
        if (e instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)e, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, executionContext.getErrors());
                result.complete(executionResult);
            }
        } else if (e instanceof CompletionException && e.getCause() instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)e.getCause(), result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, executionContext.getErrors());
                result.complete(executionResult);
            }
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionTypeInfo fieldTypeInfo(ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition) {
        GraphQLOutputType fieldType = fieldDefinition.getType();
        return ExecutionTypeInfo.newTypeInfo().type(fieldType).fieldDefinition(fieldDefinition).path(parameters.getPath()).parentInfo(parameters.getTypeInfo()).build();
    }
}

