/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Internal;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionTypeInfo;
import graphql.execution.NonNullableFieldWasNullError;
import graphql.execution.NonNullableFieldWasNullException;

@Internal
public class NonNullableFieldValidator {
    private final ExecutionContext executionContext;
    private final ExecutionTypeInfo typeInfo;

    public NonNullableFieldValidator(ExecutionContext executionContext, ExecutionTypeInfo typeInfo) {
        this.executionContext = executionContext;
        this.typeInfo = typeInfo;
    }

    public <T> T validate(ExecutionPath path, T result) throws NonNullableFieldWasNullException {
        if (result == null && this.typeInfo.isNonNullType()) {
            NonNullableFieldWasNullException nonNullException = new NonNullableFieldWasNullException(this.typeInfo, path);
            this.executionContext.addError(new NonNullableFieldWasNullError(nonNullException), path);
            throw nonNullException;
        }
        return result;
    }
}

