/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Value;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;

public class Argument
extends AbstractNode<Argument> {
    private final String name;
    private final Value value;

    public Argument(String name, Value value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.value);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument that = (Argument)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public Argument deepCopy() {
        return new Argument(this.name, this.deepCopy(this.value));
    }

    public String toString() {
        return "Argument{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitArgument(this, context);
    }
}

