/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@PublicApi
public class FragmentDefinition
extends AbstractNode<FragmentDefinition>
implements Definition<FragmentDefinition> {
    private String name;
    private TypeName typeCondition;
    private List<Directive> directives;
    private SelectionSet selectionSet;

    public FragmentDefinition() {
        this(null, null, new ArrayList<Directive>(), null);
    }

    public FragmentDefinition(String name, TypeName typeCondition) {
        this(name, typeCondition, new ArrayList<Directive>(), null);
    }

    public FragmentDefinition(String name, TypeName typeCondition, SelectionSet selectionSet) {
        this(name, typeCondition, new ArrayList<Directive>(), selectionSet);
    }

    public FragmentDefinition(String name, TypeName typeCondition, List<Directive> directives, SelectionSet selectionSet) {
        this.name = name;
        this.typeCondition = typeCondition;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeName getTypeCondition() {
        return this.typeCondition;
    }

    public void setTypeCondition(TypeName typeCondition) {
        this.typeCondition = typeCondition;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    public void setSelectionSet(SelectionSet selectionSet) {
        this.selectionSet = selectionSet;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(this.typeCondition);
        result.addAll(this.directives);
        result.add(this.selectionSet);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentDefinition that = (FragmentDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public FragmentDefinition deepCopy() {
        return new FragmentDefinition(this.name, this.deepCopy(this.typeCondition), this.deepCopy(this.directives), this.deepCopy(this.selectionSet));
    }

    public String toString() {
        return "FragmentDefinition{name='" + this.name + '\'' + ", typeCondition='" + this.typeCondition + '\'' + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor nodeVisitor) {
        return nodeVisitor.visitFragmentDefinition(this, context);
    }
}

