/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.language.AbstractNode;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.TypeDefinition;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InputObjectTypeDefinition
extends AbstractNode<InputObjectTypeDefinition>
implements TypeDefinition<InputObjectTypeDefinition> {
    private final String name;
    private Description description;
    private final List<Directive> directives;
    private final List<InputValueDefinition> inputValueDefinitions;

    public InputObjectTypeDefinition(String name) {
        this(name, new ArrayList<Directive>(), new ArrayList<InputValueDefinition>());
    }

    public InputObjectTypeDefinition(String name, List<Directive> directives, List<InputValueDefinition> inputValueDefinitions) {
        this.name = name;
        this.directives = directives;
        this.inputValueDefinitions = inputValueDefinitions;
    }

    @Override
    public List<Directive> getDirectives() {
        return this.directives;
    }

    public Map<String, Directive> getDirectivesByName() {
        return NodeUtil.directivesByName(this.directives);
    }

    public Directive getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public List<InputValueDefinition> getInputValueDefinitions() {
        return this.inputValueDefinitions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.directives);
        result.addAll(this.inputValueDefinitions);
        return result;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputObjectTypeDefinition that = (InputObjectTypeDefinition)o;
        return NodeUtil.isEqualTo(this.name, that.name);
    }

    @Override
    public InputObjectTypeDefinition deepCopy() {
        return new InputObjectTypeDefinition(this.name, this.deepCopy(this.directives), this.deepCopy(this.inputValueDefinitions));
    }

    public String toString() {
        return "InputObjectTypeDefinition{name='" + this.name + '\'' + ", directives=" + this.directives + ", inputValueDefinitions=" + this.inputValueDefinitions + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitInputObjectTypeDefinition(this, context);
    }
}

