/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

@PublicApi
public class AsyncDataFetcher<T>
implements DataFetcher<CompletableFuture<T>> {
    private final DataFetcher<T> wrappedDataFetcher;
    private final Executor executor;

    public static <T> AsyncDataFetcher<T> async(DataFetcher<T> wrappedDataFetcher) {
        return new AsyncDataFetcher<T>(wrappedDataFetcher);
    }

    public static <T> AsyncDataFetcher<T> async(DataFetcher<T> wrappedDataFetcher, Executor executor) {
        return new AsyncDataFetcher<T>(wrappedDataFetcher, executor);
    }

    public AsyncDataFetcher(DataFetcher<T> wrappedDataFetcher) {
        this(wrappedDataFetcher, ForkJoinPool.commonPool());
    }

    public AsyncDataFetcher(DataFetcher<T> wrappedDataFetcher, Executor executor) {
        this.wrappedDataFetcher = Assert.assertNotNull(wrappedDataFetcher, "wrappedDataFetcher can't be null", new Object[0]);
        this.executor = Assert.assertNotNull(executor, "executor can't be null", new Object[0]);
    }

    @Override
    public CompletableFuture<T> get(DataFetchingEnvironment environment) {
        return CompletableFuture.supplyAsync(() -> this.wrappedDataFetcher.get(environment), this.executor);
    }
}

