/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.DirectivesUtil;
import graphql.Internal;
import graphql.PublicApi;
import graphql.schema.GraphQLDirective;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@PublicApi
public class GraphQLEnumValueDefinition {
    private final String name;
    private final String description;
    private final Object value;
    private final String deprecationReason;
    private final List<GraphQLDirective> directives;

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value) {
        this(name, description, value, null, Collections.emptyList());
    }

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason) {
        this(name, description, value, deprecationReason, Collections.emptyList());
    }

    @Internal
    public GraphQLEnumValueDefinition(String name, String description, Object value, String deprecationReason, List<GraphQLDirective> directives) {
        Assert.assertValidName(name);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.value = value;
        this.deprecationReason = deprecationReason;
        this.directives = directives;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public Map<String, GraphQLDirective> getDirectivesByName() {
        return DirectivesUtil.directivesByName(this.directives);
    }

    public GraphQLDirective getDirective(String directiveName) {
        return this.getDirectivesByName().get(directiveName);
    }

    public static Builder newEnumValueDefinition() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private Object value;
        private String deprecationReason;
        private List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder deprecationReason(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Collections.addAll(this.directives, directives);
            return this;
        }

        public GraphQLEnumValueDefinition build() {
            return new GraphQLEnumValueDefinition(this.name, this.description, this.value, this.deprecationReason, this.directives);
        }
    }
}

