/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLFieldDefinition
implements GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private GraphQLOutputType type;
    private final DataFetcherFactory dataFetcherFactory;
    private final String deprecationReason;
    private final List<GraphQLArgument> arguments;
    private final List<GraphQLDirective> directives;
    private final FieldDefinition definition;

    @Deprecated
    @Internal
    public GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcher<?> dataFetcher, List<GraphQLArgument> arguments, String deprecationReason) {
        this(name, description, type, DataFetcherFactories.useDataFetcher(dataFetcher), arguments, deprecationReason, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcherFactory dataFetcherFactory, List<GraphQLArgument> arguments, String deprecationReason, List<GraphQLDirective> directives, FieldDefinition definition) {
        this.directives = directives;
        Assert.assertValidName(name);
        Assert.assertNotNull(dataFetcherFactory, "you have to provide a DataFetcher (or DataFetcherFactory)", new Object[0]);
        Assert.assertNotNull(type, "type can't be null", new Object[0]);
        Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.type = type;
        this.dataFetcherFactory = dataFetcherFactory;
        this.arguments = Collections.unmodifiableList(new ArrayList<GraphQLArgument>(arguments));
        this.deprecationReason = deprecationReason;
        this.definition = definition;
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.type = (GraphQLOutputType)new SchemaUtil().resolveTypeReference(this.type, typeMap);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLOutputType getType() {
        return this.type;
    }

    public DataFetcher getDataFetcher() {
        return this.dataFetcherFactory.get(DataFetcherFactoryEnvironment.newDataFetchingFactoryEnvironment().fieldDefinition(this).build());
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public List<GraphQLArgument> getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public FieldDefinition getDefinition() {
        return this.definition;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String toString() {
        return "GraphQLFieldDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", arguments=" + this.arguments + ", dataFetcherFactory=" + this.dataFetcherFactory + ", description='" + this.description + '\'' + ", deprecationReason='" + this.deprecationReason + '\'' + ", definition=" + this.definition + '}';
    }

    public static Builder newFieldDefinition() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private GraphQLOutputType type;
        private DataFetcherFactory<?> dataFetcherFactory;
        private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        private final List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();
        private String deprecationReason;
        private FieldDefinition definition;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder definition(FieldDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(GraphQLObjectType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLInterfaceType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLUnionType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        public Builder dataFetcher(DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher, "dataFetcher must be not null", new Object[0]);
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
            return this;
        }

        public Builder dataFetcherFactory(DataFetcherFactory dataFetcherFactory) {
            Assert.assertNotNull(dataFetcherFactory, "dataFetcherFactory must be not null", new Object[0]);
            this.dataFetcherFactory = dataFetcherFactory;
            return this;
        }

        public Builder staticValue(Object value) {
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(environment -> value);
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            this.arguments.add(argument);
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            this.arguments.add(builder.build());
            return this;
        }

        public Builder argument(List<GraphQLArgument> arguments) {
            this.arguments.addAll(arguments);
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Collections.addAll(this.directives, directives);
            return this;
        }

        public GraphQLFieldDefinition build() {
            if (this.dataFetcherFactory == null) {
                this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(new PropertyDataFetcher(this.name));
            }
            return new GraphQLFieldDefinition(this.name, this.description, this.type, this.dataFetcherFactory, this.arguments, this.deprecationReason, this.directives, this.definition);
        }
    }
}

