/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.UnionTypeDefinition;
import graphql.schema.GraphQLCompositeType;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLNullableType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnmodifiedType;
import graphql.schema.SchemaUtil;
import graphql.schema.TypeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@PublicApi
public class GraphQLUnionType
implements GraphQLType,
GraphQLOutputType,
GraphQLCompositeType,
GraphQLUnmodifiedType,
GraphQLNullableType,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private List<GraphQLOutputType> types = new ArrayList<GraphQLOutputType>();
    private final TypeResolver typeResolver;
    private final UnionTypeDefinition definition;
    private final List<GraphQLDirective> directives;

    @Internal
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver) {
        this(name, description, types, typeResolver, Collections.emptyList(), null);
    }

    @Internal
    public GraphQLUnionType(String name, String description, List<GraphQLOutputType> types, TypeResolver typeResolver, List<GraphQLDirective> directives, UnionTypeDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(types, "types can't be null", new Object[0]);
        Assert.assertNotEmpty(types, "A Union type must define one or more member types.", new Object[0]);
        Assert.assertNotNull(typeResolver, "typeResolver can't be null", new Object[0]);
        Assert.assertNotNull(directives, "directives cannot be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.types = types;
        this.typeResolver = typeResolver;
        this.definition = definition;
        this.directives = directives;
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.types = this.types.stream().map(type -> (GraphQLOutputType)new SchemaUtil().resolveTypeReference((GraphQLType)type, typeMap)).collect(Collectors.toList());
    }

    public List<GraphQLOutputType> getTypes() {
        return new ArrayList<GraphQLOutputType>(this.types);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public UnionTypeDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public static Builder newUnionType() {
        return new Builder();
    }

    @PublicApi
    public static class Builder {
        private String name;
        private String description;
        private final List<GraphQLOutputType> types = new ArrayList<GraphQLOutputType>();
        private TypeResolver typeResolver;
        private UnionTypeDefinition definition;
        private final List<GraphQLDirective> directives = new ArrayList<GraphQLDirective>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder definition(UnionTypeDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder typeResolver(TypeResolver typeResolver) {
            this.typeResolver = typeResolver;
            return this;
        }

        public Builder possibleType(GraphQLObjectType type) {
            Assert.assertNotNull(type, "possible type can't be null", new Object[0]);
            this.types.add(type);
            return this;
        }

        public Builder possibleType(GraphQLTypeReference reference) {
            Assert.assertNotNull(reference, "reference can't be null", new Object[0]);
            this.types.add(reference);
            return this;
        }

        public Builder possibleTypes(GraphQLObjectType ... type) {
            for (GraphQLObjectType graphQLType : type) {
                this.possibleType(graphQLType);
            }
            return this;
        }

        public Builder possibleTypes(GraphQLTypeReference ... references) {
            for (GraphQLTypeReference reference : references) {
                this.possibleType(reference);
            }
            return this;
        }

        public boolean containType(String name) {
            return this.types.stream().anyMatch(type -> type.getName().equals(name));
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Collections.addAll(this.directives, directives);
            return this;
        }

        public GraphQLUnionType build() {
            return new GraphQLUnionType(this.name, this.description, this.types, this.typeResolver, this.directives, this.definition);
        }
    }
}

