/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.AssertException;
import graphql.Internal;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphQLUnmodifiedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class SchemaUtil {
    public boolean isLeafType(GraphQLType type) {
        GraphQLUnmodifiedType unmodifiedType = this.getUnmodifiedType(type);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType;
    }

    public boolean isInputType(GraphQLType graphQLType) {
        GraphQLUnmodifiedType unmodifiedType = this.getUnmodifiedType(graphQLType);
        return unmodifiedType instanceof GraphQLScalarType || unmodifiedType instanceof GraphQLEnumType || unmodifiedType instanceof GraphQLInputObjectType;
    }

    public GraphQLUnmodifiedType getUnmodifiedType(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLModifiedType) {
            return this.getUnmodifiedType(((GraphQLModifiedType)graphQLType).getWrappedType());
        }
        return (GraphQLUnmodifiedType)graphQLType;
    }

    private void collectTypes(GraphQLType root, Map<String, GraphQLType> result) {
        if (root instanceof GraphQLNonNull) {
            this.collectTypes(((GraphQLNonNull)root).getWrappedType(), result);
        } else if (root instanceof GraphQLList) {
            this.collectTypes(((GraphQLList)root).getWrappedType(), result);
        } else if (root instanceof GraphQLEnumType) {
            this.assertTypeUniqueness(root, result);
            result.put(root.getName(), root);
        } else if (root instanceof GraphQLScalarType) {
            this.assertTypeUniqueness(root, result);
            result.put(root.getName(), root);
        } else if (root instanceof GraphQLObjectType) {
            this.collectTypesForObjects((GraphQLObjectType)root, result);
        } else if (root instanceof GraphQLInterfaceType) {
            this.collectTypesForInterfaces((GraphQLInterfaceType)root, result);
        } else if (root instanceof GraphQLUnionType) {
            this.collectTypesForUnions((GraphQLUnionType)root, result);
        } else if (root instanceof GraphQLInputObjectType) {
            this.collectTypesForInputObjects((GraphQLInputObjectType)root, result);
        } else if (!(root instanceof GraphQLTypeReference)) {
            Assert.assertShouldNeverHappen("Unknown type %s", root);
        }
    }

    private void assertTypeUniqueness(GraphQLType type, Map<String, GraphQLType> result) {
        GraphQLType existingType = result.get(type.getName());
        if (existingType != null && !(existingType instanceof GraphQLTypeReference) && !(type instanceof GraphQLTypeReference) && existingType != type) {
            throw new AssertException(String.format("All types within a GraphQL schema must have unique names. No two provided types may have the same name.\nNo provided type may have a name which conflicts with any built in types (including Scalar and Introspection types).\nYou have redefined the type '%s' from being a '%s' to a '%s'", type.getName(), existingType.getClass().getSimpleName(), type.getClass().getSimpleName()));
        }
    }

    private void collectTypesForUnions(GraphQLUnionType unionType, Map<String, GraphQLType> result) {
        this.assertTypeUniqueness(unionType, result);
        result.put(unionType.getName(), unionType);
        for (GraphQLType graphQLType : unionType.getTypes()) {
            this.collectTypes(graphQLType, result);
        }
    }

    private void collectTypesForInterfaces(GraphQLInterfaceType interfaceType, Map<String, GraphQLType> result) {
        if (result.containsKey(interfaceType.getName()) && !(result.get(interfaceType.getName()) instanceof GraphQLTypeReference)) {
            this.assertTypeUniqueness(interfaceType, result);
            return;
        }
        result.put(interfaceType.getName(), interfaceType);
        for (GraphQLFieldDefinition fieldDefinition : interfaceType.getFieldDefinitions()) {
            this.collectTypes(fieldDefinition.getType(), result);
            for (GraphQLArgument fieldArgument : fieldDefinition.getArguments()) {
                this.collectTypes(fieldArgument.getType(), result);
            }
        }
    }

    private void collectTypesForObjects(GraphQLObjectType objectType, Map<String, GraphQLType> result) {
        if (result.containsKey(objectType.getName()) && !(result.get(objectType.getName()) instanceof GraphQLTypeReference)) {
            this.assertTypeUniqueness(objectType, result);
            return;
        }
        result.put(objectType.getName(), objectType);
        for (GraphQLFieldDefinition fieldDefinition : objectType.getFieldDefinitions()) {
            this.collectTypes(fieldDefinition.getType(), result);
            for (GraphQLArgument fieldArgument : fieldDefinition.getArguments()) {
                this.collectTypes(fieldArgument.getType(), result);
            }
        }
        for (GraphQLOutputType interfaceType : objectType.getInterfaces()) {
            this.collectTypes(interfaceType, result);
        }
    }

    private void collectTypesForInputObjects(GraphQLInputObjectType objectType, Map<String, GraphQLType> result) {
        if (result.containsKey(objectType.getName()) && !(result.get(objectType.getName()) instanceof GraphQLTypeReference)) {
            this.assertTypeUniqueness(objectType, result);
            return;
        }
        result.put(objectType.getName(), objectType);
        for (GraphQLInputObjectField fieldDefinition : objectType.getFields()) {
            this.collectTypes(fieldDefinition.getType(), result);
        }
    }

    Map<String, GraphQLType> allTypes(GraphQLSchema schema, Set<GraphQLType> additionalTypes) {
        LinkedHashMap<String, GraphQLType> typesByName = new LinkedHashMap<String, GraphQLType>();
        this.collectTypes(schema.getQueryType(), typesByName);
        if (schema.isSupportingMutations()) {
            this.collectTypes(schema.getMutationType(), typesByName);
        }
        if (schema.isSupportingSubscriptions()) {
            this.collectTypes(schema.getSubscriptionType(), typesByName);
        }
        if (additionalTypes != null) {
            for (GraphQLType type : additionalTypes) {
                this.collectTypes(type, typesByName);
            }
        }
        this.collectTypes(Introspection.__Schema, typesByName);
        return typesByName;
    }

    Map<String, List<GraphQLObjectType>> groupImplementations(GraphQLSchema schema) {
        HashMap<String, List<GraphQLObjectType>> result = new HashMap<String, List<GraphQLObjectType>>();
        for (GraphQLType type : schema.getAllTypesAsList()) {
            if (!(type instanceof GraphQLObjectType)) continue;
            for (GraphQLOutputType interfaceType : ((GraphQLObjectType)type).getInterfaces()) {
                List myGroup = result.computeIfAbsent(interfaceType.getName(), k -> new ArrayList());
                myGroup.add((GraphQLObjectType)type);
            }
        }
        return result;
    }

    @Deprecated
    public List<GraphQLObjectType> findImplementations(GraphQLSchema schema, GraphQLInterfaceType interfaceType) {
        ArrayList<GraphQLObjectType> result = new ArrayList<GraphQLObjectType>();
        for (GraphQLType type : schema.getAllTypesAsList()) {
            GraphQLObjectType objectType;
            if (!(type instanceof GraphQLObjectType) || !(objectType = (GraphQLObjectType)type).getInterfaces().contains(interfaceType)) continue;
            result.add(objectType);
        }
        return result;
    }

    void replaceTypeReferences(GraphQLSchema schema) {
        Map<String, GraphQLType> typeMap = schema.getTypeMap();
        for (GraphQLType type : typeMap.values()) {
            if (type instanceof GraphQLFieldsContainer) {
                this.resolveTypeReferencesForFieldsContainer((GraphQLFieldsContainer)type, typeMap);
            }
            if (type instanceof GraphQLInputFieldsContainer) {
                this.resolveTypeReferencesForInputFieldsContainer((GraphQLInputFieldsContainer)type, typeMap);
            }
            if (type instanceof GraphQLObjectType) {
                ((GraphQLObjectType)type).replaceTypeReferences(typeMap);
            }
            if (!(type instanceof GraphQLUnionType)) continue;
            ((GraphQLUnionType)type).replaceTypeReferences(typeMap);
        }
    }

    private void resolveTypeReferencesForFieldsContainer(GraphQLFieldsContainer fieldsContainer, Map<String, GraphQLType> typeMap) {
        for (GraphQLFieldDefinition fieldDefinition : fieldsContainer.getFieldDefinitions()) {
            fieldDefinition.replaceTypeReferences(typeMap);
            for (GraphQLArgument argument : fieldDefinition.getArguments()) {
                argument.replaceTypeReferences(typeMap);
            }
        }
    }

    private void resolveTypeReferencesForInputFieldsContainer(GraphQLInputFieldsContainer fieldsContainer, Map<String, GraphQLType> typeMap) {
        for (GraphQLInputObjectField fieldDefinition : fieldsContainer.getFieldDefinitions()) {
            fieldDefinition.replaceTypeReferences(typeMap);
        }
    }

    GraphQLType resolveTypeReference(GraphQLType type, Map<String, GraphQLType> typeMap) {
        if (type instanceof GraphQLTypeReference || typeMap.containsKey(type.getName())) {
            GraphQLType resolvedType = typeMap.get(type.getName());
            Assert.assertTrue(resolvedType != null, "type %s not found in schema", type.getName());
            return resolvedType;
        }
        if (type instanceof GraphQLList) {
            ((GraphQLList)type).replaceTypeReferences(typeMap);
        }
        if (type instanceof GraphQLNonNull) {
            ((GraphQLNonNull)type).replaceTypeReferences(typeMap);
        }
        return type;
    }
}

