/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Assert;
import graphql.Internal;
import graphql.Scalars;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Comment;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public class SchemaGeneratorHelper {
    public Object buildValue(Value value, GraphQLType requiredType) {
        List result = null;
        if (requiredType instanceof GraphQLNonNull) {
            requiredType = ((GraphQLNonNull)requiredType).getWrappedType();
        }
        if (requiredType instanceof GraphQLScalarType) {
            result = this.parseLiteral(value, (GraphQLScalarType)requiredType);
        } else if (value instanceof EnumValue && requiredType instanceof GraphQLEnumType) {
            result = ((EnumValue)value).getName();
        } else if (value instanceof ArrayValue && requiredType instanceof GraphQLList) {
            ArrayValue arrayValue = (ArrayValue)value;
            GraphQLType wrappedType = ((GraphQLList)requiredType).getWrappedType();
            result = arrayValue.getValues().stream().map(item -> this.buildValue((Value)item, wrappedType)).collect(Collectors.toList());
        } else if (value instanceof ObjectValue && requiredType instanceof GraphQLInputObjectType) {
            result = this.buildObjectValue((ObjectValue)value, (GraphQLInputObjectType)requiredType);
        } else if (value != null && !(value instanceof NullValue)) {
            Assert.assertShouldNeverHappen("cannot build value of %s from %s", requiredType.getName(), String.valueOf(value));
        }
        return result;
    }

    private Object parseLiteral(Value value, GraphQLScalarType requiredType) {
        if (value instanceof NullValue) {
            return null;
        }
        return requiredType.getCoercing().parseLiteral(value);
    }

    public Object buildObjectValue(ObjectValue defaultValue, GraphQLInputObjectType objectType) {
        LinkedHashMap map = new LinkedHashMap();
        defaultValue.getObjectFields().forEach(of -> map.put(of.getName(), this.buildValue(of.getValue(), objectType.getField(of.getName()).getType())));
        return map;
    }

    public String buildDescription(Node<?> node, Description description) {
        if (description != null) {
            return description.getContent();
        }
        List<Comment> comments = node.getComments();
        ArrayList<String> lines = new ArrayList<String>();
        for (Comment comment : comments) {
            String commentLine = comment.getContent();
            if (commentLine.trim().isEmpty()) {
                lines.clear();
                continue;
            }
            lines.add(commentLine);
        }
        if (lines.size() == 0) {
            return null;
        }
        return lines.stream().collect(Collectors.joining("\n"));
    }

    public String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = directives == null ? Collections.emptyList() : directives).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return "No longer supported";
            }
            return args.get("reason");
        }
        return null;
    }

    public GraphQLInputType buildDirectiveInputType(Value value) {
        if (value instanceof NullValue) {
            return Scalars.GraphQLString;
        }
        if (value instanceof FloatValue) {
            return Scalars.GraphQLFloat;
        }
        if (value instanceof StringValue) {
            return Scalars.GraphQLString;
        }
        if (value instanceof IntValue) {
            return Scalars.GraphQLInt;
        }
        if (value instanceof BooleanValue) {
            return Scalars.GraphQLBoolean;
        }
        return (GraphQLInputType)Assert.assertShouldNeverHappen("Directive values of type '%s' are not supported yet", value.getClass().getName());
    }

    public GraphQLDirective buildDirective(Directive directive, Introspection.DirectiveLocation directiveLocation) {
        List arguments = directive.getArguments().stream().map(this::buildDirectiveArgument).collect(Collectors.toList());
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directive.getName()).description(this.buildDescription(directive, null)).validLocations(directiveLocation);
        for (GraphQLArgument argument : arguments) {
            builder.argument(argument);
        }
        return builder.build();
    }

    private GraphQLArgument buildDirectiveArgument(Argument arg) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.name(arg.getName());
        GraphQLInputType inputType = this.buildDirectiveInputType(arg.getValue());
        builder.type(inputType);
        builder.defaultValue(this.buildValue(arg.getValue(), inputType));
        return builder.build();
    }
}

