/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.schema.validation.SchemaValidationRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoUnbrokenInputCycles
implements SchemaValidationRule {
    @Override
    public void check(GraphQLType type, SchemaValidationErrorCollector validationErrorCollector) {
    }

    @Override
    public void check(GraphQLFieldDefinition fieldDef, SchemaValidationErrorCollector validationErrorCollector) {
        for (GraphQLArgument argument : fieldDef.getArguments()) {
            GraphQLInputType argumentType = argument.getType();
            if (!(argumentType instanceof GraphQLInputObjectType)) continue;
            ArrayList<String> path = new ArrayList<String>();
            path.add(argumentType.getName());
            this.check((GraphQLInputObjectType)argumentType, new HashSet<GraphQLType>(), path, validationErrorCollector);
        }
    }

    private void check(GraphQLInputObjectType type, Set<GraphQLType> seen, List<String> path, SchemaValidationErrorCollector validationErrorCollector) {
        if (seen.contains(type)) {
            validationErrorCollector.addError(new SchemaValidationError(SchemaValidationErrorType.UnbrokenInputCycle, this.getErrorMessage(path)));
            return;
        }
        seen.add(type);
        for (GraphQLInputObjectField field : type.getFieldDefinitions()) {
            GraphQLType unwrapped;
            if (!(field.getType() instanceof GraphQLNonNull) || !((unwrapped = this.unwrapNonNull((GraphQLNonNull)field.getType())) instanceof GraphQLInputObjectType)) continue;
            path = new ArrayList<String>(path);
            path.add(field.getName() + "!");
            this.check((GraphQLInputObjectType)unwrapped, new HashSet<GraphQLType>(seen), path, validationErrorCollector);
        }
    }

    private GraphQLType unwrapNonNull(GraphQLNonNull type) {
        if (type.getWrappedType() instanceof GraphQLList) {
            if (((GraphQLList)type.getWrappedType()).getWrappedType() instanceof GraphQLNonNull) {
                return this.unwrap(((GraphQLList)type.getWrappedType()).getWrappedType());
            }
            return type.getWrappedType();
        }
        return this.unwrap(type.getWrappedType());
    }

    private GraphQLType unwrap(GraphQLType type) {
        if (type instanceof GraphQLModifiedType) {
            return this.unwrap(((GraphQLModifiedType)type).getWrappedType());
        }
        return type;
    }

    private String getErrorMessage(List<String> path) {
        StringBuilder message = new StringBuilder();
        message.append("[");
        for (int i = 0; i < path.size(); ++i) {
            if (i != 0) {
                message.append(".");
            }
            message.append(path.get(i));
        }
        message.append("] forms an unsatisfiable cycle");
        return message.toString();
    }
}

