/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLUnionType;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.schema.validation.SchemaValidationRule;
import java.util.List;
import java.util.Objects;

public class ObjectsImplementInterfaces
implements SchemaValidationRule {
    @Override
    public void check(GraphQLFieldDefinition fieldDef, SchemaValidationErrorCollector validationErrorCollector) {
    }

    @Override
    public void check(GraphQLType type, SchemaValidationErrorCollector validationErrorCollector) {
        if (type instanceof GraphQLObjectType) {
            this.check((GraphQLObjectType)type, validationErrorCollector);
        }
    }

    private void check(GraphQLObjectType objectType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLOutputType> interfaces = objectType.getInterfaces();
        interfaces.forEach(interfaceType -> this.checkObjectImplementsInterface(objectType, (GraphQLInterfaceType)interfaceType, validationErrorCollector));
    }

    private void checkObjectImplementsInterface(GraphQLObjectType objectType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLFieldDefinition> fieldDefinitions = interfaceType.getFieldDefinitions();
        for (GraphQLFieldDefinition interfaceFieldDef : fieldDefinitions) {
            GraphQLFieldDefinition objectFieldDef = objectType.getFieldDefinition(interfaceFieldDef.getName());
            if (objectFieldDef == null) {
                validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' is missing", objectType.getName(), interfaceType.getName(), interfaceFieldDef.getName())));
                continue;
            }
            this.checkFieldTypeCompatibility(objectType, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
    }

    private void checkFieldTypeCompatibility(GraphQLObjectType objectType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        String interfaceFieldDefStr = GraphQLTypeUtil.getUnwrappedTypeName(interfaceFieldDef.getType());
        String objectFieldDefStr = GraphQLTypeUtil.getUnwrappedTypeName(objectFieldDef.getType());
        if (!this.isCompatible(interfaceFieldDef.getType(), objectFieldDef.getType())) {
            validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' is defined as '%s' type and not as '%s' type", objectType.getName(), interfaceType.getName(), interfaceFieldDef.getName(), objectFieldDefStr, interfaceFieldDefStr)));
        } else {
            this.checkFieldArgumentEquivalence(objectType, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
    }

    private void checkFieldArgumentEquivalence(GraphQLObjectType objectTyoe, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        List<GraphQLArgument> interfaceArgs = interfaceFieldDef.getArguments();
        List<GraphQLArgument> objectArgs = objectFieldDef.getArguments();
        if (interfaceArgs.size() != objectArgs.size()) {
            validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' has a different number of arguments", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName())));
        } else {
            for (int i = 0; i < interfaceArgs.size(); ++i) {
                GraphQLArgument interfaceArg = interfaceArgs.get(i);
                GraphQLArgument objectArg = objectArgs.get(i);
                String interfaceArgStr = this.makeArgStr(interfaceArg);
                String objectArgStr = this.makeArgStr(objectArg);
                boolean same = true;
                if (!interfaceArgStr.equals(objectArgStr)) {
                    same = false;
                }
                if (!Objects.equals(interfaceArg.getDefaultValue(), objectArg.getDefaultValue())) {
                    same = false;
                }
                if (same) continue;
                validationErrorCollector.addError(this.error(String.format("object type '%s' does not implement interface '%s' because field '%s' argument '%s' is defined differently", objectTyoe.getName(), interfaceType.getName(), interfaceFieldDef.getName(), interfaceArg.getName())));
            }
        }
    }

    private String makeArgStr(GraphQLArgument argument) {
        return argument.getName() + ":" + GraphQLTypeUtil.getUnwrappedTypeName(argument.getType());
    }

    private SchemaValidationError error(String msg) {
        return new SchemaValidationError(SchemaValidationErrorType.ObjectDoesNotImplementItsInterfaces, msg);
    }

    boolean isCompatible(GraphQLOutputType constraintType, GraphQLOutputType objectType) {
        if (this.isSameType(constraintType, objectType)) {
            return true;
        }
        if (constraintType instanceof GraphQLUnionType) {
            return this.objectIsMemberOfUnion((GraphQLUnionType)constraintType, objectType);
        }
        if (constraintType instanceof GraphQLInterfaceType && objectType instanceof GraphQLObjectType) {
            return this.objectImplementsInterface((GraphQLInterfaceType)constraintType, (GraphQLObjectType)objectType);
        }
        if (constraintType instanceof GraphQLList && objectType instanceof GraphQLList) {
            GraphQLOutputType wrappedConstraintType = (GraphQLOutputType)((GraphQLList)constraintType).getWrappedType();
            GraphQLOutputType wrappedObjectType = (GraphQLOutputType)((GraphQLList)objectType).getWrappedType();
            return this.isCompatible(wrappedConstraintType, wrappedObjectType);
        }
        if (objectType instanceof GraphQLNonNull) {
            GraphQLOutputType nullableConstraint = constraintType instanceof GraphQLNonNull ? (GraphQLOutputType)((GraphQLNonNull)constraintType).getWrappedType() : constraintType;
            GraphQLOutputType nullableObjectType = (GraphQLOutputType)((GraphQLNonNull)objectType).getWrappedType();
            return this.isCompatible(nullableConstraint, nullableObjectType);
        }
        return false;
    }

    boolean isSameType(GraphQLOutputType a, GraphQLOutputType b) {
        String aDefString = GraphQLTypeUtil.getUnwrappedTypeName(a);
        String bDefString = GraphQLTypeUtil.getUnwrappedTypeName(b);
        return aDefString.equals(bDefString);
    }

    boolean objectImplementsInterface(GraphQLInterfaceType interfaceType, GraphQLObjectType objectType) {
        return objectType.getInterfaces().contains(interfaceType);
    }

    boolean objectIsMemberOfUnion(GraphQLUnionType unionType, GraphQLOutputType objectType) {
        return unionType.getTypes().contains(objectType);
    }
}

