/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.TraverserContext;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@Internal
public abstract class TraverserState<T> {
    private Object initialData;
    private final Deque<Object> state;
    private final Set<T> visited = new LinkedHashSet<T>();

    private TraverserState(Object initialData) {
        this.initialData = initialData;
        this.state = new ArrayDeque<Object>(32);
    }

    public static <U> TraverserState<U> newQueueState(Object initialData) {
        return new QueueTraverserState(initialData);
    }

    public static <U> TraverserState<U> newStackState(Object initialData) {
        return new StackTraverserState(initialData);
    }

    public abstract void pushAll(TraverserContext<T> var1, Function<? super T, ? extends List<T>> var2);

    public Object pop() {
        return this.state.pop();
    }

    public void addNewContexts(Collection<? extends T> children, TraverserContext<T> root) {
        Assert.assertNotNull(children).stream().map(x -> this.newContext(x, root)).forEach(this.state::add);
    }

    public boolean isEmpty() {
        return this.state.isEmpty();
    }

    public void addVisited(T visited) {
        this.visited.add(visited);
    }

    public TraverserContext<T> newContext(T o, TraverserContext<T> parent) {
        return this.newContext(o, parent, new LinkedHashMap());
    }

    public TraverserContext<T> newContext(final T curNode, final TraverserContext<T> parent, final Map<Class<?>, Object> vars) {
        Assert.assertNotNull(vars);
        return new TraverserContext<T>(){
            Object result;

            @Override
            public T thisNode() {
                return curNode;
            }

            @Override
            public TraverserContext<T> getParentContext() {
                return parent;
            }

            @Override
            public Object getParentResult() {
                return parent.getResult();
            }

            @Override
            public Set<T> visitedNodes() {
                return TraverserState.this.visited;
            }

            @Override
            public boolean isVisited() {
                return TraverserState.this.visited.contains(curNode);
            }

            @Override
            public <S> S getVar(Class<? super S> key) {
                return key.cast(vars.get(key));
            }

            @Override
            public <S> TraverserContext<T> setVar(Class<? super S> key, S value) {
                vars.put(key, value);
                return this;
            }

            @Override
            public void setResult(Object result) {
                this.result = result;
            }

            @Override
            public Object getResult() {
                return this.result;
            }

            @Override
            public Object getInitialData() {
                return TraverserState.this.initialData;
            }
        };
    }

    private static class ReverseIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> delegate;

        private ReverseIterator(List<T> list) {
            Assert.assertNotNull(list);
            this.delegate = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T next() {
            return this.delegate.previous();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static enum Marker {
        END_LIST;

    }

    private static class QueueTraverserState<U>
    extends TraverserState<U> {
        private QueueTraverserState(Object initialData) {
            super(initialData);
        }

        @Override
        public void pushAll(TraverserContext<U> o, Function<? super U, ? extends List<U>> getChildren) {
            getChildren.apply(o.thisNode()).iterator().forEachRemaining(e -> ((TraverserState)this).state.add(this.newContext(e, o)));
            ((TraverserState)this).state.add(Marker.END_LIST);
            ((TraverserState)this).state.add(o);
        }
    }

    private static class StackTraverserState<U>
    extends TraverserState<U> {
        private StackTraverserState(Object initialData) {
            super(initialData);
        }

        @Override
        public void pushAll(TraverserContext<U> o, Function<? super U, ? extends List<U>> getChildren) {
            ((TraverserState)this).state.push(o);
            ((TraverserState)this).state.push(Marker.END_LIST);
            new ReverseIterator(getChildren.apply(o.thisNode())).forEachRemaining(e -> ((TraverserState)this).state.push(this.newContext(e, o)));
        }
    }
}

