/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.Assert;
import graphql.language.ArrayValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ValidationUtil {
    public TypeName getUnmodifiedType(Type type) {
        if (type instanceof ListType) {
            return this.getUnmodifiedType(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.getUnmodifiedType(((NonNullType)type).getType());
        }
        if (type instanceof TypeName) {
            return (TypeName)type;
        }
        return (TypeName)Assert.assertShouldNeverHappen();
    }

    protected void handleNullError(Value value, GraphQLType type) {
    }

    protected void handleScalarError(Value value, GraphQLScalarType type) {
    }

    protected void handleEnumError(Value value, GraphQLEnumType type) {
    }

    protected void handleNotObjectError(Value value, GraphQLInputObjectType type) {
    }

    protected void handleMissingFieldsError(Value value, GraphQLInputObjectType type, Set<String> missingFields) {
    }

    protected void handleExtraFieldError(Value value, GraphQLInputObjectType type, ObjectField objectField) {
    }

    protected void handleFieldNotValidError(ObjectField objectField, GraphQLInputObjectType type) {
    }

    protected void handleFieldNotValidError(Value value, GraphQLType type, int index) {
    }

    public boolean isValidLiteralValue(Value value, GraphQLType type, GraphQLSchema schema) {
        if (value == null || value instanceof NullValue) {
            boolean valid;
            boolean bl = valid = !(type instanceof GraphQLNonNull);
            if (!valid) {
                this.handleNullError(value, type);
            }
            return valid;
        }
        if (value instanceof VariableReference) {
            return true;
        }
        if (type instanceof GraphQLNonNull) {
            return this.isValidLiteralValue(value, ((GraphQLNonNull)type).getWrappedType(), schema);
        }
        if (type instanceof GraphQLScalarType) {
            boolean valid = this.parseLiteral(value, ((GraphQLScalarType)type).getCoercing());
            if (!valid) {
                this.handleScalarError(value, (GraphQLScalarType)type);
            }
            return valid;
        }
        if (type instanceof GraphQLEnumType) {
            boolean valid = this.parseLiteral(value, ((GraphQLEnumType)type).getCoercing());
            if (!valid) {
                this.handleEnumError(value, (GraphQLEnumType)type);
            }
            return valid;
        }
        if (type instanceof GraphQLList) {
            return this.isValidLiteralValue(value, (GraphQLList)type, schema);
        }
        return type instanceof GraphQLInputObjectType && this.isValidLiteralValue(value, (GraphQLInputObjectType)type, schema);
    }

    private boolean parseLiteral(Value value, Coercing coercing) {
        try {
            return coercing.parseLiteral(value) != null;
        }
        catch (CoercingParseLiteralException e) {
            return false;
        }
    }

    private boolean isValidLiteralValue(Value value, GraphQLInputObjectType type, GraphQLSchema schema) {
        if (!(value instanceof ObjectValue)) {
            this.handleNotObjectError(value, type);
            return false;
        }
        GraphqlFieldVisibility fieldVisibility = schema.getFieldVisibility();
        ObjectValue objectValue = (ObjectValue)value;
        Map<String, ObjectField> objectFieldMap = this.fieldMap(objectValue);
        Set<String> missingFields = this.getMissingFields(type, objectFieldMap, fieldVisibility);
        if (!missingFields.isEmpty()) {
            this.handleMissingFieldsError(value, type, missingFields);
            return false;
        }
        for (ObjectField objectField : objectValue.getObjectFields()) {
            GraphQLInputObjectField inputObjectField = fieldVisibility.getFieldDefinition(type, objectField.getName());
            if (inputObjectField == null) {
                this.handleExtraFieldError(value, type, objectField);
                return false;
            }
            if (this.isValidLiteralValue(objectField.getValue(), inputObjectField.getType(), schema)) continue;
            this.handleFieldNotValidError(objectField, type);
            return false;
        }
        return true;
    }

    private Set<String> getMissingFields(GraphQLInputObjectType type, Map<String, ObjectField> objectFieldMap, GraphqlFieldVisibility fieldVisibility) {
        return fieldVisibility.getFieldDefinitions(type).stream().filter(field -> field.getType() instanceof GraphQLNonNull).map(GraphQLInputObjectField::getName).filter(((Predicate<String>)objectFieldMap::containsKey).negate()).collect(Collectors.toSet());
    }

    private Map<String, ObjectField> fieldMap(ObjectValue objectValue) {
        LinkedHashMap<String, ObjectField> result = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            result.put(objectField.getName(), objectField);
        }
        return result;
    }

    private boolean isValidLiteralValue(Value value, GraphQLList type, GraphQLSchema schema) {
        GraphQLType wrappedType = type.getWrappedType();
        if (value instanceof ArrayValue) {
            List<Value> values = ((ArrayValue)value).getValues();
            for (int i = 0; i < values.size(); ++i) {
                if (this.isValidLiteralValue(values.get(i), wrappedType, schema)) continue;
                this.handleFieldNotValidError(values.get(i), wrappedType, i);
                return false;
            }
            return true;
        }
        return this.isValidLiteralValue(value, wrappedType, schema);
    }
}

