/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oas.validator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class NumericUtils {
    public static boolean isNumeric(Object obj) {
        return NumericType.of(obj) != null;
    }

    public static boolean isIntegral(Object obj) {
        switch (NumericType.of(obj).ordinal()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static <T extends Number> T zero(T value) {
        Number result;
        switch (NumericType.of(value).ordinal()) {
            case 0: {
                result = BigDecimal.ZERO;
                break;
            }
            case 1: {
                result = BigInteger.ZERO;
                break;
            }
            case 2: {
                result = (byte)0;
                break;
            }
            case 3: {
                result = 0.0;
                break;
            }
            case 4: {
                result = Float.valueOf(0.0f);
                break;
            }
            case 5: {
                result = 0;
                break;
            }
            case 6: {
                result = 0L;
                break;
            }
            case 7: {
                result = (short)0;
                break;
            }
            default: {
                return null;
            }
        }
        Number tResult = result;
        return (T)tResult;
    }

    public static <T extends Number> boolean gt(T x, T y) {
        return NumericUtils.compare(x, y) > 0;
    }

    public static <T extends Number> boolean ge(T x, T y) {
        return NumericUtils.compare(x, y) >= 0;
    }

    public static <T extends Number> boolean lt(T x, T y) {
        return NumericUtils.compare(x, y) < 0;
    }

    public static <T extends Number> boolean le(T x, T y) {
        return NumericUtils.compare(x, y) <= 0;
    }

    public static <T extends Number> boolean eq(T x, T y) {
        return NumericUtils.compare(x, y) == 0;
    }

    public static <T extends Number> boolean ne(T x, T y) {
        return NumericUtils.compare(x, y) != 0;
    }

    public static <T extends Number> boolean isPositive(T x) {
        return NumericUtils.gt(x, NumericUtils.zero(x));
    }

    public static <T extends Number> boolean isZero(T x) {
        return NumericUtils.eq(x, NumericUtils.zero(x));
    }

    public static <T extends Number> boolean isNegative(T x) {
        return NumericUtils.lt(x, NumericUtils.zero(x));
    }

    public static <T extends Number> boolean isNonNegative(T x) {
        return NumericUtils.ge(x, NumericUtils.zero(x));
    }

    public static <T extends Number> boolean isnonZero(T x) {
        return NumericUtils.ne(x, NumericUtils.zero(x));
    }

    public static <T extends Number> boolean isNonPostive(T x) {
        return NumericUtils.le(x, NumericUtils.zero(x));
    }

    public static <T extends Number> int compare(T x, T y) {
        NumericType type = NumericType.of(x);
        if (type != NumericType.of(y)) {
            throw new IllegalArgumentException();
        }
        switch (type.ordinal()) {
            case 0: {
                return ((BigDecimal)x).compareTo((BigDecimal)y);
            }
            case 1: {
                return ((BigInteger)x).compareTo((BigInteger)y);
            }
            case 2: {
                return ((Byte)x).compareTo((Byte)y);
            }
            case 3: {
                return ((Double)x).compareTo((Double)y);
            }
            case 4: {
                return ((Float)x).compareTo((Float)y);
            }
            case 5: {
                return ((Integer)x).compareTo((Integer)y);
            }
            case 6: {
                return ((Long)x).compareTo((Long)y);
            }
            case 7: {
                return ((Short)x).compareTo((Short)y);
            }
        }
        throw new IllegalArgumentException();
    }

    static enum NumericType {
        BIG_DECIMAL(BigDecimal.class),
        BIG_INTEGER(BigInteger.class),
        BYTE(Byte.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        SHORT(Short.class);

        private static Map<Class<? extends Number>, NumericType> types;

        private NumericType(Class<? extends Number> cls) {
            this.register(cls, this);
        }

        private void register(Class<? extends Number> cls, NumericType type) {
            if (types == null) {
                types = new HashMap<Class<? extends Number>, NumericType>();
            }
            types.put(cls, type);
        }

        public static NumericType of(Object value) {
            return value != null ? types.get(value.getClass()) : null;
        }
    }
}

