/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.v3d;

import eu.mihosoft.vrl.v3d.Polygon;
import eu.mihosoft.vrl.v3d.Primitive;
import eu.mihosoft.vrl.v3d.PropertyStorage;
import eu.mihosoft.vrl.v3d.Vector3d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Polyhedron
extends Primitive {
    private final PropertyStorage properties = new PropertyStorage();
    private final List<Vector3d> points = new ArrayList<Vector3d>();
    private final List<List<Integer>> faces = new ArrayList<List<Integer>>();

    public Polyhedron(List<Vector3d> points, List<List<Integer>> faces) {
        this.points.addAll(points);
        this.faces.addAll(faces);
    }

    public Polyhedron(Vector3d[] points, Integer[][] faces) {
        this.points.addAll(Arrays.asList(points));
        for (Integer[] list : faces) {
            this.faces.add(Arrays.asList(list));
        }
    }

    @Override
    public List<Polygon> toPolygons() {
        Function<Integer, Vector3d> indexToPoint = i -> this.points.get((int)i).clone();
        Function<List, Polygon> faceListToPolygon = faceList -> Polygon.fromPoints(faceList.stream().map(indexToPoint).collect(Collectors.toList()), this.properties);
        return this.faces.stream().map(faceListToPolygon).collect(Collectors.toList());
    }

    @Override
    public PropertyStorage getProperties() {
        return this.properties;
    }
}

