// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.mujoco;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

public class MuJoCoLib extends org.mujoco.MuJoCoConfig {
    static { Loader.load(); }

// Parsed from mujoco/mjexport.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJEXPORT_H_
// #define MUJOCO_MJEXPORT_H_

// #if defined _WIN32 || defined __CYGWIN__
//   #define MUJOCO_HELPER_DLL_IMPORT __declspec(dllimport)
//   #define MUJOCO_HELPER_DLL_EXPORT __declspec(dllexport)
//   #define MUJOCO_HELPER_DLL_LOCAL
// #else
//   #if __GNUC__ >= 4
//     #define MUJOCO_HELPER_DLL_IMPORT __attribute__ ((visibility ("default")))
//     #define MUJOCO_HELPER_DLL_EXPORT __attribute__ ((visibility ("default")))
//     #define MUJOCO_HELPER_DLL_LOCAL  __attribute__ ((visibility ("hidden")))
//   #else
//     #define MUJOCO_HELPER_DLL_IMPORT
//     #define MUJOCO_HELPER_DLL_EXPORT
//     #define MUJOCO_HELPER_DLL_LOCAL
//   #endif
// #endif

// #ifdef MJ_STATIC
  // static library
//   #define MJAPI
//   #define MJLOCAL
// #else
// #endif

// #endif  // MUJOCO_MJEXPORT_H_


// Parsed from mujoco/mjdata.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJDATA_H_
// #define MUJOCO_MJDATA_H_

// #include <mujoco/mjtnum.h>
// #include <mujoco/mjmodel.h>

//---------------------------------- primitive types (mjt) -----------------------------------------

/** enum mjtWarning */
public static final int        // warning types
  mjWARN_INERTIA      = 0,        // (near) singular inertia matrix
  mjWARN_CONTACTFULL = 1,             // too many contacts in contact list
  mjWARN_CNSTRFULL = 2,               // too many constraints
  mjWARN_VGEOMFULL = 3,               // too many visual geoms
  mjWARN_BADQPOS = 4,                 // bad number in qpos
  mjWARN_BADQVEL = 5,                 // bad number in qvel
  mjWARN_BADQACC = 6,                 // bad number in qacc
  mjWARN_BADCTRL = 7,                 // bad number in ctrl

  mjNWARNING = 8;                      // number of warnings


/** enum mjtTimer */
public static final int
  // main api
  mjTIMER_STEP        = 0,        // step
  mjTIMER_FORWARD = 1,                // forward
  mjTIMER_INVERSE = 2,                // inverse

  // breakdown of step/forward
  mjTIMER_POSITION = 3,               // fwdPosition
  mjTIMER_VELOCITY = 4,               // fwdVelocity
  mjTIMER_ACTUATION = 5,              // fwdActuation
  mjTIMER_ACCELERATION = 6,           // fwdAcceleration
  mjTIMER_CONSTRAINT = 7,             // fwdConstraint

  // breakdown of fwdPosition
  mjTIMER_POS_KINEMATICS = 8,         // kinematics, com, tendon, transmission
  mjTIMER_POS_INERTIA = 9,            // inertia computations
  mjTIMER_POS_COLLISION = 10,          // collision detection
  mjTIMER_POS_MAKE = 11,               // make constraints
  mjTIMER_POS_PROJECT = 12,            // project constraints

  mjNTIMER = 13;                        // number of timers


//---------------------------------- mjContact -----------------------------------------------------

public static class mjContact_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjContact_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjContact_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjContact_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjContact_ position(long position) {
        return (mjContact_)super.position(position);
    }
    @Override public mjContact_ getPointer(long i) {
        return new mjContact_((Pointer)this).offsetAddress(i);
    }
               // result of collision detection functions
  // contact parameters set by geom-specific collision detector
  public native @Cast("mjtNum") double dist(); public native mjContact_ dist(double setter);                    // distance between nearest points; neg: penetration
  public native @Cast("mjtNum") double pos(int i); public native mjContact_ pos(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer pos();                  // position of contact point: midpoint between geoms
  public native @Cast("mjtNum") double frame(int i); public native mjContact_ frame(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer frame();                // normal is in [0-2]

  // contact parameters set by mj_collideGeoms
  public native @Cast("mjtNum") double includemargin(); public native mjContact_ includemargin(double setter);           // include if dist<includemargin=margin-gap
  public native @Cast("mjtNum") double friction(int i); public native mjContact_ friction(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer friction();             // tangent1, 2, spin, roll1, 2
  public native @Cast("mjtNum") double solref(int i); public native mjContact_ solref(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer solref();          // constraint solver reference
  public native @Cast("mjtNum") double solimp(int i); public native mjContact_ solimp(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer solimp();          // constraint solver impedance

  // internal storage used by solver
  public native @Cast("mjtNum") double mu(); public native mjContact_ mu(double setter);                      // friction of regularized cone, set by mj_makeConstraint
  public native @Cast("mjtNum") double H(int i); public native mjContact_ H(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer H();                   // cone Hessian, set by mj_updateConstraint

  // contact descriptors set by mj_collideGeoms
  public native int dim(); public native mjContact_ dim(int setter);                        // contact space dimensionality: 1, 3, 4 or 6
  public native int geom1(); public native mjContact_ geom1(int setter);                      // id of geom 1
  public native int geom2(); public native mjContact_ geom2(int setter);                      // id of geom 2

  // flag set by mj_fuseContact or mj_instantianteEquality
  public native int exclude(); public native mjContact_ exclude(int setter);                    // 0: include, 1: in gap, 2: fused, 3: equality, 4: no dofs

  // address computed by mj_instantiateContact
  public native int efc_address(); public native mjContact_ efc_address(int setter);                // address in efc; -1: not included, -2-i: distance constraint i
}
@Opaque public static class mjContact extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjContact() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjContact(Pointer p) { super(p); }
}


//---------------------------------- diagnostics ---------------------------------------------------

public static class mjWarningStat_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjWarningStat_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjWarningStat_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjWarningStat_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjWarningStat_ position(long position) {
        return (mjWarningStat_)super.position(position);
    }
    @Override public mjWarningStat_ getPointer(long i) {
        return new mjWarningStat_((Pointer)this).offsetAddress(i);
    }
           // warning statistics
  public native int lastinfo(); public native mjWarningStat_ lastinfo(int setter);                   // info from last warning
  public native int number(); public native mjWarningStat_ number(int setter);                     // how many times was warning raised
}
@Opaque public static class mjWarningStat extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjWarningStat() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjWarningStat(Pointer p) { super(p); }
}


public static class mjTimerStat_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjTimerStat_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjTimerStat_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjTimerStat_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjTimerStat_ position(long position) {
        return (mjTimerStat_)super.position(position);
    }
    @Override public mjTimerStat_ getPointer(long i) {
        return new mjTimerStat_((Pointer)this).offsetAddress(i);
    }
             // timer statistics
  public native @Cast("mjtNum") double duration(); public native mjTimerStat_ duration(double setter);                // cumulative duration
  public native int number(); public native mjTimerStat_ number(int setter);                     // how many times was timer called
}
@Opaque public static class mjTimerStat extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjTimerStat() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjTimerStat(Pointer p) { super(p); }
}


public static class mjSolverStat_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjSolverStat_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjSolverStat_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjSolverStat_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjSolverStat_ position(long position) {
        return (mjSolverStat_)super.position(position);
    }
    @Override public mjSolverStat_ getPointer(long i) {
        return new mjSolverStat_((Pointer)this).offsetAddress(i);
    }
            // per-iteration solver statistics
  public native @Cast("mjtNum") double improvement(); public native mjSolverStat_ improvement(double setter);             // cost reduction, scaled by 1/trace(M(qpos0))
  public native @Cast("mjtNum") double gradient(); public native mjSolverStat_ gradient(double setter);                // gradient norm (primal only, scaled)
  public native @Cast("mjtNum") double lineslope(); public native mjSolverStat_ lineslope(double setter);               // slope in linesearch
  public native int nactive(); public native mjSolverStat_ nactive(int setter);                    // number of active constraints
  public native int nchange(); public native mjSolverStat_ nchange(int setter);                    // number of constraint state changes
  public native int neval(); public native mjSolverStat_ neval(int setter);                      // number of cost evaluations in line search
  public native int nupdate(); public native mjSolverStat_ nupdate(int setter);                    // number of Cholesky updates in line search
}
@Opaque public static class mjSolverStat extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjSolverStat() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjSolverStat(Pointer p) { super(p); }
}


//---------------------------------- mjData --------------------------------------------------------

public static class mjData_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjData_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjData_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjData_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjData_ position(long position) {
        return (mjData_)super.position(position);
    }
    @Override public mjData_ getPointer(long i) {
        return new mjData_((Pointer)this).offsetAddress(i);
    }

  // constant sizes
  public native int nstack(); public native mjData_ nstack(int setter);                     // number of mjtNums that can fit in stack
  public native int nbuffer(); public native mjData_ nbuffer(int setter);                    // size of main buffer in bytes

  // stack pointer
  public native int pstack(); public native mjData_ pstack(int setter);                     // first available mjtNum address in stack

  // memory utilization stats
  public native int maxuse_stack(); public native mjData_ maxuse_stack(int setter);               // maximum stack allocation
  public native int maxuse_con(); public native mjData_ maxuse_con(int setter);                 // maximum number of contacts
  public native int maxuse_efc(); public native mjData_ maxuse_efc(int setter);                 // maximum number of scalar constraints

  // diagnostics
  public native @ByRef mjWarningStat warning(int i); public native mjData_ warning(int i, mjWarningStat setter);
  @MemberGetter public native mjWarningStat warning(); // warning statistics
  public native @ByRef mjTimerStat timer(int i); public native mjData_ timer(int i, mjTimerStat setter);
  @MemberGetter public native mjTimerStat timer();    // timer statistics
  public native @ByRef mjSolverStat solver(int i); public native mjData_ solver(int i, mjSolverStat setter);
  @MemberGetter public native mjSolverStat solver(); // solver statistics per iteration
  public native int solver_iter(); public native mjData_ solver_iter(int setter);                // number of solver iterations
  public native int solver_nnz(); public native mjData_ solver_nnz(int setter);                 // number of non-zeros in Hessian or efc_AR
  public native @Cast("mjtNum") double solver_fwdinv(int i); public native mjData_ solver_fwdinv(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer solver_fwdinv();        // forward-inverse comparison: qfrc, efc

  // variable sizes
  public native int ne(); public native mjData_ ne(int setter);                         // number of equality constraints
  public native int nf(); public native mjData_ nf(int setter);                         // number of friction constraints
  public native int nefc(); public native mjData_ nefc(int setter);                       // number of constraints
  public native int ncon(); public native mjData_ ncon(int setter);                       // number of detected contacts

  // global properties
  public native @Cast("mjtNum") double time(); public native mjData_ time(double setter);                    // simulation time
  public native @Cast("mjtNum") double energy(int i); public native mjData_ energy(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer energy();               // potential, kinetic energy

  //-------------------------------- end of info header

  // buffers
  public native Pointer buffer(); public native mjData_ buffer(Pointer setter);               // main buffer; all pointers point in it    (nbuffer bytes)
  public native @Cast("mjtNum*") DoublePointer stack(); public native mjData_ stack(DoublePointer setter);                // stack buffer                             (nstack mjtNums)

  //-------------------------------- main inputs and outputs of the computation

  // state
  public native @Cast("mjtNum*") DoublePointer qpos(); public native mjData_ qpos(DoublePointer setter);                 // position                                 (nq x 1)
  public native @Cast("mjtNum*") DoublePointer qvel(); public native mjData_ qvel(DoublePointer setter);                 // velocity                                 (nv x 1)
  public native @Cast("mjtNum*") DoublePointer act(); public native mjData_ act(DoublePointer setter);                  // actuator activation                      (na x 1)
  public native @Cast("mjtNum*") DoublePointer qacc_warmstart(); public native mjData_ qacc_warmstart(DoublePointer setter);       // acceleration used for warmstart          (nv x 1)

  // control
  public native @Cast("mjtNum*") DoublePointer ctrl(); public native mjData_ ctrl(DoublePointer setter);                 // control                                  (nu x 1)
  public native @Cast("mjtNum*") DoublePointer qfrc_applied(); public native mjData_ qfrc_applied(DoublePointer setter);         // applied generalized force                (nv x 1)
  public native @Cast("mjtNum*") DoublePointer xfrc_applied(); public native mjData_ xfrc_applied(DoublePointer setter);         // applied Cartesian force/torque           (nbody x 6)

  // mocap data
  public native @Cast("mjtNum*") DoublePointer mocap_pos(); public native mjData_ mocap_pos(DoublePointer setter);            // positions of mocap bodies                (nmocap x 3)
  public native @Cast("mjtNum*") DoublePointer mocap_quat(); public native mjData_ mocap_quat(DoublePointer setter);           // orientations of mocap bodies             (nmocap x 4)

  // dynamics
  public native @Cast("mjtNum*") DoublePointer qacc(); public native mjData_ qacc(DoublePointer setter);                 // acceleration                             (nv x 1)
  public native @Cast("mjtNum*") DoublePointer act_dot(); public native mjData_ act_dot(DoublePointer setter);              // time-derivative of actuator activation   (na x 1)

  // user data
  public native @Cast("mjtNum*") DoublePointer userdata(); public native mjData_ userdata(DoublePointer setter);             // user data, not touched by engine         (nuserdata x 1)

  // sensors
  public native @Cast("mjtNum*") DoublePointer sensordata(); public native mjData_ sensordata(DoublePointer setter);           // sensor data array                        (nsensordata x 1)

  //-------------------------------- POSITION dependent

  // computed by mj_fwdPosition/mj_kinematics
  public native @Cast("mjtNum*") DoublePointer xpos(); public native mjData_ xpos(DoublePointer setter);                 // Cartesian position of body frame         (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer xquat(); public native mjData_ xquat(DoublePointer setter);                // Cartesian orientation of body frame      (nbody x 4)
  public native @Cast("mjtNum*") DoublePointer xmat(); public native mjData_ xmat(DoublePointer setter);                 // Cartesian orientation of body frame      (nbody x 9)
  public native @Cast("mjtNum*") DoublePointer xipos(); public native mjData_ xipos(DoublePointer setter);                // Cartesian position of body com           (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer ximat(); public native mjData_ ximat(DoublePointer setter);                // Cartesian orientation of body inertia    (nbody x 9)
  public native @Cast("mjtNum*") DoublePointer xanchor(); public native mjData_ xanchor(DoublePointer setter);              // Cartesian position of joint anchor       (njnt x 3)
  public native @Cast("mjtNum*") DoublePointer xaxis(); public native mjData_ xaxis(DoublePointer setter);                // Cartesian joint axis                     (njnt x 3)
  public native @Cast("mjtNum*") DoublePointer geom_xpos(); public native mjData_ geom_xpos(DoublePointer setter);            // Cartesian geom position                  (ngeom x 3)
  public native @Cast("mjtNum*") DoublePointer geom_xmat(); public native mjData_ geom_xmat(DoublePointer setter);            // Cartesian geom orientation               (ngeom x 9)
  public native @Cast("mjtNum*") DoublePointer site_xpos(); public native mjData_ site_xpos(DoublePointer setter);            // Cartesian site position                  (nsite x 3)
  public native @Cast("mjtNum*") DoublePointer site_xmat(); public native mjData_ site_xmat(DoublePointer setter);            // Cartesian site orientation               (nsite x 9)
  public native @Cast("mjtNum*") DoublePointer cam_xpos(); public native mjData_ cam_xpos(DoublePointer setter);             // Cartesian camera position                (ncam x 3)
  public native @Cast("mjtNum*") DoublePointer cam_xmat(); public native mjData_ cam_xmat(DoublePointer setter);             // Cartesian camera orientation             (ncam x 9)
  public native @Cast("mjtNum*") DoublePointer light_xpos(); public native mjData_ light_xpos(DoublePointer setter);           // Cartesian light position                 (nlight x 3)
  public native @Cast("mjtNum*") DoublePointer light_xdir(); public native mjData_ light_xdir(DoublePointer setter);           // Cartesian light direction                (nlight x 3)

  // computed by mj_fwdPosition/mj_comPos
  public native @Cast("mjtNum*") DoublePointer subtree_com(); public native mjData_ subtree_com(DoublePointer setter);          // center of mass of each subtree           (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer cdof(); public native mjData_ cdof(DoublePointer setter);                 // com-based motion axis of each dof        (nv x 6)
  public native @Cast("mjtNum*") DoublePointer cinert(); public native mjData_ cinert(DoublePointer setter);               // com-based body inertia and mass          (nbody x 10)

  // computed by mj_fwdPosition/mj_tendon
  public native IntPointer ten_wrapadr(); public native mjData_ ten_wrapadr(IntPointer setter);          // start address of tendon's path           (ntendon x 1)
  public native IntPointer ten_wrapnum(); public native mjData_ ten_wrapnum(IntPointer setter);          // number of wrap points in path            (ntendon x 1)
  public native IntPointer ten_J_rownnz(); public native mjData_ ten_J_rownnz(IntPointer setter);         // number of non-zeros in Jacobian row      (ntendon x 1)
  public native IntPointer ten_J_rowadr(); public native mjData_ ten_J_rowadr(IntPointer setter);         // row start address in colind array        (ntendon x 1)
  public native IntPointer ten_J_colind(); public native mjData_ ten_J_colind(IntPointer setter);         // column indices in sparse Jacobian        (ntendon x nv)
  public native @Cast("mjtNum*") DoublePointer ten_length(); public native mjData_ ten_length(DoublePointer setter);           // tendon lengths                           (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer ten_J(); public native mjData_ ten_J(DoublePointer setter);                // tendon Jacobian                          (ntendon x nv)
  public native IntPointer wrap_obj(); public native mjData_ wrap_obj(IntPointer setter);             // geom id; -1: site; -2: pulley            (nwrap*2 x 1)
  public native @Cast("mjtNum*") DoublePointer wrap_xpos(); public native mjData_ wrap_xpos(DoublePointer setter);            // Cartesian 3D points in all path          (nwrap*2 x 3)

  // computed by mj_fwdPosition/mj_transmission
  public native @Cast("mjtNum*") DoublePointer actuator_length(); public native mjData_ actuator_length(DoublePointer setter);      // actuator lengths                         (nu x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_moment(); public native mjData_ actuator_moment(DoublePointer setter);      // actuator moments                         (nu x nv)

  // computed by mj_fwdPosition/mj_crb
  public native @Cast("mjtNum*") DoublePointer crb(); public native mjData_ crb(DoublePointer setter);                  // com-based composite inertia and mass     (nbody x 10)
  public native @Cast("mjtNum*") DoublePointer qM(); public native mjData_ qM(DoublePointer setter);                   // total inertia (sparse)                   (nM x 1)

  // computed by mj_fwdPosition/mj_factorM
  public native @Cast("mjtNum*") DoublePointer qLD(); public native mjData_ qLD(DoublePointer setter);                  // L'*D*L factorization of M (sparse)       (nM x 1)
  public native @Cast("mjtNum*") DoublePointer qLDiagInv(); public native mjData_ qLDiagInv(DoublePointer setter);            // 1/diag(D)                                (nv x 1)
  public native @Cast("mjtNum*") DoublePointer qLDiagSqrtInv(); public native mjData_ qLDiagSqrtInv(DoublePointer setter);        // 1/sqrt(diag(D))                          (nv x 1)

  // computed by mj_fwdPosition/mj_collision
  public native mjContact contact(); public native mjData_ contact(mjContact setter);             // list of all detected contacts            (nconmax x 1)

  // computed by mj_fwdPosition/mj_makeConstraint
  public native IntPointer efc_type(); public native mjData_ efc_type(IntPointer setter);             // constraint type (mjtConstraint)          (njmax x 1)
  public native IntPointer efc_id(); public native mjData_ efc_id(IntPointer setter);               // id of object of specified type           (njmax x 1)
  public native IntPointer efc_J_rownnz(); public native mjData_ efc_J_rownnz(IntPointer setter);         // number of non-zeros in Jacobian row      (njmax x 1)
  public native IntPointer efc_J_rowadr(); public native mjData_ efc_J_rowadr(IntPointer setter);         // row start address in colind array        (njmax x 1)
  public native IntPointer efc_J_rowsuper(); public native mjData_ efc_J_rowsuper(IntPointer setter);       // number of subsequent rows in supernode   (njmax x 1)
  public native IntPointer efc_J_colind(); public native mjData_ efc_J_colind(IntPointer setter);         // column indices in Jacobian               (njmax x nv)
  public native IntPointer efc_JT_rownnz(); public native mjData_ efc_JT_rownnz(IntPointer setter);        // number of non-zeros in Jacobian row    T (nv x 1)
  public native IntPointer efc_JT_rowadr(); public native mjData_ efc_JT_rowadr(IntPointer setter);        // row start address in colind array      T (nv x 1)
  public native IntPointer efc_JT_rowsuper(); public native mjData_ efc_JT_rowsuper(IntPointer setter);      // number of subsequent rows in supernode T (nv x 1)
  public native IntPointer efc_JT_colind(); public native mjData_ efc_JT_colind(IntPointer setter);        // column indices in Jacobian             T (nv x njmax)
  public native @Cast("mjtNum*") DoublePointer efc_J(); public native mjData_ efc_J(DoublePointer setter);                // constraint Jacobian                      (njmax x nv)
  public native @Cast("mjtNum*") DoublePointer efc_JT(); public native mjData_ efc_JT(DoublePointer setter);               // constraint Jacobian transposed           (nv x njmax)
  public native @Cast("mjtNum*") DoublePointer efc_pos(); public native mjData_ efc_pos(DoublePointer setter);              // constraint position (equality, contact)  (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_margin(); public native mjData_ efc_margin(DoublePointer setter);           // inclusion margin (contact)               (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_frictionloss(); public native mjData_ efc_frictionloss(DoublePointer setter);     // frictionloss (friction)                  (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_diagApprox(); public native mjData_ efc_diagApprox(DoublePointer setter);       // approximation to diagonal of A           (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_KBIP(); public native mjData_ efc_KBIP(DoublePointer setter);             // stiffness, damping, impedance, imp'      (njmax x 4)
  public native @Cast("mjtNum*") DoublePointer efc_D(); public native mjData_ efc_D(DoublePointer setter);                // constraint mass                          (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_R(); public native mjData_ efc_R(DoublePointer setter);                // inverse constraint mass                  (njmax x 1)

  // computed by mj_fwdPosition/mj_projectConstraint
  public native IntPointer efc_AR_rownnz(); public native mjData_ efc_AR_rownnz(IntPointer setter);        // number of non-zeros in AR                (njmax x 1)
  public native IntPointer efc_AR_rowadr(); public native mjData_ efc_AR_rowadr(IntPointer setter);        // row start address in colind array        (njmax x 1)
  public native IntPointer efc_AR_colind(); public native mjData_ efc_AR_colind(IntPointer setter);        // column indices in sparse AR              (njmax x njmax)
  public native @Cast("mjtNum*") DoublePointer efc_AR(); public native mjData_ efc_AR(DoublePointer setter);               // J*inv(M)*J' + R                          (njmax x njmax)

  //-------------------------------- POSITION, VELOCITY dependent

  // computed by mj_fwdVelocity
  public native @Cast("mjtNum*") DoublePointer ten_velocity(); public native mjData_ ten_velocity(DoublePointer setter);         // tendon velocities                        (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_velocity(); public native mjData_ actuator_velocity(DoublePointer setter);    // actuator velocities                      (nu x 1)

  // computed by mj_fwdVelocity/mj_comVel
  public native @Cast("mjtNum*") DoublePointer cvel(); public native mjData_ cvel(DoublePointer setter);                 // com-based velocity [3D rot; 3D tran]     (nbody x 6)
  public native @Cast("mjtNum*") DoublePointer cdof_dot(); public native mjData_ cdof_dot(DoublePointer setter);             // time-derivative of cdof                  (nv x 6)

  // computed by mj_fwdVelocity/mj_rne (without acceleration)
  public native @Cast("mjtNum*") DoublePointer qfrc_bias(); public native mjData_ qfrc_bias(DoublePointer setter);            // C(qpos,qvel)                             (nv x 1)

  // computed by mj_fwdVelocity/mj_passive
  public native @Cast("mjtNum*") DoublePointer qfrc_passive(); public native mjData_ qfrc_passive(DoublePointer setter);         // passive force                            (nv x 1)

  // computed by mj_fwdVelocity/mj_referenceConstraint
  public native @Cast("mjtNum*") DoublePointer efc_vel(); public native mjData_ efc_vel(DoublePointer setter);              // velocity in constraint space: J*qvel     (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_aref(); public native mjData_ efc_aref(DoublePointer setter);             // reference pseudo-acceleration            (njmax x 1)

  // computed by mj_sensorVel/mj_subtreeVel if needed
  public native @Cast("mjtNum*") DoublePointer subtree_linvel(); public native mjData_ subtree_linvel(DoublePointer setter);       // linear velocity of subtree com           (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer subtree_angmom(); public native mjData_ subtree_angmom(DoublePointer setter);       // angular momentum about subtree com       (nbody x 3)

  // computed by mj_implicit
  public native IntPointer D_rownnz(); public native mjData_ D_rownnz(IntPointer setter);             // non-zeros in each row                    (nv x 1)
  public native IntPointer D_rowadr(); public native mjData_ D_rowadr(IntPointer setter);             // address of each row in D_colind          (nv x 1)
  public native IntPointer D_colind(); public native mjData_ D_colind(IntPointer setter);             // column indices of non-zeros              (nD x 1)

  // computed by mj_implicit/mj_derivative
  public native @Cast("mjtNum*") DoublePointer qDeriv(); public native mjData_ qDeriv(DoublePointer setter);               // d (passive + actuator - bias) / d qvel   (nD x 1)

  // computed by mj_implicit/mju_factorLUSparse
  public native @Cast("mjtNum*") DoublePointer qLU(); public native mjData_ qLU(DoublePointer setter);                  // sparse LU of (qM - dt*qDeriv)            (nD x 1)

  //-------------------------------- POSITION, VELOCITY, CONTROL/ACCELERATION dependent

  // computed by mj_fwdActuation
  public native @Cast("mjtNum*") DoublePointer actuator_force(); public native mjData_ actuator_force(DoublePointer setter);       // actuator force in actuation space        (nu x 1)
  public native @Cast("mjtNum*") DoublePointer qfrc_actuator(); public native mjData_ qfrc_actuator(DoublePointer setter);        // actuator force                           (nv x 1)

  // computed by mj_fwdAcceleration
  public native @Cast("mjtNum*") DoublePointer qfrc_smooth(); public native mjData_ qfrc_smooth(DoublePointer setter);          // net unconstrained force                  (nv x 1)
  public native @Cast("mjtNum*") DoublePointer qacc_smooth(); public native mjData_ qacc_smooth(DoublePointer setter);          // unconstrained acceleration               (nv x 1)

  // computed by mj_fwdConstraint/mj_inverse
  public native @Cast("mjtNum*") DoublePointer efc_b(); public native mjData_ efc_b(DoublePointer setter);                // linear cost term: J*qacc_smooth - aref   (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer efc_force(); public native mjData_ efc_force(DoublePointer setter);            // constraint force in constraint space     (njmax x 1)
  public native IntPointer efc_state(); public native mjData_ efc_state(IntPointer setter);            // constraint state (mjtConstraintState)    (njmax x 1)
  public native @Cast("mjtNum*") DoublePointer qfrc_constraint(); public native mjData_ qfrc_constraint(DoublePointer setter);      // constraint force                         (nv x 1)

  // computed by mj_inverse
  public native @Cast("mjtNum*") DoublePointer qfrc_inverse(); public native mjData_ qfrc_inverse(DoublePointer setter);         // net external force; should equal:        (nv x 1)
                                  // qfrc_applied + J'*xfrc_applied + qfrc_actuator

  // computed by mj_sensorAcc/mj_rnePostConstraint if needed; rotation:translation format
  public native @Cast("mjtNum*") DoublePointer cacc(); public native mjData_ cacc(DoublePointer setter);                 // com-based acceleration                   (nbody x 6)
  public native @Cast("mjtNum*") DoublePointer cfrc_int(); public native mjData_ cfrc_int(DoublePointer setter);             // com-based interaction force with parent  (nbody x 6)
  public native @Cast("mjtNum*") DoublePointer cfrc_ext(); public native mjData_ cfrc_ext(DoublePointer setter);             // com-based external force on body         (nbody x 6)
}
@Opaque public static class mjData extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjData() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjData(Pointer p) { super(p); }
}


//---------------------------------- callback function types ---------------------------------------

// generic MuJoCo function
public static class mjfGeneric extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfGeneric(Pointer p) { super(p); }
    protected mjfGeneric() { allocate(); }
    private native void allocate();
    public native void call(@Const mjModel m, mjData d);
}

// contact filter: 1- discard, 0- collide
public static class mjfConFilt extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfConFilt(Pointer p) { super(p); }
    protected mjfConFilt() { allocate(); }
    private native void allocate();
    public native int call(@Const mjModel m, mjData d, int geom1, int geom2);
}

// sensor simulation
public static class mjfSensor extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfSensor(Pointer p) { super(p); }
    protected mjfSensor() { allocate(); }
    private native void allocate();
    public native void call(@Const mjModel m, mjData d, int stage);
}

// timer
public static class mjfTime extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfTime(Pointer p) { super(p); }
    protected mjfTime() { allocate(); }
    private native void allocate();
    public native @Cast("mjtNum") double call();
}

// actuator dynamics, gain, bias
public static class mjfAct extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfAct(Pointer p) { super(p); }
    protected mjfAct() { allocate(); }
    private native void allocate();
    public native @Cast("mjtNum") double call(@Const mjModel m, @Const mjData d, int id);
}

// collision detection
public static class mjfCollision extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfCollision(Pointer p) { super(p); }
    protected mjfCollision() { allocate(); }
    private native void allocate();
    public native int call(@Const mjModel m, @Const mjData d,
                            mjContact con, int g1, int g2, @Cast("mjtNum") double margin);
}

// #endif  // MUJOCO_MJDATA_H_


// Parsed from mujoco/mjmodel.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJMODEL_H_
// #define MUJOCO_MJMODEL_H_

// #include <mujoco/mjtnum.h>

// global constants
public static final double mjPI =            3.14159265358979323846;
public static final double mjMAXVAL =        1E+10;     // maximum value in qpos, qvel, qacc
public static final double mjMINMU =         1E-5;      // minimum friction coefficient
public static final double mjMINIMP =        0.0001;    // minimum constraint impedance
public static final double mjMAXIMP =        0.9999;    // maximum constraint impedance
public static final int mjMAXCONPAIR =    50;        // maximum number of contacts per geom pair
public static final int mjMAXVFS =        2000;      // maximum number of files in virtual file system
public static final int mjMAXVFSNAME =    1000;      // maximum filename size in virtual file system


//---------------------------------- sizes ---------------------------------------------------------

public static final int mjNEQDATA =       7;         // number of eq_data fields
public static final int mjNDYN =          10;        // number of actuator dynamics parameters
public static final int mjNGAIN =         10;        // number of actuator gain parameters
public static final int mjNBIAS =         10;        // number of actuator bias parameters
public static final int mjNFLUID =        12;        // number of fluid interaction parameters
public static final int mjNREF =          2;         // number of solver reference parameters
public static final int mjNIMP =          5;         // number of solver impedance parameters
public static final int mjNSOLVER =       1000;      // size of mjData.solver_XXX arrays


//---------------------------------- primitive types (mjt) -----------------------------------------    // used for true/false


/** enum mjtDisableBit */
public static final int     // disable default feature bitflags
  mjDSBL_CONSTRAINT   = 1<<0,     // entire constraint solver
  mjDSBL_EQUALITY     = 1<<1,     // equality constraints
  mjDSBL_FRICTIONLOSS = 1<<2,     // joint and tendon frictionloss constraints
  mjDSBL_LIMIT        = 1<<3,     // joint and tendon limit constraints
  mjDSBL_CONTACT      = 1<<4,     // contact constraints
  mjDSBL_PASSIVE      = 1<<5,     // passive forces
  mjDSBL_GRAVITY      = 1<<6,     // gravitational forces
  mjDSBL_CLAMPCTRL    = 1<<7,     // clamp control to specified range
  mjDSBL_WARMSTART    = 1<<8,     // warmstart constraint solver
  mjDSBL_FILTERPARENT = 1<<9,     // remove collisions with parent body
  mjDSBL_ACTUATION    = 1<<10,    // apply actuation forces
  mjDSBL_REFSAFE      = 1<<11,    // integrator safety: make ref[0]>=2*timestep

  mjNDISABLE          = 12;        // number of disable flags


/** enum mjtEnableBit */
public static final int      // enable optional feature bitflags
  mjENBL_OVERRIDE     = 1<<0,     // override contact parameters
  mjENBL_ENERGY       = 1<<1,     // energy computation
  mjENBL_FWDINV       = 1<<2,     // record solver statistics
  mjENBL_SENSORNOISE  = 1<<3,     // add noise to sensor data
                                  // experimental features:
  mjENBL_MULTICCD     = 1<<4,     // multi-point convex collision detection

  mjNENABLE           = 5;         // number of enable flags


/** enum mjtJoint */
public static final int          // type of degree of freedom
  mjJNT_FREE          = 0,        // global position and orientation (quat)       (7)
  mjJNT_BALL = 1,                     // orientation (quat) relative to parent        (4)
  mjJNT_SLIDE = 2,                    // sliding distance along body-fixed axis       (1)
  mjJNT_HINGE = 3;                     // rotation angle (rad) around body-fixed axis  (1)


/** enum mjtGeom */
public static final int           // type of geometric shape
  // regular geom types
  mjGEOM_PLANE        = 0,        // plane
  mjGEOM_HFIELD = 1,                  // height field
  mjGEOM_SPHERE = 2,                  // sphere
  mjGEOM_CAPSULE = 3,                 // capsule
  mjGEOM_ELLIPSOID = 4,               // ellipsoid
  mjGEOM_CYLINDER = 5,                // cylinder
  mjGEOM_BOX = 6,                     // box
  mjGEOM_MESH = 7,                    // mesh

  mjNGEOMTYPES = 8,                   // number of regular geom types

  // rendering-only geom types: not used in mjModel, not counted in mjNGEOMTYPES
  mjGEOM_ARROW        = 100,      // arrow
  mjGEOM_ARROW1 = 101,                  // arrow without wedges
  mjGEOM_ARROW2 = 102,                  // arrow in both directions
  mjGEOM_LINE = 103,                    // line
  mjGEOM_SKIN = 104,                    // skin
  mjGEOM_LABEL = 105,                   // text label

  mjGEOM_NONE         = 1001;      // missing geom type


/** enum mjtCamLight */
public static final int       // tracking mode for camera and light
  mjCAMLIGHT_FIXED    = 0,        // pos and rot fixed in body
  mjCAMLIGHT_TRACK = 1,               // pos tracks body, rot fixed in global
  mjCAMLIGHT_TRACKCOM = 2,            // pos tracks subtree com, rot fixed in body
  mjCAMLIGHT_TARGETBODY = 3,          // pos fixed in body, rot tracks target body
  mjCAMLIGHT_TARGETBODYCOM = 4;        // pos fixed in body, rot tracks target subtree com


/** enum mjtTexture */
public static final int        // type of texture
  mjTEXTURE_2D        = 0,        // 2d texture, suitable for planes and hfields
  mjTEXTURE_CUBE = 1,                 // cube texture, suitable for all other geom types
  mjTEXTURE_SKYBOX = 2;                // cube texture used as skybox


/** enum mjtIntegrator */
public static final int     // integrator mode
  mjINT_EULER         = 0,        // semi-implicit Euler
  mjINT_RK4 = 1,                      // 4th-order Runge Kutta
  mjINT_IMPLICIT = 2;                  // implicit in velocity


/** enum mjtCollision */
public static final int      // collision mode for selecting geom pairs
  mjCOL_ALL           = 0,        // test precomputed and dynamic pairs
  mjCOL_PAIR = 1,                     // test predefined pairs only
  mjCOL_DYNAMIC = 2;                   // test dynamic pairs only


/** enum mjtCone */
public static final int           // type of friction cone
  mjCONE_PYRAMIDAL     = 0,       // pyramidal
  mjCONE_ELLIPTIC = 1;                 // elliptic


/** enum mjtJacobian */
public static final int       // type of constraint Jacobian
  mjJAC_DENSE          = 0,       // dense
  mjJAC_SPARSE = 1,                   // sparse
  mjJAC_AUTO = 2;                      // dense if nv<60, sparse otherwise


/** enum mjtSolver */
public static final int         // constraint solver algorithm
  mjSOL_PGS            = 0,       // PGS    (dual)
  mjSOL_CG = 1,                       // CG     (primal)
  mjSOL_NEWTON = 2;                    // Newton (primal)


/** enum mjtEq */
public static final int             // type of equality constraint
  mjEQ_CONNECT        = 0,        // connect two bodies at a point (ball joint)
  mjEQ_WELD = 1,                      // fix relative position and orientation of two bodies
  mjEQ_JOINT = 2,                     // couple the values of two scalar joints with cubic
  mjEQ_TENDON = 3,                    // couple the lengths of two tendons with cubic
  mjEQ_DISTANCE = 4;                   // fix the contact distance betweent two geoms


/** enum mjtWrap */
public static final int           // type of tendon wrap object
  mjWRAP_NONE         = 0,        // null object
  mjWRAP_JOINT = 1,                   // constant moment arm
  mjWRAP_PULLEY = 2,                  // pulley used to split tendon
  mjWRAP_SITE = 3,                    // pass through site
  mjWRAP_SPHERE = 4,                  // wrap around sphere
  mjWRAP_CYLINDER = 5;                 // wrap around (infinite) cylinder


/** enum mjtTrn */
public static final int            // type of actuator transmission
  mjTRN_JOINT         = 0,        // force on joint
  mjTRN_JOINTINPARENT = 1,            // force on joint, expressed in parent frame
  mjTRN_SLIDERCRANK = 2,              // force via slider-crank linkage
  mjTRN_TENDON = 3,                   // force on tendon
  mjTRN_SITE = 4,                     // force on site

  mjTRN_UNDEFINED     = 1000;      // undefined transmission type


/** enum mjtDyn */
public static final int            // type of actuator dynamics
  mjDYN_NONE          = 0,        // no internal dynamics; ctrl specifies force
  mjDYN_INTEGRATOR = 1,               // integrator: da/dt = u
  mjDYN_FILTER = 2,                   // linear filter: da/dt = (u-a) / tau
  mjDYN_MUSCLE = 3,                   // piece-wise linear filter with two time constants
  mjDYN_USER = 4;                      // user-defined dynamics type


/** enum mjtGain */
public static final int           // type of actuator gain
  mjGAIN_FIXED        = 0,        // fixed gain
  mjGAIN_MUSCLE = 1,                  // muscle FLV curve computed by mju_muscleGain()
  mjGAIN_USER = 2;                     // user-defined gain type


/** enum mjtBias */
public static final int           // type of actuator bias
  mjBIAS_NONE         = 0,        // no bias
  mjBIAS_AFFINE = 1,                  // const + kp*length + kv*velocity
  mjBIAS_MUSCLE = 2,                  // muscle passive force computed by mju_muscleBias()
  mjBIAS_USER = 3;                     // user-defined bias type


/** enum mjtObj */
public static final int            // type of MujoCo object
  mjOBJ_UNKNOWN       = 0,        // unknown object type
  mjOBJ_BODY = 1,                     // body
  mjOBJ_XBODY = 2,                    // body, used to access regular frame instead of i-frame
  mjOBJ_JOINT = 3,                    // joint
  mjOBJ_DOF = 4,                      // dof
  mjOBJ_GEOM = 5,                     // geom
  mjOBJ_SITE = 6,                     // site
  mjOBJ_CAMERA = 7,                   // camera
  mjOBJ_LIGHT = 8,                    // light
  mjOBJ_MESH = 9,                     // mesh
  mjOBJ_SKIN = 10,                     // skin
  mjOBJ_HFIELD = 11,                   // heightfield
  mjOBJ_TEXTURE = 12,                  // texture
  mjOBJ_MATERIAL = 13,                 // material for rendering
  mjOBJ_PAIR = 14,                     // geom pair to include
  mjOBJ_EXCLUDE = 15,                  // body pair to exclude
  mjOBJ_EQUALITY = 16,                 // equality constraint
  mjOBJ_TENDON = 17,                   // tendon
  mjOBJ_ACTUATOR = 18,                 // actuator
  mjOBJ_SENSOR = 19,                   // sensor
  mjOBJ_NUMERIC = 20,                  // numeric
  mjOBJ_TEXT = 21,                     // text
  mjOBJ_TUPLE = 22,                    // tuple
  mjOBJ_KEY = 23;                       // keyframe


/** enum mjtConstraint */
public static final int     // type of constraint
  mjCNSTR_EQUALITY    = 0,        // equality constraint
  mjCNSTR_FRICTION_DOF = 1,           // dof friction
  mjCNSTR_FRICTION_TENDON = 2,        // tendon friction
  mjCNSTR_LIMIT_JOINT = 3,            // joint limit
  mjCNSTR_LIMIT_TENDON = 4,           // tendon limit
  mjCNSTR_CONTACT_FRICTIONLESS = 5,   // frictionless contact
  mjCNSTR_CONTACT_PYRAMIDAL = 6,      // frictional contact, pyramidal friction cone
  mjCNSTR_CONTACT_ELLIPTIC = 7;        // frictional contact, elliptic friction cone


/** enum mjtConstraintState */
public static final int // constraint state
  mjCNSTRSTATE_SATISFIED = 0,     // constraint satisfied, zero cost (limit, contact)
  mjCNSTRSTATE_QUADRATIC = 1,         // quadratic cost (equality, friction, limit, contact)
  mjCNSTRSTATE_LINEARNEG = 2,         // linear cost, negative side (friction)
  mjCNSTRSTATE_LINEARPOS = 3,         // linear cost, positive side (friction)
  mjCNSTRSTATE_CONE = 4;               // squared distance to cone cost (elliptic contact)


/** enum mjtSensor */
public static final int         // type of sensor
  // common robotic sensors, attached to a site
  mjSENS_TOUCH        = 0,        // scalar contact normal forces summed over sensor zone
  mjSENS_ACCELEROMETER = 1,           // 3D linear acceleration, in local frame
  mjSENS_VELOCIMETER = 2,             // 3D linear velocity, in local frame
  mjSENS_GYRO = 3,                    // 3D angular velocity, in local frame
  mjSENS_FORCE = 4,                   // 3D force between site's body and its parent body
  mjSENS_TORQUE = 5,                  // 3D torque between site's body and its parent body
  mjSENS_MAGNETOMETER = 6,            // 3D magnetometer
  mjSENS_RANGEFINDER = 7,             // scalar distance to nearest geom or site along z-axis

  // sensors related to scalar joints, tendons, actuators
  mjSENS_JOINTPOS = 8,                // scalar joint position (hinge and slide only)
  mjSENS_JOINTVEL = 9,                // scalar joint velocity (hinge and slide only)
  mjSENS_TENDONPOS = 10,               // scalar tendon position
  mjSENS_TENDONVEL = 11,               // scalar tendon velocity
  mjSENS_ACTUATORPOS = 12,             // scalar actuator position
  mjSENS_ACTUATORVEL = 13,             // scalar actuator velocity
  mjSENS_ACTUATORFRC = 14,             // scalar actuator force

  // sensors related to ball joints
  mjSENS_BALLQUAT = 15,                // 4D ball joint quaterion
  mjSENS_BALLANGVEL = 16,              // 3D ball joint angular velocity

  // joint and tendon limit sensors, in constraint space
  mjSENS_JOINTLIMITPOS = 17,           // joint limit distance-margin
  mjSENS_JOINTLIMITVEL = 18,           // joint limit velocity
  mjSENS_JOINTLIMITFRC = 19,           // joint limit force
  mjSENS_TENDONLIMITPOS = 20,          // tendon limit distance-margin
  mjSENS_TENDONLIMITVEL = 21,          // tendon limit velocity
  mjSENS_TENDONLIMITFRC = 22,          // tendon limit force

  // sensors attached to an object with spatial frame: (x)body, geom, site, camera
  mjSENS_FRAMEPOS = 23,                // 3D position
  mjSENS_FRAMEQUAT = 24,               // 4D unit quaternion orientation
  mjSENS_FRAMEXAXIS = 25,              // 3D unit vector: x-axis of object's frame
  mjSENS_FRAMEYAXIS = 26,              // 3D unit vector: y-axis of object's frame
  mjSENS_FRAMEZAXIS = 27,              // 3D unit vector: z-axis of object's frame
  mjSENS_FRAMELINVEL = 28,             // 3D linear velocity
  mjSENS_FRAMEANGVEL = 29,             // 3D angular velocity
  mjSENS_FRAMELINACC = 30,             // 3D linear acceleration
  mjSENS_FRAMEANGACC = 31,             // 3D angular acceleration

  // sensors related to kinematic subtrees; attached to a body (which is the subtree root)
  mjSENS_SUBTREECOM = 32,              // 3D center of mass of subtree
  mjSENS_SUBTREELINVEL = 33,           // 3D linear velocity of subtree
  mjSENS_SUBTREEANGMOM = 34,           // 3D angular momentum of subtree

  // user-defined sensor
  mjSENS_USER = 35;                     // sensor data provided by mjcb_sensor callback


/** enum mjtStage */
public static final int          // computation stage
  mjSTAGE_NONE        = 0,        // no computations
  mjSTAGE_POS = 1,                    // position-dependent computations
  mjSTAGE_VEL = 2,                    // velocity-dependent computations
  mjSTAGE_ACC = 3;                     // acceleration/force-dependent computations


/** enum mjtDataType */
public static final int       // data type for sensors
  mjDATATYPE_REAL     = 0,        // real values, no constraints
  mjDATATYPE_POSITIVE = 1,            // positive values; 0 or negative: inactive
  mjDATATYPE_AXIS = 2,                // 3D unit vector
  mjDATATYPE_QUATERNION = 3;           // unit quaternion


/** enum mjtLRMode */
public static final int         // mode for actuator length range computation
  mjLRMODE_NONE   = 0,            // do not process any actuators
  mjLRMODE_MUSCLE = 1,                // process muscle actuators
  mjLRMODE_MUSCLEUSER = 2,            // process muscle and user actuators
  mjLRMODE_ALL = 3;                    // process all actuators


//---------------------------------- mjLROpt -------------------------------------------------------

public static class mjLROpt_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjLROpt_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjLROpt_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjLROpt_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjLROpt_ position(long position) {
        return (mjLROpt_)super.position(position);
    }
    @Override public mjLROpt_ getPointer(long i) {
        return new mjLROpt_((Pointer)this).offsetAddress(i);
    }
                 // options for mj_setLengthRange()
  // flags
  public native int mode(); public native mjLROpt_ mode(int setter);                       // which actuators to process (mjtLRMode)
  public native int useexisting(); public native mjLROpt_ useexisting(int setter);                // use existing length range if available
  public native int uselimit(); public native mjLROpt_ uselimit(int setter);                   // use joint and tendon limits if available

  // algorithm parameters
  public native @Cast("mjtNum") double accel(); public native mjLROpt_ accel(double setter);                   // target acceleration used to compute force
  public native @Cast("mjtNum") double maxforce(); public native mjLROpt_ maxforce(double setter);                // maximum force; 0: no limit
  public native @Cast("mjtNum") double timeconst(); public native mjLROpt_ timeconst(double setter);               // time constant for velocity reduction; min 0.01
  public native @Cast("mjtNum") double timestep(); public native mjLROpt_ timestep(double setter);                // simulation timestep; 0: use mjOption.timestep
  public native @Cast("mjtNum") double inttotal(); public native mjLROpt_ inttotal(double setter);                // total simulation time interval
  public native @Cast("mjtNum") double inteval(); public native mjLROpt_ inteval(double setter);                 // evaluation time interval (at the end)
  public native @Cast("mjtNum") double tolrange(); public native mjLROpt_ tolrange(double setter);                // convergence tolerance (relative to range)
}
@Opaque public static class mjLROpt extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjLROpt() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjLROpt(Pointer p) { super(p); }
}


//---------------------------------- mjVFS ---------------------------------------------------------

public static class mjVFS_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjVFS_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjVFS_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjVFS_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjVFS_ position(long position) {
        return (mjVFS_)super.position(position);
    }
    @Override public mjVFS_ getPointer(long i) {
        return new mjVFS_((Pointer)this).offsetAddress(i);
    }
                   // virtual file system for loading from memory
  public native int nfile(); public native mjVFS_ nfile(int setter);                    // number of files present
  public native @Cast("char") byte filename(int i, int j); public native mjVFS_ filename(int i, int j, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer filename(); // file name without path
  public native int filesize(int i); public native mjVFS_ filesize(int i, int setter);
  @MemberGetter public native IntPointer filesize();       // file size in bytes
  public native Pointer filedata(int i); public native mjVFS_ filedata(int i, Pointer setter);
  @MemberGetter public native @Cast("void**") PointerPointer filedata();       // buffer with file data
}
@Opaque public static class mjVFS extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjVFS() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjVFS(Pointer p) { super(p); }
}


//---------------------------------- mjOption ------------------------------------------------------

public static class mjOption_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjOption_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjOption_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjOption_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjOption_ position(long position) {
        return (mjOption_)super.position(position);
    }
    @Override public mjOption_ getPointer(long i) {
        return new mjOption_((Pointer)this).offsetAddress(i);
    }
                // physics options
  // timing parameters
  public native @Cast("mjtNum") double timestep(); public native mjOption_ timestep(double setter);                // timestep
  public native @Cast("mjtNum") double apirate(); public native mjOption_ apirate(double setter);                 // update rate for remote API (Hz)

  // solver parameters
  public native @Cast("mjtNum") double impratio(); public native mjOption_ impratio(double setter);                // ratio of friction-to-normal contact impedance
  public native @Cast("mjtNum") double tolerance(); public native mjOption_ tolerance(double setter);               // main solver tolerance
  public native @Cast("mjtNum") double noslip_tolerance(); public native mjOption_ noslip_tolerance(double setter);        // noslip solver tolerance
  public native @Cast("mjtNum") double mpr_tolerance(); public native mjOption_ mpr_tolerance(double setter);           // MPR solver tolerance

  // physical constants
  public native @Cast("mjtNum") double gravity(int i); public native mjOption_ gravity(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer gravity();              // gravitational acceleration
  public native @Cast("mjtNum") double wind(int i); public native mjOption_ wind(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer wind();                 // wind (for lift, drag and viscosity)
  public native @Cast("mjtNum") double magnetic(int i); public native mjOption_ magnetic(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer magnetic();             // global magnetic flux
  public native @Cast("mjtNum") double density(); public native mjOption_ density(double setter);                 // density of medium
  public native @Cast("mjtNum") double viscosity(); public native mjOption_ viscosity(double setter);               // viscosity of medium

  // override contact solver parameters (if enabled)
  public native @Cast("mjtNum") double o_margin(); public native mjOption_ o_margin(double setter);                // margin
  public native @Cast("mjtNum") double o_solref(int i); public native mjOption_ o_solref(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer o_solref();        // solref
  public native @Cast("mjtNum") double o_solimp(int i); public native mjOption_ o_solimp(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer o_solimp();        // solimp

  // discrete settings
  public native int integrator(); public native mjOption_ integrator(int setter);                 // integration mode (mjtIntegrator)
  public native int collision(); public native mjOption_ collision(int setter);                  // collision mode (mjtCollision)
  public native int cone(); public native mjOption_ cone(int setter);                       // type of friction cone (mjtCone)
  public native int jacobian(); public native mjOption_ jacobian(int setter);                   // type of Jacobian (mjtJacobian)
  public native int solver(); public native mjOption_ solver(int setter);                     // solver algorithm (mjtSolver)
  public native int iterations(); public native mjOption_ iterations(int setter);                 // maximum number of main solver iterations
  public native int noslip_iterations(); public native mjOption_ noslip_iterations(int setter);          // maximum number of noslip solver iterations
  public native int mpr_iterations(); public native mjOption_ mpr_iterations(int setter);             // maximum number of MPR solver iterations
  public native int disableflags(); public native mjOption_ disableflags(int setter);               // bit flags for disabling standard features
  public native int enableflags(); public native mjOption_ enableflags(int setter);                // bit flags for enabling optional features
}
@Opaque public static class mjOption extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjOption() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjOption(Pointer p) { super(p); }
}


//---------------------------------- mjVisual ------------------------------------------------------

public static class mjVisual_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjVisual_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjVisual_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjVisual_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjVisual_ position(long position) {
        return (mjVisual_)super.position(position);
    }
    @Override public mjVisual_ getPointer(long i) {
        return new mjVisual_((Pointer)this).offsetAddress(i);
    }
                // visualization options                        // global parameters
    @Name("global.fovy") public native float global_fovy(); public native mjVisual_ global_fovy(float setter);                   // y-field of view (deg) for free camera
    @Name("global.ipd") public native float global_ipd(); public native mjVisual_ global_ipd(float setter);                    // inter-pupilary distance for free camera
    @Name("global.linewidth") public native float global_linewidth(); public native mjVisual_ global_linewidth(float setter);              // line width for wireframe and ray rendering
    @Name("global.glow") public native float global_glow(); public native mjVisual_ global_glow(float setter);                   // glow coefficient for selected body
    @Name("global.offwidth") public native int global_offwidth(); public native mjVisual_ global_offwidth(int setter);                 // width of offscreen buffer
    @Name("global.offheight") public native int global_offheight(); public native mjVisual_ global_offheight(int setter);                // height of offscreen buffer
                        // rendering quality
    @Name("quality.shadowsize") public native int quality_shadowsize(); public native mjVisual_ quality_shadowsize(int setter);             // size of shadowmap texture
    @Name("quality.offsamples") public native int quality_offsamples(); public native mjVisual_ quality_offsamples(int setter);             // number of multisamples for offscreen rendering
    @Name("quality.numslices") public native int quality_numslices(); public native mjVisual_ quality_numslices(int setter);              // number of slices for builtin geom drawing
    @Name("quality.numstacks") public native int quality_numstacks(); public native mjVisual_ quality_numstacks(int setter);              // number of stacks for builtin geom drawing
    @Name("quality.numquads") public native int quality_numquads(); public native mjVisual_ quality_numquads(int setter);               // number of quads for box rendering
                        // head light
    @Name("headlight.ambient") public native float headlight_ambient(int i); public native mjVisual_ headlight_ambient(int i, float setter);
    @Name("headlight.ambient") @MemberGetter public native FloatPointer headlight_ambient();             // ambient rgb (alpha=1)
    @Name("headlight.diffuse") public native float headlight_diffuse(int i); public native mjVisual_ headlight_diffuse(int i, float setter);
    @Name("headlight.diffuse") @MemberGetter public native FloatPointer headlight_diffuse();             // diffuse rgb (alpha=1)
    @Name("headlight.specular") public native float headlight_specular(int i); public native mjVisual_ headlight_specular(int i, float setter);
    @Name("headlight.specular") @MemberGetter public native FloatPointer headlight_specular();            // specular rgb (alpha=1)
    @Name("headlight.active") public native int headlight_active(); public native mjVisual_ headlight_active(int setter);                 // is headlight active
                        // mapping
    @Name("map.stiffness") public native float map_stiffness(); public native mjVisual_ map_stiffness(float setter);              // mouse perturbation stiffness (space->force)
    @Name("map.stiffnessrot") public native float map_stiffnessrot(); public native mjVisual_ map_stiffnessrot(float setter);           // mouse perturbation stiffness (space->torque)
    @Name("map.force") public native float map_force(); public native mjVisual_ map_force(float setter);                  // from force units to space units
    @Name("map.torque") public native float map_torque(); public native mjVisual_ map_torque(float setter);                 // from torque units to space units
    @Name("map.alpha") public native float map_alpha(); public native mjVisual_ map_alpha(float setter);                  // scale geom alphas when transparency is enabled
    @Name("map.fogstart") public native float map_fogstart(); public native mjVisual_ map_fogstart(float setter);               // OpenGL fog starts at fogstart * mjModel.stat.extent
    @Name("map.fogend") public native float map_fogend(); public native mjVisual_ map_fogend(float setter);                 // OpenGL fog ends at fogend * mjModel.stat.extent
    @Name("map.znear") public native float map_znear(); public native mjVisual_ map_znear(float setter);                  // near clipping plane = znear * mjModel.stat.extent
    @Name("map.zfar") public native float map_zfar(); public native mjVisual_ map_zfar(float setter);                   // far clipping plane = zfar * mjModel.stat.extent
    @Name("map.haze") public native float map_haze(); public native mjVisual_ map_haze(float setter);                   // haze ratio
    @Name("map.shadowclip") public native float map_shadowclip(); public native mjVisual_ map_shadowclip(float setter);             // directional light: shadowclip * mjModel.stat.extent
    @Name("map.shadowscale") public native float map_shadowscale(); public native mjVisual_ map_shadowscale(float setter);            // spot light: shadowscale * light.cutoff
    @Name("map.actuatortendon") public native float map_actuatortendon(); public native mjVisual_ map_actuatortendon(float setter);         // scale tendon width
                        // scale of decor elements relative to mean body size
    @Name("scale.forcewidth") public native float scale_forcewidth(); public native mjVisual_ scale_forcewidth(float setter);             // width of force arrow
    @Name("scale.contactwidth") public native float scale_contactwidth(); public native mjVisual_ scale_contactwidth(float setter);           // contact width
    @Name("scale.contactheight") public native float scale_contactheight(); public native mjVisual_ scale_contactheight(float setter);          // contact height
    @Name("scale.connect") public native float scale_connect(); public native mjVisual_ scale_connect(float setter);                // autoconnect capsule width
    @Name("scale.com") public native float scale_com(); public native mjVisual_ scale_com(float setter);                    // com radius
    @Name("scale.camera") public native float scale_camera(); public native mjVisual_ scale_camera(float setter);                 // camera object
    @Name("scale.light") public native float scale_light(); public native mjVisual_ scale_light(float setter);                  // light object
    @Name("scale.selectpoint") public native float scale_selectpoint(); public native mjVisual_ scale_selectpoint(float setter);            // selection point
    @Name("scale.jointlength") public native float scale_jointlength(); public native mjVisual_ scale_jointlength(float setter);            // joint length
    @Name("scale.jointwidth") public native float scale_jointwidth(); public native mjVisual_ scale_jointwidth(float setter);             // joint width
    @Name("scale.actuatorlength") public native float scale_actuatorlength(); public native mjVisual_ scale_actuatorlength(float setter);         // actuator length
    @Name("scale.actuatorwidth") public native float scale_actuatorwidth(); public native mjVisual_ scale_actuatorwidth(float setter);          // actuator width
    @Name("scale.framelength") public native float scale_framelength(); public native mjVisual_ scale_framelength(float setter);            // bodyframe axis length
    @Name("scale.framewidth") public native float scale_framewidth(); public native mjVisual_ scale_framewidth(float setter);             // bodyframe axis width
    @Name("scale.constraint") public native float scale_constraint(); public native mjVisual_ scale_constraint(float setter);             // constraint width
    @Name("scale.slidercrank") public native float scale_slidercrank(); public native mjVisual_ scale_slidercrank(float setter);            // slidercrank width
                        // color of decor elements
    @Name("rgba.fog") public native float rgba_fog(int i); public native mjVisual_ rgba_fog(int i, float setter);
    @Name("rgba.fog") @MemberGetter public native FloatPointer rgba_fog();                 // fog
    @Name("rgba.haze") public native float rgba_haze(int i); public native mjVisual_ rgba_haze(int i, float setter);
    @Name("rgba.haze") @MemberGetter public native FloatPointer rgba_haze();                // haze
    @Name("rgba.force") public native float rgba_force(int i); public native mjVisual_ rgba_force(int i, float setter);
    @Name("rgba.force") @MemberGetter public native FloatPointer rgba_force();               // external force
    @Name("rgba.inertia") public native float rgba_inertia(int i); public native mjVisual_ rgba_inertia(int i, float setter);
    @Name("rgba.inertia") @MemberGetter public native FloatPointer rgba_inertia();             // inertia box
    @Name("rgba.joint") public native float rgba_joint(int i); public native mjVisual_ rgba_joint(int i, float setter);
    @Name("rgba.joint") @MemberGetter public native FloatPointer rgba_joint();               // joint
    @Name("rgba.actuator") public native float rgba_actuator(int i); public native mjVisual_ rgba_actuator(int i, float setter);
    @Name("rgba.actuator") @MemberGetter public native FloatPointer rgba_actuator();            // actuator, neutral
    @Name("rgba.actuatornegative") public native float rgba_actuatornegative(int i); public native mjVisual_ rgba_actuatornegative(int i, float setter);
    @Name("rgba.actuatornegative") @MemberGetter public native FloatPointer rgba_actuatornegative();    // actuator, negative limit
    @Name("rgba.actuatorpositive") public native float rgba_actuatorpositive(int i); public native mjVisual_ rgba_actuatorpositive(int i, float setter);
    @Name("rgba.actuatorpositive") @MemberGetter public native FloatPointer rgba_actuatorpositive();    // actuator, positive limit
    @Name("rgba.com") public native float rgba_com(int i); public native mjVisual_ rgba_com(int i, float setter);
    @Name("rgba.com") @MemberGetter public native FloatPointer rgba_com();                 // center of mass
    @Name("rgba.camera") public native float rgba_camera(int i); public native mjVisual_ rgba_camera(int i, float setter);
    @Name("rgba.camera") @MemberGetter public native FloatPointer rgba_camera();              // camera object
    @Name("rgba.light") public native float rgba_light(int i); public native mjVisual_ rgba_light(int i, float setter);
    @Name("rgba.light") @MemberGetter public native FloatPointer rgba_light();               // light object
    @Name("rgba.selectpoint") public native float rgba_selectpoint(int i); public native mjVisual_ rgba_selectpoint(int i, float setter);
    @Name("rgba.selectpoint") @MemberGetter public native FloatPointer rgba_selectpoint();         // selection point
    @Name("rgba.connect") public native float rgba_connect(int i); public native mjVisual_ rgba_connect(int i, float setter);
    @Name("rgba.connect") @MemberGetter public native FloatPointer rgba_connect();             // auto connect
    @Name("rgba.contactpoint") public native float rgba_contactpoint(int i); public native mjVisual_ rgba_contactpoint(int i, float setter);
    @Name("rgba.contactpoint") @MemberGetter public native FloatPointer rgba_contactpoint();        // contact point
    @Name("rgba.contactforce") public native float rgba_contactforce(int i); public native mjVisual_ rgba_contactforce(int i, float setter);
    @Name("rgba.contactforce") @MemberGetter public native FloatPointer rgba_contactforce();        // contact force
    @Name("rgba.contactfriction") public native float rgba_contactfriction(int i); public native mjVisual_ rgba_contactfriction(int i, float setter);
    @Name("rgba.contactfriction") @MemberGetter public native FloatPointer rgba_contactfriction();     // contact friction force
    @Name("rgba.contacttorque") public native float rgba_contacttorque(int i); public native mjVisual_ rgba_contacttorque(int i, float setter);
    @Name("rgba.contacttorque") @MemberGetter public native FloatPointer rgba_contacttorque();       // contact torque
    @Name("rgba.contactgap") public native float rgba_contactgap(int i); public native mjVisual_ rgba_contactgap(int i, float setter);
    @Name("rgba.contactgap") @MemberGetter public native FloatPointer rgba_contactgap();          // contact point in gap
    @Name("rgba.rangefinder") public native float rgba_rangefinder(int i); public native mjVisual_ rgba_rangefinder(int i, float setter);
    @Name("rgba.rangefinder") @MemberGetter public native FloatPointer rgba_rangefinder();         // rangefinder ray
    @Name("rgba.constraint") public native float rgba_constraint(int i); public native mjVisual_ rgba_constraint(int i, float setter);
    @Name("rgba.constraint") @MemberGetter public native FloatPointer rgba_constraint();          // constraint
    @Name("rgba.slidercrank") public native float rgba_slidercrank(int i); public native mjVisual_ rgba_slidercrank(int i, float setter);
    @Name("rgba.slidercrank") @MemberGetter public native FloatPointer rgba_slidercrank();         // slidercrank
    @Name("rgba.crankbroken") public native float rgba_crankbroken(int i); public native mjVisual_ rgba_crankbroken(int i, float setter);
    @Name("rgba.crankbroken") @MemberGetter public native FloatPointer rgba_crankbroken();         // used when crank must be stretched/broken
}
@Opaque public static class mjVisual extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjVisual() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjVisual(Pointer p) { super(p); }
}


//---------------------------------- mjStatistic ---------------------------------------------------

public static class mjStatistic_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjStatistic_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjStatistic_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjStatistic_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjStatistic_ position(long position) {
        return (mjStatistic_)super.position(position);
    }
    @Override public mjStatistic_ getPointer(long i) {
        return new mjStatistic_((Pointer)this).offsetAddress(i);
    }
             // model statistics (in qpos0)
  public native @Cast("mjtNum") double meaninertia(); public native mjStatistic_ meaninertia(double setter);             // mean diagonal inertia
  public native @Cast("mjtNum") double meanmass(); public native mjStatistic_ meanmass(double setter);                // mean body mass
  public native @Cast("mjtNum") double meansize(); public native mjStatistic_ meansize(double setter);                // mean body size
  public native @Cast("mjtNum") double extent(); public native mjStatistic_ extent(double setter);                  // spatial extent
  public native @Cast("mjtNum") double center(int i); public native mjStatistic_ center(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer center();               // center of model
}
@Opaque public static class mjStatistic extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjStatistic() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjStatistic(Pointer p) { super(p); }
}


//---------------------------------- mjModel -------------------------------------------------------

public static class mjModel_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjModel_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjModel_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjModel_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjModel_ position(long position) {
        return (mjModel_)super.position(position);
    }
    @Override public mjModel_ getPointer(long i) {
        return new mjModel_((Pointer)this).offsetAddress(i);
    }

  // ------------------------------- sizes

  // sizes needed at mjModel construction
  public native int nq(); public native mjModel_ nq(int setter);                         // number of generalized coordinates = dim(qpos)
  public native int nv(); public native mjModel_ nv(int setter);                         // number of degrees of freedom = dim(qvel)
  public native int nu(); public native mjModel_ nu(int setter);                         // number of actuators/controls = dim(ctrl)
  public native int na(); public native mjModel_ na(int setter);                         // number of activation states = dim(act)
  public native int nbody(); public native mjModel_ nbody(int setter);                      // number of bodies
  public native int njnt(); public native mjModel_ njnt(int setter);                       // number of joints
  public native int ngeom(); public native mjModel_ ngeom(int setter);                      // number of geoms
  public native int nsite(); public native mjModel_ nsite(int setter);                      // number of sites
  public native int ncam(); public native mjModel_ ncam(int setter);                       // number of cameras
  public native int nlight(); public native mjModel_ nlight(int setter);                     // number of lights
  public native int nmesh(); public native mjModel_ nmesh(int setter);                      // number of meshes
  public native int nmeshvert(); public native mjModel_ nmeshvert(int setter);                  // number of vertices in all meshes
  public native int nmeshtexvert(); public native mjModel_ nmeshtexvert(int setter);               // number of vertices with texcoords in all meshes
  public native int nmeshface(); public native mjModel_ nmeshface(int setter);                  // number of triangular faces in all meshes
  public native int nmeshgraph(); public native mjModel_ nmeshgraph(int setter);                 // number of ints in mesh auxiliary data
  public native int nskin(); public native mjModel_ nskin(int setter);                      // number of skins
  public native int nskinvert(); public native mjModel_ nskinvert(int setter);                  // number of vertices in all skins
  public native int nskintexvert(); public native mjModel_ nskintexvert(int setter);               // number of vertiex with texcoords in all skins
  public native int nskinface(); public native mjModel_ nskinface(int setter);                  // number of triangular faces in all skins
  public native int nskinbone(); public native mjModel_ nskinbone(int setter);                  // number of bones in all skins
  public native int nskinbonevert(); public native mjModel_ nskinbonevert(int setter);              // number of vertices in all skin bones
  public native int nhfield(); public native mjModel_ nhfield(int setter);                    // number of heightfields
  public native int nhfielddata(); public native mjModel_ nhfielddata(int setter);                // number of data points in all heightfields
  public native int ntex(); public native mjModel_ ntex(int setter);                       // number of textures
  public native int ntexdata(); public native mjModel_ ntexdata(int setter);                   // number of bytes in texture rgb data
  public native int nmat(); public native mjModel_ nmat(int setter);                       // number of materials
  public native int npair(); public native mjModel_ npair(int setter);                      // number of predefined geom pairs
  public native int nexclude(); public native mjModel_ nexclude(int setter);                   // number of excluded geom pairs
  public native int neq(); public native mjModel_ neq(int setter);                        // number of equality constraints
  public native int ntendon(); public native mjModel_ ntendon(int setter);                    // number of tendons
  public native int nwrap(); public native mjModel_ nwrap(int setter);                      // number of wrap objects in all tendon paths
  public native int nsensor(); public native mjModel_ nsensor(int setter);                    // number of sensors
  public native int nnumeric(); public native mjModel_ nnumeric(int setter);                   // number of numeric custom fields
  public native int nnumericdata(); public native mjModel_ nnumericdata(int setter);               // number of mjtNums in all numeric fields
  public native int ntext(); public native mjModel_ ntext(int setter);                      // number of text custom fields
  public native int ntextdata(); public native mjModel_ ntextdata(int setter);                  // number of mjtBytes in all text fields
  public native int ntuple(); public native mjModel_ ntuple(int setter);                     // number of tuple custom fields
  public native int ntupledata(); public native mjModel_ ntupledata(int setter);                 // number of objects in all tuple fields
  public native int nkey(); public native mjModel_ nkey(int setter);                       // number of keyframes
  public native int nmocap(); public native mjModel_ nmocap(int setter);                     // number of mocap bodies
  public native int nuser_body(); public native mjModel_ nuser_body(int setter);                 // number of mjtNums in body_user
  public native int nuser_jnt(); public native mjModel_ nuser_jnt(int setter);                  // number of mjtNums in jnt_user
  public native int nuser_geom(); public native mjModel_ nuser_geom(int setter);                 // number of mjtNums in geom_user
  public native int nuser_site(); public native mjModel_ nuser_site(int setter);                 // number of mjtNums in site_user
  public native int nuser_cam(); public native mjModel_ nuser_cam(int setter);                  // number of mjtNums in cam_user
  public native int nuser_tendon(); public native mjModel_ nuser_tendon(int setter);               // number of mjtNums in tendon_user
  public native int nuser_actuator(); public native mjModel_ nuser_actuator(int setter);             // number of mjtNums in actuator_user
  public native int nuser_sensor(); public native mjModel_ nuser_sensor(int setter);               // number of mjtNums in sensor_user
  public native int nnames(); public native mjModel_ nnames(int setter);                     // number of chars in all names

  // sizes set after mjModel construction (only affect mjData)
  public native int nM(); public native mjModel_ nM(int setter);                         // number of non-zeros in sparse inertia matrix
  public native int nD(); public native mjModel_ nD(int setter);                         // number of non-zeros in sparse derivative matrix
  public native int nemax(); public native mjModel_ nemax(int setter);                      // number of potential equality-constraint rows
  public native int njmax(); public native mjModel_ njmax(int setter);                      // number of available rows in constraint Jacobian
  public native int nconmax(); public native mjModel_ nconmax(int setter);                    // number of potential contacts in contact list
  public native int nstack(); public native mjModel_ nstack(int setter);                     // number of fields in mjData stack
  public native int nuserdata(); public native mjModel_ nuserdata(int setter);                  // number of extra fields in mjData
  public native int nsensordata(); public native mjModel_ nsensordata(int setter);                // number of fields in sensor data vector

  public native int nbuffer(); public native mjModel_ nbuffer(int setter);                    // number of bytes in buffer

  // ------------------------------- options and statistics

  public native @ByRef mjOption opt(); public native mjModel_ opt(mjOption setter);                   // physics options
  public native @ByRef mjVisual vis(); public native mjModel_ vis(mjVisual setter);                   // visualization options
  public native @ByRef mjStatistic stat(); public native mjModel_ stat(mjStatistic setter);               // model statistics

  // ------------------------------- buffers

  // main buffer
  public native Pointer buffer(); public native mjModel_ buffer(Pointer setter);               // main buffer; all pointers point in it    (nbuffer)

  // default generalized coordinates
  public native @Cast("mjtNum*") DoublePointer qpos0(); public native mjModel_ qpos0(DoublePointer setter);                // qpos values at default pose              (nq x 1)
  public native @Cast("mjtNum*") DoublePointer qpos_spring(); public native mjModel_ qpos_spring(DoublePointer setter);          // reference pose for springs               (nq x 1)

  // bodies
  public native IntPointer body_parentid(); public native mjModel_ body_parentid(IntPointer setter);        // id of body's parent                      (nbody x 1)
  public native IntPointer body_rootid(); public native mjModel_ body_rootid(IntPointer setter);          // id of root above body                    (nbody x 1)
  public native IntPointer body_weldid(); public native mjModel_ body_weldid(IntPointer setter);          // id of body that this body is welded to   (nbody x 1)
  public native IntPointer body_mocapid(); public native mjModel_ body_mocapid(IntPointer setter);         // id of mocap data; -1: none               (nbody x 1)
  public native IntPointer body_jntnum(); public native mjModel_ body_jntnum(IntPointer setter);          // number of joints for this body           (nbody x 1)
  public native IntPointer body_jntadr(); public native mjModel_ body_jntadr(IntPointer setter);          // start addr of joints; -1: no joints      (nbody x 1)
  public native IntPointer body_dofnum(); public native mjModel_ body_dofnum(IntPointer setter);          // number of motion degrees of freedom      (nbody x 1)
  public native IntPointer body_dofadr(); public native mjModel_ body_dofadr(IntPointer setter);          // start addr of dofs; -1: no dofs          (nbody x 1)
  public native IntPointer body_geomnum(); public native mjModel_ body_geomnum(IntPointer setter);         // number of geoms                          (nbody x 1)
  public native IntPointer body_geomadr(); public native mjModel_ body_geomadr(IntPointer setter);         // start addr of geoms; -1: no geoms        (nbody x 1)
  public native @Cast("mjtByte*") BytePointer body_simple(); public native mjModel_ body_simple(BytePointer setter);          // body is simple (has diagonal M)          (nbody x 1)
  public native @Cast("mjtByte*") BytePointer body_sameframe(); public native mjModel_ body_sameframe(BytePointer setter);       // inertial frame is same as body frame     (nbody x 1)
  public native @Cast("mjtNum*") DoublePointer body_pos(); public native mjModel_ body_pos(DoublePointer setter);             // position offset rel. to parent body      (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer body_quat(); public native mjModel_ body_quat(DoublePointer setter);            // orientation offset rel. to parent body   (nbody x 4)
  public native @Cast("mjtNum*") DoublePointer body_ipos(); public native mjModel_ body_ipos(DoublePointer setter);            // local position of center of mass         (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer body_iquat(); public native mjModel_ body_iquat(DoublePointer setter);           // local orientation of inertia ellipsoid   (nbody x 4)
  public native @Cast("mjtNum*") DoublePointer body_mass(); public native mjModel_ body_mass(DoublePointer setter);            // mass                                     (nbody x 1)
  public native @Cast("mjtNum*") DoublePointer body_subtreemass(); public native mjModel_ body_subtreemass(DoublePointer setter);     // mass of subtree starting at this body    (nbody x 1)
  public native @Cast("mjtNum*") DoublePointer body_inertia(); public native mjModel_ body_inertia(DoublePointer setter);         // diagonal inertia in ipos/iquat frame     (nbody x 3)
  public native @Cast("mjtNum*") DoublePointer body_invweight0(); public native mjModel_ body_invweight0(DoublePointer setter);      // mean inv inert in qpos0 (trn, rot)       (nbody x 2)
  public native @Cast("mjtNum*") DoublePointer body_user(); public native mjModel_ body_user(DoublePointer setter);            // user data                                (nbody x nuser_body)

  // joints
  public native IntPointer jnt_type(); public native mjModel_ jnt_type(IntPointer setter);             // type of joint (mjtJoint)                 (njnt x 1)
  public native IntPointer jnt_qposadr(); public native mjModel_ jnt_qposadr(IntPointer setter);          // start addr in 'qpos' for joint's data    (njnt x 1)
  public native IntPointer jnt_dofadr(); public native mjModel_ jnt_dofadr(IntPointer setter);           // start addr in 'qvel' for joint's data    (njnt x 1)
  public native IntPointer jnt_bodyid(); public native mjModel_ jnt_bodyid(IntPointer setter);           // id of joint's body                       (njnt x 1)
  public native IntPointer jnt_group(); public native mjModel_ jnt_group(IntPointer setter);            // group for visibility                     (njnt x 1)
  public native @Cast("mjtByte*") BytePointer jnt_limited(); public native mjModel_ jnt_limited(BytePointer setter);          // does joint have limits                   (njnt x 1)
  public native @Cast("mjtNum*") DoublePointer jnt_solref(); public native mjModel_ jnt_solref(DoublePointer setter);           // constraint solver reference: limit       (njnt x mjNREF)
  public native @Cast("mjtNum*") DoublePointer jnt_solimp(); public native mjModel_ jnt_solimp(DoublePointer setter);           // constraint solver impedance: limit       (njnt x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer jnt_pos(); public native mjModel_ jnt_pos(DoublePointer setter);              // local anchor position                    (njnt x 3)
  public native @Cast("mjtNum*") DoublePointer jnt_axis(); public native mjModel_ jnt_axis(DoublePointer setter);             // local joint axis                         (njnt x 3)
  public native @Cast("mjtNum*") DoublePointer jnt_stiffness(); public native mjModel_ jnt_stiffness(DoublePointer setter);        // stiffness coefficient                    (njnt x 1)
  public native @Cast("mjtNum*") DoublePointer jnt_range(); public native mjModel_ jnt_range(DoublePointer setter);            // joint limits                             (njnt x 2)
  public native @Cast("mjtNum*") DoublePointer jnt_margin(); public native mjModel_ jnt_margin(DoublePointer setter);           // min distance for limit detection         (njnt x 1)
  public native @Cast("mjtNum*") DoublePointer jnt_user(); public native mjModel_ jnt_user(DoublePointer setter);             // user data                                (njnt x nuser_jnt)

  // dofs
  public native IntPointer dof_bodyid(); public native mjModel_ dof_bodyid(IntPointer setter);           // id of dof's body                         (nv x 1)
  public native IntPointer dof_jntid(); public native mjModel_ dof_jntid(IntPointer setter);            // id of dof's joint                        (nv x 1)
  public native IntPointer dof_parentid(); public native mjModel_ dof_parentid(IntPointer setter);         // id of dof's parent; -1: none             (nv x 1)
  public native IntPointer dof_Madr(); public native mjModel_ dof_Madr(IntPointer setter);             // dof address in M-diagonal                (nv x 1)
  public native IntPointer dof_simplenum(); public native mjModel_ dof_simplenum(IntPointer setter);        // number of consecutive simple dofs        (nv x 1)
  public native @Cast("mjtNum*") DoublePointer dof_solref(); public native mjModel_ dof_solref(DoublePointer setter);           // constraint solver reference:frictionloss (nv x mjNREF)
  public native @Cast("mjtNum*") DoublePointer dof_solimp(); public native mjModel_ dof_solimp(DoublePointer setter);           // constraint solver impedance:frictionloss (nv x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer dof_frictionloss(); public native mjModel_ dof_frictionloss(DoublePointer setter);     // dof friction loss                        (nv x 1)
  public native @Cast("mjtNum*") DoublePointer dof_armature(); public native mjModel_ dof_armature(DoublePointer setter);         // dof armature inertia/mass                (nv x 1)
  public native @Cast("mjtNum*") DoublePointer dof_damping(); public native mjModel_ dof_damping(DoublePointer setter);          // damping coefficient                      (nv x 1)
  public native @Cast("mjtNum*") DoublePointer dof_invweight0(); public native mjModel_ dof_invweight0(DoublePointer setter);       // diag. inverse inertia in qpos0           (nv x 1)
  public native @Cast("mjtNum*") DoublePointer dof_M0(); public native mjModel_ dof_M0(DoublePointer setter);               // diag. inertia in qpos0                   (nv x 1)

  // geoms
  public native IntPointer geom_type(); public native mjModel_ geom_type(IntPointer setter);            // geometric type (mjtGeom)                 (ngeom x 1)
  public native IntPointer geom_contype(); public native mjModel_ geom_contype(IntPointer setter);         // geom contact type                        (ngeom x 1)
  public native IntPointer geom_conaffinity(); public native mjModel_ geom_conaffinity(IntPointer setter);     // geom contact affinity                    (ngeom x 1)
  public native IntPointer geom_condim(); public native mjModel_ geom_condim(IntPointer setter);          // contact dimensionality (1, 3, 4, 6)      (ngeom x 1)
  public native IntPointer geom_bodyid(); public native mjModel_ geom_bodyid(IntPointer setter);          // id of geom's body                        (ngeom x 1)
  public native IntPointer geom_dataid(); public native mjModel_ geom_dataid(IntPointer setter);          // id of geom's mesh/hfield (-1: none)      (ngeom x 1)
  public native IntPointer geom_matid(); public native mjModel_ geom_matid(IntPointer setter);           // material id for rendering                (ngeom x 1)
  public native IntPointer geom_group(); public native mjModel_ geom_group(IntPointer setter);           // group for visibility                     (ngeom x 1)
  public native IntPointer geom_priority(); public native mjModel_ geom_priority(IntPointer setter);        // geom contact priority                    (ngeom x 1)
  public native @Cast("mjtByte*") BytePointer geom_sameframe(); public native mjModel_ geom_sameframe(BytePointer setter);       // same as body frame (1) or iframe (2)     (ngeom x 1)
  public native @Cast("mjtNum*") DoublePointer geom_solmix(); public native mjModel_ geom_solmix(DoublePointer setter);          // mixing coef for solref/imp in geom pair  (ngeom x 1)
  public native @Cast("mjtNum*") DoublePointer geom_solref(); public native mjModel_ geom_solref(DoublePointer setter);          // constraint solver reference: contact     (ngeom x mjNREF)
  public native @Cast("mjtNum*") DoublePointer geom_solimp(); public native mjModel_ geom_solimp(DoublePointer setter);          // constraint solver impedance: contact     (ngeom x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer geom_size(); public native mjModel_ geom_size(DoublePointer setter);            // geom-specific size parameters            (ngeom x 3)
  public native @Cast("mjtNum*") DoublePointer geom_rbound(); public native mjModel_ geom_rbound(DoublePointer setter);          // radius of bounding sphere                (ngeom x 1)
  public native @Cast("mjtNum*") DoublePointer geom_pos(); public native mjModel_ geom_pos(DoublePointer setter);             // local position offset rel. to body       (ngeom x 3)
  public native @Cast("mjtNum*") DoublePointer geom_quat(); public native mjModel_ geom_quat(DoublePointer setter);            // local orientation offset rel. to body    (ngeom x 4)
  public native @Cast("mjtNum*") DoublePointer geom_friction(); public native mjModel_ geom_friction(DoublePointer setter);        // friction for (slide, spin, roll)         (ngeom x 3)
  public native @Cast("mjtNum*") DoublePointer geom_margin(); public native mjModel_ geom_margin(DoublePointer setter);          // detect contact if dist<margin            (ngeom x 1)
  public native @Cast("mjtNum*") DoublePointer geom_gap(); public native mjModel_ geom_gap(DoublePointer setter);             // include in solver if dist<margin-gap     (ngeom x 1)
  public native @Cast("mjtNum*") DoublePointer geom_fluid(); public native mjModel_ geom_fluid(DoublePointer setter);           // fluid interaction parameters             (ngeom x mjNFLUID)
  public native @Cast("mjtNum*") DoublePointer geom_user(); public native mjModel_ geom_user(DoublePointer setter);            // user data                                (ngeom x nuser_geom)
  public native FloatPointer geom_rgba(); public native mjModel_ geom_rgba(FloatPointer setter);            // rgba when material is omitted            (ngeom x 4)

  // sites
  public native IntPointer site_type(); public native mjModel_ site_type(IntPointer setter);            // geom type for rendering (mjtGeom)        (nsite x 1)
  public native IntPointer site_bodyid(); public native mjModel_ site_bodyid(IntPointer setter);          // id of site's body                        (nsite x 1)
  public native IntPointer site_matid(); public native mjModel_ site_matid(IntPointer setter);           // material id for rendering                (nsite x 1)
  public native IntPointer site_group(); public native mjModel_ site_group(IntPointer setter);           // group for visibility                     (nsite x 1)
  public native @Cast("mjtByte*") BytePointer site_sameframe(); public native mjModel_ site_sameframe(BytePointer setter);       // same as body frame (1) or iframe (2)     (nsite x 1)
  public native @Cast("mjtNum*") DoublePointer site_size(); public native mjModel_ site_size(DoublePointer setter);            // geom size for rendering                  (nsite x 3)
  public native @Cast("mjtNum*") DoublePointer site_pos(); public native mjModel_ site_pos(DoublePointer setter);             // local position offset rel. to body       (nsite x 3)
  public native @Cast("mjtNum*") DoublePointer site_quat(); public native mjModel_ site_quat(DoublePointer setter);            // local orientation offset rel. to body    (nsite x 4)
  public native @Cast("mjtNum*") DoublePointer site_user(); public native mjModel_ site_user(DoublePointer setter);            // user data                                (nsite x nuser_site)
  public native FloatPointer site_rgba(); public native mjModel_ site_rgba(FloatPointer setter);            // rgba when material is omitted            (nsite x 4)

  // cameras
  public native IntPointer cam_mode(); public native mjModel_ cam_mode(IntPointer setter);             // camera tracking mode (mjtCamLight)       (ncam x 1)
  public native IntPointer cam_bodyid(); public native mjModel_ cam_bodyid(IntPointer setter);           // id of camera's body                      (ncam x 1)
  public native IntPointer cam_targetbodyid(); public native mjModel_ cam_targetbodyid(IntPointer setter);     // id of targeted body; -1: none            (ncam x 1)
  public native @Cast("mjtNum*") DoublePointer cam_pos(); public native mjModel_ cam_pos(DoublePointer setter);              // position rel. to body frame              (ncam x 3)
  public native @Cast("mjtNum*") DoublePointer cam_quat(); public native mjModel_ cam_quat(DoublePointer setter);             // orientation rel. to body frame           (ncam x 4)
  public native @Cast("mjtNum*") DoublePointer cam_poscom0(); public native mjModel_ cam_poscom0(DoublePointer setter);          // global position rel. to sub-com in qpos0 (ncam x 3)
  public native @Cast("mjtNum*") DoublePointer cam_pos0(); public native mjModel_ cam_pos0(DoublePointer setter);             // global position rel. to body in qpos0    (ncam x 3)
  public native @Cast("mjtNum*") DoublePointer cam_mat0(); public native mjModel_ cam_mat0(DoublePointer setter);             // global orientation in qpos0              (ncam x 9)
  public native @Cast("mjtNum*") DoublePointer cam_fovy(); public native mjModel_ cam_fovy(DoublePointer setter);             // y-field of view (deg)                    (ncam x 1)
  public native @Cast("mjtNum*") DoublePointer cam_ipd(); public native mjModel_ cam_ipd(DoublePointer setter);              // inter-pupilary distance                  (ncam x 1)
  public native @Cast("mjtNum*") DoublePointer cam_user(); public native mjModel_ cam_user(DoublePointer setter);             // user data                                (ncam x nuser_cam)

  // lights
  public native IntPointer light_mode(); public native mjModel_ light_mode(IntPointer setter);           // light tracking mode (mjtCamLight)        (nlight x 1)
  public native IntPointer light_bodyid(); public native mjModel_ light_bodyid(IntPointer setter);         // id of light's body                       (nlight x 1)
  public native IntPointer light_targetbodyid(); public native mjModel_ light_targetbodyid(IntPointer setter);   // id of targeted body; -1: none            (nlight x 1)
  public native @Cast("mjtByte*") BytePointer light_directional(); public native mjModel_ light_directional(BytePointer setter);    // directional light                        (nlight x 1)
  public native @Cast("mjtByte*") BytePointer light_castshadow(); public native mjModel_ light_castshadow(BytePointer setter);     // does light cast shadows                  (nlight x 1)
  public native @Cast("mjtByte*") BytePointer light_active(); public native mjModel_ light_active(BytePointer setter);         // is light on                              (nlight x 1)
  public native @Cast("mjtNum*") DoublePointer light_pos(); public native mjModel_ light_pos(DoublePointer setter);            // position rel. to body frame              (nlight x 3)
  public native @Cast("mjtNum*") DoublePointer light_dir(); public native mjModel_ light_dir(DoublePointer setter);            // direction rel. to body frame             (nlight x 3)
  public native @Cast("mjtNum*") DoublePointer light_poscom0(); public native mjModel_ light_poscom0(DoublePointer setter);        // global position rel. to sub-com in qpos0 (nlight x 3)
  public native @Cast("mjtNum*") DoublePointer light_pos0(); public native mjModel_ light_pos0(DoublePointer setter);           // global position rel. to body in qpos0    (nlight x 3)
  public native @Cast("mjtNum*") DoublePointer light_dir0(); public native mjModel_ light_dir0(DoublePointer setter);           // global direction in qpos0                (nlight x 3)
  public native FloatPointer light_attenuation(); public native mjModel_ light_attenuation(FloatPointer setter);    // OpenGL attenuation (quadratic model)     (nlight x 3)
  public native FloatPointer light_cutoff(); public native mjModel_ light_cutoff(FloatPointer setter);         // OpenGL cutoff                            (nlight x 1)
  public native FloatPointer light_exponent(); public native mjModel_ light_exponent(FloatPointer setter);       // OpenGL exponent                          (nlight x 1)
  public native FloatPointer light_ambient(); public native mjModel_ light_ambient(FloatPointer setter);        // ambient rgb (alpha=1)                    (nlight x 3)
  public native FloatPointer light_diffuse(); public native mjModel_ light_diffuse(FloatPointer setter);        // diffuse rgb (alpha=1)                    (nlight x 3)
  public native FloatPointer light_specular(); public native mjModel_ light_specular(FloatPointer setter);       // specular rgb (alpha=1)                   (nlight x 3)

  // meshes
  public native IntPointer mesh_vertadr(); public native mjModel_ mesh_vertadr(IntPointer setter);         // first vertex address                     (nmesh x 1)
  public native IntPointer mesh_vertnum(); public native mjModel_ mesh_vertnum(IntPointer setter);         // number of vertices                       (nmesh x 1)
  public native IntPointer mesh_texcoordadr(); public native mjModel_ mesh_texcoordadr(IntPointer setter);     // texcoord data address; -1: no texcoord   (nmesh x 1)
  public native IntPointer mesh_faceadr(); public native mjModel_ mesh_faceadr(IntPointer setter);         // first face address                       (nmesh x 1)
  public native IntPointer mesh_facenum(); public native mjModel_ mesh_facenum(IntPointer setter);         // number of faces                          (nmesh x 1)
  public native IntPointer mesh_graphadr(); public native mjModel_ mesh_graphadr(IntPointer setter);        // graph data address; -1: no graph         (nmesh x 1)
  public native FloatPointer mesh_vert(); public native mjModel_ mesh_vert(FloatPointer setter);            // vertex positions for all meshe           (nmeshvert x 3)
  public native FloatPointer mesh_normal(); public native mjModel_ mesh_normal(FloatPointer setter);          // vertex normals for all meshes            (nmeshvert x 3)
  public native FloatPointer mesh_texcoord(); public native mjModel_ mesh_texcoord(FloatPointer setter);        // vertex texcoords for all meshes          (nmeshtexvert x 2)
  public native IntPointer mesh_face(); public native mjModel_ mesh_face(IntPointer setter);            // triangle face data                       (nmeshface x 3)
  public native IntPointer mesh_graph(); public native mjModel_ mesh_graph(IntPointer setter);           // convex graph data                        (nmeshgraph x 1)

  // skins
  public native IntPointer skin_matid(); public native mjModel_ skin_matid(IntPointer setter);           // skin material id; -1: none               (nskin x 1)
  public native FloatPointer skin_rgba(); public native mjModel_ skin_rgba(FloatPointer setter);            // skin rgba                                (nskin x 4)
  public native FloatPointer skin_inflate(); public native mjModel_ skin_inflate(FloatPointer setter);         // inflate skin in normal direction         (nskin x 1)
  public native IntPointer skin_vertadr(); public native mjModel_ skin_vertadr(IntPointer setter);         // first vertex address                     (nskin x 1)
  public native IntPointer skin_vertnum(); public native mjModel_ skin_vertnum(IntPointer setter);         // number of vertices                       (nskin x 1)
  public native IntPointer skin_texcoordadr(); public native mjModel_ skin_texcoordadr(IntPointer setter);     // texcoord data address; -1: no texcoord   (nskin x 1)
  public native IntPointer skin_faceadr(); public native mjModel_ skin_faceadr(IntPointer setter);         // first face address                       (nskin x 1)
  public native IntPointer skin_facenum(); public native mjModel_ skin_facenum(IntPointer setter);         // number of faces                          (nskin x 1)
  public native IntPointer skin_boneadr(); public native mjModel_ skin_boneadr(IntPointer setter);         // first bone in skin                       (nskin x 1)
  public native IntPointer skin_bonenum(); public native mjModel_ skin_bonenum(IntPointer setter);         // number of bones in skin                  (nskin x 1)
  public native FloatPointer skin_vert(); public native mjModel_ skin_vert(FloatPointer setter);            // vertex positions for all skin meshes     (nskinvert x 3)
  public native FloatPointer skin_texcoord(); public native mjModel_ skin_texcoord(FloatPointer setter);        // vertex texcoords for all skin meshes     (nskintexvert x 2)
  public native IntPointer skin_face(); public native mjModel_ skin_face(IntPointer setter);            // triangle faces for all skin meshes       (nskinface x 3)
  public native IntPointer skin_bonevertadr(); public native mjModel_ skin_bonevertadr(IntPointer setter);     // first vertex in each bone                (nskinbone x 1)
  public native IntPointer skin_bonevertnum(); public native mjModel_ skin_bonevertnum(IntPointer setter);     // number of vertices in each bone          (nskinbone x 1)
  public native FloatPointer skin_bonebindpos(); public native mjModel_ skin_bonebindpos(FloatPointer setter);     // bind pos of each bone                    (nskinbone x 3)
  public native FloatPointer skin_bonebindquat(); public native mjModel_ skin_bonebindquat(FloatPointer setter);    // bind quat of each bone                   (nskinbone x 4)
  public native IntPointer skin_bonebodyid(); public native mjModel_ skin_bonebodyid(IntPointer setter);      // body id of each bone                     (nskinbone x 1)
  public native IntPointer skin_bonevertid(); public native mjModel_ skin_bonevertid(IntPointer setter);      // mesh ids of vertices in each bone        (nskinbonevert x 1)
  public native FloatPointer skin_bonevertweight(); public native mjModel_ skin_bonevertweight(FloatPointer setter);  // weights of vertices in each bone         (nskinbonevert x 1)

  // height fields
  public native @Cast("mjtNum*") DoublePointer hfield_size(); public native mjModel_ hfield_size(DoublePointer setter);          // (x, y, z_top, z_bottom)                  (nhfield x 4)
  public native IntPointer hfield_nrow(); public native mjModel_ hfield_nrow(IntPointer setter);          // number of rows in grid                   (nhfield x 1)
  public native IntPointer hfield_ncol(); public native mjModel_ hfield_ncol(IntPointer setter);          // number of columns in grid                (nhfield x 1)
  public native IntPointer hfield_adr(); public native mjModel_ hfield_adr(IntPointer setter);           // address in hfield_data                   (nhfield x 1)
  public native FloatPointer hfield_data(); public native mjModel_ hfield_data(FloatPointer setter);          // elevation data                           (nhfielddata x 1)

  // textures
  public native IntPointer tex_type(); public native mjModel_ tex_type(IntPointer setter);             // texture type (mjtTexture)                (ntex x 1)
  public native IntPointer tex_height(); public native mjModel_ tex_height(IntPointer setter);           // number of rows in texture image          (ntex x 1)
  public native IntPointer tex_width(); public native mjModel_ tex_width(IntPointer setter);            // number of columns in texture image       (ntex x 1)
  public native IntPointer tex_adr(); public native mjModel_ tex_adr(IntPointer setter);              // address in rgb                           (ntex x 1)
  public native @Cast("mjtByte*") BytePointer tex_rgb(); public native mjModel_ tex_rgb(BytePointer setter);              // rgb (alpha = 1)                          (ntexdata x 1)

  // materials
  public native IntPointer mat_texid(); public native mjModel_ mat_texid(IntPointer setter);            // texture id; -1: none                     (nmat x 1)
  public native @Cast("mjtByte*") BytePointer mat_texuniform(); public native mjModel_ mat_texuniform(BytePointer setter);       // make texture cube uniform                (nmat x 1)
  public native FloatPointer mat_texrepeat(); public native mjModel_ mat_texrepeat(FloatPointer setter);        // texture repetition for 2d mapping        (nmat x 2)
  public native FloatPointer mat_emission(); public native mjModel_ mat_emission(FloatPointer setter);         // emission (x rgb)                         (nmat x 1)
  public native FloatPointer mat_specular(); public native mjModel_ mat_specular(FloatPointer setter);         // specular (x white)                       (nmat x 1)
  public native FloatPointer mat_shininess(); public native mjModel_ mat_shininess(FloatPointer setter);        // shininess coef                           (nmat x 1)
  public native FloatPointer mat_reflectance(); public native mjModel_ mat_reflectance(FloatPointer setter);      // reflectance (0: disable)                 (nmat x 1)
  public native FloatPointer mat_rgba(); public native mjModel_ mat_rgba(FloatPointer setter);             // rgba                                     (nmat x 4)

  // predefined geom pairs for collision detection; has precedence over exclude
  public native IntPointer pair_dim(); public native mjModel_ pair_dim(IntPointer setter);             // contact dimensionality                   (npair x 1)
  public native IntPointer pair_geom1(); public native mjModel_ pair_geom1(IntPointer setter);           // id of geom1                              (npair x 1)
  public native IntPointer pair_geom2(); public native mjModel_ pair_geom2(IntPointer setter);           // id of geom2                              (npair x 1)
  public native IntPointer pair_signature(); public native mjModel_ pair_signature(IntPointer setter);       // (body1+1)<<16 + body2+1                  (npair x 1)
  public native @Cast("mjtNum*") DoublePointer pair_solref(); public native mjModel_ pair_solref(DoublePointer setter);          // constraint solver reference: contact     (npair x mjNREF)
  public native @Cast("mjtNum*") DoublePointer pair_solimp(); public native mjModel_ pair_solimp(DoublePointer setter);          // constraint solver impedance: contact     (npair x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer pair_margin(); public native mjModel_ pair_margin(DoublePointer setter);          // detect contact if dist<margin            (npair x 1)
  public native @Cast("mjtNum*") DoublePointer pair_gap(); public native mjModel_ pair_gap(DoublePointer setter);             // include in solver if dist<margin-gap     (npair x 1)
  public native @Cast("mjtNum*") DoublePointer pair_friction(); public native mjModel_ pair_friction(DoublePointer setter);        // tangent1, 2, spin, roll1, 2              (npair x 5)

  // excluded body pairs for collision detection
  public native IntPointer exclude_signature(); public native mjModel_ exclude_signature(IntPointer setter);    // (body1+1)<<16 + body2+1                  (nexclude x 1)

  // equality constraints
  public native IntPointer eq_type(); public native mjModel_ eq_type(IntPointer setter);              // constraint type (mjtEq)                  (neq x 1)
  public native IntPointer eq_obj1id(); public native mjModel_ eq_obj1id(IntPointer setter);            // id of object 1                           (neq x 1)
  public native IntPointer eq_obj2id(); public native mjModel_ eq_obj2id(IntPointer setter);            // id of object 2                           (neq x 1)
  public native @Cast("mjtByte*") BytePointer eq_active(); public native mjModel_ eq_active(BytePointer setter);            // enable/disable constraint                (neq x 1)
  public native @Cast("mjtNum*") DoublePointer eq_solref(); public native mjModel_ eq_solref(DoublePointer setter);            // constraint solver reference              (neq x mjNREF)
  public native @Cast("mjtNum*") DoublePointer eq_solimp(); public native mjModel_ eq_solimp(DoublePointer setter);            // constraint solver impedance              (neq x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer eq_data(); public native mjModel_ eq_data(DoublePointer setter);              // numeric data for constraint              (neq x mjNEQDATA)

  // tendons
  public native IntPointer tendon_adr(); public native mjModel_ tendon_adr(IntPointer setter);           // address of first object in tendon's path (ntendon x 1)
  public native IntPointer tendon_num(); public native mjModel_ tendon_num(IntPointer setter);           // number of objects in tendon's path       (ntendon x 1)
  public native IntPointer tendon_matid(); public native mjModel_ tendon_matid(IntPointer setter);         // material id for rendering                (ntendon x 1)
  public native IntPointer tendon_group(); public native mjModel_ tendon_group(IntPointer setter);         // group for visibility                     (ntendon x 1)
  public native @Cast("mjtByte*") BytePointer tendon_limited(); public native mjModel_ tendon_limited(BytePointer setter);       // does tendon have length limits           (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_width(); public native mjModel_ tendon_width(DoublePointer setter);         // width for rendering                      (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_solref_lim(); public native mjModel_ tendon_solref_lim(DoublePointer setter);    // constraint solver reference: limit       (ntendon x mjNREF)
  public native @Cast("mjtNum*") DoublePointer tendon_solimp_lim(); public native mjModel_ tendon_solimp_lim(DoublePointer setter);    // constraint solver impedance: limit       (ntendon x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer tendon_solref_fri(); public native mjModel_ tendon_solref_fri(DoublePointer setter);    // constraint solver reference: friction    (ntendon x mjNREF)
  public native @Cast("mjtNum*") DoublePointer tendon_solimp_fri(); public native mjModel_ tendon_solimp_fri(DoublePointer setter);    // constraint solver impedance: friction    (ntendon x mjNIMP)
  public native @Cast("mjtNum*") DoublePointer tendon_range(); public native mjModel_ tendon_range(DoublePointer setter);         // tendon length limits                     (ntendon x 2)
  public native @Cast("mjtNum*") DoublePointer tendon_margin(); public native mjModel_ tendon_margin(DoublePointer setter);        // min distance for limit detection         (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_stiffness(); public native mjModel_ tendon_stiffness(DoublePointer setter);     // stiffness coefficient                    (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_damping(); public native mjModel_ tendon_damping(DoublePointer setter);       // damping coefficient                      (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_frictionloss(); public native mjModel_ tendon_frictionloss(DoublePointer setter);  // loss due to friction                     (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_lengthspring(); public native mjModel_ tendon_lengthspring(DoublePointer setter);  // tendon length in qpos_spring             (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_length0(); public native mjModel_ tendon_length0(DoublePointer setter);       // tendon length in qpos0                   (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_invweight0(); public native mjModel_ tendon_invweight0(DoublePointer setter);    // inv. weight in qpos0                     (ntendon x 1)
  public native @Cast("mjtNum*") DoublePointer tendon_user(); public native mjModel_ tendon_user(DoublePointer setter);          // user data                                (ntendon x nuser_tendon)
  public native FloatPointer tendon_rgba(); public native mjModel_ tendon_rgba(FloatPointer setter);          // rgba when material is omitted            (ntendon x 4)

  // list of all wrap objects in tendon paths
  public native IntPointer wrap_type(); public native mjModel_ wrap_type(IntPointer setter);            // wrap object type (mjtWrap)               (nwrap x 1)
  public native IntPointer wrap_objid(); public native mjModel_ wrap_objid(IntPointer setter);           // object id: geom, site, joint             (nwrap x 1)
  public native @Cast("mjtNum*") DoublePointer wrap_prm(); public native mjModel_ wrap_prm(DoublePointer setter);             // divisor, joint coef, or site id          (nwrap x 1)

  // actuators
  public native IntPointer actuator_trntype(); public native mjModel_ actuator_trntype(IntPointer setter);     // transmission type (mjtTrn)               (nu x 1)
  public native IntPointer actuator_dyntype(); public native mjModel_ actuator_dyntype(IntPointer setter);     // dynamics type (mjtDyn)                   (nu x 1)
  public native IntPointer actuator_gaintype(); public native mjModel_ actuator_gaintype(IntPointer setter);    // gain type (mjtGain)                      (nu x 1)
  public native IntPointer actuator_biastype(); public native mjModel_ actuator_biastype(IntPointer setter);    // bias type (mjtBias)                      (nu x 1)
  public native IntPointer actuator_trnid(); public native mjModel_ actuator_trnid(IntPointer setter);       // transmission id: joint, tendon, site     (nu x 2)
  public native IntPointer actuator_group(); public native mjModel_ actuator_group(IntPointer setter);       // group for visibility                     (nu x 1)
  public native @Cast("mjtByte*") BytePointer actuator_ctrllimited(); public native mjModel_ actuator_ctrllimited(BytePointer setter); // is control limited                       (nu x 1)
  public native @Cast("mjtByte*") BytePointer actuator_forcelimited(); public native mjModel_ actuator_forcelimited(BytePointer setter);// is force limited                         (nu x 1)
  public native @Cast("mjtByte*") BytePointer actuator_actlimited(); public native mjModel_ actuator_actlimited(BytePointer setter);  // is activation limited                    (nu x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_dynprm(); public native mjModel_ actuator_dynprm(DoublePointer setter);      // dynamics parameters                      (nu x mjNDYN)
  public native @Cast("mjtNum*") DoublePointer actuator_gainprm(); public native mjModel_ actuator_gainprm(DoublePointer setter);     // gain parameters                          (nu x mjNGAIN)
  public native @Cast("mjtNum*") DoublePointer actuator_biasprm(); public native mjModel_ actuator_biasprm(DoublePointer setter);     // bias parameters                          (nu x mjNBIAS)
  public native @Cast("mjtNum*") DoublePointer actuator_ctrlrange(); public native mjModel_ actuator_ctrlrange(DoublePointer setter);   // range of controls                        (nu x 2)
  public native @Cast("mjtNum*") DoublePointer actuator_forcerange(); public native mjModel_ actuator_forcerange(DoublePointer setter);  // range of forces                          (nu x 2)
  public native @Cast("mjtNum*") DoublePointer actuator_actrange(); public native mjModel_ actuator_actrange(DoublePointer setter);    // range of activations                     (nu x 2)
  public native @Cast("mjtNum*") DoublePointer actuator_gear(); public native mjModel_ actuator_gear(DoublePointer setter);        // scale length and transmitted force       (nu x 6)
  public native @Cast("mjtNum*") DoublePointer actuator_cranklength(); public native mjModel_ actuator_cranklength(DoublePointer setter); // crank length for slider-crank            (nu x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_acc0(); public native mjModel_ actuator_acc0(DoublePointer setter);        // acceleration from unit force in qpos0    (nu x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_length0(); public native mjModel_ actuator_length0(DoublePointer setter);     // actuator length in qpos0                 (nu x 1)
  public native @Cast("mjtNum*") DoublePointer actuator_lengthrange(); public native mjModel_ actuator_lengthrange(DoublePointer setter); // feasible actuator length range           (nu x 2)
  public native @Cast("mjtNum*") DoublePointer actuator_user(); public native mjModel_ actuator_user(DoublePointer setter);        // user data                                (nu x nuser_actuator)

  // sensors
  public native IntPointer sensor_type(); public native mjModel_ sensor_type(IntPointer setter);          // sensor type (mjtSensor)                  (nsensor x 1)
  public native IntPointer sensor_datatype(); public native mjModel_ sensor_datatype(IntPointer setter);      // numeric data type (mjtDataType)          (nsensor x 1)
  public native IntPointer sensor_needstage(); public native mjModel_ sensor_needstage(IntPointer setter);     // required compute stage (mjtStage)        (nsensor x 1)
  public native IntPointer sensor_objtype(); public native mjModel_ sensor_objtype(IntPointer setter);       // type of sensorized object (mjtObj)       (nsensor x 1)
  public native IntPointer sensor_objid(); public native mjModel_ sensor_objid(IntPointer setter);         // id of sensorized object                  (nsensor x 1)
  public native IntPointer sensor_reftype(); public native mjModel_ sensor_reftype(IntPointer setter);       // type of reference frame (mjtObj)         (nsensor x 1)
  public native IntPointer sensor_refid(); public native mjModel_ sensor_refid(IntPointer setter);         // id of reference frame; -1: global frame  (nsensor x 1)
  public native IntPointer sensor_dim(); public native mjModel_ sensor_dim(IntPointer setter);           // number of scalar outputs                 (nsensor x 1)
  public native IntPointer sensor_adr(); public native mjModel_ sensor_adr(IntPointer setter);           // address in sensor array                  (nsensor x 1)
  public native @Cast("mjtNum*") DoublePointer sensor_cutoff(); public native mjModel_ sensor_cutoff(DoublePointer setter);        // cutoff for real and positive; 0: ignore  (nsensor x 1)
  public native @Cast("mjtNum*") DoublePointer sensor_noise(); public native mjModel_ sensor_noise(DoublePointer setter);         // noise standard deviation                 (nsensor x 1)
  public native @Cast("mjtNum*") DoublePointer sensor_user(); public native mjModel_ sensor_user(DoublePointer setter);          // user data                                (nsensor x nuser_sensor)

  // custom numeric fields
  public native IntPointer numeric_adr(); public native mjModel_ numeric_adr(IntPointer setter);          // address of field in numeric_data         (nnumeric x 1)
  public native IntPointer numeric_size(); public native mjModel_ numeric_size(IntPointer setter);         // size of numeric field                    (nnumeric x 1)
  public native @Cast("mjtNum*") DoublePointer numeric_data(); public native mjModel_ numeric_data(DoublePointer setter);         // array of all numeric fields              (nnumericdata x 1)

  // custom text fields
  public native IntPointer text_adr(); public native mjModel_ text_adr(IntPointer setter);             // address of text in text_data             (ntext x 1)
  public native IntPointer text_size(); public native mjModel_ text_size(IntPointer setter);            // size of text field (strlen+1)            (ntext x 1)
  public native @Cast("char*") BytePointer text_data(); public native mjModel_ text_data(BytePointer setter);            // array of all text fields (0-terminated)  (ntextdata x 1)

  // custom tuple fields
  public native IntPointer tuple_adr(); public native mjModel_ tuple_adr(IntPointer setter);            // address of text in text_data             (ntuple x 1)
  public native IntPointer tuple_size(); public native mjModel_ tuple_size(IntPointer setter);           // number of objects in tuple               (ntuple x 1)
  public native IntPointer tuple_objtype(); public native mjModel_ tuple_objtype(IntPointer setter);        // array of object types in all tuples      (ntupledata x 1)
  public native IntPointer tuple_objid(); public native mjModel_ tuple_objid(IntPointer setter);          // array of object ids in all tuples        (ntupledata x 1)
  public native @Cast("mjtNum*") DoublePointer tuple_objprm(); public native mjModel_ tuple_objprm(DoublePointer setter);         // array of object params in all tuples     (ntupledata x 1)

  // keyframes
  public native @Cast("mjtNum*") DoublePointer key_time(); public native mjModel_ key_time(DoublePointer setter);             // key time                                 (nkey x 1)
  public native @Cast("mjtNum*") DoublePointer key_qpos(); public native mjModel_ key_qpos(DoublePointer setter);             // key position                             (nkey x nq)
  public native @Cast("mjtNum*") DoublePointer key_qvel(); public native mjModel_ key_qvel(DoublePointer setter);             // key velocity                             (nkey x nv)
  public native @Cast("mjtNum*") DoublePointer key_act(); public native mjModel_ key_act(DoublePointer setter);              // key activation                           (nkey x na)
  public native @Cast("mjtNum*") DoublePointer key_mpos(); public native mjModel_ key_mpos(DoublePointer setter);             // key mocap position                       (nkey x 3*nmocap)
  public native @Cast("mjtNum*") DoublePointer key_mquat(); public native mjModel_ key_mquat(DoublePointer setter);            // key mocap quaternion                     (nkey x 4*nmocap)

  // names
  public native IntPointer name_bodyadr(); public native mjModel_ name_bodyadr(IntPointer setter);         // body name pointers                       (nbody x 1)
  public native IntPointer name_jntadr(); public native mjModel_ name_jntadr(IntPointer setter);          // joint name pointers                      (njnt x 1)
  public native IntPointer name_geomadr(); public native mjModel_ name_geomadr(IntPointer setter);         // geom name pointers                       (ngeom x 1)
  public native IntPointer name_siteadr(); public native mjModel_ name_siteadr(IntPointer setter);         // site name pointers                       (nsite x 1)
  public native IntPointer name_camadr(); public native mjModel_ name_camadr(IntPointer setter);          // camera name pointers                     (ncam x 1)
  public native IntPointer name_lightadr(); public native mjModel_ name_lightadr(IntPointer setter);        // light name pointers                      (nlight x 1)
  public native IntPointer name_meshadr(); public native mjModel_ name_meshadr(IntPointer setter);         // mesh name pointers                       (nmesh x 1)
  public native IntPointer name_skinadr(); public native mjModel_ name_skinadr(IntPointer setter);         // skin name pointers                       (nskin x 1)
  public native IntPointer name_hfieldadr(); public native mjModel_ name_hfieldadr(IntPointer setter);       // hfield name pointers                     (nhfield x 1)
  public native IntPointer name_texadr(); public native mjModel_ name_texadr(IntPointer setter);          // texture name pointers                    (ntex x 1)
  public native IntPointer name_matadr(); public native mjModel_ name_matadr(IntPointer setter);          // material name pointers                   (nmat x 1)
  public native IntPointer name_pairadr(); public native mjModel_ name_pairadr(IntPointer setter);         // geom pair name pointers                  (npair x 1)
  public native IntPointer name_excludeadr(); public native mjModel_ name_excludeadr(IntPointer setter);      // exclude name pointers                    (nexclude x 1)
  public native IntPointer name_eqadr(); public native mjModel_ name_eqadr(IntPointer setter);           // equality constraint name pointers        (neq x 1)
  public native IntPointer name_tendonadr(); public native mjModel_ name_tendonadr(IntPointer setter);       // tendon name pointers                     (ntendon x 1)
  public native IntPointer name_actuatoradr(); public native mjModel_ name_actuatoradr(IntPointer setter);     // actuator name pointers                   (nu x 1)
  public native IntPointer name_sensoradr(); public native mjModel_ name_sensoradr(IntPointer setter);       // sensor name pointers                     (nsensor x 1)
  public native IntPointer name_numericadr(); public native mjModel_ name_numericadr(IntPointer setter);      // numeric name pointers                    (nnumeric x 1)
  public native IntPointer name_textadr(); public native mjModel_ name_textadr(IntPointer setter);         // text name pointers                       (ntext x 1)
  public native IntPointer name_tupleadr(); public native mjModel_ name_tupleadr(IntPointer setter);        // tuple name pointers                      (ntuple x 1)
  public native IntPointer name_keyadr(); public native mjModel_ name_keyadr(IntPointer setter);          // keyframe name pointers                   (nkey x 1)
  public native @Cast("char*") BytePointer names(); public native mjModel_ names(BytePointer setter);                // names of all objects, 0-terminated       (nnames x 1)
}
@Opaque public static class mjModel extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjModel() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjModel(Pointer p) { super(p); }
}

// #endif  // MUJOCO_MJMODEL_H_


// Parsed from mujoco/mjrender.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJRENDER_H_
// #define MUJOCO_MJRENDER_H_

// #include <mujoco/mjmodel.h>

// #if defined(__cplusplus)
// #endif

public static final int mjNAUX =          10;        // number of auxiliary buffers
public static final int mjMAXTEXTURE =    1000;      // maximum number of textures


//---------------------------------- primitive types (mjt) -----------------------------------------

/** enum mjtGridPos */
public static final int        // grid position for overlay
  mjGRID_TOPLEFT      = 0,        // top left
  mjGRID_TOPRIGHT = 1,                // top right
  mjGRID_BOTTOMLEFT = 2,              // bottom left
  mjGRID_BOTTOMRIGHT = 3;              // bottom right


/** enum mjtFramebuffer */
public static final int      // OpenGL framebuffer option
  mjFB_WINDOW         = 0,        // default/window buffer
  mjFB_OFFSCREEN = 1;                  // offscreen buffer


/** enum mjtFontScale */
public static final int        // font scale, used at context creation
  mjFONTSCALE_50      = 50,       // 50% scale, suitable for low-res rendering
  mjFONTSCALE_100     = 100,      // normal scale, suitable in the absence of DPI scaling
  mjFONTSCALE_150     = 150,      // 150% scale
  mjFONTSCALE_200     = 200,      // 200% scale
  mjFONTSCALE_250     = 250,      // 250% scale
  mjFONTSCALE_300     = 300;       // 300% scale


/** enum mjtFont */
public static final int           // font type, used at each text operation
  mjFONT_NORMAL       = 0,        // normal font
  mjFONT_SHADOW = 1,                  // normal font with shadow (for higher contrast)
  mjFONT_BIG = 2;                      // big font (for user alerts)


public static class mjrRect_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjrRect_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjrRect_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjrRect_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjrRect_ position(long position) {
        return (mjrRect_)super.position(position);
    }
    @Override public mjrRect_ getPointer(long i) {
        return new mjrRect_((Pointer)this).offsetAddress(i);
    }
                 // OpenGL rectangle
  public native int left(); public native mjrRect_ left(int setter);                       // left (usually 0)
  public native int bottom(); public native mjrRect_ bottom(int setter);                     // bottom (usually 0)
  public native int width(); public native mjrRect_ width(int setter);                      // width (usually buffer width)
  public native int height(); public native mjrRect_ height(int setter);                     // height (usually buffer height)
}
@Opaque public static class mjrRect extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjrRect() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjrRect(Pointer p) { super(p); }
}


//---------------------------------- mjrContext ----------------------------------------------------

public static class mjrContext_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjrContext_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjrContext_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjrContext_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjrContext_ position(long position) {
        return (mjrContext_)super.position(position);
    }
    @Override public mjrContext_ getPointer(long i) {
        return new mjrContext_((Pointer)this).offsetAddress(i);
    }
              // custom OpenGL context
  // parameters copied from mjVisual
  public native float lineWidth(); public native mjrContext_ lineWidth(float setter);                // line width for wireframe rendering
  public native float shadowClip(); public native mjrContext_ shadowClip(float setter);               // clipping radius for directional lights
  public native float shadowScale(); public native mjrContext_ shadowScale(float setter);              // fraction of light cutoff for spot lights
  public native float fogStart(); public native mjrContext_ fogStart(float setter);                 // fog start = stat.extent * vis.map.fogstart
  public native float fogEnd(); public native mjrContext_ fogEnd(float setter);                   // fog end = stat.extent * vis.map.fogend
  public native float fogRGBA(int i); public native mjrContext_ fogRGBA(int i, float setter);
  @MemberGetter public native FloatPointer fogRGBA();               // fog rgba
  public native int shadowSize(); public native mjrContext_ shadowSize(int setter);                 // size of shadow map texture
  public native int offWidth(); public native mjrContext_ offWidth(int setter);                   // width of offscreen buffer
  public native int offHeight(); public native mjrContext_ offHeight(int setter);                  // height of offscreen buffer
  public native int offSamples(); public native mjrContext_ offSamples(int setter);                 // number of offscreen buffer multisamples

  // parameters specified at creation
  public native int fontScale(); public native mjrContext_ fontScale(int setter);                  // font scale
  public native int auxWidth(int i); public native mjrContext_ auxWidth(int i, int setter);
  @MemberGetter public native IntPointer auxWidth();           // auxiliary buffer width
  public native int auxHeight(int i); public native mjrContext_ auxHeight(int i, int setter);
  @MemberGetter public native IntPointer auxHeight();          // auxiliary buffer height
  public native int auxSamples(int i); public native mjrContext_ auxSamples(int i, int setter);
  @MemberGetter public native IntPointer auxSamples();         // auxiliary buffer multisamples

  // offscreen rendering objects
  public native @Cast("unsigned int") int offFBO(); public native mjrContext_ offFBO(int setter);            // offscreen framebuffer object
  public native @Cast("unsigned int") int offFBO_r(); public native mjrContext_ offFBO_r(int setter);          // offscreen framebuffer for resolving multisamples
  public native @Cast("unsigned int") int offColor(); public native mjrContext_ offColor(int setter);          // offscreen color buffer
  public native @Cast("unsigned int") int offColor_r(); public native mjrContext_ offColor_r(int setter);        // offscreen color buffer for resolving multisamples
  public native @Cast("unsigned int") int offDepthStencil(); public native mjrContext_ offDepthStencil(int setter);   // offscreen depth and stencil buffer
  public native @Cast("unsigned int") int offDepthStencil_r(); public native mjrContext_ offDepthStencil_r(int setter); // offscreen depth and stencil buffer for resolving multisamples

  // shadow rendering objects
  public native @Cast("unsigned int") int shadowFBO(); public native mjrContext_ shadowFBO(int setter);         // shadow map framebuffer object
  public native @Cast("unsigned int") int shadowTex(); public native mjrContext_ shadowTex(int setter);         // shadow map texture

  // auxiliary buffers
  public native @Cast("unsigned int") int auxFBO(int i); public native mjrContext_ auxFBO(int i, int setter);
  @MemberGetter public native @Cast("unsigned int*") IntPointer auxFBO();    // auxiliary framebuffer object
  public native @Cast("unsigned int") int auxFBO_r(int i); public native mjrContext_ auxFBO_r(int i, int setter);
  @MemberGetter public native @Cast("unsigned int*") IntPointer auxFBO_r();  // auxiliary framebuffer object for resolving
  public native @Cast("unsigned int") int auxColor(int i); public native mjrContext_ auxColor(int i, int setter);
  @MemberGetter public native @Cast("unsigned int*") IntPointer auxColor();  // auxiliary color buffer
  public native @Cast("unsigned int") int auxColor_r(int i); public native mjrContext_ auxColor_r(int i, int setter);
  @MemberGetter public native @Cast("unsigned int*") IntPointer auxColor_r();// auxiliary color buffer for resolving

  // texture objects and info
  public native int ntexture(); public native mjrContext_ ntexture(int setter);                   // number of allocated textures
  public native int textureType(int i); public native mjrContext_ textureType(int i, int setter);
  @MemberGetter public native IntPointer textureType();           // type of texture (mjtTexture)
  public native @Cast("unsigned int") int texture(int i); public native mjrContext_ texture(int i, int setter);
  @MemberGetter public native @Cast("unsigned int*") IntPointer texture();      // texture names

  // displaylist starting positions
  public native @Cast("unsigned int") int basePlane(); public native mjrContext_ basePlane(int setter);         // all planes from model
  public native @Cast("unsigned int") int baseMesh(); public native mjrContext_ baseMesh(int setter);          // all meshes from model
  public native @Cast("unsigned int") int baseHField(); public native mjrContext_ baseHField(int setter);        // all hfields from model
  public native @Cast("unsigned int") int baseBuiltin(); public native mjrContext_ baseBuiltin(int setter);       // all buildin geoms, with quality from model
  public native @Cast("unsigned int") int baseFontNormal(); public native mjrContext_ baseFontNormal(int setter);    // normal font
  public native @Cast("unsigned int") int baseFontShadow(); public native mjrContext_ baseFontShadow(int setter);    // shadow font
  public native @Cast("unsigned int") int baseFontBig(); public native mjrContext_ baseFontBig(int setter);       // big font

  // displaylist ranges
  public native int rangePlane(); public native mjrContext_ rangePlane(int setter);                 // all planes from model
  public native int rangeMesh(); public native mjrContext_ rangeMesh(int setter);                  // all meshes from model
  public native int rangeHField(); public native mjrContext_ rangeHField(int setter);                // all hfields from model
  public native int rangeBuiltin(); public native mjrContext_ rangeBuiltin(int setter);               // all builtin geoms, with quality from model
  public native int rangeFont(); public native mjrContext_ rangeFont(int setter);                  // all characters in font

  // skin VBOs
  public native int nskin(); public native mjrContext_ nskin(int setter);                      // number of skins
  public native @Cast("unsigned int*") IntPointer skinvertVBO(); public native mjrContext_ skinvertVBO(IntPointer setter);      // skin vertex position VBOs
  public native @Cast("unsigned int*") IntPointer skinnormalVBO(); public native mjrContext_ skinnormalVBO(IntPointer setter);    // skin vertex normal VBOs
  public native @Cast("unsigned int*") IntPointer skintexcoordVBO(); public native mjrContext_ skintexcoordVBO(IntPointer setter);  // skin vertex texture coordinate VBOs
  public native @Cast("unsigned int*") IntPointer skinfaceVBO(); public native mjrContext_ skinfaceVBO(IntPointer setter);      // skin face index VBOs

  // character info
  public native int charWidth(int i); public native mjrContext_ charWidth(int i, int setter);
  @MemberGetter public native IntPointer charWidth();             // character widths: normal and shadow
  public native int charWidthBig(int i); public native mjrContext_ charWidthBig(int i, int setter);
  @MemberGetter public native IntPointer charWidthBig();          // chacarter widths: big
  public native int charHeight(); public native mjrContext_ charHeight(int setter);                 // character heights: normal and shadow
  public native int charHeightBig(); public native mjrContext_ charHeightBig(int setter);              // character heights: big

  // capabilities
  public native int glInitialized(); public native mjrContext_ glInitialized(int setter);              // is OpenGL initialized
  public native int windowAvailable(); public native mjrContext_ windowAvailable(int setter);            // is default/window framebuffer available
  public native int windowSamples(); public native mjrContext_ windowSamples(int setter);              // number of samples for default/window framebuffer
  public native int windowStereo(); public native mjrContext_ windowStereo(int setter);               // is stereo available for default/window framebuffer
  public native int windowDoublebuffer(); public native mjrContext_ windowDoublebuffer(int setter);         // is default/window framebuffer double buffered

  // framebuffer
  public native int currentBuffer(); public native mjrContext_ currentBuffer(int setter);          // currently active framebuffer: mjFB_WINDOW or mjFB_OFFSCREEN
}
@Opaque public static class mjrContext extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjrContext() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjrContext(Pointer p) { super(p); }
}

// #if defined(__cplusplus)
// #endif
// #endif  // MUJOCO_MJRENDER_H_


// Parsed from mujoco/mjtnum.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_INCLUDE_MJTNUM_H_
// #define MUJOCO_INCLUDE_MJTNUM_H_

//---------------------------------- floating-point definitions ------------------------------------

// compile-time configuration options
// #define mjUSEDOUBLE               // single or double precision for mjtNum


// floating point data type and minval
// #ifdef mjUSEDOUBLE
  public static final double mjMINVAL =    1E-15;       // minimum value in any denominator
// #else
// #endif


// #endif  // MUJOCO_INCLUDE_MJTNUM_H_


// Parsed from mujoco/mjui.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJUI_H_
// #define MUJOCO_MJUI_H_

// #include <mujoco/mjrender.h>

public static final int mjMAXUISECT =     10;      // maximum number of sections
public static final int mjMAXUIITEM =     80;      // maximum number of items per section
public static final int mjMAXUITEXT =     300;     // maximum number of chars in edittext and other
public static final int mjMAXUINAME =     40;      // maximum number of chars in name
public static final int mjMAXUIMULTI =    35;      // maximum number of radio/select items in group
public static final int mjMAXUIEDIT =     7;       // maximum number of elements in edit list
public static final int mjMAXUIRECT =     25;      // maximum number of rectangles

public static final int mjSEPCLOSED =     1000;    // closed state of adjustable separator


// key codes matching GLFW (user must remap for other frameworks)
public static final int mjKEY_ESCAPE =     256;
public static final int mjKEY_ENTER =      257;
public static final int mjKEY_TAB =        258;
public static final int mjKEY_BACKSPACE =  259;
public static final int mjKEY_INSERT =     260;
public static final int mjKEY_DELETE =     261;
public static final int mjKEY_RIGHT =      262;
public static final int mjKEY_LEFT =       263;
public static final int mjKEY_DOWN =       264;
public static final int mjKEY_UP =         265;
public static final int mjKEY_PAGE_UP =    266;
public static final int mjKEY_PAGE_DOWN =  267;
public static final int mjKEY_HOME =       268;
public static final int mjKEY_END =        269;
public static final int mjKEY_F1 =         290;
public static final int mjKEY_F2 =         291;
public static final int mjKEY_F3 =         292;
public static final int mjKEY_F4 =         293;
public static final int mjKEY_F5 =         294;
public static final int mjKEY_F6 =         295;
public static final int mjKEY_F7 =         296;
public static final int mjKEY_F8 =         297;
public static final int mjKEY_F9 =         298;
public static final int mjKEY_F10 =        299;
public static final int mjKEY_F11 =        300;
public static final int mjKEY_F12 =        301;


//---------------------------------- primitive types (mjt) -----------------------------------------

/** enum mjtButton */
public static final int         // mouse button
  mjBUTTON_NONE = 0,              // no button
  mjBUTTON_LEFT = 1,                  // left button
  mjBUTTON_RIGHT = 2,                 // right button
  mjBUTTON_MIDDLE = 3;                 // middle button


/** enum mjtEvent */
public static final int          // mouse and keyboard event type
  mjEVENT_NONE = 0,               // no event
  mjEVENT_MOVE = 1,                   // mouse move
  mjEVENT_PRESS = 2,                  // mouse button press
  mjEVENT_RELEASE = 3,                // mouse button release
  mjEVENT_SCROLL = 4,                 // scroll
  mjEVENT_KEY = 5,                    // key press
  mjEVENT_RESIZE = 6;                  // resize


/** enum mjtItem */
public static final int           // UI item type
  mjITEM_END = -2,                // end of definition list (not an item)
  mjITEM_SECTION = -1,            // section (not an item)
  mjITEM_SEPARATOR = 0,           // separator
  mjITEM_STATIC = 1,                  // static text
  mjITEM_BUTTON = 2,                  // button

  // the rest have data pointer
  mjITEM_CHECKINT = 3,                // check box, int value
  mjITEM_CHECKBYTE = 4,               // check box, mjtByte value
  mjITEM_RADIO = 5,                   // radio group
  mjITEM_RADIOLINE = 6,               // radio group, single line
  mjITEM_SELECT = 7,                  // selection box
  mjITEM_SLIDERINT = 8,               // slider, int value
  mjITEM_SLIDERNUM = 9,               // slider, mjtNum value
  mjITEM_EDITINT = 10,                 // editable array, int values
  mjITEM_EDITNUM = 11,                 // editable array, mjtNum values
  mjITEM_EDITTXT = 12,                 // editable text

  mjNITEM = 13;                         // number of item types


// predicate function: set enable/disable based on item category
public static class mjfItemEnable extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    mjfItemEnable(Pointer p) { super(p); }
    protected mjfItemEnable() { allocate(); }
    private native void allocate();
    public native int call(int category, Pointer data);
}


//---------------------------------- mjuiState -----------------------------------------------------

public static class mjuiState_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiState_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiState_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiState_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiState_ position(long position) {
        return (mjuiState_)super.position(position);
    }
    @Override public mjuiState_ getPointer(long i) {
        return new mjuiState_((Pointer)this).offsetAddress(i);
    }
               // mouse and keyboard state
  // constants set by user
  public native int nrect(); public native mjuiState_ nrect(int setter);                      // number of rectangles used
  public native @ByRef mjrRect rect(int i); public native mjuiState_ rect(int i, mjrRect setter);
  @MemberGetter public native mjrRect rect();      // rectangles (index 0: entire window)
  public native Pointer userdata(); public native mjuiState_ userdata(Pointer setter);                 // pointer to user data (for callbacks)

  // event type
  public native int type(); public native mjuiState_ type(int setter);                       // (type mjtEvent)

  // mouse buttons
  public native int left(); public native mjuiState_ left(int setter);                       // is left button down
  public native int right(); public native mjuiState_ right(int setter);                      // is right button down
  public native int middle(); public native mjuiState_ middle(int setter);                     // is middle button down
  public native int doubleclick(); public native mjuiState_ doubleclick(int setter);                // is last press a double click
  public native int button(); public native mjuiState_ button(int setter);                     // which button was pressed (mjtButton)
  public native double buttontime(); public native mjuiState_ buttontime(double setter);              // time of last button press

  // mouse position
  public native double x(); public native mjuiState_ x(double setter);                       // x position
  public native double y(); public native mjuiState_ y(double setter);                       // y position
  public native double dx(); public native mjuiState_ dx(double setter);                      // x displacement
  public native double dy(); public native mjuiState_ dy(double setter);                      // y displacement
  public native double sx(); public native mjuiState_ sx(double setter);                      // x scroll
  public native double sy(); public native mjuiState_ sy(double setter);                      // y scroll

  // keyboard
  public native int control(); public native mjuiState_ control(int setter);                    // is control down
  public native int shift(); public native mjuiState_ shift(int setter);                      // is shift down
  public native int alt(); public native mjuiState_ alt(int setter);                        // is alt down
  public native int key(); public native mjuiState_ key(int setter);                        // which key was pressed
  public native double keytime(); public native mjuiState_ keytime(double setter);                 // time of last key press

  // rectangle ownership and dragging
  public native int mouserect(); public native mjuiState_ mouserect(int setter);                  // which rectangle contains mouse
  public native int dragrect(); public native mjuiState_ dragrect(int setter);                   // which rectangle is dragged with mouse
  public native int dragbutton(); public native mjuiState_ dragbutton(int setter);                 // which button started drag (mjtButton)
}
@Opaque public static class mjuiState extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiState() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiState(Pointer p) { super(p); }
}


//---------------------------------- mjuiThemeSpacing ----------------------------------------------

public static class mjuiThemeSpacing_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiThemeSpacing_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiThemeSpacing_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiThemeSpacing_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiThemeSpacing_ position(long position) {
        return (mjuiThemeSpacing_)super.position(position);
    }
    @Override public mjuiThemeSpacing_ getPointer(long i) {
        return new mjuiThemeSpacing_((Pointer)this).offsetAddress(i);
    }
        // UI visualization theme spacing
  public native int total(); public native mjuiThemeSpacing_ total(int setter);                      // total width
  public native int scroll(); public native mjuiThemeSpacing_ scroll(int setter);                     // scrollbar width
  public native int label(); public native mjuiThemeSpacing_ label(int setter);                      // label width
  public native int section(); public native mjuiThemeSpacing_ section(int setter);                    // section gap
  public native int itemside(); public native mjuiThemeSpacing_ itemside(int setter);                   // item side gap
  public native int itemmid(); public native mjuiThemeSpacing_ itemmid(int setter);                    // item middle gap
  public native int itemver(); public native mjuiThemeSpacing_ itemver(int setter);                    // item vertical gap
  public native int texthor(); public native mjuiThemeSpacing_ texthor(int setter);                    // text horizontal gap
  public native int textver(); public native mjuiThemeSpacing_ textver(int setter);                    // text vertical gap
  public native int linescroll(); public native mjuiThemeSpacing_ linescroll(int setter);                 // number of pixels to scroll
  public native int samples(); public native mjuiThemeSpacing_ samples(int setter);                    // number of multisamples
}
@Opaque public static class mjuiThemeSpacing extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiThemeSpacing() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiThemeSpacing(Pointer p) { super(p); }
}


//---------------------------------- mjuiThemeColor ------------------------------------------------

public static class mjuiThemeColor_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiThemeColor_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiThemeColor_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiThemeColor_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiThemeColor_ position(long position) {
        return (mjuiThemeColor_)super.position(position);
    }
    @Override public mjuiThemeColor_ getPointer(long i) {
        return new mjuiThemeColor_((Pointer)this).offsetAddress(i);
    }
          // UI visualization theme color
  public native float master(int i); public native mjuiThemeColor_ master(int i, float setter);
  @MemberGetter public native FloatPointer master();                // master background
  public native float thumb(int i); public native mjuiThemeColor_ thumb(int i, float setter);
  @MemberGetter public native FloatPointer thumb();                 // scrollbar thumb
  public native float secttitle(int i); public native mjuiThemeColor_ secttitle(int i, float setter);
  @MemberGetter public native FloatPointer secttitle();             // section title
  public native float sectfont(int i); public native mjuiThemeColor_ sectfont(int i, float setter);
  @MemberGetter public native FloatPointer sectfont();              // section font
  public native float sectsymbol(int i); public native mjuiThemeColor_ sectsymbol(int i, float setter);
  @MemberGetter public native FloatPointer sectsymbol();            // section symbol
  public native float sectpane(int i); public native mjuiThemeColor_ sectpane(int i, float setter);
  @MemberGetter public native FloatPointer sectpane();              // section pane
  public native float shortcut(int i); public native mjuiThemeColor_ shortcut(int i, float setter);
  @MemberGetter public native FloatPointer shortcut();              // shortcut background
  public native float fontactive(int i); public native mjuiThemeColor_ fontactive(int i, float setter);
  @MemberGetter public native FloatPointer fontactive();            // font active
  public native float fontinactive(int i); public native mjuiThemeColor_ fontinactive(int i, float setter);
  @MemberGetter public native FloatPointer fontinactive();          // font inactive
  public native float decorinactive(int i); public native mjuiThemeColor_ decorinactive(int i, float setter);
  @MemberGetter public native FloatPointer decorinactive();         // decor inactive
  public native float decorinactive2(int i); public native mjuiThemeColor_ decorinactive2(int i, float setter);
  @MemberGetter public native FloatPointer decorinactive2();        // inactive slider color 2
  public native float button(int i); public native mjuiThemeColor_ button(int i, float setter);
  @MemberGetter public native FloatPointer button();                // button
  public native float check(int i); public native mjuiThemeColor_ check(int i, float setter);
  @MemberGetter public native FloatPointer check();                 // check
  public native float radio(int i); public native mjuiThemeColor_ radio(int i, float setter);
  @MemberGetter public native FloatPointer radio();                 // radio
  public native float select(int i); public native mjuiThemeColor_ select(int i, float setter);
  @MemberGetter public native FloatPointer select();                // select
  public native float select2(int i); public native mjuiThemeColor_ select2(int i, float setter);
  @MemberGetter public native FloatPointer select2();               // select pane
  public native float slider(int i); public native mjuiThemeColor_ slider(int i, float setter);
  @MemberGetter public native FloatPointer slider();                // slider
  public native float slider2(int i); public native mjuiThemeColor_ slider2(int i, float setter);
  @MemberGetter public native FloatPointer slider2();               // slider color 2
  public native float edit(int i); public native mjuiThemeColor_ edit(int i, float setter);
  @MemberGetter public native FloatPointer edit();                  // edit
  public native float edit2(int i); public native mjuiThemeColor_ edit2(int i, float setter);
  @MemberGetter public native FloatPointer edit2();                 // edit invalid
  public native float cursor(int i); public native mjuiThemeColor_ cursor(int i, float setter);
  @MemberGetter public native FloatPointer cursor();                // edit cursor
}
@Opaque public static class mjuiThemeColor extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiThemeColor() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiThemeColor(Pointer p) { super(p); }
}


//---------------------------------- mjuiItem ------------------------------------------------------

public static class mjuiItemSingle_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiItemSingle_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiItemSingle_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItemSingle_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiItemSingle_ position(long position) {
        return (mjuiItemSingle_)super.position(position);
    }
    @Override public mjuiItemSingle_ getPointer(long i) {
        return new mjuiItemSingle_((Pointer)this).offsetAddress(i);
    }
          // check and button-related
  public native int modifier(); public native mjuiItemSingle_ modifier(int setter);                   // 0: none, 1: control, 2: shift; 4: alt
  public native int shortcut(); public native mjuiItemSingle_ shortcut(int setter);                   // shortcut key; 0: undefined
}


public static class mjuiItemMulti_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiItemMulti_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiItemMulti_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItemMulti_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiItemMulti_ position(long position) {
        return (mjuiItemMulti_)super.position(position);
    }
    @Override public mjuiItemMulti_ getPointer(long i) {
        return new mjuiItemMulti_((Pointer)this).offsetAddress(i);
    }
           // static, radio and select-related
  public native int nelem(); public native mjuiItemMulti_ nelem(int setter);                      // number of elements in group
  public native @Cast("char") byte name(int i, int j); public native mjuiItemMulti_ name(int i, int j, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer name(); // element names
}


public static class mjuiItemSlider_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiItemSlider_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiItemSlider_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItemSlider_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiItemSlider_ position(long position) {
        return (mjuiItemSlider_)super.position(position);
    }
    @Override public mjuiItemSlider_ getPointer(long i) {
        return new mjuiItemSlider_((Pointer)this).offsetAddress(i);
    }
          // slider-related
  public native double range(int i); public native mjuiItemSlider_ range(int i, double setter);
  @MemberGetter public native DoublePointer range();                // slider range
  public native double divisions(); public native mjuiItemSlider_ divisions(double setter);               // number of range divisions
}


public static class mjuiItemEdit_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiItemEdit_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiItemEdit_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItemEdit_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiItemEdit_ position(long position) {
        return (mjuiItemEdit_)super.position(position);
    }
    @Override public mjuiItemEdit_ getPointer(long i) {
        return new mjuiItemEdit_((Pointer)this).offsetAddress(i);
    }
            // edit-related
  public native int nelem(); public native mjuiItemEdit_ nelem(int setter);                      // number of elements in list
  public native double range(int i, int j); public native mjuiItemEdit_ range(int i, int j, double setter);
  @MemberGetter public native @Cast("double(*)[2]") DoublePointer range();   // element range (min>=max: ignore)
}


public static class mjuiItem_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiItem_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiItem_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItem_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiItem_ position(long position) {
        return (mjuiItem_)super.position(position);
    }
    @Override public mjuiItem_ getPointer(long i) {
        return new mjuiItem_((Pointer)this).offsetAddress(i);
    }
                // UI item
  // common properties
  public native int type(); public native mjuiItem_ type(int setter);                       // type (mjtItem)
  public native @Cast("char") byte name(int i); public native mjuiItem_ name(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer name();         // name
  public native int state(); public native mjuiItem_ state(int setter);                      // 0: disable, 1: enable, 2+: use predicate
  public native Pointer pdata(); public native mjuiItem_ pdata(Pointer setter);                    // data pointer (type-specific)
  public native int sectionid(); public native mjuiItem_ sectionid(int setter);                  // id of section containing item
  public native int itemid(); public native mjuiItem_ itemid(int setter);                     // id of item within section

  // type-specific properties
    public native @ByRef mjuiItemSingle_ single(); public native mjuiItem_ single(mjuiItemSingle_ setter); // check and button
    public native @ByRef mjuiItemMulti_ multi(); public native mjuiItem_ multi(mjuiItemMulti_ setter);   // static, radio and select
    public native @ByRef mjuiItemSlider_ slider(); public native mjuiItem_ slider(mjuiItemSlider_ setter); // slider
    public native @ByRef mjuiItemEdit_ edit(); public native mjuiItem_ edit(mjuiItemEdit_ setter);     // edit

  // internal
  public native @ByRef mjrRect rect(); public native mjuiItem_ rect(mjrRect setter);                   // rectangle occupied by item
}
@Opaque public static class mjuiItem extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiItem() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiItem(Pointer p) { super(p); }
}


//---------------------------------- mjuiSection ---------------------------------------------------

public static class mjuiSection_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiSection_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiSection_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiSection_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiSection_ position(long position) {
        return (mjuiSection_)super.position(position);
    }
    @Override public mjuiSection_ getPointer(long i) {
        return new mjuiSection_((Pointer)this).offsetAddress(i);
    }
             // UI section
  // properties
  public native @Cast("char") byte name(int i); public native mjuiSection_ name(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer name();         // name
  public native int state(); public native mjuiSection_ state(int setter);                      // 0: closed, 1: open
  public native int modifier(); public native mjuiSection_ modifier(int setter);                   // 0: none, 1: control, 2: shift; 4: alt
  public native int shortcut(); public native mjuiSection_ shortcut(int setter);                   // shortcut key; 0: undefined
  public native int nitem(); public native mjuiSection_ nitem(int setter);                      // number of items in use
  public native @ByRef mjuiItem item(int i); public native mjuiSection_ item(int i, mjuiItem setter);
  @MemberGetter public native mjuiItem item();     // preallocated array of items

  // internal
  public native @ByRef mjrRect rtitle(); public native mjuiSection_ rtitle(mjrRect setter);                 // rectangle occupied by title
  public native @ByRef mjrRect rcontent(); public native mjuiSection_ rcontent(mjrRect setter);               // rectangle occupied by content
}
@Opaque public static class mjuiSection extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiSection() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiSection(Pointer p) { super(p); }
}


//---------------------------------- mjUI ----------------------------------------------------------

public static class mjUI_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjUI_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjUI_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjUI_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjUI_ position(long position) {
        return (mjUI_)super.position(position);
    }
    @Override public mjUI_ getPointer(long i) {
        return new mjUI_((Pointer)this).offsetAddress(i);
    }
                    // entire UI
  // constants set by user
  public native @ByRef mjuiThemeSpacing spacing(); public native mjUI_ spacing(mjuiThemeSpacing setter);       // UI theme spacing
  public native @ByRef mjuiThemeColor color(); public native mjUI_ color(mjuiThemeColor setter);           // UI theme color
  public native mjfItemEnable predicate(); public native mjUI_ predicate(mjfItemEnable setter);        // callback to set item state programmatically
  public native Pointer userdata(); public native mjUI_ userdata(Pointer setter);                 // pointer to user data (passed to predicate)
  public native int rectid(); public native mjUI_ rectid(int setter);                     // index of this ui rectangle in mjuiState
  public native int auxid(); public native mjUI_ auxid(int setter);                      // aux buffer index of this ui
  public native int radiocol(); public native mjUI_ radiocol(int setter);                   // number of radio columns (0 defaults to 2)

  // UI sizes (framebuffer units)
  public native int width(); public native mjUI_ width(int setter);                      // width
  public native int height(); public native mjUI_ height(int setter);                     // current heigth
  public native int maxheight(); public native mjUI_ maxheight(int setter);                  // height when all sections open
  public native int scroll(); public native mjUI_ scroll(int setter);                     // scroll from top of UI

  // mouse focus
  public native int mousesect(); public native mjUI_ mousesect(int setter);                  // 0: none, -1: scroll, otherwise 1+section
  public native int mouseitem(); public native mjUI_ mouseitem(int setter);                  // item within section
  public native int mousehelp(); public native mjUI_ mousehelp(int setter);                  // help button down: print shortcuts

  // keyboard focus and edit
  public native int editsect(); public native mjUI_ editsect(int setter);                   // 0: none, otherwise 1+section
  public native int edititem(); public native mjUI_ edititem(int setter);                   // item within section
  public native int editcursor(); public native mjUI_ editcursor(int setter);                 // cursor position
  public native int editscroll(); public native mjUI_ editscroll(int setter);                 // horizontal scroll
  public native @Cast("char") byte edittext(int i); public native mjUI_ edittext(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer edittext();     // current text
  public native mjuiItem editchanged(); public native mjUI_ editchanged(mjuiItem setter);          // pointer to changed edit in last mjui_event

  // sections
  public native int nsect(); public native mjUI_ nsect(int setter);                      // number of sections in use
  public native @ByRef mjuiSection sect(int i); public native mjUI_ sect(int i, mjuiSection setter);
  @MemberGetter public native mjuiSection sect();  // preallocated array of sections
}
@Opaque public static class mjUI extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjUI() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjUI(Pointer p) { super(p); }
}


//---------------------------------- mjuiDef -------------------------------------------------------

public static class mjuiDef_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjuiDef_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjuiDef_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiDef_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjuiDef_ position(long position) {
        return (mjuiDef_)super.position(position);
    }
    @Override public mjuiDef_ getPointer(long i) {
        return new mjuiDef_((Pointer)this).offsetAddress(i);
    }
                 // table passed to mjui_add()
  public native int type(); public native mjuiDef_ type(int setter);                       // type (mjtItem); -1: section
  public native @Cast("char") byte name(int i); public native mjuiDef_ name(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer name();         // name
  public native int state(); public native mjuiDef_ state(int setter);                      // state
  public native Pointer pdata(); public native mjuiDef_ pdata(Pointer setter);                    // pointer to data
  public native @Cast("char") byte other(int i); public native mjuiDef_ other(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer other();        // string with type-specific properties
}
@Opaque public static class mjuiDef extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjuiDef() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjuiDef(Pointer p) { super(p); }
}

// #endif  // MUJOCO_MJUI_H_


// Parsed from mujoco/mjvisualize.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MJVISUALIZE_H_
// #define MUJOCO_MJVISUALIZE_H_

// #include <mujoco/mjtnum.h>
// #include <mujoco/mjmodel.h>

public static final int mjNGROUP =        6;         // number of geom, site, joint groups with visflags
public static final int mjMAXLIGHT =      100;       // maximum number of lights in a scene
public static final int mjMAXOVERLAY =    500;       // maximum number of characters in overlay text
public static final int mjMAXLINE =       100;       // maximum number of lines per plot
public static final int mjMAXLINEPNT =    1000;      // maximum number points per line
public static final int mjMAXPLANEGRID =  200;       // maximum number of grid divisions for plane


//---------------------------------- primitive types (mjt) -----------------------------------------

/** enum mjtCatBit */
public static final int         // bitflags for mjvGeom category
  mjCAT_STATIC        = 1,        // model elements in body 0
  mjCAT_DYNAMIC       = 2,        // model elements in all other bodies
  mjCAT_DECOR         = 4,        // decorative geoms
  mjCAT_ALL           = 7;         // select all categories


/** enum mjtMouse */
public static final int          // mouse interaction mode
  mjMOUSE_NONE        = 0,        // no action
  mjMOUSE_ROTATE_V = 1,               // rotate, vertical plane
  mjMOUSE_ROTATE_H = 2,               // rotate, horizontal plane
  mjMOUSE_MOVE_V = 3,                 // move, vertical plane
  mjMOUSE_MOVE_H = 4,                 // move, horizontal plane
  mjMOUSE_ZOOM = 5,                   // zoom
  mjMOUSE_SELECT = 6;                  // selection


/** enum mjtPertBit */
public static final int        // mouse perturbations
  mjPERT_TRANSLATE    = 1,        // translation
  mjPERT_ROTATE       = 2;         // rotation


/** enum mjtCamera */
public static final int         // abstract camera type
  mjCAMERA_FREE       = 0,        // free camera
  mjCAMERA_TRACKING = 1,              // tracking camera; uses trackbodyid
  mjCAMERA_FIXED = 2,                 // fixed camera; uses fixedcamid
  mjCAMERA_USER = 3;                   // user is responsible for setting OpenGL camera


/** enum mjtLabel */
public static final int          // object labeling
  mjLABEL_NONE        = 0,        // nothing
  mjLABEL_BODY = 1,                   // body labels
  mjLABEL_JOINT = 2,                  // joint labels
  mjLABEL_GEOM = 3,                   // geom labels
  mjLABEL_SITE = 4,                   // site labels
  mjLABEL_CAMERA = 5,                 // camera labels
  mjLABEL_LIGHT = 6,                  // light labels
  mjLABEL_TENDON = 7,                 // tendon labels
  mjLABEL_ACTUATOR = 8,               // actuator labels
  mjLABEL_CONSTRAINT = 9,             // constraint labels
  mjLABEL_SKIN = 10,                   // skin labels
  mjLABEL_SELECTION = 11,              // selected object
  mjLABEL_SELPNT = 12,                 // coordinates of selection point
  mjLABEL_CONTACTFORCE = 13,           // magnitude of contact force

  mjNLABEL = 14;                        // number of label types


/** enum mjtFrame */
public static final int          // frame visualization
  mjFRAME_NONE        = 0,        // no frames
  mjFRAME_BODY = 1,                   // body frames
  mjFRAME_GEOM = 2,                   // geom frames
  mjFRAME_SITE = 3,                   // site frames
  mjFRAME_CAMERA = 4,                 // camera frames
  mjFRAME_LIGHT = 5,                  // light frames
  mjFRAME_CONTACT = 6,                // contact frames
  mjFRAME_WORLD = 7,                  // world frame

  mjNFRAME = 8;                        // number of visualization frames


/** enum mjtVisFlag */
public static final int        // flags enabling model element visualization
  mjVIS_CONVEXHULL    = 0,        // mesh convex hull
  mjVIS_TEXTURE = 1,                  // textures
  mjVIS_JOINT = 2,                    // joints
  mjVIS_ACTUATOR = 3,                 // actuators
  mjVIS_CAMERA = 4,                   // cameras
  mjVIS_LIGHT = 5,                    // lights
  mjVIS_TENDON = 6,                   // tendons
  mjVIS_RANGEFINDER = 7,              // rangefinder sensors
  mjVIS_CONSTRAINT = 8,               // point constraints
  mjVIS_INERTIA = 9,                  // equivalent inertia boxes
  mjVIS_SCLINERTIA = 10,               // scale equivalent inertia boxes with mass
  mjVIS_PERTFORCE = 11,                // perturbation force
  mjVIS_PERTOBJ = 12,                  // perturbation object
  mjVIS_CONTACTPOINT = 13,             // contact points
  mjVIS_CONTACTFORCE = 14,             // contact force
  mjVIS_CONTACTSPLIT = 15,             // split contact force into normal and tanget
  mjVIS_TRANSPARENT = 16,              // make dynamic geoms more transparent
  mjVIS_AUTOCONNECT = 17,              // auto connect joints and body coms
  mjVIS_COM = 18,                      // center of mass
  mjVIS_SELECT = 19,                   // selection point
  mjVIS_STATIC = 20,                   // static bodies
  mjVIS_SKIN = 21,                     // skin

  mjNVISFLAG = 22;                      // number of visualization flags


/** enum mjtRndFlag */
public static final int        // flags enabling rendering effects
  mjRND_SHADOW        = 0,        // shadows
  mjRND_WIREFRAME = 1,                // wireframe
  mjRND_REFLECTION = 2,               // reflections
  mjRND_ADDITIVE = 3,                 // additive transparency
  mjRND_SKYBOX = 4,                   // skybox
  mjRND_FOG = 5,                      // fog
  mjRND_HAZE = 6,                     // haze
  mjRND_SEGMENT = 7,                  // segmentation with random color
  mjRND_IDCOLOR = 8,                  // segmentation with segid color

  mjNRNDFLAG = 9;                      // number of rendering flags


/** enum mjtStereo */
public static final int         // type of stereo rendering
  mjSTEREO_NONE       = 0,        // no stereo; use left eye only
  mjSTEREO_QUADBUFFERED = 1,          // quad buffered; revert to side-by-side if no hardware support
  mjSTEREO_SIDEBYSIDE = 2;             // side-by-side


//---------------------------------- mjvPerturb ----------------------------------------------------

public static class mjvPerturb_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvPerturb_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvPerturb_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvPerturb_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvPerturb_ position(long position) {
        return (mjvPerturb_)super.position(position);
    }
    @Override public mjvPerturb_ getPointer(long i) {
        return new mjvPerturb_((Pointer)this).offsetAddress(i);
    }
              // object selection and perturbation
  public native int select(); public native mjvPerturb_ select(int setter);                // selected body id; non-positive: none
  public native int skinselect(); public native mjvPerturb_ skinselect(int setter);            // selected skin id; negative: none
  public native int active(); public native mjvPerturb_ active(int setter);                // perturbation bitmask (mjtPertBit)
  public native int active2(); public native mjvPerturb_ active2(int setter);               // secondary perturbation bitmask (mjtPertBit)
  public native @Cast("mjtNum") double refpos(int i); public native mjvPerturb_ refpos(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer refpos();             // desired position for selected object
  public native @Cast("mjtNum") double refquat(int i); public native mjvPerturb_ refquat(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer refquat();            // desired orientation for selected object
  public native @Cast("mjtNum") double localpos(int i); public native mjvPerturb_ localpos(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer localpos();           // selection point in object coordinates
  public native @Cast("mjtNum") double scale(); public native mjvPerturb_ scale(double setter);                 // relative mouse motion-to-space scaling (set by initPerturb)
}
@Opaque public static class mjvPerturb extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvPerturb() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvPerturb(Pointer p) { super(p); }
}


//---------------------------------- mjvCamera -----------------------------------------------------

public static class mjvCamera_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvCamera_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvCamera_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvCamera_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvCamera_ position(long position) {
        return (mjvCamera_)super.position(position);
    }
    @Override public mjvCamera_ getPointer(long i) {
        return new mjvCamera_((Pointer)this).offsetAddress(i);
    }
               // abstract camera
  // type and ids
  public native int type(); public native mjvCamera_ type(int setter);                  // camera type (mjtCamera)
  public native int fixedcamid(); public native mjvCamera_ fixedcamid(int setter);            // fixed camera id
  public native int trackbodyid(); public native mjvCamera_ trackbodyid(int setter);           // body id to track

  // abstract camera pose specification
  public native @Cast("mjtNum") double lookat(int i); public native mjvCamera_ lookat(int i, double setter);
  @MemberGetter public native @Cast("mjtNum*") DoublePointer lookat();             // lookat point
  public native @Cast("mjtNum") double distance(); public native mjvCamera_ distance(double setter);              // distance to lookat point or tracked body
  public native @Cast("mjtNum") double azimuth(); public native mjvCamera_ azimuth(double setter);               // camera azimuth (deg)
  public native @Cast("mjtNum") double elevation(); public native mjvCamera_ elevation(double setter);             // camera elevation (deg)
}
@Opaque public static class mjvCamera extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvCamera() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvCamera(Pointer p) { super(p); }
}


//---------------------------------- mjvGLCamera ---------------------------------------------------

public static class mjvGLCamera_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvGLCamera_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvGLCamera_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvGLCamera_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvGLCamera_ position(long position) {
        return (mjvGLCamera_)super.position(position);
    }
    @Override public mjvGLCamera_ getPointer(long i) {
        return new mjvGLCamera_((Pointer)this).offsetAddress(i);
    }
             // OpenGL camera
  // camera frame
  public native float pos(int i); public native mjvGLCamera_ pos(int i, float setter);
  @MemberGetter public native FloatPointer pos();                // position
  public native float forward(int i); public native mjvGLCamera_ forward(int i, float setter);
  @MemberGetter public native FloatPointer forward();            // forward direction
  public native float up(int i); public native mjvGLCamera_ up(int i, float setter);
  @MemberGetter public native FloatPointer up();                 // up direction

  // camera projection
  public native float frustum_center(); public native mjvGLCamera_ frustum_center(float setter);        // hor. center (left,right set to match aspect)
  public native float frustum_bottom(); public native mjvGLCamera_ frustum_bottom(float setter);        // bottom
  public native float frustum_top(); public native mjvGLCamera_ frustum_top(float setter);           // top
  public native float frustum_near(); public native mjvGLCamera_ frustum_near(float setter);          // near
  public native float frustum_far(); public native mjvGLCamera_ frustum_far(float setter);           // far
}
@Opaque public static class mjvGLCamera extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvGLCamera() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvGLCamera(Pointer p) { super(p); }
}


//---------------------------------- mjvGeom -------------------------------------------------------

public static class mjvGeom_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvGeom_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvGeom_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvGeom_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvGeom_ position(long position) {
        return (mjvGeom_)super.position(position);
    }
    @Override public mjvGeom_ getPointer(long i) {
        return new mjvGeom_((Pointer)this).offsetAddress(i);
    }
                 // abstract geom
  // type info
  public native int type(); public native mjvGeom_ type(int setter);                  // geom type (mjtGeom)
  public native int dataid(); public native mjvGeom_ dataid(int setter);                // mesh, hfield or plane id; -1: none
  public native int objtype(); public native mjvGeom_ objtype(int setter);               // mujoco object type; mjOBJ_UNKNOWN for decor
  public native int objid(); public native mjvGeom_ objid(int setter);                 // mujoco object id; -1 for decor
  public native int category(); public native mjvGeom_ category(int setter);              // visual category
  public native int texid(); public native mjvGeom_ texid(int setter);                 // texture id; -1: no texture
  public native int texuniform(); public native mjvGeom_ texuniform(int setter);            // uniform cube mapping
  public native int texcoord(); public native mjvGeom_ texcoord(int setter);              // mesh geom has texture coordinates
  public native int segid(); public native mjvGeom_ segid(int setter);                 // segmentation id; -1: not shown

  // OpenGL info
  public native float texrepeat(int i); public native mjvGeom_ texrepeat(int i, float setter);
  @MemberGetter public native FloatPointer texrepeat();          // texture repetition for 2D mapping
  public native float size(int i); public native mjvGeom_ size(int i, float setter);
  @MemberGetter public native FloatPointer size();               // size parameters
  public native float pos(int i); public native mjvGeom_ pos(int i, float setter);
  @MemberGetter public native FloatPointer pos();                // Cartesian position
  public native float mat(int i); public native mjvGeom_ mat(int i, float setter);
  @MemberGetter public native FloatPointer mat();                // Cartesian orientation
  public native float rgba(int i); public native mjvGeom_ rgba(int i, float setter);
  @MemberGetter public native FloatPointer rgba();               // color and transparency
  public native float emission(); public native mjvGeom_ emission(float setter);              // emission coef
  public native float specular(); public native mjvGeom_ specular(float setter);              // specular coef
  public native float shininess(); public native mjvGeom_ shininess(float setter);             // shininess coef
  public native float reflectance(); public native mjvGeom_ reflectance(float setter);           // reflectance coef
  public native @Cast("char") byte label(int i); public native mjvGeom_ label(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer label();            // text label

  // transparency rendering (set internally)
  public native float camdist(); public native mjvGeom_ camdist(float setter);               // distance to camera (used by sorter)
  public native float modelrbound(); public native mjvGeom_ modelrbound(float setter);           // geom rbound from model, 0 if not model geom
  public native @Cast("mjtByte") byte transparent(); public native mjvGeom_ transparent(byte setter);           // treat geom as transparent
}
@Opaque public static class mjvGeom extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvGeom() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvGeom(Pointer p) { super(p); }
}


//---------------------------------- mjvLight ------------------------------------------------------

public static class mjvLight_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvLight_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvLight_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvLight_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvLight_ position(long position) {
        return (mjvLight_)super.position(position);
    }
    @Override public mjvLight_ getPointer(long i) {
        return new mjvLight_((Pointer)this).offsetAddress(i);
    }
                // OpenGL light
  public native float pos(int i); public native mjvLight_ pos(int i, float setter);
  @MemberGetter public native FloatPointer pos();                // position rel. to body frame
  public native float dir(int i); public native mjvLight_ dir(int i, float setter);
  @MemberGetter public native FloatPointer dir();                // direction rel. to body frame
  public native float attenuation(int i); public native mjvLight_ attenuation(int i, float setter);
  @MemberGetter public native FloatPointer attenuation();        // OpenGL attenuation (quadratic model)
  public native float cutoff(); public native mjvLight_ cutoff(float setter);                // OpenGL cutoff
  public native float exponent(); public native mjvLight_ exponent(float setter);              // OpenGL exponent
  public native float ambient(int i); public native mjvLight_ ambient(int i, float setter);
  @MemberGetter public native FloatPointer ambient();            // ambient rgb (alpha=1)
  public native float diffuse(int i); public native mjvLight_ diffuse(int i, float setter);
  @MemberGetter public native FloatPointer diffuse();            // diffuse rgb (alpha=1)
  public native float specular(int i); public native mjvLight_ specular(int i, float setter);
  @MemberGetter public native FloatPointer specular();           // specular rgb (alpha=1)
  public native @Cast("mjtByte") byte headlight(); public native mjvLight_ headlight(byte setter);             // headlight
  public native @Cast("mjtByte") byte directional(); public native mjvLight_ directional(byte setter);           // directional light
  public native @Cast("mjtByte") byte castshadow(); public native mjvLight_ castshadow(byte setter);            // does light cast shadows
}
@Opaque public static class mjvLight extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvLight() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvLight(Pointer p) { super(p); }
}


//---------------------------------- mjvOption -----------------------------------------------------

public static class mjvOption_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvOption_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvOption_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvOption_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvOption_ position(long position) {
        return (mjvOption_)super.position(position);
    }
    @Override public mjvOption_ getPointer(long i) {
        return new mjvOption_((Pointer)this).offsetAddress(i);
    }
               // abstract visualization options
  public native int label(); public native mjvOption_ label(int setter);                 // what objects to label (mjtLabel)
  public native int frame(); public native mjvOption_ frame(int setter);                 // which frame to show (mjtFrame)
  public native @Cast("mjtByte") byte geomgroup(int i); public native mjvOption_ geomgroup(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer geomgroup();   // geom visualization by group
  public native @Cast("mjtByte") byte sitegroup(int i); public native mjvOption_ sitegroup(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer sitegroup();   // site visualization by group
  public native @Cast("mjtByte") byte jointgroup(int i); public native mjvOption_ jointgroup(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer jointgroup();  // joint visualization by group
  public native @Cast("mjtByte") byte tendongroup(int i); public native mjvOption_ tendongroup(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer tendongroup(); // tendon visualization by group
  public native @Cast("mjtByte") byte actuatorgroup(int i); public native mjvOption_ actuatorgroup(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer actuatorgroup();  // actuator visualization by group
  public native @Cast("mjtByte") byte flags(int i); public native mjvOption_ flags(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer flags();     // visualization flags (indexed by mjtVisFlag)
}
@Opaque public static class mjvOption extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvOption() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvOption(Pointer p) { super(p); }
}


//---------------------------------- mjvScene ------------------------------------------------------

public static class mjvScene_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvScene_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvScene_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvScene_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvScene_ position(long position) {
        return (mjvScene_)super.position(position);
    }
    @Override public mjvScene_ getPointer(long i) {
        return new mjvScene_((Pointer)this).offsetAddress(i);
    }
                // abstract scene passed to OpenGL renderer
  // abstract geoms
  public native int maxgeom(); public native mjvScene_ maxgeom(int setter);               // size of allocated geom buffer
  public native int ngeom(); public native mjvScene_ ngeom(int setter);                 // number of geoms currently in buffer
  public native mjvGeom geoms(); public native mjvScene_ geoms(mjvGeom setter);                 // buffer for geoms
  public native IntPointer geomorder(); public native mjvScene_ geomorder(IntPointer setter);             // buffer for ordering geoms by distance to camera

  // skin data
  public native int nskin(); public native mjvScene_ nskin(int setter);                 // number of skins
  public native IntPointer skinfacenum(); public native mjvScene_ skinfacenum(IntPointer setter);           // number of faces in skin
  public native IntPointer skinvertadr(); public native mjvScene_ skinvertadr(IntPointer setter);           // address of skin vertices
  public native IntPointer skinvertnum(); public native mjvScene_ skinvertnum(IntPointer setter);           // number of vertices in skin
  public native FloatPointer skinvert(); public native mjvScene_ skinvert(FloatPointer setter);              // skin vertex data
  public native FloatPointer skinnormal(); public native mjvScene_ skinnormal(FloatPointer setter);            // skin normal data

  // OpenGL lights
  public native int nlight(); public native mjvScene_ nlight(int setter);                // number of lights currently in buffer
  public native @ByRef mjvLight lights(int i); public native mjvScene_ lights(int i, mjvLight setter);
  @MemberGetter public native mjvLight lights();    // buffer for lights

  // OpenGL cameras
  public native @ByRef mjvGLCamera camera(int i); public native mjvScene_ camera(int i, mjvGLCamera setter);
  @MemberGetter public native mjvGLCamera camera();          // left and right camera

  // OpenGL model transformation
  public native @Cast("mjtByte") byte enabletransform(); public native mjvScene_ enabletransform(byte setter);       // enable model transformation
  public native float translate(int i); public native mjvScene_ translate(int i, float setter);
  @MemberGetter public native FloatPointer translate();          // model translation
  public native float rotate(int i); public native mjvScene_ rotate(int i, float setter);
  @MemberGetter public native FloatPointer rotate();             // model quaternion rotation
  public native float scale(); public native mjvScene_ scale(float setter);                 // model scaling

  // OpenGL rendering effects
  public native int stereo(); public native mjvScene_ stereo(int setter);                // stereoscopic rendering (mjtStereo)
  public native @Cast("mjtByte") byte flags(int i); public native mjvScene_ flags(int i, byte setter);
  @MemberGetter public native @Cast("mjtByte*") BytePointer flags();     // rendering flags (indexed by mjtRndFlag)

  // framing
  public native int framewidth(); public native mjvScene_ framewidth(int setter);            // frame pixel width; 0: disable framing
  public native float framergb(int i); public native mjvScene_ framergb(int i, float setter);
  @MemberGetter public native FloatPointer framergb();           // frame color
}
@Opaque public static class mjvScene extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvScene() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvScene(Pointer p) { super(p); }
}


//---------------------------------- mjvFigure -----------------------------------------------------

public static class mjvFigure_ extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public mjvFigure_() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public mjvFigure_(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvFigure_(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public mjvFigure_ position(long position) {
        return (mjvFigure_)super.position(position);
    }
    @Override public mjvFigure_ getPointer(long i) {
        return new mjvFigure_((Pointer)this).offsetAddress(i);
    }
               // abstract 2D figure passed to OpenGL renderer
  // enable flags
  public native int flg_legend(); public native mjvFigure_ flg_legend(int setter);             // show legend
  public native int flg_ticklabel(int i); public native mjvFigure_ flg_ticklabel(int i, int setter);
  @MemberGetter public native IntPointer flg_ticklabel();       // show grid tick labels (x,y)
  public native int flg_extend(); public native mjvFigure_ flg_extend(int setter);             // automatically extend axis ranges to fit data
  public native int flg_barplot(); public native mjvFigure_ flg_barplot(int setter);            // isolated line segments (i.e. GL_LINES)
  public native int flg_selection(); public native mjvFigure_ flg_selection(int setter);          // vertical selection line
  public native int flg_symmetric(); public native mjvFigure_ flg_symmetric(int setter);          // symmetric y-axis

  // style settings
  public native float linewidth(); public native mjvFigure_ linewidth(float setter);              // line width
  public native float gridwidth(); public native mjvFigure_ gridwidth(float setter);              // grid line width
  public native int gridsize(int i); public native mjvFigure_ gridsize(int i, int setter);
  @MemberGetter public native IntPointer gridsize();            // number of grid points in (x,y)
  public native float gridrgb(int i); public native mjvFigure_ gridrgb(int i, float setter);
  @MemberGetter public native FloatPointer gridrgb();             // grid line rgb
  public native float figurergba(int i); public native mjvFigure_ figurergba(int i, float setter);
  @MemberGetter public native FloatPointer figurergba();          // figure color and alpha
  public native float panergba(int i); public native mjvFigure_ panergba(int i, float setter);
  @MemberGetter public native FloatPointer panergba();            // pane color and alpha
  public native float legendrgba(int i); public native mjvFigure_ legendrgba(int i, float setter);
  @MemberGetter public native FloatPointer legendrgba();          // legend color and alpha
  public native float textrgb(int i); public native mjvFigure_ textrgb(int i, float setter);
  @MemberGetter public native FloatPointer textrgb();             // text color
  public native float linergb(int i, int j); public native mjvFigure_ linergb(int i, int j, float setter);
  @MemberGetter public native @Cast("float(*)[3]") FloatPointer linergb();  // line colors
  public native float range(int i, int j); public native mjvFigure_ range(int i, int j, float setter);
  @MemberGetter public native @Cast("float(* /*[2]*/ )[2]") FloatPointer range();            // axis ranges; (min>=max) automatic
  public native @Cast("char") byte xformat(int i); public native mjvFigure_ xformat(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer xformat();            // x-tick label format for sprintf
  public native @Cast("char") byte yformat(int i); public native mjvFigure_ yformat(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer yformat();            // y-tick label format for sprintf
  public native @Cast("char") byte minwidth(int i); public native mjvFigure_ minwidth(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer minwidth();           // string used to determine min y-tick width

  // text labels
  public native @Cast("char") byte title(int i); public native mjvFigure_ title(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer title();            // figure title; subplots separated with 2+ spaces
  public native @Cast("char") byte xlabel(int i); public native mjvFigure_ xlabel(int i, byte setter);
  @MemberGetter public native @Cast("char*") BytePointer xlabel();            // x-axis label
  public native @Cast("char") byte linename(int i, int j); public native mjvFigure_ linename(int i, int j, byte setter);
  @MemberGetter public native @Cast("char(*)[100]") BytePointer linename(); // line names for legend

  // dynamic settings
  public native int legendoffset(); public native mjvFigure_ legendoffset(int setter);           // number of lines to offset legend
  public native int subplot(); public native mjvFigure_ subplot(int setter);                // selected subplot (for title rendering)
  public native int highlight(int i); public native mjvFigure_ highlight(int i, int setter);
  @MemberGetter public native IntPointer highlight();           // if point is in legend rect, highlight line
  public native int highlightid(); public native mjvFigure_ highlightid(int setter);            // if id>=0 and no point, highlight id
  public native float selection(); public native mjvFigure_ selection(float setter);              // selection line x-value

  // line data
  public native int linepnt(int i); public native mjvFigure_ linepnt(int i, int setter);
  @MemberGetter public native IntPointer linepnt();     // number of points in line; (0) disable
  public native float linedata(int i, int j); public native mjvFigure_ linedata(int i, int j, float setter);
  @MemberGetter public native @Cast("float(*)[2]") FloatPointer linedata(); // line data (x,y)

  // output from renderer
  public native int xaxispixel(int i); public native mjvFigure_ xaxispixel(int i, int setter);
  @MemberGetter public native IntPointer xaxispixel();          // range of x-axis in pixels
  public native int yaxispixel(int i); public native mjvFigure_ yaxispixel(int i, int setter);
  @MemberGetter public native IntPointer yaxispixel();          // range of y-axis in pixels
  public native float xaxisdata(int i); public native mjvFigure_ xaxisdata(int i, float setter);
  @MemberGetter public native FloatPointer xaxisdata();           // range of x-axis in data units
  public native float yaxisdata(int i); public native mjvFigure_ yaxisdata(int i, float setter);
  @MemberGetter public native FloatPointer yaxisdata();           // range of y-axis in data units
}
@Opaque public static class mjvFigure extends Pointer {
    /** Empty constructor. Calls {@code super((Pointer)null)}. */
    public mjvFigure() { super((Pointer)null); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public mjvFigure(Pointer p) { super(p); }
}

// #endif  // MUJOCO_MJVISUALIZE_H_


// Parsed from mujoco/mujoco.h

// Copyright 2021 DeepMind Technologies Limited
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// #ifndef MUJOCO_MUJOCO_H_
// #define MUJOCO_MUJOCO_H_

// #include <mujoco/mjexport.h>


// this is a C-API
// #if defined(__cplusplus)
// #endif

// header version; should match the library version as returned by mj_version()
public static final int mjVERSION_HEADER = 220;

// needed to define size_t, fabs and log10
// #include "stdlib.h"
// #include "math.h"


// type definitions
// #include <mujoco/mjdata.h>
// #include <mujoco/mjmodel.h>
// #include <mujoco/mjrender.h>
// #include <mujoco/mjtnum.h>
// #include <mujoco/mjui.h>
// #include <mujoco/mjvisualize.h>


// macros
// #define mjMARKSTACK   int _mark = d->pstack;
// #define mjFREESTACK   d->pstack = _mark;
// #define mjDISABLED(x) (m->opt.disableflags & (x))
// #define mjENABLED(x)  (m->opt.enableflags & (x))


// user error and memory handlers
public static class Mju_user_error_BytePointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    Mju_user_error_BytePointer(Pointer p) { super(p); }
    protected Mju_user_error_BytePointer() { allocate(); }
    private native void allocate();
    public native void call(@Cast("const char*") BytePointer arg0);
}
public static native Mju_user_error_BytePointer mju_user_error(); public static native void mju_user_error(Mju_user_error_BytePointer setter);
public static class Mju_user_warning_BytePointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    Mju_user_warning_BytePointer(Pointer p) { super(p); }
    protected Mju_user_warning_BytePointer() { allocate(); }
    private native void allocate();
    public native void call(@Cast("const char*") BytePointer arg0);
}
public static native Mju_user_warning_BytePointer mju_user_warning(); public static native void mju_user_warning(Mju_user_warning_BytePointer setter);
public static class Mju_user_malloc_long extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    Mju_user_malloc_long(Pointer p) { super(p); }
    protected Mju_user_malloc_long() { allocate(); }
    private native void allocate();
    public native Pointer call(@Cast("size_t") long arg0);
}
public static native Mju_user_malloc_long mju_user_malloc(); public static native void mju_user_malloc(Mju_user_malloc_long setter);
public static class Mju_user_free_Pointer extends FunctionPointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public    Mju_user_free_Pointer(Pointer p) { super(p); }
    protected Mju_user_free_Pointer() { allocate(); }
    private native void allocate();
    public native void call(Pointer arg0);
}
public static native Mju_user_free_Pointer mju_user_free(); public static native void mju_user_free(Mju_user_free_Pointer setter);


// callbacks extending computation pipeline
public static native mjfGeneric mjcb_passive(); public static native void mjcb_passive(mjfGeneric setter);
public static native mjfGeneric mjcb_control(); public static native void mjcb_control(mjfGeneric setter);
public static native mjfConFilt mjcb_contactfilter(); public static native void mjcb_contactfilter(mjfConFilt setter);
public static native mjfSensor mjcb_sensor(); public static native void mjcb_sensor(mjfSensor setter);
public static native mjfTime mjcb_time(); public static native void mjcb_time(mjfTime setter);
public static native mjfAct mjcb_act_dyn(); public static native void mjcb_act_dyn(mjfAct setter);
public static native mjfAct mjcb_act_gain(); public static native void mjcb_act_gain(mjfAct setter);
public static native mjfAct mjcb_act_bias(); public static native void mjcb_act_bias(mjfAct setter);


// collision function table



// string names
public static native @Cast("const char*") BytePointer mjDISABLESTRING(int i); public static native void mjDISABLESTRING(int i, BytePointer setter);
@MemberGetter public static native @Cast("const char**") PointerPointer mjDISABLESTRING();
public static native @Cast("const char*") BytePointer mjENABLESTRING(int i); public static native void mjENABLESTRING(int i, BytePointer setter);
@MemberGetter public static native @Cast("const char**") PointerPointer mjENABLESTRING();
public static native @Cast("const char*") BytePointer mjTIMERSTRING(int i); public static native void mjTIMERSTRING(int i, BytePointer setter);
@MemberGetter public static native @Cast("const char**") PointerPointer mjTIMERSTRING();
public static native @Cast("const char*") BytePointer mjLABELSTRING(int i); public static native void mjLABELSTRING(int i, BytePointer setter);
@MemberGetter public static native @Cast("const char**") PointerPointer mjLABELSTRING();
public static native @Cast("const char*") BytePointer mjFRAMESTRING(int i); public static native void mjFRAMESTRING(int i, BytePointer setter);
@MemberGetter public static native @Cast("const char**") PointerPointer mjFRAMESTRING();
public static native @Cast("const char*") BytePointer mjVISSTRING(int i, int j); public static native void mjVISSTRING(int i, int j, BytePointer setter);
@MemberGetter public static native @Cast("const char*(*)[3]") PointerPointer mjVISSTRING();
public static native @Cast("const char*") BytePointer mjRNDSTRING(int i, int j); public static native void mjRNDSTRING(int i, int j, BytePointer setter);
@MemberGetter public static native @Cast("const char*(*)[3]") PointerPointer mjRNDSTRING();


//---------------------------------- Virtual file system -------------------------------------------

// Initialize VFS to empty (no deallocation).
public static native void mj_defaultVFS(mjVFS vfs);

// Add file to VFS, return 0: success, 1: full, 2: repeated name, -1: failed to load.
public static native int mj_addFileVFS(mjVFS vfs, @Cast("const char*") BytePointer directory, @Cast("const char*") BytePointer filename);
public static native int mj_addFileVFS(mjVFS vfs, String directory, String filename);

// Make empty file in VFS, return 0: success, 1: full, 2: repeated name.
public static native int mj_makeEmptyFileVFS(mjVFS vfs, @Cast("const char*") BytePointer filename, int filesize);
public static native int mj_makeEmptyFileVFS(mjVFS vfs, String filename, int filesize);

// Return file index in VFS, or -1 if not found in VFS.
public static native int mj_findFileVFS(@Const mjVFS vfs, @Cast("const char*") BytePointer filename);
public static native int mj_findFileVFS(@Const mjVFS vfs, String filename);

// Delete file from VFS, return 0: success, -1: not found in VFS.
public static native int mj_deleteFileVFS(mjVFS vfs, @Cast("const char*") BytePointer filename);
public static native int mj_deleteFileVFS(mjVFS vfs, String filename);

// Delete all files from VFS.
public static native void mj_deleteVFS(mjVFS vfs);


//---------------------------------- Parse and compile ---------------------------------------------

// Parse XML file in MJCF or URDF format, compile it, return low-level model.
// If vfs is not NULL, look up files in vfs before reading from disk.
// If error is not NULL, it must have size error_sz.
public static native mjModel mj_loadXML(@Cast("const char*") BytePointer filename, @Const mjVFS vfs,
                          @Cast("char*") BytePointer error, int error_sz);
public static native mjModel mj_loadXML(String filename, @Const mjVFS vfs,
                          @Cast("char*") ByteBuffer error, int error_sz);
public static native mjModel mj_loadXML(@Cast("const char*") BytePointer filename, @Const mjVFS vfs,
                          @Cast("char*") byte[] error, int error_sz);
public static native mjModel mj_loadXML(String filename, @Const mjVFS vfs,
                          @Cast("char*") BytePointer error, int error_sz);
public static native mjModel mj_loadXML(@Cast("const char*") BytePointer filename, @Const mjVFS vfs,
                          @Cast("char*") ByteBuffer error, int error_sz);
public static native mjModel mj_loadXML(String filename, @Const mjVFS vfs,
                          @Cast("char*") byte[] error, int error_sz);

// Update XML data structures with info from low-level model, save as MJCF.
// If error is not NULL, it must have size error_sz.
public static native int mj_saveLastXML(@Cast("const char*") BytePointer filename, @Const mjModel m,
                         @Cast("char*") BytePointer error, int error_sz);
public static native int mj_saveLastXML(String filename, @Const mjModel m,
                         @Cast("char*") ByteBuffer error, int error_sz);
public static native int mj_saveLastXML(@Cast("const char*") BytePointer filename, @Const mjModel m,
                         @Cast("char*") byte[] error, int error_sz);
public static native int mj_saveLastXML(String filename, @Const mjModel m,
                         @Cast("char*") BytePointer error, int error_sz);
public static native int mj_saveLastXML(@Cast("const char*") BytePointer filename, @Const mjModel m,
                         @Cast("char*") ByteBuffer error, int error_sz);
public static native int mj_saveLastXML(String filename, @Const mjModel m,
                         @Cast("char*") byte[] error, int error_sz);

// Free last XML model if loaded. Called internally at each load.
public static native void mj_freeLastXML();

// Print internal XML schema as plain text or HTML, with style-padding or &nbsp;.
public static native int mj_printSchema(@Cast("const char*") BytePointer filename, @Cast("char*") BytePointer buffer, int buffer_sz,
                         int flg_html, int flg_pad);
public static native int mj_printSchema(String filename, @Cast("char*") ByteBuffer buffer, int buffer_sz,
                         int flg_html, int flg_pad);
public static native int mj_printSchema(@Cast("const char*") BytePointer filename, @Cast("char*") byte[] buffer, int buffer_sz,
                         int flg_html, int flg_pad);
public static native int mj_printSchema(String filename, @Cast("char*") BytePointer buffer, int buffer_sz,
                         int flg_html, int flg_pad);
public static native int mj_printSchema(@Cast("const char*") BytePointer filename, @Cast("char*") ByteBuffer buffer, int buffer_sz,
                         int flg_html, int flg_pad);
public static native int mj_printSchema(String filename, @Cast("char*") byte[] buffer, int buffer_sz,
                         int flg_html, int flg_pad);


//---------------------------------- Main simulation -----------------------------------------------

// Advance simulation, use control callback to obtain external force and control.
public static native void mj_step(@Const mjModel m, mjData d);

// Advance simulation in two steps: before external force and control is set by user.
public static native void mj_step1(@Const mjModel m, mjData d);

// Advance simulation in two steps: after external force and control is set by user.
public static native void mj_step2(@Const mjModel m, mjData d);

// Forward dynamics: same as mj_step but do not integrate in time.
public static native void mj_forward(@Const mjModel m, mjData d);

// Inverse dynamics: qacc must be set before calling.
public static native void mj_inverse(@Const mjModel m, mjData d);

// Forward dynamics with skip; skipstage is mjtStage.
public static native void mj_forwardSkip(@Const mjModel m, mjData d, int skipstage, int skipsensor);

// Inverse dynamics with skip; skipstage is mjtStage.
public static native void mj_inverseSkip(@Const mjModel m, mjData d, int skipstage, int skipsensor);


//---------------------------------- Initialization ------------------------------------------------

// Set default options for length range computation.
public static native void mj_defaultLROpt(mjLROpt opt);

// Set solver parameters to default values.
public static native void mj_defaultSolRefImp(@Cast("mjtNum*") DoublePointer solref, @Cast("mjtNum*") DoublePointer solimp);

// Set physics options to default values.
public static native void mj_defaultOption(mjOption opt);

// Set visual options to default values.
public static native void mj_defaultVisual(mjVisual vis);

// Copy mjModel, allocate new if dest is NULL.
public static native mjModel mj_copyModel(mjModel dest, @Const mjModel src);

// Save model to binary MJB file or memory buffer; buffer has precedence when given.
public static native void mj_saveModel(@Const mjModel m, @Cast("const char*") BytePointer filename, Pointer buffer, int buffer_sz);
public static native void mj_saveModel(@Const mjModel m, String filename, Pointer buffer, int buffer_sz);

// Load model from binary MJB file.
// If vfs is not NULL, look up file in vfs before reading from disk.
public static native mjModel mj_loadModel(@Cast("const char*") BytePointer filename, @Const mjVFS vfs);
public static native mjModel mj_loadModel(String filename, @Const mjVFS vfs);

// Free memory allocation in model.
public static native void mj_deleteModel(mjModel m);

// Return size of buffer needed to hold model.
public static native int mj_sizeModel(@Const mjModel m);

// Allocate mjData correponding to given model.
// If the model buffer is unallocated the initial configuration will not be set.
public static native mjData mj_makeData(@Const mjModel m);

// Copy mjData.
// m is only required to contain the size fields from MJMODEL_INTS.
public static native mjData mj_copyData(mjData dest, @Const mjModel m, @Const mjData src);

// Reset data to defaults.
public static native void mj_resetData(@Const mjModel m, mjData d);

// Reset data to defaults, fill everything else with debug_value.
public static native void mj_resetDataDebug(@Const mjModel m, mjData d, @Cast("unsigned char") byte debug_value);

// Reset data, set fields from specified keyframe.
public static native void mj_resetDataKeyframe(@Const mjModel m, mjData d, int key);

// Allocate array of specified size on mjData stack. Call mju_error on stack overflow.
public static native @Cast("mjtNum*") DoublePointer mj_stackAlloc(mjData d, int size);

// Free memory allocation in mjData.
public static native void mj_deleteData(mjData d);

// Reset all callbacks to NULL pointers (NULL is the default).
public static native void mj_resetCallbacks();

// Set constant fields of mjModel, corresponding to qpos0 configuration.
public static native void mj_setConst(mjModel m, mjData d);

// Set actuator_lengthrange for specified actuator; return 1 if ok, 0 if error.
public static native int mj_setLengthRange(mjModel m, mjData d, int index,
                            @Const mjLROpt opt, @Cast("char*") BytePointer error, int error_sz);
public static native int mj_setLengthRange(mjModel m, mjData d, int index,
                            @Const mjLROpt opt, @Cast("char*") ByteBuffer error, int error_sz);
public static native int mj_setLengthRange(mjModel m, mjData d, int index,
                            @Const mjLROpt opt, @Cast("char*") byte[] error, int error_sz);


//---------------------------------- Printing ------------------------------------------------------

// Print mjModel to text file, specifying format.
// float_format must be a valid printf-style format string for a single float value.
public static native void mj_printFormattedModel(@Const mjModel m, @Cast("const char*") BytePointer filename, @Cast("const char*") BytePointer float_format);
public static native void mj_printFormattedModel(@Const mjModel m, String filename, String float_format);

// Print model to text file.
public static native void mj_printModel(@Const mjModel m, @Cast("const char*") BytePointer filename);
public static native void mj_printModel(@Const mjModel m, String filename);

// Print mjData to text file, specifying format.
// float_format must be a valid printf-style format string for a single float value
public static native void mj_printFormattedData(@Const mjModel m, mjData d, @Cast("const char*") BytePointer filename,
                                 @Cast("const char*") BytePointer float_format);
public static native void mj_printFormattedData(@Const mjModel m, mjData d, String filename,
                                 String float_format);

// Print data to text file.
public static native void mj_printData(@Const mjModel m, mjData d, @Cast("const char*") BytePointer filename);
public static native void mj_printData(@Const mjModel m, mjData d, String filename);

// Print matrix to screen.
public static native void mju_printMat(@Cast("const mjtNum*") DoublePointer mat, int nr, int nc);

// Print sparse matrix to screen.
public static native void mju_printMatSparse(@Cast("const mjtNum*") DoublePointer mat, int nr,
                              @Const IntPointer rownnz, @Const IntPointer rowadr, @Const IntPointer colind);
public static native void mju_printMatSparse(@Cast("const mjtNum*") DoublePointer mat, int nr,
                              @Const IntBuffer rownnz, @Const IntBuffer rowadr, @Const IntBuffer colind);
public static native void mju_printMatSparse(@Cast("const mjtNum*") DoublePointer mat, int nr,
                              @Const int[] rownnz, @Const int[] rowadr, @Const int[] colind);


//---------------------------------- Components ----------------------------------------------------

// Run position-dependent computations.
public static native void mj_fwdPosition(@Const mjModel m, mjData d);

// Run velocity-dependent computations.
public static native void mj_fwdVelocity(@Const mjModel m, mjData d);

// Compute actuator force qfrc_actuator.
public static native void mj_fwdActuation(@Const mjModel m, mjData d);

// Add up all non-constraint forces, compute qacc_unc.
public static native void mj_fwdAcceleration(@Const mjModel m, mjData d);

// Run selected constraint solver.
public static native void mj_fwdConstraint(@Const mjModel m, mjData d);

// Euler integrator, semi-implicit in velocity.
public static native void mj_Euler(@Const mjModel m, mjData d);

// Runge-Kutta explicit order-N integrator.
public static native void mj_RungeKutta(@Const mjModel m, mjData d, int N);

// Run position-dependent computations in inverse dynamics.
public static native void mj_invPosition(@Const mjModel m, mjData d);

// Run velocity-dependent computations in inverse dynamics.
public static native void mj_invVelocity(@Const mjModel m, mjData d);

// Apply the analytical formula for inverse constraint dynamics.
public static native void mj_invConstraint(@Const mjModel m, mjData d);

// Compare forward and inverse dynamics, save results in fwdinv.
public static native void mj_compareFwdInv(@Const mjModel m, mjData d);


//---------------------------------- Sub components ------------------------------------------------

// Evaluate position-dependent sensors.
public static native void mj_sensorPos(@Const mjModel m, mjData d);

// Evaluate velocity-dependent sensors.
public static native void mj_sensorVel(@Const mjModel m, mjData d);

// Evaluate acceleration and force-dependent sensors.
public static native void mj_sensorAcc(@Const mjModel m, mjData d);

// Evaluate position-dependent energy (potential).
public static native void mj_energyPos(@Const mjModel m, mjData d);

// Evaluate velocity-dependent energy (kinetic).
public static native void mj_energyVel(@Const mjModel m, mjData d);

// Check qpos, reset if any element is too big or nan.
public static native void mj_checkPos(@Const mjModel m, mjData d);

// Check qvel, reset if any element is too big or nan.
public static native void mj_checkVel(@Const mjModel m, mjData d);

// Check qacc, reset if any element is too big or nan.
public static native void mj_checkAcc(@Const mjModel m, mjData d);

// Run forward kinematics.
public static native void mj_kinematics(@Const mjModel m, mjData d);

// Map inertias and motion dofs to global frame centered at CoM.
public static native void mj_comPos(@Const mjModel m, mjData d);

// Compute camera and light positions and orientations.
public static native void mj_camlight(@Const mjModel m, mjData d);

// Compute tendon lengths, velocities and moment arms.
public static native void mj_tendon(@Const mjModel m, mjData d);

// Compute actuator transmission lengths and moments.
public static native void mj_transmission(@Const mjModel m, mjData d);

// Run composite rigid body inertia algorithm (CRB).
public static native void mj_crb(@Const mjModel m, mjData d);

// Compute sparse L'*D*L factorizaton of inertia matrix.
public static native void mj_factorM(@Const mjModel m, mjData d);

// Solve linear system M * x = y using factorization:  x = inv(L'*D*L)*y
public static native void mj_solveM(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer x, @Cast("const mjtNum*") DoublePointer y, int n);

// Half of linear solve:  x = sqrt(inv(D))*inv(L')*y
public static native void mj_solveM2(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer x, @Cast("const mjtNum*") DoublePointer y, int n);

// Compute cvel, cdof_dot.
public static native void mj_comVel(@Const mjModel m, mjData d);

// Compute qfrc_passive from spring-dampers, viscosity and density.
public static native void mj_passive(@Const mjModel m, mjData d);

// subtree linear velocity and angular momentum
public static native void mj_subtreeVel(@Const mjModel m, mjData d);

// RNE: compute M(qpos)*qacc + C(qpos,qvel); flg_acc=0 removes inertial term.
public static native void mj_rne(@Const mjModel m, mjData d, int flg_acc, @Cast("mjtNum*") DoublePointer result);

// RNE with complete data: compute cacc, cfrc_ext, cfrc_int.
public static native void mj_rnePostConstraint(@Const mjModel m, mjData d);

// Run collision detection.
public static native void mj_collision(@Const mjModel m, mjData d);

// Construct constraints.
public static native void mj_makeConstraint(@Const mjModel m, mjData d);

// Compute inverse constaint inertia efc_AR.
public static native void mj_projectConstraint(@Const mjModel m, mjData d);

// Compute efc_vel, efc_aref.
public static native void mj_referenceConstraint(@Const mjModel m, mjData d);

// Compute efc_state, efc_force, qfrc_constraint, and (optionally) cone Hessians.
// If cost is not NULL, set *cost = s(jar) where jar = Jac*qacc-aref.
public static native void mj_constraintUpdate(@Const mjModel m, mjData d, @Cast("const mjtNum*") DoublePointer jar,
                               @Cast("mjtNum*") DoublePointer cost, int flg_coneHessian);


//---------------------------------- Support -------------------------------------------------------

// Add contact to d->contact list; return 0 if success; 1 if buffer full.
public static native int mj_addContact(@Const mjModel m, mjData d, @Const mjContact con);

// Determine type of friction cone.
public static native int mj_isPyramidal(@Const mjModel m);

// Determine type of constraint Jacobian.
public static native int mj_isSparse(@Const mjModel m);

// Determine type of solver (PGS is dual, CG and Newton are primal).
public static native int mj_isDual(@Const mjModel m);

// Multiply dense or sparse constraint Jacobian by vector.
public static native void mj_mulJacVec(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Multiply dense or sparse constraint Jacobian transpose by vector.
public static native void mj_mulJacTVec(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Compute 3/6-by-nv end-effector Jacobian of global point attached to given body.
public static native void mj_jac(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer jacp, @Cast("mjtNum*") DoublePointer jacr,
                  @Cast("const mjtNum*") DoublePointer point, int body);

// Compute body frame end-effector Jacobian.
public static native void mj_jacBody(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer jacp, @Cast("mjtNum*") DoublePointer jacr, int body);

// Compute body center-of-mass end-effector Jacobian.
public static native void mj_jacBodyCom(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer jacp, @Cast("mjtNum*") DoublePointer jacr, int body);

// Compute geom end-effector Jacobian.
public static native void mj_jacGeom(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer jacp, @Cast("mjtNum*") DoublePointer jacr, int geom);

// Compute site end-effector Jacobian.
public static native void mj_jacSite(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer jacp, @Cast("mjtNum*") DoublePointer jacr, int site);

// Compute translation end-effector Jacobian of point, and rotation Jacobian of axis.
public static native void mj_jacPointAxis(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer jacPoint, @Cast("mjtNum*") DoublePointer jacAxis,
                           @Cast("const mjtNum*") DoublePointer point, @Cast("const mjtNum*") DoublePointer axis, int body);

// Get id of object with specified name, return -1 if not found; type is mjtObj.
public static native int mj_name2id(@Const mjModel m, int type, @Cast("const char*") BytePointer name);
public static native int mj_name2id(@Const mjModel m, int type, String name);

// Get name of object with specified id, return 0 if invalid type or id; type is mjtObj.
public static native @Cast("const char*") BytePointer mj_id2name(@Const mjModel m, int type, int id);

// Convert sparse inertia matrix M into full (i.e. dense) matrix.
public static native void mj_fullM(@Const mjModel m, @Cast("mjtNum*") DoublePointer dst, @Cast("const mjtNum*") DoublePointer M);

// Multiply vector by inertia matrix.
public static native void mj_mulM(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Multiply vector by (inertia matrix)^(1/2).
public static native void mj_mulM2(@Const mjModel m, @Const mjData d, @Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Add inertia matrix to destination matrix.
// Destination can be sparse uncompressed, or dense when all int* are NULL
public static native void mj_addM(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer dst, IntPointer rownnz, IntPointer rowadr, IntPointer colind);
public static native void mj_addM(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer dst, IntBuffer rownnz, IntBuffer rowadr, IntBuffer colind);
public static native void mj_addM(@Const mjModel m, mjData d, @Cast("mjtNum*") DoublePointer dst, int[] rownnz, int[] rowadr, int[] colind);

// Apply cartesian force and torque (outside xfrc_applied mechanism).
public static native void mj_applyFT(@Const mjModel m, mjData d, @Cast("const mjtNum*") DoublePointer force, @Cast("const mjtNum*") DoublePointer torque,
                      @Cast("const mjtNum*") DoublePointer point, int body, @Cast("mjtNum*") DoublePointer qfrc_target);

// Compute object 6D velocity in object-centered frame, world/local orientation.
public static native void mj_objectVelocity(@Const mjModel m, @Const mjData d,
                             int objtype, int objid, @Cast("mjtNum*") DoublePointer res, int flg_local);

// Compute object 6D acceleration in object-centered frame, world/local orientation.
public static native void mj_objectAcceleration(@Const mjModel m, @Const mjData d,
                                 int objtype, int objid, @Cast("mjtNum*") DoublePointer res, int flg_local);

// Extract 6D force:torque given contact id, in the contact frame.
public static native void mj_contactForce(@Const mjModel m, @Const mjData d, int id, @Cast("mjtNum*") DoublePointer result);

// Compute velocity by finite-differencing two positions.
public static native void mj_differentiatePos(@Const mjModel m, @Cast("mjtNum*") DoublePointer qvel, @Cast("mjtNum") double dt,
                               @Cast("const mjtNum*") DoublePointer qpos1, @Cast("const mjtNum*") DoublePointer qpos2);

// Integrate position with given velocity.
public static native void mj_integratePos(@Const mjModel m, @Cast("mjtNum*") DoublePointer qpos, @Cast("const mjtNum*") DoublePointer qvel, @Cast("mjtNum") double dt);

// Normalize all quaterions in qpos-type vector.
public static native void mj_normalizeQuat(@Const mjModel m, @Cast("mjtNum*") DoublePointer qpos);

// Map from body local to global Cartesian coordinates.
public static native void mj_local2Global(mjData d, @Cast("mjtNum*") DoublePointer xpos, @Cast("mjtNum*") DoublePointer xmat, @Cast("const mjtNum*") DoublePointer pos,
                           @Cast("const mjtNum*") DoublePointer quat, int body, @Cast("mjtByte") byte sameframe);

// Sum all body masses.
public static native @Cast("mjtNum") double mj_getTotalmass(@Const mjModel m);

// Scale body masses and inertias to achieve specified total mass.
public static native void mj_setTotalmass(mjModel m, @Cast("mjtNum") double newmass);

// Return version number: 1.0.2 is encoded as 102.
public static native int mj_version();

// Return the current version of MuJoCo as a null-terminated string.
public static native @Cast("const char*") BytePointer mj_versionString();


//---------------------------------- Ray collisions ------------------------------------------------

// Intersect ray (pnt+x*vec, x>=0) with visible geoms, except geoms in bodyexclude.
// Return distance (x) to nearest surface, or -1 if no intersection and output geomid.
// geomgroup, flg_static are as in mjvOption; geomgroup==NULL skips group exclusion.
public static native @Cast("mjtNum") double mj_ray(@Const mjModel m, @Const mjData d, @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec,
                    @Cast("const mjtByte*") BytePointer geomgroup, @Cast("mjtByte") byte flg_static, int bodyexclude,
                    IntPointer geomid);
public static native @Cast("mjtNum") double mj_ray(@Const mjModel m, @Const mjData d, @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec,
                    @Cast("const mjtByte*") ByteBuffer geomgroup, @Cast("mjtByte") byte flg_static, int bodyexclude,
                    IntBuffer geomid);
public static native @Cast("mjtNum") double mj_ray(@Const mjModel m, @Const mjData d, @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec,
                    @Cast("const mjtByte*") byte[] geomgroup, @Cast("mjtByte") byte flg_static, int bodyexclude,
                    int[] geomid);

// Interect ray with hfield, return nearest distance or -1 if no intersection.
public static native @Cast("mjtNum") double mj_rayHfield(@Const mjModel m, @Const mjData d, int geomid,
                          @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec);

// Interect ray with mesh, return nearest distance or -1 if no intersection.
public static native @Cast("mjtNum") double mj_rayMesh(@Const mjModel m, @Const mjData d, int geomid,
                        @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec);

// Interect ray with pure geom, return nearest distance or -1 if no intersection.
public static native @Cast("mjtNum") double mju_rayGeom(@Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer mat, @Cast("const mjtNum*") DoublePointer size,
                         @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec, int geomtype);

// Interect ray with skin, return nearest distance or -1 if no intersection,
// and also output nearest vertex id.
public static native @Cast("mjtNum") double mju_raySkin(int nface, int nvert, @Const IntPointer face, @Const FloatPointer vert,
                         @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec, IntPointer vertid);
public static native @Cast("mjtNum") double mju_raySkin(int nface, int nvert, @Const IntBuffer face, @Const FloatBuffer vert,
                         @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec, IntBuffer vertid);
public static native @Cast("mjtNum") double mju_raySkin(int nface, int nvert, @Const int[] face, @Const float[] vert,
                         @Cast("const mjtNum*") DoublePointer pnt, @Cast("const mjtNum*") DoublePointer vec, int[] vertid);


//---------------------------------- Interaction ---------------------------------------------------

// Set default camera.
public static native void mjv_defaultCamera(mjvCamera cam);

// Set default perturbation.
public static native void mjv_defaultPerturb(mjvPerturb pert);

// Transform pose from room to model space.
public static native void mjv_room2model(@Cast("mjtNum*") DoublePointer modelpos, @Cast("mjtNum*") DoublePointer modelquat, @Cast("const mjtNum*") DoublePointer roompos,
                          @Cast("const mjtNum*") DoublePointer roomquat, @Const mjvScene scn);

// Transform pose from model to room space.
public static native void mjv_model2room(@Cast("mjtNum*") DoublePointer roompos, @Cast("mjtNum*") DoublePointer roomquat, @Cast("const mjtNum*") DoublePointer modelpos,
                          @Cast("const mjtNum*") DoublePointer modelquat, @Const mjvScene scn);

// Get camera info in model space; average left and right OpenGL cameras.
public static native void mjv_cameraInModel(@Cast("mjtNum*") DoublePointer headpos, @Cast("mjtNum*") DoublePointer forward, @Cast("mjtNum*") DoublePointer up,
                             @Const mjvScene scn);

// Get camera info in room space; average left and right OpenGL cameras.
public static native void mjv_cameraInRoom(@Cast("mjtNum*") DoublePointer headpos, @Cast("mjtNum*") DoublePointer forward, @Cast("mjtNum*") DoublePointer up,
                            @Const mjvScene scn);

// Get frustum height at unit distance from camera; average left and right OpenGL cameras.
public static native @Cast("mjtNum") double mjv_frustumHeight(@Const mjvScene scn);

// Rotate 3D vec in horizontal plane by angle between (0,1) and (forward_x,forward_y).
public static native void mjv_alignToCamera(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("const mjtNum*") DoublePointer forward);

// Move camera with mouse; action is mjtMouse.
public static native void mjv_moveCamera(@Const mjModel m, int action, @Cast("mjtNum") double reldx, @Cast("mjtNum") double reldy,
                          @Const mjvScene scn, mjvCamera cam);

// Move perturb object with mouse; action is mjtMouse.
public static native void mjv_movePerturb(@Const mjModel m, @Const mjData d, int action, @Cast("mjtNum") double reldx,
                           @Cast("mjtNum") double reldy, @Const mjvScene scn, mjvPerturb pert);

// Move model with mouse; action is mjtMouse.
public static native void mjv_moveModel(@Const mjModel m, int action, @Cast("mjtNum") double reldx, @Cast("mjtNum") double reldy,
                         @Cast("const mjtNum*") DoublePointer roomup, mjvScene scn);

// Copy perturb pos,quat from selected body; set scale for perturbation.
public static native void mjv_initPerturb(@Const mjModel m, @Const mjData d,
                           @Const mjvScene scn, mjvPerturb pert);

// Set perturb pos,quat in d->mocap when selected body is mocap, and in d->qpos otherwise.
// Write d->qpos only if flg_paused and subtree root for selected body has free joint.
public static native void mjv_applyPerturbPose(@Const mjModel m, mjData d, @Const mjvPerturb pert,
                                int flg_paused);

// Set perturb force,torque in d->xfrc_applied, if selected body is dynamic.
public static native void mjv_applyPerturbForce(@Const mjModel m, mjData d, @Const mjvPerturb pert);

// Return the average of two OpenGL cameras.
public static native @ByVal mjvGLCamera mjv_averageCamera(@Const mjvGLCamera cam1, @Const mjvGLCamera cam2);

// Select geom or skin with mouse, return bodyid; -1: none selected.
public static native int mjv_select(@Const mjModel m, @Const mjData d, @Const mjvOption vopt,
                     @Cast("mjtNum") double aspectratio, @Cast("mjtNum") double relx, @Cast("mjtNum") double rely,
                     @Const mjvScene scn, @Cast("mjtNum*") DoublePointer selpnt, IntPointer geomid, IntPointer skinid);
public static native int mjv_select(@Const mjModel m, @Const mjData d, @Const mjvOption vopt,
                     @Cast("mjtNum") double aspectratio, @Cast("mjtNum") double relx, @Cast("mjtNum") double rely,
                     @Const mjvScene scn, @Cast("mjtNum*") DoublePointer selpnt, IntBuffer geomid, IntBuffer skinid);
public static native int mjv_select(@Const mjModel m, @Const mjData d, @Const mjvOption vopt,
                     @Cast("mjtNum") double aspectratio, @Cast("mjtNum") double relx, @Cast("mjtNum") double rely,
                     @Const mjvScene scn, @Cast("mjtNum*") DoublePointer selpnt, int[] geomid, int[] skinid);


//---------------------------------- Visualization -------------------------------------------------

// Set default visualization options.
public static native void mjv_defaultOption(mjvOption opt);

// Set default figure.
public static native void mjv_defaultFigure(mjvFigure fig);

// Initialize given geom fields when not NULL, set the rest to their default values.
public static native void mjv_initGeom(mjvGeom geom, int type, @Cast("const mjtNum*") DoublePointer size,
                        @Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer mat, @Const FloatPointer rgba);
public static native void mjv_initGeom(mjvGeom geom, int type, @Cast("const mjtNum*") DoublePointer size,
                        @Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer mat, @Const FloatBuffer rgba);
public static native void mjv_initGeom(mjvGeom geom, int type, @Cast("const mjtNum*") DoublePointer size,
                        @Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer mat, @Const float[] rgba);

// Set (type, size, pos, mat) for connector-type geom between given points.
// Assume that mjv_initGeom was already called to set all other properties.
public static native void mjv_makeConnector(mjvGeom geom, int type, @Cast("mjtNum") double width,
                             @Cast("mjtNum") double a0, @Cast("mjtNum") double a1, @Cast("mjtNum") double a2,
                             @Cast("mjtNum") double b0, @Cast("mjtNum") double b1, @Cast("mjtNum") double b2);

// Set default abstract scene.
public static native void mjv_defaultScene(mjvScene scn);

// Allocate resources in abstract scene.
public static native void mjv_makeScene(@Const mjModel m, mjvScene scn, int maxgeom);

// Free abstract scene.
public static native void mjv_freeScene(mjvScene scn);

// Update entire scene given model state.
public static native void mjv_updateScene(@Const mjModel m, mjData d, @Const mjvOption opt,
                           @Const mjvPerturb pert, mjvCamera cam, int catmask, mjvScene scn);

// Add geoms from selected categories.
public static native void mjv_addGeoms(@Const mjModel m, mjData d, @Const mjvOption opt,
                        @Const mjvPerturb pert, int catmask, mjvScene scn);

// Make list of lights.
public static native void mjv_makeLights(@Const mjModel m, mjData d, mjvScene scn);

// Update camera.
public static native void mjv_updateCamera(@Const mjModel m, mjData d, mjvCamera cam, mjvScene scn);

// Update skins.
public static native void mjv_updateSkin(@Const mjModel m, mjData d, mjvScene scn);


//---------------------------------- OpenGL rendering ----------------------------------------------

// Set default mjrContext.
public static native void mjr_defaultContext(mjrContext con);

// Allocate resources in custom OpenGL context; fontscale is mjtFontScale.
public static native void mjr_makeContext(@Const mjModel m, mjrContext con, int fontscale);

// Change font of existing context.
public static native void mjr_changeFont(int fontscale, mjrContext con);

// Add Aux buffer with given index to context; free previous Aux buffer.
public static native void mjr_addAux(int index, int width, int height, int samples, mjrContext con);

// Free resources in custom OpenGL context, set to default.
public static native void mjr_freeContext(mjrContext con);

// Upload texture to GPU, overwriting previous upload if any.
public static native void mjr_uploadTexture(@Const mjModel m, @Const mjrContext con, int texid);

// Upload mesh to GPU, overwriting previous upload if any.
public static native void mjr_uploadMesh(@Const mjModel m, @Const mjrContext con, int meshid);

// Upload height field to GPU, overwriting previous upload if any.
public static native void mjr_uploadHField(@Const mjModel m, @Const mjrContext con, int hfieldid);

// Make con->currentBuffer current again.
public static native void mjr_restoreBuffer(@Const mjrContext con);

// Set OpenGL framebuffer for rendering: mjFB_WINDOW or mjFB_OFFSCREEN.
// If only one buffer is available, set that buffer and ignore framebuffer argument.
public static native void mjr_setBuffer(int framebuffer, mjrContext con);

// Read pixels from current OpenGL framebuffer to client buffer.
// Viewport is in OpenGL framebuffer; client buffer starts at (0,0).
public static native void mjr_readPixels(@Cast("unsigned char*") BytePointer rgb, FloatPointer depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);
public static native void mjr_readPixels(@Cast("unsigned char*") ByteBuffer rgb, FloatBuffer depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);
public static native void mjr_readPixels(@Cast("unsigned char*") byte[] rgb, float[] depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);

// Draw pixels from client buffer to current OpenGL framebuffer.
// Viewport is in OpenGL framebuffer; client buffer starts at (0,0).
public static native void mjr_drawPixels(@Cast("const unsigned char*") BytePointer rgb, @Const FloatPointer depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);
public static native void mjr_drawPixels(@Cast("const unsigned char*") ByteBuffer rgb, @Const FloatBuffer depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);
public static native void mjr_drawPixels(@Cast("const unsigned char*") byte[] rgb, @Const float[] depth,
                          @ByVal mjrRect viewport, @Const mjrContext con);

// Blit from src viewpoint in current framebuffer to dst viewport in other framebuffer.
// If src, dst have different size and flg_depth==0, color is interpolated with GL_LINEAR.
public static native void mjr_blitBuffer(@ByVal mjrRect src, @ByVal mjrRect dst,
                          int flg_color, int flg_depth, @Const mjrContext con);

// Set Aux buffer for custom OpenGL rendering (call restoreBuffer when done).
public static native void mjr_setAux(int index, @Const mjrContext con);

// Blit from Aux buffer to con->currentBuffer.
public static native void mjr_blitAux(int index, @ByVal mjrRect src, int left, int bottom, @Const mjrContext con);

// Draw text at (x,y) in relative coordinates; font is mjtFont.
public static native void mjr_text(int font, @Cast("const char*") BytePointer txt, @Const mjrContext con,
                    float x, float y, float r, float g, float b);
public static native void mjr_text(int font, String txt, @Const mjrContext con,
                    float x, float y, float r, float g, float b);

// Draw text overlay; font is mjtFont; gridpos is mjtGridPos.
public static native void mjr_overlay(int font, int gridpos, @ByVal mjrRect viewport,
                       @Cast("const char*") BytePointer overlay, @Cast("const char*") BytePointer overlay2, @Const mjrContext con);
public static native void mjr_overlay(int font, int gridpos, @ByVal mjrRect viewport,
                       String overlay, String overlay2, @Const mjrContext con);

// Get maximum viewport for active buffer.
public static native @ByVal mjrRect mjr_maxViewport(@Const mjrContext con);

// Draw rectangle.
public static native void mjr_rectangle(@ByVal mjrRect viewport, float r, float g, float b, float a);

// Draw rectangle with centered text.
public static native void mjr_label(@ByVal mjrRect viewport, int font, @Cast("const char*") BytePointer txt,
                     float r, float g, float b, float a, float rt, float gt, float bt,
                     @Const mjrContext con);
public static native void mjr_label(@ByVal mjrRect viewport, int font, String txt,
                     float r, float g, float b, float a, float rt, float gt, float bt,
                     @Const mjrContext con);

// Draw 2D figure.
public static native void mjr_figure(@ByVal mjrRect viewport, mjvFigure fig, @Const mjrContext con);

// Render 3D scene.
public static native void mjr_render(@ByVal mjrRect viewport, mjvScene scn, @Const mjrContext con);

// Call glFinish.
public static native void mjr_finish();

// Call glGetError and return result.
public static native int mjr_getError();

// Find first rectangle containing mouse, -1: not found.
public static native int mjr_findRect(int x, int y, int nrect, @Const mjrRect rect);


//---------------------------------- UI framework --------------------------------------------------

// Get builtin UI theme spacing (ind: 0-1).
public static native @ByVal mjuiThemeSpacing mjui_themeSpacing(int ind);

// Get builtin UI theme color (ind: 0-3).
public static native @ByVal mjuiThemeColor mjui_themeColor(int ind);

// Add definitions to UI.
public static native void mjui_add(mjUI ui, @Const mjuiDef def);

// Add definitions to UI section.
public static native void mjui_addToSection(mjUI ui, int sect, @Const mjuiDef def);

// Compute UI sizes.
public static native void mjui_resize(mjUI ui, @Const mjrContext con);

// Update specific section/item; -1: update all.
public static native void mjui_update(int section, int item, @Const mjUI ui,
                       @Const mjuiState state, @Const mjrContext con);

// Handle UI event, return pointer to changed item, NULL if no change.
public static native mjuiItem mjui_event(mjUI ui, mjuiState state, @Const mjrContext con);

// Copy UI image to current buffer.
public static native void mjui_render(mjUI ui, @Const mjuiState state, @Const mjrContext con);


//---------------------------------- Error and memory ----------------------------------------------

// Main error function; does not return to caller.
public static native void mju_error(@Cast("const char*") BytePointer msg);
public static native void mju_error(String msg);

// Error function with int argument; msg is a printf format string.
public static native void mju_error_i(@Cast("const char*") BytePointer msg, int i);
public static native void mju_error_i(String msg, int i);

// Error function with string argument.
public static native void mju_error_s(@Cast("const char*") BytePointer msg, @Cast("const char*") BytePointer text);
public static native void mju_error_s(String msg, String text);

// Main warning function; returns to caller.
public static native void mju_warning(@Cast("const char*") BytePointer msg);
public static native void mju_warning(String msg);

// Warning function with int argument.
public static native void mju_warning_i(@Cast("const char*") BytePointer msg, int i);
public static native void mju_warning_i(String msg, int i);

// Warning function with string argument.
public static native void mju_warning_s(@Cast("const char*") BytePointer msg, @Cast("const char*") BytePointer text);
public static native void mju_warning_s(String msg, String text);

// Clear user error and memory handlers.
public static native void mju_clearHandlers();

// Allocate memory; byte-align on 8; pad size to multiple of 8.
public static native Pointer mju_malloc(@Cast("size_t") long size);

// Free memory, using free() by default.
public static native void mju_free(Pointer ptr);

// High-level warning function: count warnings in mjData, print only the first.
public static native void mj_warning(mjData d, int warning, int info);

// Write [datetime, type: message] to MUJOCO_LOG.TXT.
public static native void mju_writeLog(@Cast("const char*") BytePointer type, @Cast("const char*") BytePointer msg);
public static native void mju_writeLog(String type, String msg);


//---------------------------------- Activation ----------------------------------------------------

// Return 1 (for backward compatibility).
public static native int mj_activate(@Cast("const char*") BytePointer filename);
public static native int mj_activate(String filename);

// Do nothing (for backward compatibility).
public static native void mj_deactivate();


//---------------------------------- Standard math -------------------------------------------------

// #define mjMAX(a,b) (((a) > (b)) ? (a) : (b))
// #define mjMIN(a,b) (((a) < (b)) ? (a) : (b))

// #ifdef mjUSEDOUBLE
//   #define mju_sqrt    sqrt
//   #define mju_exp     exp
//   #define mju_sin     sin
//   #define mju_cos     cos
//   #define mju_tan     tan
//   #define mju_asin    asin
//   #define mju_acos    acos
//   #define mju_atan2   atan2
//   #define mju_tanh    tanh
//   #define mju_pow     pow
//   #define mju_abs     fabs
//   #define mju_log     log
//   #define mju_log10   log10
//   #define mju_floor   floor
//   #define mju_ceil    ceil

// #else
//   #define mju_sqrt    sqrtf
//   #define mju_exp     expf
//   #define mju_sin     sinf
//   #define mju_cos     cosf
//   #define mju_tan     tanf
//   #define mju_asin    asinf
//   #define mju_acos    acosf
//   #define mju_atan2   atan2f
//   #define mju_tanh    tanhf
//   #define mju_pow     powf
//   #define mju_abs     fabsf
//   #define mju_log     logf
//   #define mju_log10   log10f
//   #define mju_floor   floorf
//   #define mju_ceil    ceilf
// #endif


//---------------------------------- Vector math ---------------------------------------------------

// Set res = 0.
public static native void mju_zero3(@Cast("mjtNum*") DoublePointer res);

// Set res = vec.
public static native void mju_copy3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer data);

// Set res = vec*scl.
public static native void mju_scl3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("mjtNum") double scl);

// Set res = vec1 + vec2.
public static native void mju_add3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2);

// Set res = vec1 - vec2.
public static native void mju_sub3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2);

// Set res = res + vec.
public static native void mju_addTo3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Set res = res - vec.
public static native void mju_subFrom3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec);

// Set res = res + vec*scl.
public static native void mju_addToScl3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("mjtNum") double scl);

// Set res = vec1 + vec2*scl.
public static native void mju_addScl3(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2, @Cast("mjtNum") double scl);

// Normalize vector, return length before normalization.
public static native @Cast("mjtNum") double mju_normalize3(@Cast("mjtNum*") DoublePointer res);

// Return vector length (without normalizing the vector).
public static native @Cast("mjtNum") double mju_norm3(@Cast("const mjtNum*") DoublePointer vec);

// Return dot-product of vec1 and vec2.
public static native @Cast("mjtNum") double mju_dot3(@Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2);

// Return Cartesian distance between 3D vectors pos1 and pos2.
public static native @Cast("mjtNum") double mju_dist3(@Cast("const mjtNum*") DoublePointer pos1, @Cast("const mjtNum*") DoublePointer pos2);

// Multiply vector by 3D rotation matrix: res = mat * vec.
public static native void mju_rotVecMat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("const mjtNum*") DoublePointer mat);

// Multiply vector by transposed 3D rotation matrix: res = mat' * vec.
public static native void mju_rotVecMatT(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("const mjtNum*") DoublePointer mat);

// Compute cross-product: res = cross(a, b).
public static native void mju_cross(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer a, @Cast("const mjtNum*") DoublePointer b);

// Set res = 0.
public static native void mju_zero4(@Cast("mjtNum*") DoublePointer res);

// Set res = (1,0,0,0).
public static native void mju_unit4(@Cast("mjtNum*") DoublePointer res);

// Set res = vec.
public static native void mju_copy4(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer data);

// Normalize vector, return length before normalization.
public static native @Cast("mjtNum") double mju_normalize4(@Cast("mjtNum*") DoublePointer res);

// Set res = 0.
public static native void mju_zero(@Cast("mjtNum*") DoublePointer res, int n);

// Set res = vec.
public static native void mju_copy(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer data, int n);

// Return sum(vec).
public static native @Cast("mjtNum") double mju_sum(@Cast("const mjtNum*") DoublePointer vec, int n);

// Return L1 norm: sum(abs(vec)).
public static native @Cast("mjtNum") double mju_L1(@Cast("const mjtNum*") DoublePointer vec, int n);

// Set res = vec*scl.
public static native void mju_scl(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("mjtNum") double scl, int n);

// Set res = vec1 + vec2.
public static native void mju_add(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2, int n);

// Set res = vec1 - vec2.
public static native void mju_sub(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2, int n);

// Set res = res + vec.
public static native void mju_addTo(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, int n);

// Set res = res - vec.
public static native void mju_subFrom(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, int n);

// Set res = res + vec*scl.
public static native void mju_addToScl(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("mjtNum") double scl, int n);

// Set res = vec1 + vec2*scl.
public static native void mju_addScl(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2, @Cast("mjtNum") double scl, int n);

// Normalize vector, return length before normalization.
public static native @Cast("mjtNum") double mju_normalize(@Cast("mjtNum*") DoublePointer res, int n);

// Return vector length (without normalizing vector).
public static native @Cast("mjtNum") double mju_norm(@Cast("const mjtNum*") DoublePointer res, int n);

// Return dot-product of vec1 and vec2.
public static native @Cast("mjtNum") double mju_dot(@Cast("const mjtNum*") DoublePointer vec1, @Cast("const mjtNum*") DoublePointer vec2, int n);

// Multiply matrix and vector: res = mat * vec.
public static native void mju_mulMatVec(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat, @Cast("const mjtNum*") DoublePointer vec, int nr, int nc);

// Multiply transposed matrix and vector: res = mat' * vec.
public static native void mju_mulMatTVec(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat, @Cast("const mjtNum*") DoublePointer vec, int nr, int nc);

// Transpose matrix: res = mat'.
public static native void mju_transpose(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat, int nr, int nc);

// Multiply matrices: res = mat1 * mat2.
public static native void mju_mulMatMat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat1, @Cast("const mjtNum*") DoublePointer mat2,
                         int r1, int c1, int c2);

// Multiply matrices, second argument transposed: res = mat1 * mat2'.
public static native void mju_mulMatMatT(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat1, @Cast("const mjtNum*") DoublePointer mat2,
                          int r1, int c1, int r2);

// Multiply matrices, first argument transposed: res = mat1' * mat2.
public static native void mju_mulMatTMat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat1, @Cast("const mjtNum*") DoublePointer mat2,
                          int r1, int c1, int c2);

// Set res = mat' * diag * mat if diag is not NULL, and res = mat' * mat otherwise.
public static native void mju_sqrMatTD(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat, @Cast("const mjtNum*") DoublePointer diag, int nr, int nc);

// Coordinate transform of 6D motion or force vector in rotation:translation format.
// rotnew2old is 3-by-3, NULL means no rotation; flg_force specifies force or motion type.
public static native void mju_transformSpatial(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, int flg_force,
                                @Cast("const mjtNum*") DoublePointer newpos, @Cast("const mjtNum*") DoublePointer oldpos,
                                @Cast("const mjtNum*") DoublePointer rotnew2old);


//---------------------------------- Quaternions ---------------------------------------------------

// Rotate vector by quaternion.
public static native void mju_rotVecQuat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, @Cast("const mjtNum*") DoublePointer quat);

// Conjugate quaternion, corresponding to opposite rotation.
public static native void mju_negQuat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat);

// Multiply quaternions.
public static native void mju_mulQuat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat1, @Cast("const mjtNum*") DoublePointer quat2);

// Multiply quaternion and axis.
public static native void mju_mulQuatAxis(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer axis);

// Convert axisAngle to quaternion.
public static native void mju_axisAngle2Quat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer axis, @Cast("mjtNum") double angle);

// Convert quaternion (corresponding to orientation difference) to 3D velocity.
public static native void mju_quat2Vel(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat, @Cast("mjtNum") double dt);

// Subtract quaternions, express as 3D velocity: qb*quat(res) = qa.
public static native void mju_subQuat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer qa, @Cast("const mjtNum*") DoublePointer qb);

// Convert quaternion to 3D rotation matrix.
public static native void mju_quat2Mat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat);

// Convert 3D rotation matrix to quaterion.
public static native void mju_mat2Quat(@Cast("mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer mat);

// Compute time-derivative of quaternion, given 3D rotational velocity.
public static native void mju_derivQuat(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer vel);

// Integrate quaterion given 3D angular velocity.
public static native void mju_quatIntegrate(@Cast("mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer vel, @Cast("mjtNum") double scale);

// Construct quaternion performing rotation from z-axis to given vector.
public static native void mju_quatZ2Vec(@Cast("mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer vec);


//---------------------------------- Poses ---------------------------------------------------------

// Multiply two poses.
public static native void mju_mulPose(@Cast("mjtNum*") DoublePointer posres, @Cast("mjtNum*") DoublePointer quatres,
                       @Cast("const mjtNum*") DoublePointer pos1, @Cast("const mjtNum*") DoublePointer quat1,
                       @Cast("const mjtNum*") DoublePointer pos2, @Cast("const mjtNum*") DoublePointer quat2);

// Conjugate pose, corresponding to the opposite spatial transformation.
public static native void mju_negPose(@Cast("mjtNum*") DoublePointer posres, @Cast("mjtNum*") DoublePointer quatres,
                       @Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer quat);

// Transform vector by pose.
public static native void mju_trnVecPose(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer pos, @Cast("const mjtNum*") DoublePointer quat,
                          @Cast("const mjtNum*") DoublePointer vec);


//--------------------------------- Decompositions -------------------------------------------------

// Cholesky decomposition: mat = L*L'; return rank, decomposition performed in-place into mat.
public static native int mju_cholFactor(@Cast("mjtNum*") DoublePointer mat, int n, @Cast("mjtNum") double mindiag);

// Solve mat * res = vec, where mat is Cholesky-factorized
public static native void mju_cholSolve(@Cast("mjtNum*") DoublePointer res, @Cast("const mjtNum*") DoublePointer mat, @Cast("const mjtNum*") DoublePointer vec, int n);

// Cholesky rank-one update: L*L' +/- x*x'; return rank.
public static native int mju_cholUpdate(@Cast("mjtNum*") DoublePointer mat, @Cast("mjtNum*") DoublePointer x, int n, int flg_plus);

// Eigenvalue decomposition of symmetric 3x3 matrix.
public static native int mju_eig3(@Cast("mjtNum*") DoublePointer eigval, @Cast("mjtNum*") DoublePointer eigvec, @Cast("mjtNum*") DoublePointer quat, @Cast("const mjtNum*") DoublePointer mat);


//---------------------- Miscellaneous --------------------------------------------------

// Muscle active force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax, fvmax).
public static native @Cast("mjtNum") double mju_muscleGain(@Cast("mjtNum") double len, @Cast("mjtNum") double vel, @Cast("const mjtNum*") DoublePointer lengthrange,
                            @Cast("mjtNum") double acc0, @Cast("const mjtNum*") DoublePointer prm);

// Muscle passive force, prm = (range[2], force, scale, lmin, lmax, vmax, fpmax, fvmax).
public static native @Cast("mjtNum") double mju_muscleBias(@Cast("mjtNum") double len, @Cast("const mjtNum*") DoublePointer lengthrange,
                            @Cast("mjtNum") double acc0, @Cast("const mjtNum*") DoublePointer prm);

// Muscle activation dynamics, prm = (tau_act, tau_deact).
public static native @Cast("mjtNum") double mju_muscleDynamics(@Cast("mjtNum") double ctrl, @Cast("mjtNum") double act, @Cast("const mjtNum*") DoublePointer prm);

// Convert contact force to pyramid representation.
public static native void mju_encodePyramid(@Cast("mjtNum*") DoublePointer pyramid, @Cast("const mjtNum*") DoublePointer force, @Cast("const mjtNum*") DoublePointer mu, int dim);

// Convert pyramid representation to contact force.
public static native void mju_decodePyramid(@Cast("mjtNum*") DoublePointer force, @Cast("const mjtNum*") DoublePointer pyramid, @Cast("const mjtNum*") DoublePointer mu, int dim);

// Integrate spring-damper analytically, return pos(dt).
public static native @Cast("mjtNum") double mju_springDamper(@Cast("mjtNum") double pos0, @Cast("mjtNum") double vel0, @Cast("mjtNum") double Kp, @Cast("mjtNum") double Kv, @Cast("mjtNum") double dt);

// Return min(a,b) with single evaluation of a and b.
public static native @Cast("mjtNum") double mju_min(@Cast("mjtNum") double a, @Cast("mjtNum") double b);

// Return max(a,b) with single evaluation of a and b.
public static native @Cast("mjtNum") double mju_max(@Cast("mjtNum") double a, @Cast("mjtNum") double b);

// Return sign of x: +1, -1 or 0.
public static native @Cast("mjtNum") double mju_sign(@Cast("mjtNum") double x);

// Round x to nearest integer.
public static native int mju_round(@Cast("mjtNum") double x);

// Convert type id (mjtObj) to type name.
public static native @Cast("const char*") BytePointer mju_type2Str(int type);

// Convert type name to type id (mjtObj).
public static native int mju_str2Type(@Cast("const char*") BytePointer str);
public static native int mju_str2Type(String str);

// Construct a warning message given the warning type and info.
public static native @Cast("const char*") BytePointer mju_warningText(int warning, int info);

// Return 1 if nan or abs(x)>mjMAXVAL, 0 otherwise. Used by check functions.
public static native int mju_isBad(@Cast("mjtNum") double x);

// Return 1 if all elements are 0.
public static native int mju_isZero(@Cast("mjtNum*") DoublePointer vec, int n);

// Standard normal random number generator (optional second number).
public static native @Cast("mjtNum") double mju_standardNormal(@Cast("mjtNum*") DoublePointer num2);

// Convert from float to mjtNum.
public static native void mju_f2n(@Cast("mjtNum*") DoublePointer res, @Const FloatPointer vec, int n);
public static native void mju_f2n(@Cast("mjtNum*") DoublePointer res, @Const FloatBuffer vec, int n);
public static native void mju_f2n(@Cast("mjtNum*") DoublePointer res, @Const float[] vec, int n);

// Convert from mjtNum to float.
public static native void mju_n2f(FloatPointer res, @Cast("const mjtNum*") DoublePointer vec, int n);
public static native void mju_n2f(FloatBuffer res, @Cast("const mjtNum*") DoublePointer vec, int n);
public static native void mju_n2f(float[] res, @Cast("const mjtNum*") DoublePointer vec, int n);

// Convert from double to mjtNum.
public static native void mju_d2n(@Cast("mjtNum*") DoublePointer res, @Const DoublePointer vec, int n);
public static native void mju_d2n(@Cast("mjtNum*") DoublePointer res, @Const DoubleBuffer vec, int n);
public static native void mju_d2n(@Cast("mjtNum*") DoublePointer res, @Const double[] vec, int n);

// Convert from mjtNum to double.
public static native void mju_n2d(DoublePointer res, @Cast("const mjtNum*") DoublePointer vec, int n);
public static native void mju_n2d(DoubleBuffer res, @Cast("const mjtNum*") DoublePointer vec, int n);
public static native void mju_n2d(double[] res, @Cast("const mjtNum*") DoublePointer vec, int n);

// Insertion sort, resulting list is in increasing order.
public static native void mju_insertionSort(@Cast("mjtNum*") DoublePointer list, int n);

// Integer insertion sort, resulting list is in increasing order.
public static native void mju_insertionSortInt(IntPointer list, int n);
public static native void mju_insertionSortInt(IntBuffer list, int n);
public static native void mju_insertionSortInt(int[] list, int n);

// Generate Halton sequence.
public static native @Cast("mjtNum") double mju_Halton(int index, int base);

// Call strncpy, then set dst[n-1] = 0.
public static native @Cast("char*") BytePointer mju_strncpy(@Cast("char*") BytePointer dst, @Cast("const char*") BytePointer src, int n);
public static native @Cast("char*") ByteBuffer mju_strncpy(@Cast("char*") ByteBuffer dst, String src, int n);
public static native @Cast("char*") byte[] mju_strncpy(@Cast("char*") byte[] dst, @Cast("const char*") BytePointer src, int n);
public static native @Cast("char*") BytePointer mju_strncpy(@Cast("char*") BytePointer dst, String src, int n);
public static native @Cast("char*") ByteBuffer mju_strncpy(@Cast("char*") ByteBuffer dst, @Cast("const char*") BytePointer src, int n);
public static native @Cast("char*") byte[] mju_strncpy(@Cast("char*") byte[] dst, String src, int n);

// Sigmoid function over 0<=x<=1 constructed from half-quadratics.
public static native @Cast("mjtNum") double mju_sigmoid(@Cast("mjtNum") double x);


// #if defined(__cplusplus)
// #endif

// #endif  // MUJOCO_MUJOCO_H_


}
