/*
 * Decompiled with CFR 0.152.
 */
package com.nfbsoftware.xml;

import com.nfbsoftware.xml.IXmlDocument;
import com.nfbsoftware.xml.IXmlElement;
import com.nfbsoftware.xml.exception.XmlDocumentCheckedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlDocument
implements IXmlDocument {
    private static final long serialVersionUID = 1L;
    protected Document mDocument;
    protected Node mRootNode;
    private transient DocumentBuilder mDocumentBuilder;
    protected static final String SEPARATOR = "/";

    public XmlDocument() throws XmlDocumentCheckedException {
        this.create();
    }

    public XmlDocument(File file) throws XmlDocumentCheckedException {
        this();
        String debugString = this.getClass().getName() + ".XmlDocument(File)";
        try {
            if (!this.replaceFromStream(new FileInputStream(file))) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (IOException ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    public XmlDocument(File file, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".XmlDocument(File, String)";
        try {
            if (!this.replaceFromStream(new FileInputStream(file), enc)) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (IOException ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    public XmlDocument(InputStream in) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".XmlDocument(InputStream)";
        if (!this.replaceFromStream(in)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    public XmlDocument(InputStream in, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".XmlDocument(InputStream, String)";
        try {
            if (!this.replaceFromStream(in, enc)) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    public XmlDocument(Reader reader) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".XmlDocument(Reader)";
        if (!this.replaceFromReader(reader)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    public XmlDocument(Node node, Document doc) {
        this.mRootNode = node;
        this.mDocument = doc;
    }

    public XmlDocument(IXmlDocument xmlDocument) throws XmlDocumentCheckedException {
        this.mRootNode = xmlDocument.getRootNode();
        this.mDocument = xmlDocument.getDocument();
    }

    public XmlDocument(String xml) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".XmlDocument(String)";
        if (!this.replaceFromString(xml)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    private void create() throws XmlDocumentCheckedException {
        this.mDocumentBuilder = this.createDocumentBuilder();
        this.mDocument = this.mDocumentBuilder.newDocument();
        this.mRootNode = this.mDocument;
    }

    private XmlDocument create(Node node, Document doc) {
        return new XmlDocument(node, doc);
    }

    private IXmlElement create(Node node) throws XmlDocumentCheckedException {
        DocumentImpl doc;
        DocumentImpl rootNode = doc = new DocumentImpl();
        Node child = XmlDocument.cloneChildren((Document)doc, node);
        rootNode.appendChild(child);
        return new XmlDocument((Node)rootNode, (Document)doc).getRootElement();
    }

    private XmlDocument createNewChild(String child, String value) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".createNewChild(String, String)";
        try {
            Element e = this.mDocument.createElement(child);
            this.mRootNode.appendChild(e);
            if (!StringUtils.isEmpty((String)value)) {
                Text text = this.mDocument.createTextNode(value);
                e.appendChild(text);
            }
            return this.create(e, this.mDocument);
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public void addChild(IXmlElement child) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".addChild(IXmlElement)";
        try {
            Node root = child.getRootNode();
            if (this.mRootNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.NULL_ROOT_ELEMENT, debugString);
            }
            this.mRootNode.appendChild(this.examineChild(child.getDocument(), root));
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    @Override
    public void addToChild(IXmlElement child, String parent) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".addToChild(IXmlElement, String)";
        try {
            if (child instanceof IXmlDocument) {
                child = ((IXmlDocument)child).getRootElement();
            }
            this.appendChildByName(parent, new XmlDocument(this.create(child.getRootNode(), child.getDocument())));
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public void appendChildByName(String parent, XmlDocument child) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".addToChild(IXmlElement, String)";
        try {
            if (this.mRootNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.NULL_ROOT_ELEMENT, debugString);
            }
            Node parentNode = this.prvGetChildByName(parent);
            if (parentNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.PARENT_NOT_FOUND, debugString);
            }
            Node childRoot = child.getRootNode();
            parentNode.appendChild(this.examineChild(child.getDocument(), childRoot));
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(debugString, e);
        }
    }

    @Override
    public IXmlDocument clone(boolean deep) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".clone(boolean)";
        try {
            Node clonedNode = this.mRootNode.cloneNode(deep);
            return this.create(clonedNode, this.mDocument);
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement createChild(String childName, String value) throws XmlDocumentCheckedException {
        XmlDocument results;
        String debugString = this.getClass().getName() + ".createChild(String, String)";
        try {
            results = this.createNewChild(childName, value);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlElement createChildren(String fullChildPath) throws XmlDocumentCheckedException {
        XmlDocument results;
        String debugString = this.getClass().getName() + ".createChildren(String)";
        try {
            results = this.createChildByName(fullChildPath);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    public XmlDocument createChildByName(String child) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".createChildByName(String)";
        try {
            Node childNode = this.prgCreateChildByName(child);
            return this.create(childNode, this.mDocument);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public Node getRootNode() throws XmlDocumentCheckedException {
        return this.mRootNode;
    }

    @Override
    public Document getDocument() throws XmlDocumentCheckedException {
        return this.mDocument;
    }

    public Node getPrivateElementNode() {
        return this.mRootNode;
    }

    public Document getPrivateDocument() {
        return this.mDocument;
    }

    @Override
    public String getAttribute(String name) throws XmlDocumentCheckedException {
        String results;
        String debugString = this.getClass().getName() + ".getAttribute(String)";
        try {
            results = this.getAttributeByName(name);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    public final String getAttributeByName(String sName) throws XmlDocumentCheckedException {
        Node attr = this.mRootNode.getAttributes().getNamedItem(sName);
        if (attr == null) {
            return "";
        }
        return attr.getNodeValue();
    }

    @Override
    public Collection<String> getAttributeNames() throws XmlDocumentCheckedException {
        ArrayList<String> results;
        String debugString = this.getClass().getName() + ".getAttributeNames()";
        try {
            int attributeCount = this.getAttributeCount();
            results = new ArrayList<String>(attributeCount);
            for (int i = 0; i < attributeCount; ++i) {
                results.add(this.getAttributeNameByIndex(i));
            }
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public Collection<String> getAttributeValues() throws XmlDocumentCheckedException {
        ArrayList<String> results;
        String debugString = this.getClass().getName() + ".getAttributeValues()";
        try {
            Collection<String> attributeNames = this.getAttributeNames();
            int attributeCount = attributeNames.size();
            results = new ArrayList<String>(attributeCount);
            Iterator<String> it = attributeNames.iterator();
            while (it.hasNext()) {
                results.add(this.getAttributeByName(it.next()));
            }
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public IXmlElement getChild(int index) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChild(int)";
        try {
            Node child = this.getElementChildByIndex(this.mRootNode, index);
            if (child == null) {
                return null;
            }
            return this.create(child);
        }
        catch (XmlDocumentCheckedException e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement getChild(String childName) throws XmlDocumentCheckedException {
        Node childNode;
        String debugString = this.getClass().getName() + ".getChild(String)";
        try {
            if (this.mRootNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.NULL_ROOT_ELEMENT, debugString);
            }
            childNode = this.prvGetChildByName(childName);
            if (childNode == null) {
                return null;
            }
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
        return this.create(childNode);
    }

    @Override
    public String getChildAttribute(String child, String attr) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChildAttribute(String, String)";
        try {
            Node childNode = this.prvGetChildByName(child);
            if (childNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.CHILD_NOT_FOUND, debugString);
            }
            Node attrNode = childNode.getAttributes().getNamedItem(attr);
            if (attr == null) {
                return "";
            }
            return attrNode.getNodeValue();
        }
        catch (XmlDocumentCheckedException xdce) {
            throw xdce;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    public final int getChildrenCount() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChildrenCount()";
        try {
            return this.getElementChildNodesLength(this.mRootNode.getChildNodes());
        }
        catch (XmlDocumentCheckedException xdce) {
            throw xdce;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    private final int getElementChildNodesLength(NodeList childNodes) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getElementChildNodesLength(NodeList)";
        try {
            int length = childNodes.getLength();
            int size = 0;
            for (int i = 0; i < length; ++i) {
                if (childNodes.item(i).getNodeType() != 1) continue;
                ++size;
            }
            return size;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    @Override
    public int getChildCount() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChildCount()";
        int results = 0;
        try {
            results = this.getChildrenCount();
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public Collection<IXmlElement> getChildren() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChildren()";
        try {
            int length = this.getElementChildNodesLength(this.mRootNode.getChildNodes());
            ArrayList<IXmlElement> results = new ArrayList<IXmlElement>(length);
            for (int i = 0; i < length; ++i) {
                Node child = this.getElementChildByIndex(this.mRootNode, i);
                results.add(this.create(child));
            }
            return results;
        }
        catch (XmlDocumentCheckedException xdce) {
            throw xdce;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    @Override
    public Collection<IXmlElement> getChildrenByName(String name) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getChildrenByName";
        try {
            int length = this.getElementChildNodesLength(this.mRootNode.getChildNodes());
            ArrayList<IXmlElement> results = new ArrayList<IXmlElement>(length);
            for (int i = 0; i < length; ++i) {
                Node child = this.getElementChildByIndex(this.mRootNode, i);
                if (!child.getNodeName().equals(name)) continue;
                results.add(this.create(child));
            }
            return results;
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public String getChildValue(String childName) throws XmlDocumentCheckedException {
        String results;
        String debugString = this.getClass().getName() + ".getChildValue(String)";
        try {
            results = this.getNodeValue(childName);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    @Override
    public String getCDATASection(String childName) throws XmlDocumentCheckedException {
        String results;
        String debugString = this.getClass().getName() + ".getCDATASection(String)";
        try {
            results = this.getCDATAValue(childName);
        }
        catch (XmlDocumentCheckedException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
        return results;
    }

    public final String getNodeValue(String sChild) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getNodeValue(String)";
        try {
            Node childNode = this.prvGetChildByName(sChild);
            if (childNode == null) {
                return "";
            }
            return this.getNodeTextValue(childNode);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    protected final String getNodeTextValue(Node node) throws XmlDocumentCheckedException {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int cnt = children.getLength();
            for (int i = 0; i < cnt; ++i) {
                if (children.item(i).getNodeType() != 3) continue;
                return children.item(i).getNodeValue();
            }
        }
        return "";
    }

    public final String getCDATAValue(String sChild) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getCDATAValue(String)";
        try {
            Node childNode = this.prvGetChildByName(sChild);
            if (childNode == null) {
                return "";
            }
            return this.getCDATATextValue(childNode);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    protected final String getCDATATextValue(Node node) throws XmlDocumentCheckedException {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int cnt = children.getLength();
            for (int i = 0; i < cnt; ++i) {
                if (children.item(i).getNodeType() != 4) continue;
                return children.item(i).getNodeValue();
            }
        }
        return "";
    }

    @Override
    public String getName() throws XmlDocumentCheckedException {
        return this.mRootNode.getNodeName();
    }

    @Override
    public String getNameSpace() throws XmlDocumentCheckedException {
        return this.mRootNode.getNodeName();
    }

    @Override
    public String getValue() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getValue()";
        try {
            return this.getNodeTextValue(this.mRootNode);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public void load(File file) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(File)";
        try {
            if (!this.replaceFromStream(new FileInputStream(file))) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (IOException ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    @Override
    public void load(File file, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(File, String)";
        try {
            if (!this.replaceFromStream(new FileInputStream(file), enc)) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (IOException ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    @Override
    public void load(InputStream in) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(InputStream)";
        if (!this.replaceFromStream(in)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    @Override
    public void load(InputStream in, String enc) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(InputStream, String)";
        try {
            if (!this.replaceFromStream(in, enc)) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    @Override
    public void load(Reader reader) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(Reader)";
        if (!this.replaceFromReader(reader)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    @Override
    public void load(String xml) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".load(String)";
        if (!this.replaceFromString(xml)) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.DOCUMENT_LOAD_FAILED, debugString);
        }
    }

    @Override
    public void removeAttribute(String attrName) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".removeAttribute(String)";
        try {
            this.mRootNode.getAttributes().removeNamedItem(attrName);
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement removeChild(int index) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".removeChild(int)";
        try {
            Node child = this.getElementChildByIndex(this.mRootNode, index);
            if (child == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.INVALID_INDEX, debugString);
            }
            child.getParentNode().removeChild(child);
            return this.create(child, this.mDocument);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement removeChild(String childName) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".removeChild(String)";
        try {
            Node xmlNode = this.prvGetChildByName(childName);
            if (xmlNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.CHILD_NOT_FOUND, debugString);
            }
            xmlNode.getParentNode().removeChild(xmlNode);
            return this.create(xmlNode, this.mDocument);
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    @Override
    public void removeChildAttribute(String childName, String attrName) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".removeChildAttribute(String, String)";
        try {
            Node xmlNode = this.prvGetChildByName(childName);
            if (xmlNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.CHILD_NOT_FOUND, debugString);
            }
            xmlNode.getAttributes().removeNamedItem(attrName);
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public void replaceAllChildren(IXmlElement parent) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".replaceAllChildren(IXmlElement)";
        try {
            Node parentNode;
            NodeList children = this.mRootNode.getChildNodes();
            int length = children.getLength();
            Vector<Node> textNodes = new Vector<Node>(length);
            int nTextNodes = 0;
            while (children.getLength() != 0) {
                Node child = children.item(0);
                if ((child = this.mRootNode.removeChild(child)).getNodeType() == 3) {
                    textNodes.addElement(child);
                    ++nTextNodes;
                }
                children = this.mRootNode.getChildNodes();
            }
            if (nTextNodes > 0) {
                for (int i = 0; i < nTextNodes; ++i) {
                    this.mRootNode.appendChild((Node)textNodes.elementAt(i));
                }
            }
            if ((parentNode = parent.getRootNode()) == null) {
                return;
            }
            children = parentNode.getChildNodes();
            int cnt = 0;
            while (cnt < children.getLength()) {
                Node child = children.item(cnt++);
                Node newChild = this.examineChild(parent.getDocument(), child);
                if (newChild == null) continue;
                this.mRootNode.appendChild(newChild);
            }
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement replaceChild(int index, IXmlElement newChild) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".replaceChild(int, IXmlElement)";
        try {
            Node child = this.getElementChildByIndex(this.mRootNode, index);
            if (child == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.INVALID_INDEX, debugString);
            }
            Node newNode = newChild.getRootNode();
            this.mRootNode.replaceChild(this.examineChild(newChild.getDocument(), newNode), child);
            return this.create(child, this.mDocument);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public IXmlElement replaceChild(String childName, IXmlElement newChild) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".replaceChild(String, IXmlElement)";
        try {
            Node xmlNode = this.prvGetChildByName(childName);
            if (xmlNode == null) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.CHILD_NOT_FOUND, debugString);
            }
            Node newNode = newChild.getRootNode();
            xmlNode.getParentNode().replaceChild(this.examineChild(newChild.getDocument(), newNode), xmlNode);
            return this.create(xmlNode, this.mDocument);
        }
        catch (XmlDocumentCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public void setAttribute(String attrName, String value) throws XmlDocumentCheckedException {
        Attr attr = (Attr)this.mRootNode.getAttributes().getNamedItem(attrName);
        if (attr == null) {
            Attr attrNew = this.mDocument.createAttribute(attrName);
            attrNew.setValue(value);
            NamedNodeMap attributes = this.mRootNode.getAttributes();
            attributes.setNamedItem(attrNew);
        } else {
            attr.setNodeValue(value);
        }
    }

    protected final void setTextValue(Node node, String sValue) throws XmlDocumentCheckedException {
        NodeList children;
        String value = sValue;
        if (value == null) {
            value = "";
        }
        if ((children = node.getChildNodes()) != null) {
            int cnt = children.getLength();
            for (int i = 0; i < cnt; ++i) {
                if (children.item(i).getNodeType() != 3) continue;
                children.item(i).setNodeValue(value);
                return;
            }
        }
        if (value.length() > 0) {
            Text text = this.mDocument.createTextNode(value);
            node.appendChild(text);
        }
    }

    protected final void setCDATASection(Node node, String sValue) throws Exception {
        String value = sValue;
        if (value == null) {
            value = "";
        }
        if (value.length() > 0) {
            CDATASection text = this.mDocument.createCDATASection(value);
            node.appendChild(text);
        }
    }

    @Override
    public void setCDATASection(String value) throws Exception {
        this.setCDATASection(this.mRootNode, value);
    }

    @Override
    public void setValue(String value) throws XmlDocumentCheckedException {
        this.setTextValue(this.mRootNode, value);
    }

    @Override
    public void write(File file) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".write(File)";
        try {
            FileOutputStream output = new FileOutputStream(file);
            this.writeToStream(output);
            output.close();
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    private void writeToStream(OutputStream output) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".writeToStream(OutputStream)";
        try {
            OutputFormat format = new OutputFormat(this.mDocument);
            format.setIndenting(false);
            format.setPreserveSpace(true);
            XMLSerializer serial = new XMLSerializer(output, format);
            serial.asDOMSerializer();
            if (this.mRootNode == this.mDocument) {
                serial.serialize(this.mDocument);
            } else {
                serial.serialize((Element)this.mRootNode);
            }
        }
        catch (IOException e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    @Override
    public void write(OutputStream output) throws XmlDocumentCheckedException {
        this.writeToStream(output);
    }

    @Override
    public IXmlElement getRootElement() throws XmlDocumentCheckedException {
        return new XmlDocument(this.create(this.mDocument.getDocumentElement(), this.mDocument));
    }

    public String toString() {
        StringWriter stringwriter = new StringWriter();
        try {
            OutputFormat outputformat = new OutputFormat();
            outputformat.setIndenting(true);
            outputformat.setLineWidth(0);
            XMLSerializer xmlserializer = new XMLSerializer((Writer)stringwriter, outputformat);
            xmlserializer.serialize(this.mDocument);
            stringwriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringwriter.toString();
    }

    private DocumentBuilder createDocumentBuilder() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".createDocumentBuilder()";
        try {
            DocumentBuilderFactory docBuidlerFactory = DocumentBuilderFactory.newInstance();
            docBuidlerFactory.setNamespaceAware(true);
            return docBuidlerFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    public boolean replaceFromStream(InputStream in) {
        return this.replaceFromReader(new InputStreamReader(in));
    }

    public boolean replaceFromStream(InputStream in, String enc) throws UnsupportedEncodingException {
        return this.replaceFromReader(new InputStreamReader(in, enc));
    }

    public boolean replaceFromReader(Reader reader) {
        try {
            if (this.mDocumentBuilder == null) {
                this.mDocumentBuilder = this.createDocumentBuilder();
                this.mDocument = this.mDocumentBuilder.newDocument();
                this.mRootNode = this.mDocument;
            }
            this.mDocument = this.mDocumentBuilder.parse(new InputSource(reader));
            this.mRootNode = this.mDocument;
        }
        catch (Exception e) {
            this.mDocument = null;
            this.mRootNode = null;
            return false;
        }
        return true;
    }

    public final boolean replaceFromString(String xml) {
        return this.replaceFromReader(new StringReader(xml));
    }

    protected Node prvGetChildByName(String sChildName) {
        return this.prvGetChildByName(sChildName, this.mRootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node prvGetChildByName(String sChildName, Node rootNode) {
        Node childNode = null;
        String[] tagList = StringUtils.split((String)sChildName, (String)SEPARATOR);
        Document document = this.mDocument;
        synchronized (document) {
            childNode = this.getChildNodeByTag(rootNode, tagList, 0);
        }
        return childNode;
    }

    private Node getChildNodeByTag(Node rootNode, String[] tagList, int index) {
        if (index >= tagList.length) {
            return rootNode;
        }
        String tagName = tagList[index];
        for (Node node = rootNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            if (!node.getNodeName().equals(tagName) || (child = this.getChildNodeByTag(node, tagList, index + 1)) == null) continue;
            return child;
        }
        return null;
    }

    protected Node examineChild(Document rootDoc, Node child) throws XmlDocumentCheckedException {
        if (!this.mDocument.equals(rootDoc)) {
            return XmlDocument.cloneChildren(this.mDocument, child);
        }
        return child;
    }

    public static Node cloneChildren(Document doc, Node child) throws XmlDocumentCheckedException {
        String debugString = ".getElementChildByIndex(Node, int)";
        Node node = null;
        if (child.getNodeType() == 3) {
            node = child.getNodeValue() == null ? null : doc.createTextNode(child.getNodeValue());
        } else if (child.getNodeType() == 1) {
            node = doc.createElement(child.getNodeName());
            NamedNodeMap attributes = child.getAttributes();
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attributes.item(i);
                Attr newAttr = doc.createAttribute(attr.getNodeName());
                newAttr.setNodeValue(attr.getNodeValue());
                node.getAttributes().setNamedItem(newAttr);
            }
            NodeList children = child.getChildNodes();
            int cnt = children.getLength();
            for (int i = 0; i < cnt; ++i) {
                Node newChild = XmlDocument.cloneChildren(doc, children.item(i));
                if (newChild != null) {
                    node.appendChild(newChild);
                }
                newChild = null;
            }
        } else if (child.getNodeType() == 8) {
            node = doc.createComment(child.getNodeValue());
        } else if (child.getNodeType() == 4) {
            node = doc.createCDATASection(child.getNodeValue());
        } else {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.CLONE_FAILED, ".getElementChildByIndex(Node, int)");
        }
        return node;
    }

    private final Node prgCreateChildByName(String sChild) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".prgCreateChildByName(String)";
        try {
            Node childNode = this.prvGetChildByName(sChild);
            if (childNode == null) {
                StringTokenizer childTokens = new StringTokenizer(sChild, SEPARATOR);
                int size = childTokens.countTokens();
                Node rootNode = this.mRootNode;
                for (int i = 0; i < size; ++i) {
                    String nextChildName = childTokens.nextToken();
                    childNode = this.prvGetChildByName(nextChildName, rootNode);
                    if (childNode == null) {
                        Element newChild = this.mDocument.createElement(nextChildName);
                        rootNode.appendChild(newChild);
                        rootNode = newChild;
                        while (childTokens.hasMoreTokens()) {
                            nextChildName = childTokens.nextToken();
                            newChild = this.mDocument.createElement(nextChildName);
                            rootNode.appendChild(newChild);
                            rootNode = newChild;
                        }
                        return rootNode;
                    }
                    rootNode = childNode;
                }
            }
            return childNode;
        }
        catch (Exception e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
    }

    public final int getAttributeCount() throws XmlDocumentCheckedException {
        return this.mRootNode.getAttributes().getLength();
    }

    @Override
    public void isValid() throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".isValid()";
        String parserClass = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        String validationFeature = "http://xml.org/sax/features/validation";
        String schemaFeature = "http://apache.org/xml/features/validation/schema";
        try {
            XMLReader r = XMLReaderFactory.createXMLReader(parserClass);
            r.setFeature(validationFeature, true);
            r.setFeature(schemaFeature, true);
            r.setErrorHandler(new ErrorHandler());
            InputSource inputSource = new InputSource(new StringReader(this.toString()));
            r.parse(inputSource);
        }
        catch (SAXException e) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)e, debugString, (Throwable)e);
        }
        catch (IOException ex) {
            throw new XmlDocumentCheckedException(debugString, ex);
        }
    }

    public final String getAttributeNameByIndex(int index) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getAttributeNameByIndex(int)";
        try {
            if (index < 0 || index >= this.mRootNode.getAttributes().getLength()) {
                throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.INVALID_INDEX, debugString);
            }
            return this.mRootNode.getAttributes().item(index).getNodeName();
        }
        catch (XmlDocumentCheckedException xdce) {
            throw xdce;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    private final Node getElementChildByIndex(Node parent, int index) throws XmlDocumentCheckedException {
        String debugString = this.getClass().getName() + ".getElementChildByIndex(Node, int)";
        try {
            int cnt = 0;
            NodeList children = parent.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                if (cnt == index) {
                    return children.item(i);
                }
                ++cnt;
            }
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.INVALID_INDEX, debugString);
        }
        catch (XmlDocumentCheckedException xdce) {
            throw xdce;
        }
        catch (Exception ex) {
            throw new XmlDocumentCheckedException(XmlDocumentCheckedException.Codes.GENERAL_ERROR, (Object)ex, debugString, (Throwable)ex);
        }
    }

    private static class ErrorHandler
    extends DefaultHandler {
        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }
    }
}

