/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Items;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.DefaultCounter;
import com.ning.api.client.access.impl.DefaultCreator;
import com.ning.api.client.access.impl.DefaultDeleter;
import com.ning.api.client.access.impl.DefaultLister;
import com.ning.api.client.access.impl.DefaultUpdater;
import com.ning.api.client.access.impl.PagedListImpl;
import com.ning.api.client.action.Creator;
import com.ning.api.client.action.Deleter;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.action.Updater;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpPut;
import com.ning.api.client.http.NingHttpRequest;
import com.ning.api.client.item.BlogPost;
import com.ning.api.client.item.BlogPostField;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.Key;
import com.ning.api.client.item.PublishStatus;
import com.ning.api.client.item.Visibility;
import org.joda.time.ReadableDateTime;

public class BlogPosts
extends Items<BlogPost, BlogPostField> {
    public BlogPosts(NingConnection connection, NingClientConfig config) {
        super(connection, config, "BlogPost", BlogPost.class, BlogPostField.class);
    }

    public Counter counter(ReadableDateTime createdAfter) {
        return new Counter(this.connection, this.config, this.endpointForCount(), createdAfter, null, null, null);
    }

    public Creator<BlogPost> creator(BlogPost blogPost) {
        return new BlogPostCreator(this.connection, this.config, this.endpointForPOST(), blogPost);
    }

    public final Deleter<BlogPost> deleter(Key<BlogPost> id) {
        return new DefaultDeleter<BlogPost>(this.connection, this.config, this.endpointForDELETE(), id);
    }

    public Lister listerForRecent(BlogPostField firstField, BlogPostField ... otherFields) {
        return this.listerForRecent(new Fields(BlogPostField.class, (Enum)firstField, (Enum[])otherFields));
    }

    public Lister listerForRecent(Fields<BlogPostField> fields) {
        return new Lister(this.connection, this.config, this.endpointForRecent(), fields, null, null, null);
    }

    public Updater<BlogPost> updater(BlogPost blogPost) {
        return new BlogPostUpdater(this.connection, this.config, this.endpointForPUT(), blogPost);
    }

    public static class BlogPostUpdater
    extends DefaultUpdater<BlogPost> {
        protected BlogPost blogPost;

        protected BlogPostUpdater(NingConnection connection, NingClientConfig config, String endpoint, BlogPost blogPost) {
            super(connection, config, endpoint);
            this.blogPost = blogPost.clone();
        }

        public BlogPostUpdater visibility(Visibility v) {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setVisibility(v);
            return this;
        }

        public BlogPostUpdater draft() {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.draft);
            this.blogPost.setPublishTime(null);
            return this;
        }

        public BlogPostUpdater published() {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.publish);
            this.blogPost.setPublishTime(null);
            return this;
        }

        public BlogPostUpdater published(ReadableDateTime publishTime) {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.queued);
            this.blogPost.setPublishTime(publishTime);
            return this;
        }

        public BlogPostUpdater approved(Boolean approvedOrNot) {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setApproved(approvedOrNot);
            return this;
        }

        @Override
        protected NingHttpPut addUpdateParameters(NingHttpPut put) {
            Key id = this.blogPost.id();
            if (id == null) {
                throw new IllegalArgumentException("Missing mandatory field 'id'");
            }
            put = (NingHttpPut)put.addFormParameter("id", id.toString());
            if (this.blogPost.getDescription() != null) {
                put = (NingHttpPut)put.addFormParameter("description", this.blogPost.getDescription());
            }
            if (this.blogPost.getTitle() != null) {
                put = (NingHttpPut)put.addFormParameter("title", this.blogPost.getTitle());
            }
            if (this.blogPost.getVisibility() != null) {
                put = (NingHttpPut)put.addFormParameter("visibility", this.blogPost.getVisibility().toString());
            }
            if (this.blogPost.getPublishStatus() != null) {
                put = (NingHttpPut)put.addFormParameter("publishStatus", this.blogPost.getPublishStatus().toString());
            }
            if (this.blogPost.getPublishTime() != null) {
                put = (NingHttpPut)put.addFormParameter("publishTime", this.blogPost.getPublishTime().toString());
            }
            if (this.blogPost.isApproved() != null) {
                put = (NingHttpPut)put.addFormParameter("approved", this.blogPost.isApproved().toString());
            }
            return put;
        }
    }

    public static class Lister
    extends DefaultLister<BlogPost, BlogPostField> {
        protected Lister(NingConnection connection, NingClientConfig config, String endpoint, Fields<BlogPostField> fields, String author, Boolean isPrivate, Boolean isApproved) {
            super(connection, config, endpoint, fields, author, isPrivate, isApproved);
        }

        public Lister author(String author) {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, author, this.isPrivate, this.isApproved);
        }

        public Lister approved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, this.isPrivate, Boolean.TRUE);
        }

        public Lister unapproved() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, this.isPrivate, Boolean.FALSE);
        }

        public Lister onlyPrivate() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, Boolean.TRUE, this.isApproved);
        }

        public Lister onlyPublic() {
            return new Lister(this.connection, this.config, this.endpoint, this.fields, this.author, Boolean.FALSE, this.isApproved);
        }

        @Override
        public PagedList<BlogPost> list() {
            return new PagedListImpl(this.connection, this.config, this.endpoint, BlogPost.class, this.fields, this.author, this.isPrivate, this.isApproved, new NingHttpRequest.Param[0]);
        }
    }

    public static class BlogPostCreator
    extends DefaultCreator<BlogPost> {
        protected BlogPost blogPost;

        public BlogPostCreator(NingConnection connection, NingClientConfig config, String endpoint, BlogPost blogPost) {
            super(connection, config, endpoint);
            this.blogPost = blogPost.clone();
        }

        public BlogPostCreator visibility(Visibility v) {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setVisibility(v);
            return this;
        }

        public BlogPostCreator draft() {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.draft);
            this.blogPost.setPublishTime(null);
            return this;
        }

        public BlogPostCreator published() {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.publish);
            this.blogPost.setPublishTime(null);
            return this;
        }

        public BlogPostCreator published(ReadableDateTime publishTime) {
            this.blogPost = this.blogPost.clone();
            this.blogPost.setPublishStatus(PublishStatus.queued);
            this.blogPost.setPublishTime(publishTime);
            return this;
        }

        @Override
        protected NingHttpPost addCreateParameters(NingHttpPost create) {
            if (this.blogPost.getDescription() != null) {
                create = (NingHttpPost)create.addFormParameter("description", this.blogPost.getDescription());
            }
            if (this.blogPost.getTitle() != null) {
                create = (NingHttpPost)create.addFormParameter("title", this.blogPost.getTitle());
            }
            if (this.blogPost.getVisibility() != null) {
                create = (NingHttpPost)create.addFormParameter("visibility", this.blogPost.getVisibility().toString());
            }
            if (this.blogPost.getPublishStatus() != null) {
                create = (NingHttpPost)create.addFormParameter("publishStatus", this.blogPost.getPublishStatus().toString());
            }
            if (this.blogPost.getPublishTime() != null) {
                create = (NingHttpPost)create.addFormParameter("publishTime", this.blogPost.getPublishTime().toString());
            }
            return create;
        }
    }

    public class Counter
    extends DefaultCounter {
        protected Counter(NingConnection connection, NingClientConfig config, String endpoint, ReadableDateTime createdAfter, String author, Boolean isPrivate, Boolean isApproved) {
            super(connection, config, endpoint, createdAfter, author, isPrivate, isApproved);
        }

        protected Counter(Counter base, String author, Boolean isPrivate, Boolean isApproved) {
            this(base.connection, base.config, base.endpoint, base.createdAfter, author, isPrivate, isApproved);
        }

        public Counter author(String author) {
            return new Counter(this, author, this.isPrivate, this.isApproved);
        }

        public Counter approved() {
            return new Counter(this, this.author, this.isPrivate, Boolean.TRUE);
        }

        public Counter unapproved() {
            return new Counter(this, this.author, this.isPrivate, Boolean.FALSE);
        }

        public Counter onlyPrivate() {
            return new Counter(this, this.author, Boolean.TRUE, this.isApproved);
        }

        public Counter onlyPublic() {
            return new Counter(this, this.author, Boolean.FALSE, this.isApproved);
        }
    }
}

