/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.Activities;
import com.ning.api.client.access.BlogPosts;
import com.ning.api.client.access.BroadcastMessages;
import com.ning.api.client.access.Comments;
import com.ning.api.client.access.Networks;
import com.ning.api.client.access.Photos;
import com.ning.api.client.access.Users;
import com.ning.api.client.access.Videos;
import com.ning.api.client.auth.ConsumerKey;
import com.ning.api.client.auth.OAuthSignatureCalculator;
import com.ning.api.client.auth.RequestToken;
import com.ning.api.client.http.NingHttpClient;
import com.ning.api.client.http.NingHttpDelete;
import com.ning.api.client.http.NingHttpGet;
import com.ning.api.client.http.NingHttpPost;
import com.ning.api.client.http.NingHttpPut;
import org.codehaus.jackson.map.ObjectMapper;

public class NingConnection {
    protected final NingHttpClient httpClient;
    protected final ObjectMapper objectMapper;
    protected final OAuthSignatureCalculator signatureCalculator;
    protected final String xapiPrefixRegular;
    protected final String xapiPrefixSecure;
    protected final NingClientConfig config;
    protected boolean hasBeenClosed = false;

    public NingConnection(NingClientConfig config, ObjectMapper objectMapper, ConsumerKey consumerAuth, RequestToken userAuth, NingHttpClient httpClient, String xapiPrefixRegular, String xapiPrefixSecure) {
        this.config = config;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.signatureCalculator = new OAuthSignatureCalculator(consumerAuth, userAuth);
        this.xapiPrefixRegular = xapiPrefixRegular;
        this.xapiPrefixSecure = xapiPrefixSecure;
    }

    protected NingConnection(NingConnection baseline, NingClientConfig configOverrides) {
        this.config = baseline.config.overrideWith(configOverrides);
        this.objectMapper = baseline.objectMapper;
        this.httpClient = baseline.httpClient;
        this.signatureCalculator = baseline.signatureCalculator;
        this.xapiPrefixRegular = baseline.xapiPrefixRegular;
        this.xapiPrefixSecure = baseline.xapiPrefixSecure;
    }

    public NingConnection configuredConnection(NingClientConfig configOverrides) {
        return new NingConnection(this, configOverrides);
    }

    public void close() {
        if (!this.hasBeenClosed) {
            this.httpClient.close();
            this.hasBeenClosed = true;
        }
    }

    public NingClientConfig getConfig() {
        return this.config;
    }

    public Activities activities() {
        this.checkNotClosed();
        return new Activities(this, this.config);
    }

    public BlogPosts blogPosts() {
        this.checkNotClosed();
        return new BlogPosts(this, this.config);
    }

    public BroadcastMessages broadcastMessages() {
        this.checkNotClosed();
        return new BroadcastMessages(this, this.config);
    }

    public Comments comments() {
        this.checkNotClosed();
        return new Comments(this, this.config);
    }

    public Networks networks() {
        this.checkNotClosed();
        return new Networks(this, this.config);
    }

    public Photos photos() {
        this.checkNotClosed();
        return new Photos(this, this.config);
    }

    public Users users() {
        this.checkNotClosed();
        return new Users(this, this.config);
    }

    public Videos videos() {
        this.checkNotClosed();
        return new Videos(this, this.config);
    }

    public NingHttpDelete prepareHttpDelete(String endpoint, NingClientConfig config) {
        this.checkNotClosed();
        String url = this.prefixFor(endpoint, config);
        return this.httpClient.prepareDelete(url, this.signatureCalculator);
    }

    public NingHttpGet prepareHttpGet(String endpoint, NingClientConfig config) {
        this.checkNotClosed();
        String url = this.prefixFor(endpoint, config);
        return this.httpClient.prepareGet(url, this.signatureCalculator);
    }

    public NingHttpPost prepareHttpPost(String endpoint, NingClientConfig config) {
        this.checkNotClosed();
        String url = this.prefixFor(endpoint, config);
        return this.httpClient.preparePost(url, this.signatureCalculator);
    }

    public NingHttpPut prepareHttpPut(String endpoint, NingClientConfig config) {
        this.checkNotClosed();
        String url = this.prefixFor(endpoint, config);
        return this.httpClient.preparePut(url, this.signatureCalculator);
    }

    protected String prefixFor(String endpoint, NingClientConfig config) {
        Boolean secure = config.getUseSecureConnection();
        if (secure.booleanValue() && secure.booleanValue()) {
            return this.securePrefixFor(endpoint);
        }
        return this.regularPrefixFor(endpoint);
    }

    private String regularPrefixFor(String endpoint) {
        return this.xapiPrefixRegular + endpoint;
    }

    private String securePrefixFor(String endpoint) {
        return this.xapiPrefixSecure + endpoint;
    }

    private void checkNotClosed() {
        if (this.hasBeenClosed) {
            throw new IllegalStateException("Connection instance closed: can not use");
        }
    }
}

