/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access.impl;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.action.Deleter;
import com.ning.api.client.http.NingHttpDelete;
import com.ning.api.client.http.NingHttpException;
import com.ning.api.client.http.NingHttpResponse;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Key;

public class DefaultDeleter<C extends ContentItem<?, C>>
implements Deleter<C> {
    protected final NingConnection connection;
    protected NingClientConfig config;
    protected final String endpoint;
    protected final Key<C> id;

    public DefaultDeleter(NingConnection connection, NingClientConfig config, String endpoint, String id) {
        this(connection, config, endpoint, new Key(id));
    }

    public DefaultDeleter(NingConnection connection, NingClientConfig config, String endpoint, Key<C> id) {
        this.connection = connection;
        this.config = config;
        this.endpoint = endpoint;
        this.id = id;
    }

    @Override
    public void delete() throws NingHttpException {
        NingHttpDelete deleter = this.buildRequest(this.id);
        NingHttpResponse response = deleter.execute(this.config.getWriteTimeoutMsecs().intValue());
        response.verifyResponse();
    }

    protected NingHttpDelete buildRequest(Key<C> id) {
        NingHttpDelete deleter = this.connection.prepareHttpDelete(this.endpoint, this.config);
        deleter = (NingHttpDelete)deleter.addAccept("*/*");
        deleter = (NingHttpDelete)deleter.addQueryParameter("id", id.toString());
        return deleter;
    }
}

