/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access.impl;

import com.ning.api.client.action.PagedList;
import com.ning.api.client.item.ContentItem;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ItemIteratorImpl<C extends ContentItem<?, C>>
implements Iterator<C> {
    public static final int DEFAULT_CHUNK_SIZE = 20;
    protected final PagedList<C> pageLister;
    protected final int itemsPerCall;
    protected Iterator<C> currentItems;
    protected boolean closed;

    public ItemIteratorImpl(PagedList<C> pageLister) {
        this(pageLister, 20);
    }

    public ItemIteratorImpl(PagedList<C> pageLister, int itemsPerCall) {
        this.pageLister = pageLister;
        this.itemsPerCall = itemsPerCall;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        return this.currentItems != null && this.currentItems.hasNext() || this.fetchMore();
    }

    @Override
    public C next() {
        if (!(this.currentItems != null && this.currentItems.hasNext() || !this.closed && this.fetchMore())) {
            throw new NoSuchElementException("No more entries to iterate");
        }
        return (C)((ContentItem)this.currentItems.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Item lists are read-only");
    }

    protected boolean fetchMore() {
        List<C> items = this.pageLister.next(this.itemsPerCall);
        if (items.isEmpty()) {
            this.closed = true;
            return false;
        }
        this.currentItems = items.iterator();
        return true;
    }
}

