/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.item;

import com.ning.api.client.item.Author;
import java.io.IOException;
import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class SubResources {
    protected final ObjectMapper objectMapper;
    protected final JsonNode resources;
    private transient HashMap<String, Object> boundResources;

    public SubResources(ObjectMapper m, JsonNode r) {
        this.objectMapper = m;
        this.resources = r;
    }

    public <RT> RT findOrLoadResource(Class<RT> type, String id) {
        return this.findOrLoadResource(type, id, null);
    }

    public <RT> RT findOrLoadResource(Class<RT> type, String id, RT instance) {
        RT value = this.findResource(type, id);
        if (value == null) {
            value = this.loadResource(type, id, instance);
        }
        return value;
    }

    protected <RT> RT findResource(Class<RT> type, String id) {
        Object ob;
        if (this.boundResources != null && (ob = this.boundResources.get(id)) != null) {
            if (!(ob instanceof Author)) {
                throw new IllegalArgumentException("Type problem: sub-resource '" + id + "' not of type " + type.getSimpleName() + ", but of type " + ob.getClass().getSimpleName());
            }
            Object result = ob;
            return (RT)result;
        }
        return null;
    }

    protected <RT> RT loadResource(Class<RT> type, String id, RT instance) {
        if (this.resources == null || id == null) {
            return null;
        }
        JsonNode entry = this.resources.get(id);
        if (entry == null) {
            return null;
        }
        if (!entry.isObject()) {
            throw new IllegalArgumentException("Corrupt or malformed data: " + type.getSimpleName() + " data for '" + id + "' not a JSON object but " + entry.asToken());
        }
        try {
            if (instance == null) {
                instance = this.objectMapper.treeToValue(entry, type);
            } else {
                this.objectMapper.updatingReader(instance).readValue(entry.traverse());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Corrupt or malformed data: author data for '" + id + "' could not be bound, problem: " + e.getMessage());
        }
        if (this.boundResources == null) {
            this.boundResources = new HashMap();
        }
        this.boundResources.put(id, instance);
        return instance;
    }
}

