/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.DefaultFinder;
import com.ning.api.client.action.Finder;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Fields;

public abstract class Items<C extends ContentItem<F, C>, F extends Enum<F>> {
    protected final NingConnection connection;
    protected NingClientConfig config;
    protected final String endpointBase;
    protected final Class<C> itemType;
    protected final Class<F> fieldType;

    protected Items(NingConnection connection, NingClientConfig config, String endpointBase, Class<C> itemType, Class<F> fieldType) {
        this.connection = connection;
        this.endpointBase = endpointBase;
        this.itemType = itemType;
        this.fieldType = fieldType;
        this.config = config;
    }

    public NingClientConfig getConfig() {
        return this.config;
    }

    public void setConfig(NingClientConfig configOverrides) {
        this.config = this.config.overrideWith(configOverrides);
    }

    public Finder<C> finder(F firstField, F ... otherFields) {
        return this.finder(new Fields(this.fieldType, firstField, otherFields));
    }

    public Finder<C> finder(Fields<F> fields) {
        return new DefaultFinder<C, F>(this.connection, this.config, this.endpointForRecent(), this.itemType, fields);
    }

    protected String endpointForSingle() {
        return this.endpointBase;
    }

    protected String endpointForDELETE() {
        return this.endpointBase;
    }

    protected String endpointForPUT() {
        return this.endpointBase;
    }

    protected String endpointForPOST() {
        return this.endpointBase;
    }

    protected String endpointForAlpha() {
        return this.endpointBase + "/alpha";
    }

    protected String endpointForRecent() {
        return this.endpointBase + "/recent";
    }

    protected String endpointForCount() {
        return this.endpointBase + "/count";
    }

    public Fields<F> fields() {
        return new Fields<F>(this.fieldType);
    }

    public Fields<F> fields(F first, F ... other) {
        return new Fields(this.fieldType, first, other);
    }
}

