/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.access.impl;

import com.ning.api.client.NingClientConfig;
import com.ning.api.client.NingClientException;
import com.ning.api.client.access.Anchor;
import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.impl.AnchorHolder;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.http.NingHttpGet;
import com.ning.api.client.http.NingHttpRequest;
import com.ning.api.client.item.ContentItem;
import com.ning.api.client.item.Fields;
import java.util.List;

public class PagedListImpl<C extends ContentItem<F, C>, F extends Enum<F>>
implements PagedList<C> {
    protected final NingConnection connection;
    protected NingClientConfig config;
    protected final String endpoint;
    protected final Class<C> itemClass;
    protected final Fields<F> fields;
    protected final String author;
    protected final Boolean isPrivate;
    protected final Boolean isApproved;
    protected final NingHttpRequest.Param[] additionalQueryParams;
    protected final AnchorHolder anchor;

    public PagedListImpl(NingConnection connection, NingClientConfig config, String endpoint, Class<C> itemClass, Fields<F> fields, String author, Boolean isPrivate, Boolean isApproved, NingHttpRequest.Param ... additionalQueryParams) {
        this.connection = connection;
        this.config = config;
        this.endpoint = endpoint;
        this.itemClass = itemClass;
        this.fields = fields;
        this.author = author;
        this.isPrivate = isPrivate;
        this.isApproved = isApproved;
        this.additionalQueryParams = additionalQueryParams;
        this.anchor = new AnchorHolder();
    }

    @Override
    public List<C> next(int pageSize) {
        return this.fetchSequence(pageSize);
    }

    @Override
    public List<C> previous(int pageSize) {
        return this.fetchSequence(-pageSize);
    }

    protected List<C> fetchSequence(int count) throws NingClientException {
        NingHttpGet getter = this.connection.prepareHttpGet(this.endpoint, this.config);
        getter = (NingHttpGet)getter.addAccept("*/*");
        getter = (NingHttpGet)getter.addQueryParameter("count", String.valueOf(count));
        getter = (NingHttpGet)getter.addQueryParameter("fields", this.fields.toString());
        if (this.author != null) {
            getter = (NingHttpGet)getter.addQueryParameter("author", this.author);
        }
        if (this.isPrivate != null) {
            getter = (NingHttpGet)getter.addQueryParameter("private", this.isPrivate.toString());
        }
        if (this.isApproved != null) {
            getter = (NingHttpGet)getter.addQueryParameter("approved", this.isApproved.toString());
        }
        if (this.anchor != null && this.anchor.hasAnchor()) {
            getter = (NingHttpGet)getter.addQueryParameter("anchor", this.anchor.toString());
        }
        if (this.additionalQueryParams != null) {
            getter = (NingHttpGet)getter.addQueryParameters(this.additionalQueryParams);
        }
        return getter.execute(this.config.getReadTimeoutMsecs().intValue()).asItemList(this.itemClass, this.anchor);
    }

    @Override
    public Anchor position() {
        return this.anchor.getAnchor();
    }
}

