/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.http;

import com.ning.api.client.NingClientException;
import java.io.IOException;

public class NingHttpException
extends NingClientException {
    private static final long serialVersionUID = 1L;
    protected final int httpResponseCode;
    protected final String httpResponseMessage;

    public NingHttpException(int httpResponseCode, String httpResponseMessage) {
        this(httpResponseCode, httpResponseMessage, "HTTP error " + httpResponseCode);
    }

    public NingHttpException(int httpResponseCode, String httpResponseMessage, String msg) {
        super(msg);
        this.httpResponseCode = httpResponseCode;
        this.httpResponseMessage = httpResponseMessage;
    }

    public NingHttpException(IOException e) {
        super(e);
        this.httpResponseMessage = null;
        this.httpResponseCode = 0;
    }

    public boolean hasHttpResponseCode() {
        return this.httpResponseCode > 0;
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public String getResponseMessage() {
        return this.httpResponseMessage;
    }

    @Override
    public String toString() {
        return "" + this.getMessage() + "; response = '" + this.getResponseMessage() + "'";
    }

    @Override
    public boolean isRetryable() {
        return this.hasHttpResponseCode() && (this.httpResponseCode < 400 || this.httpResponseCode >= 500);
    }
}

