/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.sample;

import com.ning.api.client.access.NingConnection;
import com.ning.api.client.item.Author;
import com.ning.api.client.item.Image;
import com.ning.api.client.item.Photo;
import com.ning.api.client.item.PhotoField;
import com.ning.api.client.sample.SampleIntermediate;

public class ManualListPhotos
extends SampleIntermediate {
    @Override
    public void doAction(NingConnection conn) throws Exception {
        System.out.println("Latest 20 photos:");
        int nr = 0;
        long startTime = System.currentTimeMillis();
        for (Photo photo : conn.photos().listerForRecent(PhotoField.title, PhotoField.author_fullName, PhotoField.author_url, PhotoField.author_iconUrl, PhotoField.image_url, PhotoField.image_width, PhotoField.image_height)) {
            System.out.println("Post #" + ++nr + "; " + this.desc(photo));
        }
        long took = System.currentTimeMillis() - startTime;
        System.out.println("List, took " + took + " msecs");
    }

    private String desc(Photo photo) {
        Author auth = photo.getAuthorResource();
        String desc = auth == null ? ", NO author" : ", author=" + auth.getFullName() + ", author.url=" + auth.getUrl() + ", author.icon=" + auth.getIconUrl();
        Image image = photo.getImageResource();
        desc = image == null ? desc + ", NO image data" : desc + ", image url: " + image.getUrl() + ", image width: " + image.getWidth() + ", image height: " + image.getHeight();
        return desc;
    }

    public static void main(String[] args) throws Exception {
        new ManualListPhotos().action();
    }
}

