/*
 * Decompiled with CFR 0.152.
 */
package com.ning.api.client.sample;

import com.ning.api.client.access.NingConnection;
import com.ning.api.client.access.Users;
import com.ning.api.client.action.PagedList;
import com.ning.api.client.item.Fields;
import com.ning.api.client.item.User;
import com.ning.api.client.item.UserField;
import com.ning.api.client.sample.SampleIntermediate;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableDateTime;

public class ManualListUsers
extends SampleIntermediate {
    @Override
    public void doAction(NingConnection conn) throws Exception {
        DateTime since = new DateTime();
        since = since.minusDays(6);
        int count = conn.users().counter((ReadableDateTime)since).count();
        System.out.println("Users created since " + since + ": " + count);
        List<User> users = null;
        try {
            Fields fields = conn.users().fields(UserField.birthDate, new UserField[]{UserField.fullName, UserField.statusMessage});
            Users.UserLister lister = conn.users().listerForRecent(fields);
            PagedList<User> list = lister.list();
            users = list.next(6);
        }
        catch (Exception e) {
            System.err.println("Failed, problem (" + e.getClass().getName() + ") = " + e);
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Users found (" + users.size() + "):");
        Iterator<User> i$ = users.iterator();
        while (i$.hasNext()) {
            User user;
            User uc = user = i$.next();
            System.out.println(" User(c): id=" + uc.id() + ", name=" + uc.getFullName() + ", birthDate=" + uc.getBirthDate() + ", email=" + uc.getEmail() + ", profileQuestions=" + uc.getProfileQuestions() + ", statusMessage=" + uc.getStatusMessage());
        }
        System.out.println("Done!");
    }

    public static void main(String[] args) throws Exception {
        new ManualListUsers().action();
    }
}

