/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.spring;

import com.objectsql.ObjectSQLManager;
import com.objectsql.support.CommitHandler;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TxCommit {
    private PlatformTransactionManager transactionManager;
    private TransactionStatus status;
    private boolean executeSuccess = false;
    private CommitHandler commitHandler;
    private int propagation;
    private int isolationLevel;

    public TxCommit(PlatformTransactionManager manager) {
        this(manager, 0, -1);
    }

    public TxCommit(PlatformTransactionManager manager, int propagation) {
        this(manager, propagation, -1);
    }

    public TxCommit(PlatformTransactionManager manager, int propagation, int isolationLevel) {
        this.transactionManager = manager;
        this.propagation = propagation;
        this.isolationLevel = isolationLevel;
    }

    public TxCommit(ObjectSQLManager sqlManager) {
        this(sqlManager.getDataSource(), 0, -1);
    }

    public TxCommit(ObjectSQLManager sqlManager, int propagation) {
        this(sqlManager.getDataSource(), propagation, -1);
    }

    public TxCommit(ObjectSQLManager sqlManager, int propagation, int isolationLevel) {
        this((PlatformTransactionManager)new DataSourceTransactionManager(sqlManager.getDataSource()), propagation, isolationLevel);
    }

    public TxCommit(DataSource dataSource) {
        this(dataSource, 0, -1);
    }

    public TxCommit(DataSource dataSource, int propagation) {
        this(dataSource, propagation, -1);
    }

    public TxCommit(DataSource dataSource, int propagation, int isolationLevel) {
        this((PlatformTransactionManager)new DataSourceTransactionManager(dataSource), propagation, isolationLevel);
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, CommitHandler commitHandler) {
        if (runnable == null) {
            return;
        }
        try {
            this.manual();
            runnable.run();
            this.commit();
        }
        catch (Exception e) {
            if (commitHandler != null) {
                commitHandler.handle(e);
            }
        }
        finally {
            if (!this.executeSuccess) {
                this.rollback();
            }
        }
    }

    private void manual() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(this.propagation);
        definition.setIsolationLevel(this.isolationLevel);
        this.status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        this.executeSuccess = false;
    }

    private void commit() {
        if (this.transactionManager != null && this.status != null) {
            this.transactionManager.commit(this.status);
            this.executeSuccess = true;
        }
    }

    private void rollback() {
        if (!this.executeSuccess && this.transactionManager != null && this.status != null) {
            this.transactionManager.rollback(this.status);
        }
    }

    public static void tx(DataSource dataSource, Runnable runnable) {
        new TxCommit(dataSource).execute(runnable);
    }

    public static void tx(DataSource dataSource, int propagation, Runnable runnable) {
        new TxCommit(dataSource, propagation).execute(runnable);
    }

    public static void tx(DataSource dataSource, int propagation, int isolationLevel, Runnable runnable) {
        new TxCommit(dataSource, propagation, isolationLevel).execute(runnable);
    }

    public static void tx(DataSource dataSource, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(dataSource).execute(runnable, commitHandler);
    }

    public static void tx(DataSource dataSource, int propagation, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(dataSource, propagation).execute(runnable, commitHandler);
    }

    public static void tx(DataSource dataSource, int propagation, int isolationLevel, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(dataSource, propagation, isolationLevel).execute(runnable, commitHandler);
    }

    public static void tx(ObjectSQLManager objectSQLManager, Runnable runnable) {
        new TxCommit(objectSQLManager).execute(runnable);
    }

    public static void tx(ObjectSQLManager objectSQLManager, int propagation, Runnable runnable) {
        new TxCommit(objectSQLManager, propagation).execute(runnable);
    }

    public static void tx(ObjectSQLManager objectSQLManager, int propagation, int isolationLevel, Runnable runnable) {
        new TxCommit(objectSQLManager, propagation, isolationLevel).execute(runnable);
    }

    public static void tx(ObjectSQLManager objectSQLManager, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(objectSQLManager).execute(runnable, commitHandler);
    }

    public static void tx(ObjectSQLManager objectSQLManager, int propagation, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(objectSQLManager, propagation).execute(runnable, commitHandler);
    }

    public static void tx(ObjectSQLManager objectSQLManager, int propagation, int isolationLevel, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit(objectSQLManager, propagation, isolationLevel).execute(runnable, commitHandler);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, Runnable runnable) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager).execute(runnable);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, Runnable runnable) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation).execute(runnable);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, int isolationLevel, Runnable runnable) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation, isolationLevel).execute(runnable);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager).execute(runnable, commitHandler);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation).execute(runnable, commitHandler);
    }

    public static void tx(DataSourceTransactionManager dataSourceTransactionManager, int propagation, int isolationLevel, Runnable runnable, CommitHandler commitHandler) {
        new TxCommit((PlatformTransactionManager)dataSourceTransactionManager, propagation, isolationLevel).execute(runnable, commitHandler);
    }
}

