/*
 * Decompiled with CFR 0.152.
 */
import com.qcloud.Module.Vod;
import com.qcloud.QcloudApiModuleCenter;
import com.qcloud.Utilities.Json.JSONObject;
import com.qcloud.Utilities.SHA1;
import java.io.File;
import java.util.TreeMap;

public class VodDemo {
    public static void main(String[] args) {
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("SecretId", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdsecretId");
        config.put("SecretKey", "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdsecretKey");
        config.put("RequestMethod", "POST");
        config.put("DefaultRegion", "gz");
        QcloudApiModuleCenter module = new QcloudApiModuleCenter(new Vod(), config);
        try {
            int firstDataSize;
            System.out.println("starting...");
            String fileName = "d:\\test.rmvb";
            long fileSize = new File(fileName).length();
            String fileSHA1 = SHA1.fileNameToSHA(fileName);
            int fixDataSize = 0x3200000;
            int tmpDataSize = firstDataSize = 10240;
            long remainderSize = fileSize;
            int tmpOffset = 0;
            String result = null;
            if (remainderSize <= 0L) {
                System.out.println("wrong file path...");
            }
            while (remainderSize > 0L) {
                TreeMap<String, Object> params = new TreeMap<String, Object>();
                params.put("fileSha", fileSHA1);
                params.put("fileType", "rmvb");
                params.put("fileName", "Test");
                params.put("fileSize", fileSize);
                params.put("dataSize", tmpDataSize);
                params.put("offset", tmpOffset);
                params.put("file", fileName);
                params.put("isTranscode", 0);
                params.put("isScreenshot", 0);
                params.put("isWatermark", 0);
                result = module.call("MultipartUploadVodFile", params);
                System.out.println(result);
                JSONObject json_result = new JSONObject(result);
                int code = json_result.getInt("code");
                if (code == -3002) {
                    tmpDataSize = firstDataSize;
                    tmpOffset = 0;
                    continue;
                }
                if (code != 0) {
                    return;
                }
                int flag = json_result.getInt("flag");
                if (flag == 1) {
                    String fileId = json_result.getString("fileId");
                    break;
                }
                tmpOffset = Integer.parseInt(json_result.getString("offset"));
                remainderSize = fileSize - (long)tmpOffset;
                if ((long)fixDataSize < remainderSize) {
                    tmpDataSize = fixDataSize;
                    continue;
                }
                tmpDataSize = (int)remainderSize;
            }
            System.out.println("end...");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("error..." + e.toString());
        }
    }
}

