/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.Common;

import com.qcloud.Utilities.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sign {
    private static final String CONTENT_CHARSET = "UTF-8";
    private static final String HMAC_ALGORITHM = "HmacSHA1";

    public static String sign(String signStr, String secret, String signatureMethod) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        byte[] hash;
        String sig = null;
        Mac mac1 = Mac.getInstance(HMAC_ALGORITHM);
        Mac mac2 = Mac.getInstance("HmacSHA256");
        if (signatureMethod.equals("HmacSHA256")) {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CONTENT_CHARSET), mac2.getAlgorithm());
            mac2.init(secretKey);
            hash = mac2.doFinal(signStr.getBytes(CONTENT_CHARSET));
        } else {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CONTENT_CHARSET), mac1.getAlgorithm());
            mac1.init(secretKey);
            hash = mac1.doFinal(signStr.getBytes(CONTENT_CHARSET));
        }
        sig = new String(Base64.encode(hash));
        return sig;
    }

    public static String makeSignPlainText(TreeMap<String, Object> requestParams, String requestMethod, String requestHost, String requestPath) {
        String retStr = "";
        retStr = retStr + requestMethod;
        retStr = retStr + requestHost;
        retStr = retStr + requestPath;
        retStr = retStr + Sign.buildParamStr1(requestParams, requestMethod);
        return retStr;
    }

    protected static String buildParamStr1(TreeMap<String, Object> requestParams, String requestMethod) {
        return Sign.buildParamStr(requestParams, requestMethod);
    }

    protected static String buildParamStr(TreeMap<String, Object> requestParams, String requestMethod) {
        String retStr = "";
        for (String key : requestParams.keySet()) {
            if (requestMethod == "POST" && requestParams.get(key).toString().substring(0, 1).equals("@")) continue;
            retStr = retStr.length() == 0 ? retStr + '?' : retStr + '&';
            retStr = retStr + key.replace("_", ".") + '=' + requestParams.get(key).toString();
        }
        return retStr;
    }
}

