/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.ObjectMappers;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.core.RulebricksApiApiException;
import com.rulebricks.core.RulebricksApiException;
import com.rulebricks.core.RulebricksApiHttpResponse;
import com.rulebricks.types.UsageStatistics;
import java.io.IOException;
import java.lang.Object;
import java.lang.String;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawAssetsClient {
  protected final ClientOptions clientOptions;

  public RawAssetsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public RulebricksApiHttpResponse<UsageStatistics> getUsage() {
    return getUsage(null);
  }

  /**
   * Get the rule execution usage of your organization.
   */
  public RulebricksApiHttpResponse<UsageStatistics> getUsage(RequestOptions requestOptions) {
    HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl()).newBuilder()

      .addPathSegments("admin/usage")
      .build();
    Request okhttpRequest = new Request.Builder()
      .url(httpUrl)
      .method("GET", null)
      .headers(Headers.of(clientOptions.headers(requestOptions)))
      .addHeader("Accept", "application/json")
      .build();
    OkHttpClient client = clientOptions.httpClient();
    if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
      client = clientOptions.httpClientWithTimeout(requestOptions);
    }
    try (Response response = client.newCall(okhttpRequest).execute()) {
      ResponseBody responseBody = response.body();
      String responseBodyString = responseBody != null ? responseBody.string() : "{}";
      if (response.isSuccessful()) {
        return new RulebricksApiHttpResponse<>(ObjectMappers.JSON_MAPPER.readValue(responseBodyString, UsageStatistics.class), response);
      }
      Object errorBody = ObjectMappers.parseErrorBody(responseBodyString);
      throw new RulebricksApiApiException("Error with status code " + response.code(), response.code(), errorBody, response);
    }
    catch (IOException e) {
      throw new RulebricksApiException("Network error executing HTTP request", e);
    }
  }
}
