/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.assets.folders;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.assets.folders.requests.DeleteFolderRequest;
import com.rulebricks.resources.assets.folders.requests.UpsertFolderRequest;
import com.rulebricks.types.Folder;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AsyncFoldersClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawFoldersClient rawClient;

  public AsyncFoldersClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawFoldersClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawFoldersClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public CompletableFuture<List<Folder>> list() {
    return this.rawClient.list().thenApply(response -> response.body());
  }

  /**
   * Retrieve all rule folders for the authenticated user.
   */
  public CompletableFuture<List<Folder>> list(RequestOptions requestOptions) {
    return this.rawClient.list(requestOptions).thenApply(response -> response.body());
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public CompletableFuture<Folder> upsert(UpsertFolderRequest request) {
    return this.rawClient.upsert(request).thenApply(response -> response.body());
  }

  /**
   * Create a new rule folder or update an existing one for the authenticated user.
   */
  public CompletableFuture<Folder> upsert(UpsertFolderRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.upsert(request, requestOptions).thenApply(response -> response.body());
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public CompletableFuture<Folder> delete(DeleteFolderRequest request) {
    return this.rawClient.delete(request).thenApply(response -> response.body());
  }

  /**
   * Delete a specific rule folder for the authenticated user. This does not delete the rules within the folder.
   */
  public CompletableFuture<Folder> delete(DeleteFolderRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
  }
}
