/**
 * This file was auto-generated by Fern from our API Definition.
 */

package com.rulebricks.resources.decisions;

import com.rulebricks.core.ClientOptions;
import com.rulebricks.core.RequestOptions;
import com.rulebricks.resources.decisions.requests.QueryDecisionsRequest;
import com.rulebricks.types.DecisionLogResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncDecisionsClient {
  protected final ClientOptions clientOptions;

  private final AsyncRawDecisionsClient rawClient;

  public AsyncDecisionsClient(ClientOptions clientOptions) {
    this.clientOptions = clientOptions;
    this.rawClient = new AsyncRawDecisionsClient(clientOptions);
  }

  /**
   * Get responses with HTTP metadata like headers
   */
  public AsyncRawDecisionsClient withRawResponse() {
    return this.rawClient;
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<DecisionLogResponse> query() {
    return this.rawClient.query().thenApply(response -> response.body());
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<DecisionLogResponse> query(QueryDecisionsRequest request) {
    return this.rawClient.query(request).thenApply(response -> response.body());
  }

  /**
   * Query decision logs with support for the decision data query language, rule/status filters, date ranges, and pagination. The query language supports field comparisons (e.g., <code>alpha=0</code>, <code>score&gt;10</code>), contains/not-contains (e.g., <code>name:John</code>, <code>status!:error</code>), boolean logic (<code>AND</code>, <code>OR</code>), and parentheses for grouping.
   */
  public CompletableFuture<DecisionLogResponse> query(QueryDecisionsRequest request,
      RequestOptions requestOptions) {
    return this.rawClient.query(request, requestOptions).thenApply(response -> response.body());
  }
}
